/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.vcs.log.graph.GraphColorManager;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.api.printer.GraphColorGetter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/graph/impl/print/GraphColorGetterByHead;", "CommitId", "Lcom/intellij/vcs/log/graph/api/printer/GraphColorGetter;", "permanentGraphInfo", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "colorManager", "Lcom/intellij/vcs/log/graph/GraphColorManager;", "(Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;Lcom/intellij/vcs/log/graph/GraphColorManager;)V", "getNodeColor", "", "nodeId", "layoutIndex", "intellij.platform.vcs.log.graph.impl"})
final class GraphColorGetterByHead<CommitId>
implements GraphColorGetter {
    @NotNull
    private final PermanentGraphInfo<CommitId> permanentGraphInfo;
    @NotNull
    private final GraphColorManager<CommitId> colorManager;

    public GraphColorGetterByHead(@NotNull PermanentGraphInfo<CommitId> permanentGraphInfo, @NotNull GraphColorManager<CommitId> colorManager) {
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        Intrinsics.checkNotNullParameter(colorManager, (String)"colorManager");
        this.permanentGraphInfo = permanentGraphInfo;
        this.colorManager = colorManager;
    }

    @Override
    public int getNodeColor(int nodeId, int layoutIndex) {
        int headNodeId = nodeId < 0 ? 0 : this.permanentGraphInfo.getPermanentGraphLayout().getOneOfHeadNodeIndex(nodeId);
        CommitId CommitId2 = this.permanentGraphInfo.getPermanentCommitsInfo().getCommitId(headNodeId);
        Intrinsics.checkNotNullExpressionValue(CommitId2, (String)"getCommitId(...)");
        CommitId headCommitId = CommitId2;
        int headLayoutIndex = this.permanentGraphInfo.getPermanentGraphLayout().getLayoutIndex(headNodeId);
        return this.colorManager.getColor(headCommitId, headLayoutIndex, layoutIndex);
    }
}

