/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.impl.permanent.GraphLayoutImpl;
import com.intellij.vcs.log.graph.utils.DfsUtilKt;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntList;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public final class GraphLayoutBuilder {
    private static final Logger LOG = Logger.getInstance(GraphLayoutBuilder.class);
    @NotNull
    private final LinearGraph myGraph;
    private final int @NotNull [] myLayoutIndex;
    @NotNull
    private final IntList myHeadNodeIndex;
    private final int @NotNull [] myStartLayoutIndexForHead;
    private int currentLayoutIndex;

    @NotNull
    public static GraphLayoutImpl build(@NotNull LinearGraph graph, @NotNull IntComparator headNodeIndexComparator) {
        if (graph == null) {
            GraphLayoutBuilder.$$$reportNull$$$0(0);
        }
        if (headNodeIndexComparator == null) {
            GraphLayoutBuilder.$$$reportNull$$$0(1);
        }
        IntArrayList heads = new IntArrayList();
        for (int i = 0; i < graph.nodesCount(); ++i) {
            if (!LinearGraphUtils.getUpNodes(graph, i).isEmpty()) continue;
            heads.add(i);
        }
        try {
            heads.sort(headNodeIndexComparator);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        GraphLayoutBuilder builder2 = new GraphLayoutBuilder(graph, (IntList)heads);
        return builder2.build();
    }

    private GraphLayoutBuilder(@NotNull LinearGraph graph, @NotNull IntList headNodeIndex) {
        if (graph == null) {
            GraphLayoutBuilder.$$$reportNull$$$0(2);
        }
        if (headNodeIndex == null) {
            GraphLayoutBuilder.$$$reportNull$$$0(3);
        }
        this.currentLayoutIndex = 1;
        this.myGraph = graph;
        this.myLayoutIndex = new int[graph.nodesCount()];
        this.myHeadNodeIndex = headNodeIndex;
        this.myStartLayoutIndexForHead = new int[headNodeIndex.size()];
    }

    private void dfs(int nodeIndex) {
        DfsUtilKt.walk(nodeIndex, (Function1<? super Integer, Integer>)((Function1)currentNode -> {
            boolean firstVisit;
            boolean bl = firstVisit = this.myLayoutIndex[currentNode] == 0;
            if (firstVisit) {
                this.myLayoutIndex[currentNode.intValue()] = this.currentLayoutIndex;
            }
            int childWithoutLayoutIndex = -1;
            for (int childNodeIndex : LinearGraphUtils.getDownNodes(this.myGraph, currentNode)) {
                if (this.myLayoutIndex[childNodeIndex] != 0) continue;
                childWithoutLayoutIndex = childNodeIndex;
                break;
            }
            if (childWithoutLayoutIndex == -1) {
                if (firstVisit) {
                    ++this.currentLayoutIndex;
                }
                return -1;
            }
            return childWithoutLayoutIndex;
        }));
    }

    @NotNull
    private GraphLayoutImpl build() {
        for (int i = 0; i < this.myHeadNodeIndex.size(); ++i) {
            int headNodeIndex = this.myHeadNodeIndex.getInt(i);
            this.myStartLayoutIndexForHead[i] = this.currentLayoutIndex;
            this.dfs(headNodeIndex);
        }
        return new GraphLayoutImpl(this.myLayoutIndex, this.myHeadNodeIndex, this.myStartLayoutIndexForHead);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headNodeIndexComparator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headNodeIndex";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

