/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.AbstractDataGetter;
import com.intellij.vcs.log.data.LoadingDetailsImpl;
import com.intellij.vcs.log.data.VcsLogStorage;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J6\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\u001cH\u0014J\u0017\u0010\u001d\u001a\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\u001e2\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J$\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00020\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0014J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u000eH\u0016J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u0002H\u0014RN\u0010\f\u001aB\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00020\u0002 \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00020\u0002\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0010\u001aB\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00120\u0012 \u000f* \u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/vcs/log/data/CommitDetailsGetter;", "Lcom/intellij/vcs/log/data/AbstractDataGetter;", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/vcs/log/data/VcsLogStorage;Ljava/util/Map;Lcom/intellij/openapi/Disposable;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "kotlin.jvm.PlatformType", "placeholdersCache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lcom/intellij/vcs/log/data/LoadingDetailsImpl;", "dispose", "", "doLoadCommitsDataFromProvider", "logProvider", "root", "hashes", "", "", "consumer", "Lcom/intellij/util/Consumer;", "getCachedData", "Lorg/checkerframework/checker/nullness/qual/Nullable;", "commitId", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "commits", "getCachedDataOrPlaceholder", "saveInCache", "commit", "details", "intellij.platform.vcs.log.impl"})
public final class CommitDetailsGetter
extends AbstractDataGetter<VcsFullCommitDetails> {
    private final Cache<Integer, VcsFullCommitDetails> cache;
    private final LoadingCache<Integer, LoadingDetailsImpl> placeholdersCache;

    public CommitDetailsGetter(@NotNull VcsLogStorage storage, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(storage, logProviders, parentDisposable);
        this.cache = Caffeine.newBuilder().maximumSize(10000L).build();
        this.placeholdersCache = Caffeine.newBuilder().maximumSize(1000L).weakValues().build(arg_0 -> CommitDetailsGetter.placeholdersCache$lambda$0((Function1)new Function1<Integer, LoadingDetailsImpl>(storage){
            final /* synthetic */ VcsLogStorage $storage;
            {
                this.$storage = $storage;
                super(1);
            }

            @Nullable
            public final LoadingDetailsImpl invoke(Integer it) {
                Intrinsics.checkNotNull((Object)it);
                return new LoadingDetailsImpl(this.$storage, it, 0L);
            }
        }, arg_0));
        LowMemoryWatcher.register(() -> CommitDetailsGetter._init_$lambda$1(this), (Disposable)this);
    }

    @Override
    @NotNull
    public VcsFullCommitDetails getCachedDataOrPlaceholder(int commitId2) {
        VcsFullCommitDetails vcsFullCommitDetails = this.getCachedData(commitId2);
        if (vcsFullCommitDetails == null) {
            Object object = this.placeholdersCache.get((Object)commitId2);
            Intrinsics.checkNotNull((Object)object);
            vcsFullCommitDetails = (VcsFullCommitDetails)object;
        }
        return vcsFullCommitDetails;
    }

    @Override
    @Nullable
    public VcsFullCommitDetails getCachedData(int commitId2) {
        return (VcsFullCommitDetails)this.cache.getIfPresent((Object)commitId2);
    }

    @Override
    @NotNull
    protected Int2ObjectOpenHashMap<VcsFullCommitDetails> getCachedData(@NotNull List<Integer> commits2) {
        Intrinsics.checkNotNullParameter(commits2, (String)"commits");
        return new Int2ObjectOpenHashMap(this.cache.getAllPresent((Iterable)commits2));
    }

    @Override
    protected void saveInCache(int commit2, @NotNull VcsFullCommitDetails details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.cache.put((Object)commit2, (Object)details);
    }

    @Override
    protected void doLoadCommitsDataFromProvider(@NotNull VcsLogProvider logProvider, @NotNull VirtualFile root, @NotNull List<String> hashes2, @NotNull Consumer<? super VcsFullCommitDetails> consumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)logProvider, (String)"logProvider");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(hashes2, (String)"hashes");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        logProvider.readFullDetails(root, hashes2, consumer);
    }

    public void dispose() {
        this.cache.invalidateAll();
        this.placeholdersCache.invalidateAll();
    }

    private static final LoadingDetailsImpl placeholdersCache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (LoadingDetailsImpl)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$1(CommitDetailsGetter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cache.invalidateAll();
    }
}

