/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.VcsLogFileHistoryHandler;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefresher;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsUser;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsLogProvider {
    public static final ExtensionPointName<VcsLogProvider> LOG_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.logProvider");

    @NotNull
    public DetailedLogData readFirstBlock(@NotNull VirtualFile var1, @NotNull Requirements var2) throws VcsException;

    @NotNull
    public LogData readAllHashes(@NotNull VirtualFile var1, @NotNull Consumer<? super TimedVcsCommit> var2) throws VcsException;

    public void readMetadata(@NotNull VirtualFile var1, @NotNull List<String> var2, @NotNull Consumer<? super VcsCommitMetadata> var3) throws VcsException;

    public void readFullDetails(@NotNull VirtualFile var1, @NotNull List<String> var2, @NotNull Consumer<? super VcsFullCommitDetails> var3) throws VcsException;

    @NotNull
    public VcsKey getSupportedVcs();

    @NotNull
    public VcsLogRefManager getReferenceManager();

    @NotNull
    public Disposable subscribeToRootRefreshEvents(@NotNull Collection<? extends VirtualFile> var1, @NotNull VcsLogRefresher var2);

    @NotNull
    public List<TimedVcsCommit> getCommitsMatchingFilter(@NotNull VirtualFile var1, @NotNull VcsLogFilterCollection var2, int var3) throws VcsException;

    @Nullable
    public VcsUser getCurrentUser(@NotNull VirtualFile var1) throws VcsException;

    @NotNull
    public Collection<String> getContainingBranches(@NotNull VirtualFile var1, @NotNull Hash var2) throws VcsException;

    @Nullable
    public <T> T getPropertyValue(VcsLogProperties.VcsLogProperty<T> var1);

    @Nullable
    public String getCurrentBranch(@NotNull VirtualFile var1);

    @Nullable
    default public VcsLogDiffHandler getDiffHandler() {
        return null;
    }

    @Nullable
    default public VcsLogFileHistoryHandler getFileHistoryHandler(Project project2) {
        return VcsLogFileHistoryHandler.getByVcs(project2, this.getSupportedVcs());
    }

    @Nullable
    default public Hash resolveReference(@NotNull String ref, @NotNull VirtualFile root) {
        if (ref == null) {
            VcsLogProvider.$$$reportNull$$$0(0);
        }
        if (root == null) {
            VcsLogProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    default public VirtualFile getVcsRoot(@NotNull Project project2, @NotNull VirtualFile detectedRoot, @NotNull FilePath filePath) {
        if (project2 == null) {
            VcsLogProvider.$$$reportNull$$$0(2);
        }
        if (detectedRoot == null) {
            VcsLogProvider.$$$reportNull$$$0(3);
        }
        if (filePath == null) {
            VcsLogProvider.$$$reportNull$$$0(4);
        }
        return detectedRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/VcsLogProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveReference";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getVcsRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface DetailedLogData {
        @NotNull
        public List<VcsCommitMetadata> getCommits();

        @NotNull
        public Set<VcsRef> getRefs();
    }

    public static interface LogData {
        @NotNull
        public Set<VcsRef> getRefs();

        @NotNull
        public Set<VcsUser> getUsers();
    }

    public static interface Requirements {
        public int getCommitCount();
    }
}

