/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.VcsSymlinkResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultVcsSymlinkResolver
implements VcsSymlinkResolver {
    private final Project myProject;
    private final Mode myMode;

    public DefaultVcsSymlinkResolver(@NotNull Project project2) {
        if (project2 == null) {
            DefaultVcsSymlinkResolver.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        RegistryValue value2 = Registry.get((String)"vcs.resolve.symlinks.for.vcs.operations");
        this.myMode = switch (value2.asString()) {
            case "force_target" -> Mode.FORCE_TARGET;
            case "prefer_target" -> Mode.PREFER_TARGET;
            case "fallback_target" -> Mode.FALLBACK_TARGET;
            default -> Mode.DISABLED;
        };
    }

    @Override
    public boolean isEnabled() {
        return this.myMode != Mode.DISABLED;
    }

    @Override
    @Nullable
    public VirtualFile resolveSymlink(@NotNull VirtualFile file) {
        if (file == null) {
            DefaultVcsSymlinkResolver.$$$reportNull$$$0(1);
        }
        if (this.myMode == Mode.DISABLED) {
            return file;
        }
        VirtualFile canonicalFile = file.getCanonicalFile();
        if (canonicalFile == null || file.equals(canonicalFile)) {
            return null;
        }
        if (this.myMode == Mode.FORCE_TARGET) {
            return canonicalFile;
        }
        if (this.myMode == Mode.PREFER_TARGET ? ProjectLevelVcsManager.getInstance(this.myProject).getVcsFor(canonicalFile) != null : this.myMode == Mode.FALLBACK_TARGET && ProjectLevelVcsManager.getInstance(this.myProject).getVcsFor(file) == null && ProjectLevelVcsManager.getInstance(this.myProject).getVcsFor(canonicalFile) != null) {
            return canonicalFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/DefaultVcsSymlinkResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveSymlink";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum Mode {
        FORCE_TARGET,
        PREFER_TARGET,
        FALLBACK_TARGET,
        DISABLED;

    }
}

