/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lvcs.impl.diff;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.platform.lvcs.impl.ActivityScope;
import com.intellij.platform.lvcs.impl.ActivityScopeKt;
import com.intellij.platform.lvcs.impl.ChangeSetSelection;
import com.intellij.platform.lvcs.impl.diff.DifferenceDiffRequestProducer;
import com.intellij.platform.lvcs.impl.diff.DifferenceWrapperKt;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0010\u0018\u00002\u00020\u0001B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0013\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\u000fH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020 H\u0016J\b\u0010'\u001a\u00020(H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0015R\u0014\u0010\u0004\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/platform/lvcs/impl/diff/DifferenceWrapper;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "scope", "Lcom/intellij/platform/lvcs/impl/ActivityScope$File;", "selection", "Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "difference", "Lcom/intellij/history/core/revisions/Difference;", "isOldContentUsed", "", "(Lcom/intellij/history/integration/IdeaGateway;Lcom/intellij/platform/lvcs/impl/ActivityScope$File;Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;Lcom/intellij/history/core/revisions/Difference;Z)V", "Lcom/intellij/platform/lvcs/impl/ActivityScope;", "targetFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/history/integration/IdeaGateway;Lcom/intellij/platform/lvcs/impl/ActivityScope;Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;Lcom/intellij/history/core/revisions/Difference;Lcom/intellij/openapi/vcs/FilePath;Z)V", "getDifference", "()Lcom/intellij/history/core/revisions/Difference;", "getGateway", "()Lcom/intellij/history/integration/IdeaGateway;", "()Z", "getScope", "()Lcom/intellij/platform/lvcs/impl/ActivityScope;", "getSelection", "()Lcom/intellij/platform/lvcs/impl/ChangeSetSelection;", "createProducer", "Lcom/intellij/diff/chains/DiffRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "equals", "other", "", "getFilePath", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getPresentableName", "", "getUserObject", "hashCode", "", "intellij.platform.lvcs.impl"})
public class DifferenceWrapper
extends ChangeViewDiffRequestProcessor.Wrapper {
    @NotNull
    private final IdeaGateway gateway;
    @NotNull
    private final ActivityScope scope;
    @NotNull
    private final ChangeSetSelection selection;
    @NotNull
    private final Difference difference;
    @NotNull
    private final FilePath targetFilePath;
    private final boolean isOldContentUsed;

    public DifferenceWrapper(@NotNull IdeaGateway gateway, @NotNull ActivityScope scope2, @NotNull ChangeSetSelection selection, @NotNull Difference difference, @NotNull FilePath targetFilePath, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)difference, (String)"difference");
        Intrinsics.checkNotNullParameter((Object)targetFilePath, (String)"targetFilePath");
        this.gateway = gateway;
        this.scope = scope2;
        this.selection = selection;
        this.difference = difference;
        this.targetFilePath = targetFilePath;
        this.isOldContentUsed = isOldContentUsed;
    }

    @NotNull
    protected final IdeaGateway getGateway() {
        return this.gateway;
    }

    @NotNull
    protected ActivityScope getScope() {
        return this.scope;
    }

    @NotNull
    protected final ChangeSetSelection getSelection() {
        return this.selection;
    }

    @NotNull
    protected final Difference getDifference() {
        return this.difference;
    }

    protected final boolean isOldContentUsed() {
        return this.isOldContentUsed;
    }

    public DifferenceWrapper(@NotNull IdeaGateway gateway, @NotNull ActivityScope.File scope2, @NotNull ChangeSetSelection selection, @NotNull Difference difference, boolean isOldContentUsed) {
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)difference, (String)"difference");
        ActivityScope activityScope = scope2;
        FilePath filePath = difference.getFilePath();
        if (filePath == null) {
            filePath = ActivityScopeKt.getFilePath(scope2);
        }
        FilePath filePath2 = filePath;
        Intrinsics.checkNotNull((Object)filePath2);
        this(gateway, activityScope, selection, difference, filePath2, isOldContentUsed);
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        return this.targetFilePath;
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        return DifferenceWrapperKt.fileStatus(this.difference.getLeft() != null, this.difference.getRight() != null);
    }

    @Override
    @NotNull
    public Object getUserObject() {
        return this.difference;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string2 = this.targetFilePath.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return string2;
    }

    @Override
    @NotNull
    public DiffRequestProducer createProducer(@Nullable Project project2) {
        return new DifferenceDiffRequestProducer(project2, this.gateway, this.getScope(), this.selection, this.difference, this.isOldContentUsed);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DifferenceWrapper)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getScope(), (Object)((DifferenceWrapper)other).getScope())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.selection, (Object)((DifferenceWrapper)other).selection)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.difference, (Object)((DifferenceWrapper)other).difference);
    }

    @Override
    public int hashCode() {
        Object[] objectArray = new Object[]{this.getScope(), this.selection, this.difference};
        return Objects.hash(objectArray);
    }
}

