/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.intentions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.SelectedBlockHistoryAction;
import com.intellij.psi.PsiFile;
import com.intellij.vcsUtil.VcsSelection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0005H\u0016J!\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/intentions/SelectedBlockHistoryIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "getFamilyName", "", "getSelection", "Lcom/intellij/vcsUtil/VcsSelection;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "intellij.platform.vcs.impl"})
public final class SelectedBlockHistoryIntention
implements IntentionAction,
LowPriorityAction {
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = CodeInsightBundle.message((String)"intention.show.history.for.block.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VcsSelection vcsSelection = this.getSelection(editor);
        if (vcsSelection == null) {
            return false;
        }
        VcsSelection selection = vcsSelection;
        return SelectedBlockHistoryAction.isEnabled(project2, selection);
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VcsSelection vcsSelection = this.getSelection(editor);
        if (vcsSelection == null) {
            return;
        }
        VcsSelection selection = vcsSelection;
        SelectedBlockHistoryAction.showHistoryForSelection(selection, project2);
    }

    private final VcsSelection getSelection(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"getSelectionModel(...)");
        SelectionModel selectionModel2 = selectionModel;
        if (selectionModel2.hasSelection()) {
            return new VcsSelection(editor.getDocument(), new TextRange(selectionModel2.getSelectionStart(), selectionModel2.getSelectionEnd()), VcsBundle.message("action.name.show.history.for.selection", new Object[0]));
        }
        return null;
    }
}

