/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.components.ActionLink;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class VcsUpdateInfoScopeFilterConfigurable
implements Configurable,
NamedScopesHolder.ScopeListener,
Disposable {
    private final JCheckBox myCheckbox;
    private final ComboBox<String> myComboBox;
    private final VcsConfiguration myVcsConfiguration;
    private final NamedScopesHolder[] myNamedScopeHolders;

    VcsUpdateInfoScopeFilterConfigurable(@NotNull Project project2, VcsConfiguration vcsConfiguration) {
        if (project2 == null) {
            VcsUpdateInfoScopeFilterConfigurable.$$$reportNull$$$0(0);
        }
        this.myVcsConfiguration = vcsConfiguration;
        this.myCheckbox = new JCheckBox(VcsBundle.message("settings.filter.update.project.info.by.scope", new Object[0]));
        this.myComboBox = new ComboBox();
        this.myComboBox.setEnabled(this.myCheckbox.isSelected());
        this.myCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsUpdateInfoScopeFilterConfigurable.this.myComboBox.setEnabled(VcsUpdateInfoScopeFilterConfigurable.this.myCheckbox.isSelected());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/configurable/VcsUpdateInfoScopeFilterConfigurable$1", "stateChanged"));
            }
        });
        for (NamedScopesHolder holder : this.myNamedScopeHolders = NamedScopesHolder.getAllNamedScopeHolders((Project)project2)) {
            holder.addScopeListener((NamedScopesHolder.ScopeListener)this, (Disposable)this);
        }
    }

    public void scopesChanged() {
        this.reset();
    }

    @Nls
    public String getDisplayName() {
        return VcsBundle.message("settings.filter.update.project.info.by.scope", new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        JPanel panel2 = new JPanel(new FlowLayout(0, 0, 0));
        panel2.add(this.myCheckbox);
        panel2.add((Component)this.myComboBox);
        panel2.add(Box.createHorizontalStrut(10));
        panel2.add((Component)new ActionLink(VcsBundle.message("configurable.vcs.manage.scopes", new Object[0]), e -> {
            Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)panel2));
            if (settings != null) {
                settings.select(settings.find("project.scopes"));
            }
        }));
        JPanel jPanel = panel2;
        if (jPanel == null) {
            VcsUpdateInfoScopeFilterConfigurable.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    public boolean isModified() {
        return !Objects.equals(this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME, this.getScopeFilterName());
    }

    public void apply() {
        this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME = this.getScopeFilterName();
    }

    public void reset() {
        this.myComboBox.removeAllItems();
        boolean selection = false;
        for (NamedScopesHolder holder : this.myNamedScopeHolders) {
            for (NamedScope scope2 : holder.getEditableScopes()) {
                @NlsSafe String name = scope2.getScopeId();
                this.myComboBox.addItem((Object)name);
                if (selection || !name.equals(this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME)) continue;
                selection = true;
            }
        }
        if (selection) {
            this.myComboBox.setItem((Object)this.myVcsConfiguration.UPDATE_FILTER_SCOPE_NAME);
        }
        this.myCheckbox.setSelected(selection);
    }

    public void dispose() {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    private String getScopeFilterName() {
        if (!this.myCheckbox.isSelected()) {
            return null;
        }
        return (String)this.myComboBox.getItem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/configurable/VcsUpdateInfoScopeFilterConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsUpdateInfoScopeFilterConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

