/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.openapi.vcs.IssueNavigationLink;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.configurable.IssueLinkConfigurationDialog;
import com.intellij.openapi.vcs.configurable.IssueNavigationConfigurable;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.UIBundle;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0003\u0014\u0015\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0012H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "Lcom/intellij/openapi/options/Configurable$NoScroll;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "ISSUE_COLUMN", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/openapi/vcs/IssueNavigationLink;", "", "LINK_COLUMN", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "editLink", "", "linkTable", "Lcom/intellij/ui/table/JBTable;", "model", "Lcom/intellij/util/ui/ListTableModel;", "removeLink", "AddIssueNavigationLinkAction", "AddJiraLinkAction", "AddYouTrackLinkAction", "intellij.platform.vcs.impl"})
public final class IssueNavigationConfigurable
extends BoundSearchableConfigurable
implements Configurable.NoScroll {
    @NotNull
    private final Project project;
    @NotNull
    private final ColumnInfo<IssueNavigationLink, String> ISSUE_COLUMN;
    @NotNull
    private final ColumnInfo<IssueNavigationLink, String> LINK_COLUMN;

    public IssueNavigationConfigurable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        String string2 = VcsBundle.message("configurable.IssueNavigationConfigurationPanel.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        super(string2, "project.propVCSSupport.Issue.Navigation", null, 4, null);
        this.project = project2;
        String string3 = VcsBundle.message("issue.link.issue.column", new Object[0]);
        this.ISSUE_COLUMN = (ColumnInfo)new ColumnInfo<IssueNavigationLink, String>(string3){

            @NotNull
            public String valueOf(@NotNull IssueNavigationLink issueNavigationLink) {
                Intrinsics.checkNotNullParameter((Object)issueNavigationLink, (String)"issueNavigationLink");
                String string2 = issueNavigationLink.getIssueRegexp();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIssueRegexp(...)");
                return string2;
            }
        };
        string3 = VcsBundle.message("issue.link.link.column", new Object[0]);
        this.LINK_COLUMN = (ColumnInfo)new ColumnInfo<IssueNavigationLink, String>(string3){

            @NotNull
            public String valueOf(@NotNull IssueNavigationLink issueNavigationLink) {
                Intrinsics.checkNotNullParameter((Object)issueNavigationLink, (String)"issueNavigationLink");
                String string2 = issueNavigationLink.getLinkRegexp();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLinkRegexp(...)");
                return string2;
            }
        };
    }

    @NotNull
    public DialogPanel createPanel() {
        IssueNavigationConfiguration configuration = IssueNavigationConfiguration.getInstance(this.project);
        List links = new ArrayList();
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{this.ISSUE_COLUMN, this.LINK_COLUMN};
        ListTableModel model2 = new ListTableModel(columnInfoArray, links, 0);
        JBTable linkTable = new JBTable((TableModel)model2);
        linkTable.setShowGrid(false);
        linkTable.getEmptyText().setText(VcsBundle.message("issue.link.no.patterns", new Object[0]));
        AnAction[] anActionArray = new AnAction[]{new AddYouTrackLinkAction(linkTable, (ListTableModel<IssueNavigationLink>)model2), new AddJiraLinkAction(linkTable, (ListTableModel<IssueNavigationLink>)model2), new AddIssueNavigationLinkAction((ListTableModel<IssueNavigationLink>)model2)};
        DefaultActionGroup addGroup = new DefaultActionGroup(anActionArray);
        addGroup.getTemplatePresentation().setPopupGroup(true);
        addGroup.getTemplatePresentation().setIcon(AllIcons.General.Add);
        addGroup.getTemplatePresentation().setText(UIBundle.messagePointer((String)"button.text.add.with.ellipsis", (Object[])new Object[0]));
        addGroup.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), null);
        String[] stringArray = new String[]{UIBundle.message((String)"button.text.add.with.ellipsis", (Object[])new Object[0]), VcsBundle.message("configurable.issue.link.edit", new Object[0]), VcsBundle.message("configurable.issue.link.remove", new Object[0])};
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)linkTable)).disableAddAction().addExtraAction((AnAction)addGroup).setRemoveAction(arg_0 -> IssueNavigationConfigurable.createPanel$lambda$0(this, linkTable, model2, arg_0)).setEditAction(arg_0 -> IssueNavigationConfigurable.createPanel$lambda$1(this, linkTable, model2, arg_0)).setButtonComparator(stringArray).disableUpDownActions().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel decorator = jPanel;
        return BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(decorator, (List<IssueNavigationLink>)links, configuration, (ListTableModel<IssueNavigationLink>)model2){
            final /* synthetic */ JPanel $decorator;
            final /* synthetic */ List<IssueNavigationLink> $links;
            final /* synthetic */ IssueNavigationConfiguration $configuration;
            final /* synthetic */ ListTableModel<IssueNavigationLink> $model;
            {
                this.$decorator = $decorator;
                this.$links = $links;
                this.$configuration = $configuration;
                this.$model = $model;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)createPanel.1.INSTANCE, (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$decorator, this.$links, this.$configuration, this.$model){
                    final /* synthetic */ JPanel $decorator;
                    final /* synthetic */ List<IssueNavigationLink> $links;
                    final /* synthetic */ IssueNavigationConfiguration $configuration;
                    final /* synthetic */ ListTableModel<IssueNavigationLink> $model;
                    {
                        this.$decorator = $decorator;
                        this.$links = $links;
                        this.$configuration = $configuration;
                        this.$model = $model;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)this.$decorator).align(Align.FILL).onReset((Function0)new Function0<Unit>(this.$links, this.$configuration, this.$model){
                            final /* synthetic */ List<IssueNavigationLink> $links;
                            final /* synthetic */ IssueNavigationConfiguration $configuration;
                            final /* synthetic */ ListTableModel<IssueNavigationLink> $model;
                            {
                                this.$links = $links;
                                this.$configuration = $configuration;
                                this.$model = $model;
                                super(0);
                            }

                            public final void invoke() {
                                this.$links.clear();
                                for (IssueNavigationLink link2 : this.$configuration.getLinks()) {
                                    ((Collection)this.$links).add(new IssueNavigationLink(link2.getIssueRegexp(), link2.getLinkRegexp()));
                                }
                                this.$model.fireTableDataChanged();
                            }
                        }).onApply((Function0)new Function0<Unit>(this.$configuration, this.$links){
                            final /* synthetic */ IssueNavigationConfiguration $configuration;
                            final /* synthetic */ List<IssueNavigationLink> $links;
                            {
                                this.$configuration = $configuration;
                                this.$links = $links;
                                super(0);
                            }

                            public final void invoke() {
                                this.$configuration.setLinks(this.$links);
                            }
                        }).onIsModified((Function0)new Function0<Boolean>(this.$links, this.$configuration){
                            final /* synthetic */ List<IssueNavigationLink> $links;
                            final /* synthetic */ IssueNavigationConfiguration $configuration;
                            {
                                this.$links = $links;
                                this.$configuration = $configuration;
                                super(0);
                            }

                            @NotNull
                            public final Boolean invoke() {
                                return !Intrinsics.areEqual(this.$links, this.$configuration.getLinks());
                            }
                        });
                    }
                }), (int)1, null).resizableRow();
            }
        }));
    }

    private final void removeLink(JBTable linkTable, ListTableModel<IssueNavigationLink> model2) {
        if (Messages.showOkCancelDialog((Project)this.project, (String)VcsBundle.message("issue.link.delete.prompt", new Object[0]), (String)VcsBundle.message("issue.link.delete.title", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
            int selRow = linkTable.getSelectedRow();
            model2.removeRow(selRow);
            model2.fireTableDataChanged();
            if (linkTable.getRowCount() > 0) {
                if (selRow >= linkTable.getRowCount()) {
                    --selRow;
                }
                linkTable.getSelectionModel().setSelectionInterval(selRow, selRow);
            }
        }
    }

    private final void editLink(JBTable linkTable, ListTableModel<IssueNavigationLink> model2) {
        Object object = model2.getItem(linkTable.getSelectedRow());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItem(...)");
        IssueNavigationLink link2 = (IssueNavigationLink)object;
        IssueLinkConfigurationDialog dlg = new IssueLinkConfigurationDialog(this.project);
        dlg.setTitle(VcsBundle.message("issue.link.edit.title", new Object[0]));
        dlg.setLink(link2);
        if (dlg.showAndGet()) {
            IssueNavigationLink editedLink = dlg.getLink();
            link2.setIssueRegexp(editedLink.getIssueRegexp());
            link2.setLinkRegexp(editedLink.getLinkRegexp());
            model2.fireTableDataChanged();
        }
    }

    private static final void createPanel$lambda$0(IssueNavigationConfigurable this$0, JBTable $linkTable, ListTableModel $model, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$linkTable, (String)"$linkTable");
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        this$0.removeLink($linkTable, (ListTableModel<IssueNavigationLink>)$model);
    }

    private static final void createPanel$lambda$1(IssueNavigationConfigurable this$0, JBTable $linkTable, ListTableModel $model, AnActionButton it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$linkTable, (String)"$linkTable");
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        this$0.editLink($linkTable, (ListTableModel<IssueNavigationLink>)$model);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable$AddIssueNavigationLinkAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "model", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/openapi/vcs/IssueNavigationLink;", "(Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable;Lcom/intellij/util/ui/ListTableModel;)V", "getModel", "()Lcom/intellij/util/ui/ListTableModel;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.impl"})
    private final class AddIssueNavigationLinkAction
    extends DumbAwareAction {
        @NotNull
        private final ListTableModel<IssueNavigationLink> model;

        public AddIssueNavigationLinkAction(ListTableModel<IssueNavigationLink> model2) {
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            super(VcsBundle.messagePointer("issue.link.add.title", new Object[0]));
            this.model = model2;
        }

        @NotNull
        public final ListTableModel<IssueNavigationLink> getModel() {
            return this.model;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            IssueLinkConfigurationDialog dlg = new IssueLinkConfigurationDialog(IssueNavigationConfigurable.this.project);
            dlg.setTitle(VcsBundle.message("issue.link.add.title", new Object[0]));
            if (dlg.showAndGet()) {
                this.model.addRow((Object)dlg.getLink());
                this.model.fireTableDataChanged();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable$AddJiraLinkAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "linkTable", "Lcom/intellij/ui/table/JBTable;", "model", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/openapi/vcs/IssueNavigationLink;", "(Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable;Lcom/intellij/ui/table/JBTable;Lcom/intellij/util/ui/ListTableModel;)V", "getLinkTable", "()Lcom/intellij/ui/table/JBTable;", "getModel", "()Lcom/intellij/util/ui/ListTableModel;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.impl"})
    private final class AddJiraLinkAction
    extends DumbAwareAction {
        @NotNull
        private final JBTable linkTable;
        @NotNull
        private final ListTableModel<IssueNavigationLink> model;

        public AddJiraLinkAction(@NotNull JBTable linkTable, ListTableModel<IssueNavigationLink> model2) {
            Intrinsics.checkNotNullParameter((Object)linkTable, (String)"linkTable");
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            super(VcsBundle.messagePointer("action.AnActionButton.text.add.jira.pattern", new Object[0]));
            this.linkTable = linkTable;
            this.model = model2;
        }

        @NotNull
        public final JBTable getLinkTable() {
            return this.linkTable;
        }

        @NotNull
        public final ListTableModel<IssueNavigationLink> getModel() {
            return this.model;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String string2 = Messages.showInputDialog((Component)((Component)this.linkTable), (String)VcsBundle.message("issue.action.enter.jira.installation.url.label", new Object[0]), (String)VcsBundle.message("issue.action.add.jira.issue.navigation.pattern.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (string2 == null) {
                return;
            }
            Object s = string2;
            if (!StringsKt.endsWith$default((String)s, (String)"/", (boolean)false, (int)2, null)) {
                s = (String)s + "/";
            }
            this.model.addRow((Object)new IssueNavigationLink("[A-Z]+\\-\\d+", (String)s + "browse/$0"));
            this.model.fireTableDataChanged();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable$AddYouTrackLinkAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "linkTable", "Lcom/intellij/ui/table/JBTable;", "model", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/openapi/vcs/IssueNavigationLink;", "(Lcom/intellij/openapi/vcs/configurable/IssueNavigationConfigurable;Lcom/intellij/ui/table/JBTable;Lcom/intellij/util/ui/ListTableModel;)V", "getLinkTable", "()Lcom/intellij/ui/table/JBTable;", "getModel", "()Lcom/intellij/util/ui/ListTableModel;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.vcs.impl"})
    private final class AddYouTrackLinkAction
    extends DumbAwareAction {
        @NotNull
        private final JBTable linkTable;
        @NotNull
        private final ListTableModel<IssueNavigationLink> model;

        public AddYouTrackLinkAction(@NotNull JBTable linkTable, ListTableModel<IssueNavigationLink> model2) {
            Intrinsics.checkNotNullParameter((Object)linkTable, (String)"linkTable");
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            super(VcsBundle.messagePointer("action.AnActionButton.text.add.youtrack.pattern", new Object[0]));
            this.linkTable = linkTable;
            this.model = model2;
        }

        @NotNull
        public final JBTable getLinkTable() {
            return this.linkTable;
        }

        @NotNull
        public final ListTableModel<IssueNavigationLink> getModel() {
            return this.model;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String string2 = Messages.showInputDialog((Component)((Component)this.linkTable), (String)VcsBundle.message("issue.action.enter.youtrack.installation.url.label", new Object[0]), (String)VcsBundle.message("issue.action.add.youtrack.issue.navigation.pattern.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (string2 == null) {
                return;
            }
            Object s = string2;
            if (!StringsKt.endsWith$default((String)s, (String)"/", (boolean)false, (int)2, null)) {
                s = (String)s + "/";
            }
            this.model.addRow((Object)new IssueNavigationLink("[A-Z]+\\-\\d+", (String)s + "issue/$0"));
            this.model.fireTableDataChanged();
        }
    }
}

