/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.vcs.commit.AbstractCommitWorkflowKt;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015BB\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u000eH\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u000eH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/SessionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "title", "", "Lorg/jetbrains/annotations/Nls;", "project", "Lcom/intellij/openapi/project/Project;", "mySession", "Lcom/intellij/openapi/vcs/changes/CommitSession;", "myChanges", "", "Lcom/intellij/openapi/vcs/changes/Change;", "myCommitMessage", "myConfigurationComponent", "Ljavax/swing/JComponent;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/CommitSession;Ljava/util/List;Ljava/lang/String;Ljavax/swing/JComponent;)V", "createCenterPanel", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getHelpId", "getPreferredFocusedComponent", "Companion", "intellij.platform.vcs.impl"})
public final class SessionDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommitSession mySession;
    @NotNull
    private final List<Change> myChanges;
    @Nullable
    private final String myCommitMessage;
    @NotNull
    private final JComponent myConfigurationComponent;
    @NonNls
    @NotNull
    public static final String VCS_CONFIGURATION_UI_TITLE = "Vcs.SessionDialog.title";

    public SessionDialog(@NotNull String title2, @NotNull Project project2, @NotNull CommitSession mySession, @NotNull List<? extends Change> myChanges, @Nullable String myCommitMessage, @NotNull JComponent myConfigurationComponent) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mySession, (String)"mySession");
        Intrinsics.checkNotNullParameter(myChanges, (String)"myChanges");
        Intrinsics.checkNotNullParameter((Object)myConfigurationComponent, (String)"myConfigurationComponent");
        super(project2, true);
        this.mySession = mySession;
        this.myChanges = myChanges;
        this.myCommitMessage = myCommitMessage;
        this.myConfigurationComponent = myConfigurationComponent;
        Object object = this.myConfigurationComponent.getClientProperty(VCS_CONFIGURATION_UI_TITLE);
        String configurationComponentName = object instanceof String ? (String)object : null;
        object = configurationComponentName;
        this.setTitle(object == null || StringsKt.isBlank((CharSequence)object) ? AbstractCommitWorkflowKt.removeEllipsisSuffix(title2) : configurationComponentName);
        this.init();
        this.initValidation();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.myConfigurationComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)this.myConfigurationComponent);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.setOKActionEnabled(this.mySession.canExecute((Collection<? extends Change>)this.myChanges, this.myCommitMessage));
        return this.mySession.validateFields();
    }

    @Nullable
    protected String getHelpId() {
        return this.mySession.getHelpId();
    }

    @JvmStatic
    public static final boolean configureCommitSession(@NotNull Project project2, @NotNull String title2, @NotNull CommitSession commitSession, @NotNull List<? extends Change> changes2, @Nullable String commitMessage) {
        return Companion.configureCommitSession(project2, title2, commitSession, changes2, commitMessage);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000b\u0010\t\u001a\u00070\u0004\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/SessionDialog$Companion;", "", "()V", "VCS_CONFIGURATION_UI_TITLE", "", "configureCommitSession", "", "project", "Lcom/intellij/openapi/project/Project;", "title", "Lorg/jetbrains/annotations/Nls;", "commitSession", "Lcom/intellij/openapi/vcs/changes/CommitSession;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "commitMessage", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean configureCommitSession(@NotNull Project project2, @NotNull String title2, @NotNull CommitSession commitSession, @NotNull List<? extends Change> changes2, @Nullable String commitMessage) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter((Object)commitSession, (String)"commitSession");
            Intrinsics.checkNotNullParameter(changes2, (String)"changes");
            JComponent jComponent = commitSession.getAdditionalConfigurationUI((Collection<? extends Change>)changes2, commitMessage);
            if (jComponent == null) {
                return true;
            }
            JComponent configurationUI = jComponent;
            SessionDialog sessionDialog = new SessionDialog(title2, project2, commitSession, changes2, commitMessage, configurationUI);
            if (sessionDialog.showAndGet()) {
                return true;
            }
            commitSession.executionCanceled();
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

