/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.history.ActivityId;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vcs.rollback.DefaultRollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.VcsActivity;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackWorker {
    private static final Logger LOG = Logger.getInstance(RollbackWorker.class);
    private final Project myProject;
    @Nls(capitalization=Nls.Capitalization.Title)
    private final String myOperationName;
    private final boolean myInvokedFromModalContext;
    private final List<VcsException> myExceptions;

    public RollbackWorker(Project project2) {
        this(project2, DefaultRollbackEnvironment.getRollbackOperationText(), false);
    }

    public RollbackWorker(Project project2, @Nls(capitalization=Nls.Capitalization.Title) String operationName, boolean invokedFromModalContext) {
        this.myProject = project2;
        this.myOperationName = operationName;
        this.myInvokedFromModalContext = invokedFromModalContext;
        this.myExceptions = new ArrayList<VcsException>(0);
    }

    public void doRollback(@NotNull Collection<? extends Change> changes2, boolean deleteLocallyAddedFiles) {
        if (changes2 == null) {
            RollbackWorker.$$$reportNull$$$0(0);
        }
        this.doRollback(changes2, deleteLocallyAddedFiles, VcsBundle.message("activity.name.rollback", new Object[0]), VcsActivity.Rollback);
    }

    public void doRollback(@NotNull Collection<? extends Change> changes2, boolean deleteLocallyAddedFiles, @Nullable Runnable afterVcsRefreshInAwt, @Nullable @Nls String localHistoryActionName) {
        if (changes2 == null) {
            RollbackWorker.$$$reportNull$$$0(1);
        }
        this.doRollback(changes2, deleteLocallyAddedFiles, afterVcsRefreshInAwt, (String)ObjectUtils.chooseNotNull((Object)localHistoryActionName, (Object)VcsBundle.message("activity.name.rollback", new Object[0])), VcsActivity.Rollback, false);
    }

    public void doRollback(@NotNull Collection<? extends Change> changes2, boolean deleteLocallyAddedFiles, @NotNull @NlsContexts.Label String localHistoryActionName, @NotNull ActivityId activityId) {
        if (changes2 == null) {
            RollbackWorker.$$$reportNull$$$0(2);
        }
        if (localHistoryActionName == null) {
            RollbackWorker.$$$reportNull$$$0(3);
        }
        if (activityId == null) {
            RollbackWorker.$$$reportNull$$$0(4);
        }
        this.doRollback(changes2, deleteLocallyAddedFiles, null, localHistoryActionName, activityId, false);
    }

    public void doRollback(@NotNull Collection<? extends Change> changes2, boolean deleteLocallyAddedFiles, @Nullable Runnable afterVcsRefreshInAwt, @NotNull @NlsContexts.Label String localHistoryActionName, @Nullable ActivityId activityId, boolean honorExcludedFromCommit) {
        if (changes2 == null) {
            RollbackWorker.$$$reportNull$$$0(5);
        }
        if (localHistoryActionName == null) {
            RollbackWorker.$$$reportNull$$$0(6);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
            Collection affectedChangelists = changeListManager.getAffectedLists((Collection)changes2);
            LocalHistoryAction action2 = activityId != null ? LocalHistory.getInstance().startAction(localHistoryActionName, activityId) : null;
            Runnable afterRefresh = () -> {
                if (action2 != null) {
                    action2.finish();
                }
                LocalHistory.getInstance().putSystemLabel(this.myProject, localHistoryActionName, -1);
                InvokeAfterUpdateMode updateMode = this.myInvokedFromModalContext ? InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE : InvokeAfterUpdateMode.SILENT;
                changeListManager.invokeAfterUpdate(() -> {
                    for (LocalChangeList list2 : affectedChangelists) {
                        changeListManager.scheduleAutomaticEmptyChangeListDeletion(list2);
                    }
                    if (afterVcsRefreshInAwt != null) {
                        afterVcsRefreshInAwt.run();
                    }
                }, updateMode, VcsBundle.message("changes.refresh.changelists.after.update", new Object[0]), ModalityState.current());
            };
            List<Change> otherChanges = this.revertPartialChanges(changes2, honorExcludedFromCommit);
            if (otherChanges.isEmpty()) {
                WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)afterRefresh, null, (Project)this.myProject);
                return;
            }
            final MyRollbackRunnable rollbackAction = new MyRollbackRunnable(otherChanges, deleteLocallyAddedFiles, afterRefresh);
            if (ApplicationManager.getApplication().isDispatchThread() && !this.myInvokedFromModalContext) {
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, this.myOperationName, false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        rollbackAction.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ui/RollbackWorker$1", "run"));
                    }
                });
            } else if (this.myInvokedFromModalContext) {
                ProgressManager.getInstance().run((Task)new Task.Modal(this.myProject, this.myOperationName, false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        rollbackAction.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/changes/ui/RollbackWorker$2", "run"));
                    }
                });
            } else {
                rollbackAction.run();
            }
            changeListManager.showLocalChangesInvalidated();
        });
    }

    @NotNull
    private List<Change> revertPartialChanges(@NotNull Collection<? extends Change> changes2, boolean honorExcludedFromCommit) {
        if (changes2 == null) {
            RollbackWorker.$$$reportNull$$$0(7);
        }
        List<Change> list2 = PartialChangesUtil.processPartialChanges(this.myProject, changes2, true, (PairFunction<? super List<ChangeListChange>, ? super PartialLocalLineStatusTracker, Boolean>)((PairFunction)(partialChanges, tracker) -> {
            Set selectedIds;
            if (!tracker.hasPartialChangesToCommit()) {
                return false;
            }
            if (!tracker.isOperational()) {
                LOG.warn("Skipping non-operational tracker: " + tracker);
                return false;
            }
            if (!honorExcludedFromCommit && (selectedIds = ContainerUtil.map2Set((Collection)partialChanges, change -> change.getChangeListId())).containsAll(tracker.getAffectedChangeListsIds())) {
                return false;
            }
            List changelistIds = ContainerUtil.map((Collection)partialChanges, change -> change.getChangeListId());
            tracker.rollbackChanges(changelistIds, honorExcludedFromCommit);
            return true;
        }));
        if (list2 == null) {
            RollbackWorker.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localHistoryActionName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/RollbackWorker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/RollbackWorker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "revertPartialChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doRollback";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "revertPartialChanges";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8 -> new IllegalStateException(string2);
        };
    }

    private final class MyRollbackRunnable
    implements Runnable {
        private final Collection<? extends Change> myChanges;
        private final boolean myDeleteLocallyAddedFiles;
        private final Runnable myAfterRefresh;
        private ProgressIndicator myIndicator;

        private MyRollbackRunnable(Collection<? extends Change> changes2, boolean deleteLocallyAddedFiles, Runnable afterRefresh) {
            this.myChanges = changes2;
            this.myDeleteLocallyAddedFiles = deleteLocallyAddedFiles;
            this.myAfterRefresh = afterRefresh;
        }

        @Override
        public void run() {
            ChangesUtil.markInternalOperation(this.myChanges, true);
            try {
                this.doRun();
            }
            finally {
                ChangesUtil.markInternalOperation(this.myChanges, false);
            }
        }

        private void doRun() {
            this.myIndicator = ProgressManager.getInstance().getProgressIndicator();
            ArrayList changesToRefresh = new ArrayList();
            try {
                ChangesUtil.processChangesByVcs(RollbackWorker.this.myProject, this.myChanges, (vcs, changes2) -> {
                    RollbackEnvironment environment = vcs.getRollbackEnvironment();
                    if (environment != null) {
                        changesToRefresh.addAll(changes2);
                        if (this.myIndicator != null) {
                            this.myIndicator.setText(VcsBundle.message("changes.progress.text.vcs.name.performing.operation.name", vcs.getDisplayName(), StringUtil.toLowerCase((String)RollbackWorker.this.myOperationName)));
                            this.myIndicator.setIndeterminate(false);
                            this.myIndicator.checkCanceled();
                        }
                        environment.rollbackChanges(changes2, RollbackWorker.this.myExceptions, new RollbackProgressModifier(changes2.size(), this.myIndicator));
                        if (this.myIndicator != null) {
                            this.myIndicator.setText2("");
                            this.myIndicator.checkCanceled();
                        }
                        if (RollbackWorker.this.myExceptions.isEmpty() && this.myDeleteLocallyAddedFiles) {
                            this.deleteAddedFilesLocally(changes2);
                        }
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            if (this.myIndicator != null) {
                this.myIndicator.setIndeterminate(true);
                this.myIndicator.setText2("");
                this.myIndicator.setText(VcsBundle.message("progress.text.synchronizing.files", new Object[0]));
            }
            this.doRefresh(RollbackWorker.this.myProject, changesToRefresh);
            if (!RollbackWorker.this.myExceptions.isEmpty()) {
                AbstractVcsHelper.getInstance(RollbackWorker.this.myProject).showErrors(RollbackWorker.this.myExceptions, RollbackWorker.this.myOperationName);
            }
        }

        private void doRefresh(Project project2, List<? extends Change> changesToRefresh) {
            VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance(RollbackWorker.this.myProject);
            ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(RollbackWorker.this.myProject);
            for (FilePath filePath : ChangesUtil.iteratePaths(changesToRefresh)) {
                MyRollbackRunnable.markDirty(filePath, vcsManager2, dirtyScopeManager);
            }
            RefreshVFsSynchronously.updateChangesForRollback(changesToRefresh);
            WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)this.myAfterRefresh, null, (Project)project2);
        }

        private static void markDirty(@NotNull FilePath filePath, @NotNull ProjectLevelVcsManager vcsManager2, @NotNull VcsDirtyScopeManager dirtyScopeManager) {
            FilePath parentPath;
            AbstractVcs vcs;
            if (filePath == null) {
                MyRollbackRunnable.$$$reportNull$$$0(0);
            }
            if (vcsManager2 == null) {
                MyRollbackRunnable.$$$reportNull$$$0(1);
            }
            if (dirtyScopeManager == null) {
                MyRollbackRunnable.$$$reportNull$$$0(2);
            }
            if ((vcs = vcsManager2.getVcsFor(filePath)) == null) {
                return;
            }
            if (vcs.areDirectoriesVersionedItems() && (parentPath = filePath.getParentPath()) != null && vcsManager2.getVcsFor(parentPath) == vcs) {
                dirtyScopeManager.dirDirtyRecursively(parentPath);
                return;
            }
            dirtyScopeManager.fileDirty(filePath);
        }

        private void deleteAddedFilesLocally(List<? extends Change> changes2) {
            if (this.myIndicator != null) {
                this.myIndicator.setText(VcsBundle.message("changes.deleting.added.files.locally", new Object[0]));
                this.myIndicator.setFraction(0.0);
            }
            int changesSize = changes2.size();
            for (int i = 0; i < changesSize; ++i) {
                Change c = changes2.get(i);
                if (c.getType() != Change.Type.NEW) continue;
                ContentRevision rev = c.getAfterRevision();
                assert (rev != null);
                File ioFile = rev.getFile().getIOFile();
                if (this.myIndicator != null) {
                    this.myIndicator.setText2(ioFile.getAbsolutePath());
                    this.myIndicator.setFraction((double)i / (double)changesSize);
                }
                FileUtil.delete((File)ioFile);
            }
            if (this.myIndicator != null) {
                this.myIndicator.setText2("");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vcsManager";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dirtyScopeManager";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ui/RollbackWorker$MyRollbackRunnable";
            objectArray[2] = "markDirty";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

