/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CurrentBinaryContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShelvedBinaryFile
implements JDOMExternalizable {
    public String BEFORE_PATH;
    public String AFTER_PATH;
    @Nullable
    public String SHELVED_PATH;
    private Change myChange;

    ShelvedBinaryFile() {
    }

    public ShelvedBinaryFile(String beforePath, String afterPath, @Nullable String shelvedPath) {
        assert (beforePath != null || afterPath != null);
        this.BEFORE_PATH = beforePath;
        this.AFTER_PATH = afterPath;
        this.SHELVED_PATH = shelvedPath;
        this.convertPathsToSystemIndependent();
    }

    @Nullable
    private static String convertToSystemIndependent(@Nullable String beforePath) {
        return beforePath != null ? FileUtil.toSystemIndependentName((String)beforePath) : null;
    }

    private void convertPathsToSystemIndependent() {
        this.BEFORE_PATH = ShelvedBinaryFile.convertToSystemIndependent(this.BEFORE_PATH);
        this.AFTER_PATH = ShelvedBinaryFile.convertToSystemIndependent(this.AFTER_PATH);
        this.SHELVED_PATH = ShelvedBinaryFile.convertToSystemIndependent(this.SHELVED_PATH);
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.convertPathsToSystemIndependent();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public FileStatus getFileStatus() {
        if (this.BEFORE_PATH == null) {
            return FileStatus.ADDED;
        }
        if (this.SHELVED_PATH == null) {
            return FileStatus.DELETED;
        }
        return FileStatus.MODIFIED;
    }

    @NotNull
    public Change createChange(@NotNull Project project2) {
        if (project2 == null) {
            ShelvedBinaryFile.$$$reportNull$$$0(0);
        }
        if (this.myChange == null) {
            CurrentBinaryContentRevision before2 = null;
            ShelvedBinaryContentRevision after2 = null;
            File baseDir2 = new File(project2.getBaseDir().getPath());
            if (this.BEFORE_PATH != null) {
                FilePath file = VcsUtil.getFilePath(new File(baseDir2, this.BEFORE_PATH), false);
                before2 = new CurrentBinaryContentRevision(file){

                    @Override
                    public byte @Nullable [] getBinaryContent() throws VcsException {
                        return (byte[])ObjectUtils.chooseNotNull((Object)super.getBinaryContent(), (Object)ArrayUtil.EMPTY_BYTE_ARRAY);
                    }

                    @Override
                    @NotNull
                    public VcsRevisionNumber getRevisionNumber() {
                        return new TextRevisionNumber(VcsBundle.message("local.version.title", new Object[0]));
                    }
                };
            }
            if (this.AFTER_PATH != null) {
                after2 = this.createBinaryContentRevision(project2);
            }
            this.myChange = new Change(before2, after2);
        }
        Change change = this.myChange;
        if (change == null) {
            ShelvedBinaryFile.$$$reportNull$$$0(1);
        }
        return change;
    }

    @NotNull
    ShelvedBinaryContentRevision createBinaryContentRevision(@NotNull Project project2) {
        if (project2 == null) {
            ShelvedBinaryFile.$$$reportNull$$$0(2);
        }
        FilePath file = VcsUtil.getFilePath(new File(project2.getBasePath(), this.AFTER_PATH), false);
        return new ShelvedBinaryContentRevision(file, this.SHELVED_PATH);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShelvedBinaryFile that = (ShelvedBinaryFile)o;
        if (this.AFTER_PATH != null ? !this.AFTER_PATH.equals(that.AFTER_PATH) : that.AFTER_PATH != null) {
            return false;
        }
        if (this.BEFORE_PATH != null ? !this.BEFORE_PATH.equals(that.BEFORE_PATH) : that.BEFORE_PATH != null) {
            return false;
        }
        return !(this.SHELVED_PATH != null ? !this.SHELVED_PATH.equals(that.SHELVED_PATH) : that.SHELVED_PATH != null);
    }

    public int hashCode() {
        int result2 = this.BEFORE_PATH != null ? this.BEFORE_PATH.hashCode() : 0;
        result2 = 31 * result2 + (this.AFTER_PATH != null ? this.AFTER_PATH.hashCode() : 0);
        result2 = 31 * result2 + (this.SHELVED_PATH != null ? this.SHELVED_PATH.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return FileUtil.toSystemDependentName((String)(this.BEFORE_PATH == null ? this.AFTER_PATH : this.BEFORE_PATH));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryContentRevision";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

