/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/shelf/ShelfFileWritingAccessProvider;", "Lcom/intellij/openapi/vfs/WritingAccessProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "getReadOnlyMessage", "", "requestWriting", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "intellij.platform.vcs.impl"})
public final class ShelfFileWritingAccessProvider
extends WritingAccessProvider {
    @NotNull
    private final Project myProject;

    public ShelfFileWritingAccessProvider(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @NotNull
    public final Project getMyProject() {
        return this.myProject;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Collection<VirtualFile> collection = ShelveChangesManager.getInstance(this.myProject).getShelvingFiles();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getShelvingFiles(...)");
        Collection<VirtualFile> shelvingFiles = collection;
        return CollectionsKt.toMutableSet((Iterable)CollectionsKt.intersect((Iterable)files2, (Iterable)shelvingFiles));
    }

    @NotNull
    public String getReadOnlyMessage() {
        String string2 = VcsBundle.message("shelve.file.is.locked.for.editing.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }
}

