/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.PluginVcsMappingListener;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsMappingListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesListener;
import com.intellij.openapi.vcs.changes.committed.IncomingChangesIndicatorKt;
import com.intellij.openapi.vcs.changes.committed.IncomingChangesViewProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010!\u001a\u00020\u0016H\u0002R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vcs/changes/committed/IncomingChangesIndicator;", "Lcom/intellij/openapi/wm/StatusBarWidget;", "Lcom/intellij/openapi/wm/StatusBarWidget$IconPresentation;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "<set-?>", "", "incomingChangesCount", "getIncomingChangesCount", "()I", "setIncomingChangesCount", "(I)V", "incomingChangesCount$delegate", "Lkotlin/properties/ReadWriteProperty;", "isIncomingChangesAvailable", "", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "ID", "", "dispose", "", "getCachedIncomingChangesCount", "getClickConsumer", "Lcom/intellij/util/Consumer;", "Ljava/awt/event/MouseEvent;", "getIcon", "Ljavax/swing/Icon;", "getPresentation", "Lcom/intellij/openapi/wm/StatusBarWidget$WidgetPresentation;", "getTooltipText", "install", "refresh", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nIncomingChangesIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncomingChangesIndicator.kt\ncom/intellij/openapi/vcs/changes/committed/IncomingChangesIndicator\n+ 2 Delegates.kt\nkotlin/properties/Delegates\n*L\n1#1,110:1\n33#2,3:111\n*S KotlinDebug\n*F\n+ 1 IncomingChangesIndicator.kt\ncom/intellij/openapi/vcs/changes/committed/IncomingChangesIndicator\n*L\n56#1:111,3\n*E\n"})
final class IncomingChangesIndicator
implements StatusBarWidget,
StatusBarWidget.IconPresentation {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @Nullable
    private StatusBar statusBar;
    private boolean isIncomingChangesAvailable;
    @NotNull
    private final ReadWriteProperty incomingChangesCount$delegate;

    public IncomingChangesIndicator(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        Delegates delegates = Delegates.INSTANCE;
        Integer initialValue$iv = 0;
        boolean $i$f$observable = false;
        this.incomingChangesCount$delegate = (ReadWriteProperty)new ObservableProperty<Integer>((Object)initialValue$iv, this){
            final /* synthetic */ IncomingChangesIndicator this$0;
            {
                this.this$0 = incomingChangesIndicator;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property2, Object oldValue, Object newValue) {
                block0: {
                    void newValue2;
                    Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                    int n = ((Number)newValue).intValue();
                    ((Number)oldValue).intValue();
                    boolean bl = false;
                    IncomingChangesIndicatorKt.access$getLOG$p().debug("Refreshing indicator: " + (int)newValue2 + " changes");
                    StatusBar statusBar2 = IncomingChangesIndicator.access$getStatusBar$p(this.this$0);
                    if (statusBar2 == null) break block0;
                    statusBar2.updateWidget(this.this$0.ID());
                }
            }
        };
    }

    private final int getIncomingChangesCount() {
        return ((Number)this.incomingChangesCount$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private final void setIncomingChangesCount(int n) {
        this.incomingChangesCount$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    @NotNull
    public String ID() {
        return "IncomingChanges";
    }

    @NotNull
    public StatusBarWidget.WidgetPresentation getPresentation() {
        return (StatusBarWidget.WidgetPresentation)this;
    }

    @Nullable
    public Icon getIcon() {
        Icon icon2;
        if (!this.isIncomingChangesAvailable) {
            return null;
        }
        if (this.getIncomingChangesCount() > 0) {
            icon2 = AllIcons.Ide.IncomingChangesOn;
        } else {
            Icon icon3 = AllIcons.Ide.IncomingChangesOn;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"IncomingChangesOn");
            icon2 = IconLoader.getDisabledIcon((Icon)icon3);
        }
        return icon2;
    }

    @Nullable
    public String getTooltipText() {
        String string2;
        if (!this.isIncomingChangesAvailable) {
            string2 = null;
        } else if (this.getIncomingChangesCount() > 0) {
            Object[] objectArray = new Object[]{this.getIncomingChangesCount()};
            string2 = VcsBundle.message("incoming.changes.indicator.tooltip", objectArray);
        } else {
            string2 = VcsBundle.message("changes.no.incoming.changelists.available", new Object[0]);
        }
        return string2;
    }

    @NotNull
    public Consumer<MouseEvent> getClickConsumer() {
        return arg_0 -> IncomingChangesIndicator.getClickConsumer$lambda$2(this, arg_0);
    }

    public void install(@NotNull StatusBar statusBar2) {
        Intrinsics.checkNotNullParameter((Object)statusBar2, (String)"statusBar");
        this.statusBar = statusBar2;
        MessageBusConnection busConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<CommittedChangesListener> topic = CommittedChangesCache.COMMITTED_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"COMMITTED_TOPIC");
        busConnection.subscribe(topic, (Object)new CommittedChangesListener(this){
            final /* synthetic */ IncomingChangesIndicator this$0;
            {
                this.this$0 = $receiver;
            }

            public void incomingChangesUpdated(@Nullable List<? extends CommittedChangeList> receivedChanges) {
                IncomingChangesIndicator.access$refresh(this.this$0);
            }

            public void changesCleared() {
                IncomingChangesIndicator.access$refresh(this.this$0);
            }
        });
        Topic<VcsMappingListener> topic2 = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"VCS_CONFIGURATION_CHANGED");
        busConnection.subscribe(topic2, () -> IncomingChangesIndicator.install$lambda$3(this));
        Topic<PluginVcsMappingListener> topic3 = ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN;
        Intrinsics.checkNotNullExpressionValue(topic3, (String)"VCS_CONFIGURATION_CHANGED_IN_PLUGIN");
        busConnection.subscribe(topic3, () -> IncomingChangesIndicator.install$lambda$4(this));
        this.refresh();
    }

    public void dispose() {
        this.statusBar = null;
    }

    private final void refresh() {
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ IncomingChangesIndicator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (IncomingChangesIndicator.access$getProject$p(this.this$0).isDisposed() || IncomingChangesIndicator.access$getStatusBar$p(this.this$0) == null) {
                    return;
                }
                IncomingChangesIndicator.access$setIncomingChangesAvailable$p(this.this$0, new IncomingChangesViewProvider.VisibilityPredicate().test(IncomingChangesIndicator.access$getProject$p(this.this$0)));
                IncomingChangesIndicator.access$setIncomingChangesCount(this.this$0, IncomingChangesIndicator.access$isIncomingChangesAvailable$p(this.this$0) ? IncomingChangesIndicator.access$getCachedIncomingChangesCount(this.this$0) : 0);
            }
        }), (int)1, null);
    }

    private final int getCachedIncomingChangesCount() {
        List<CommittedChangeList> list2 = CommittedChangesCache.getInstance(this.project).getCachedIncomingChanges();
        return list2 != null ? list2.size() : 0;
    }

    private static final void getClickConsumer$lambda$2$lambda$1(IncomingChangesIndicator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ChangesViewContentManager.Companion.getInstance(this$0.project).selectContent("Incoming");
    }

    private static final void getClickConsumer$lambda$2(IncomingChangesIndicator this$0, MouseEvent it) {
        block0: {
            ToolWindow toolWindow;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow("Version Control");
            if (toolWindow2 == null) break block0;
            toolWindow2.show(() -> IncomingChangesIndicator.getClickConsumer$lambda$2$lambda$1(this$0));
        }
    }

    private static final void install$lambda$3(IncomingChangesIndicator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.refresh();
    }

    private static final void install$lambda$4(IncomingChangesIndicator this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.refresh();
    }

    public static final /* synthetic */ void access$refresh(IncomingChangesIndicator $this) {
        $this.refresh();
    }

    public static final /* synthetic */ Project access$getProject$p(IncomingChangesIndicator $this) {
        return $this.project;
    }

    public static final /* synthetic */ StatusBar access$getStatusBar$p(IncomingChangesIndicator $this) {
        return $this.statusBar;
    }

    public static final /* synthetic */ void access$setIncomingChangesAvailable$p(IncomingChangesIndicator $this, boolean bl) {
        $this.isIncomingChangesAvailable = bl;
    }

    public static final /* synthetic */ void access$setIncomingChangesCount(IncomingChangesIndicator $this, int n) {
        $this.setIncomingChangesCount(n);
    }

    public static final /* synthetic */ boolean access$isIncomingChangesAvailable$p(IncomingChangesIndicator $this) {
        return $this.isIncomingChangesAvailable;
    }

    public static final /* synthetic */ int access$getCachedIncomingChangesCount(IncomingChangesIndicator $this) {
        return $this.getCachedIncomingChangesCount();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(IncomingChangesIndicator.class, "incomingChangesCount", "getIncomingChangesCount()I", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

