/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionActionExtension;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionWithIgnoredFilesConfirmationAction;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionWithIgnoredFilesConfirmationActionKt;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Functions;
import com.intellij.util.PairConsumer;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J4\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013H\u0002J$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\b\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0013H\u0002J\u0015\u0010\u0019\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0015\u0010\u001d\u001a\u00070\u001a\u00a2\u0006\u0002\b\u001e2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u001c\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\b\u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006$"}, d2={"Lcom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionWithIgnoredFilesConfirmationAction;", "Lcom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "addPathsToVcs", "project", "Lcom/intellij/openapi/project/Project;", "toAdd", "", "Lcom/intellij/openapi/vcs/FilePath;", "exceptions", "", "Lcom/intellij/openapi/vcs/VcsException;", "containsIgnored", "", "collectPathsFromChanges", "Lkotlin/sequences/Sequence;", "allChanges", "Lcom/intellij/openapi/vcs/changes/Change;", "collectPathsFromFiles", "allFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "dialogMessage", "", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "path", "dialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "getExtensionFor", "Lcom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionActionExtension;", "vcs", "Lcom/intellij/openapi/vcs/AbstractVcs;", "isEnabled", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nScheduleForAdditionWithIgnoredFilesConfirmationAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScheduleForAdditionWithIgnoredFilesConfirmationAction.kt\ncom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionWithIgnoredFilesConfirmationAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,156:1\n3190#2,10:157\n215#3,2:167\n*S KotlinDebug\n*F\n+ 1 ScheduleForAdditionWithIgnoredFilesConfirmationAction.kt\ncom/intellij/openapi/vcs/changes/actions/ScheduleForAdditionWithIgnoredFilesConfirmationAction\n*L\n54#1:157,10\n85#1:167,2\n*E\n"})
public final class ScheduleForAdditionWithIgnoredFilesConfirmationAction
extends ScheduleForAdditionAction {
    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return false;
        }
        Project project3 = project2;
        if (ScheduleForAdditionAction.Manager.INSTANCE.getUnversionedFiles(e, project3).isNotEmpty()) {
            return true;
        }
        Object[] objectArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        Object object = objectArray != null ? ArraysKt.asSequence((Object[])objectArray) : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        Sequence changes2 = object;
        Iterable iterable = (Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES);
        Object object2 = iterable != null ? CollectionsKt.asSequence((Iterable)iterable) : null;
        if (object2 == null) {
            object2 = SequencesKt.emptySequence();
        }
        Sequence files2 = object2;
        return SequencesKt.firstOrNull(this.collectPathsFromChanges(project3, (Sequence<? extends Change>)changes2)) != null || SequencesKt.firstOrNull(this.collectPathsFromFiles(project3, (Sequence<? extends VirtualFile>)files2)) != null;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        ChangesBrowserBase browser = (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY);
        Object[] objectArray = (Change[])e.getData(VcsDataKeys.CHANGES);
        Object object = objectArray != null ? ArraysKt.asSequence((Object[])objectArray) : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        Sequence changes2 = object;
        Iterable iterable = (Iterable)e.getData(VcsDataKeys.VIRTUAL_FILES);
        Object object2 = iterable != null ? CollectionsKt.asSequence((Iterable)iterable) : null;
        if (object2 == null) {
            object2 = SequencesKt.emptySequence();
        }
        Sequence files2 = object2;
        HashSet toAdd = new HashSet();
        CollectionsKt.addAll((Collection)toAdd, this.collectPathsFromChanges(project3, (Sequence<? extends Change>)changes2));
        CollectionsKt.addAll((Collection)toAdd, this.collectPathsFromFiles(project3, (Sequence<? extends VirtualFile>)files2));
        List list2 = ScheduleForAdditionAction.Manager.INSTANCE.getUnversionedFiles(e, project3).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
        List unversionedFiles = list2;
        ChangeListManager changeListManager = ChangeListManager.getInstance(project3);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        Iterable $this$partition$iv = toAdd;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FilePath p0 = (FilePath)element$iv;
            boolean bl = false;
            if (changeListManager2.isIgnoredFile(p0)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List ignored = (List)pair.component1();
        List toAddWithoutIgnored = (List)pair.component2();
        Function1 function1 = (Function1)new Function1<FilePath, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull FilePath p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ScheduleForAdditionWithIgnoredFilesConfirmationAction.access$dialogTitle((ScheduleForAdditionWithIgnoredFilesConfirmationAction)((Object)this.receiver), p0);
            }
        };
        Function1 function12 = (Function1)new Function1<FilePath, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull FilePath p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ScheduleForAdditionWithIgnoredFilesConfirmationAction.access$dialogMessage((ScheduleForAdditionWithIgnoredFilesConfirmationAction)((Object)this.receiver), p0);
            }
        };
        String string2 = VcsBundle.message("confirmation.title.add.ignored.files.or.dirs", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        List<FilePath> confirmedIgnored2 = ScheduleForAdditionWithIgnoredFilesConfirmationActionKt.confirmAddFilePaths(project3, ignored, (Function1<? super FilePath, String>)function1, (Function1<? super FilePath, String>)function12, string2);
        PairConsumer addToVcsTask = !((Collection)toAdd).isEmpty() ? (arg_0, arg_1) -> ScheduleForAdditionWithIgnoredFilesConfirmationAction.actionPerformed$lambda$0(this, project3, toAddWithoutIgnored, confirmedIgnored2, arg_0, arg_1) : null;
        ScheduleForAdditionAction.Manager.INSTANCE.performUnversionedFilesAddition$intellij_platform_vcs_impl(project3, unversionedFiles, browser, (PairConsumer<? super ProgressIndicator, ? super List<VcsException>>)addToVcsTask);
    }

    private final String dialogMessage(FilePath path2) {
        String string2 = path2.isDirectory() ? VcsBundle.message("confirmation.message.add.ignored.single.directory", new Object[0]) : VcsBundle.message("confirmation.message.add.ignored.single.file", new Object[0]);
        Intrinsics.checkNotNull((Object)string2);
        String question = string2;
        return question + "\n" + FileUtil.getLocationRelativeToUserHome((String)path2.getPresentableUrl());
    }

    private final String dialogTitle(FilePath path2) {
        String string2;
        if (path2.isDirectory()) {
            String string3 = VcsBundle.message("confirmation.title.add.ignored.single.directory", new Object[0]);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else {
            String string4 = VcsBundle.message("confirmation.title.add.ignored.single.file", new Object[0]);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        }
        return string2;
    }

    private final void addPathsToVcs(Project project2, Collection<? extends FilePath> toAdd, List<VcsException> exceptions2, boolean containsIgnored) {
        Map<VcsRoot, List<? extends FilePath>> map2 = VcsUtil.groupByRoots(project2, toAdd, Functions.identity());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"groupByRoots(...)");
        Map<VcsRoot, List<? extends FilePath>> $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VcsRoot, List<? extends FilePath>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<VcsRoot, List<? extends FilePath>> element$iv;
            Map.Entry<VcsRoot, List<? extends FilePath>> entry2 = element$iv = iterator.next();
            boolean bl = false;
            VcsRoot vcsRoot = entry2.getKey();
            List<? extends FilePath> paths = entry2.getValue();
            try {
                ScheduleForAdditionActionExtension actionExtension;
                if (this.getExtensionFor(project2, vcsRoot.getVcs()) == null) {
                    return;
                }
                VirtualFile virtualFile = vcsRoot.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getPath(...)");
                Intrinsics.checkNotNull(paths);
                actionExtension.doAddFiles(project2, virtualFile, paths, containsIgnored);
                VcsFileUtil.markFilesDirty(project2, paths);
            }
            catch (VcsException ex) {
                exceptions2.add(ex);
            }
        }
    }

    private final Sequence<FilePath> collectPathsFromChanges(Project project2, Sequence<? extends Change> allChanges) {
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(project2);
        return SequencesKt.map((Sequence)SequencesKt.filter(allChanges, (Function1)((Function1)new Function1<Change, Boolean>(this, project2, vcsManager2){
            final /* synthetic */ ScheduleForAdditionWithIgnoredFilesConfirmationAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectLevelVcsManager $vcsManager;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$vcsManager = $vcsManager;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Change change) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                ScheduleForAdditionActionExtension actionExtension = ScheduleForAdditionWithIgnoredFilesConfirmationAction.access$getExtensionFor(this.this$0, this.$project, this.$vcsManager.getVcsFor(ChangesUtil.getFilePath(change)));
                if (actionExtension != null) {
                    FileStatus fileStatus = change.getFileStatus();
                    Intrinsics.checkNotNullExpressionValue((Object)fileStatus, (String)"getFileStatus(...)");
                    if (actionExtension.isStatusForAddition(fileStatus)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        })), (Function1)collectPathsFromChanges.2.INSTANCE);
    }

    private final Sequence<FilePath> collectPathsFromFiles(Project project2, Sequence<? extends VirtualFile> allFiles) {
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance(project2);
        ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        return SequencesKt.map((Sequence)SequencesKt.filter(allFiles, (Function1)((Function1)new Function1<VirtualFile, Boolean>(this, project2, vcsManager2, changeListManager2){
            final /* synthetic */ ScheduleForAdditionWithIgnoredFilesConfirmationAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectLevelVcsManager $vcsManager;
            final /* synthetic */ ChangeListManager $changeListManager;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$vcsManager = $vcsManager;
                this.$changeListManager = $changeListManager;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull VirtualFile file) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                ScheduleForAdditionActionExtension actionExtension = ScheduleForAdditionWithIgnoredFilesConfirmationAction.access$getExtensionFor(this.this$0, this.$project, this.$vcsManager.getVcsFor(file));
                if (actionExtension != null) {
                    boolean bl2;
                    FileStatus status = this.$changeListManager.getStatus(file);
                    boolean bl3 = false;
                    if (file.isDirectory()) {
                        Intrinsics.checkNotNull((Object)status);
                        bl2 = actionExtension.isStatusForDirectoryAddition(status);
                    } else {
                        Intrinsics.checkNotNull((Object)status);
                        bl2 = actionExtension.isStatusForAddition(status);
                    }
                    if (bl2) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        })), (Function1)collectPathsFromFiles.2.INSTANCE);
    }

    private final ScheduleForAdditionActionExtension getExtensionFor(Project project2, AbstractVcs vcs) {
        return vcs == null ? null : (ScheduleForAdditionActionExtension)ScheduleForAdditionActionExtension.Companion.getEP_NAME().findFirstSafe(arg_0 -> ScheduleForAdditionWithIgnoredFilesConfirmationAction.getExtensionFor$lambda$2((Function1)new Function1<ScheduleForAdditionActionExtension, Boolean>(project2, vcs){
            final /* synthetic */ Project $project;
            final /* synthetic */ AbstractVcs $vcs;
            {
                this.$project = $project;
                this.$vcs = $vcs;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ScheduleForAdditionActionExtension it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getSupportedVcs(this.$project), (Object)this.$vcs);
            }
        }, arg_0));
    }

    private static final void actionPerformed$lambda$0(ScheduleForAdditionWithIgnoredFilesConfirmationAction this$0, Project $project, List $toAddWithoutIgnored, List $confirmedIgnored, ProgressIndicator progressIndicator, List exceptions2) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$toAddWithoutIgnored, (String)"$toAddWithoutIgnored");
        Intrinsics.checkNotNullParameter((Object)$confirmedIgnored, (String)"$confirmedIgnored");
        Collection collection = CollectionsKt.plus((Collection)$toAddWithoutIgnored, (Iterable)$confirmedIgnored);
        Intrinsics.checkNotNull((Object)exceptions2);
        this$0.addPathsToVcs($project, collection, exceptions2, !((Collection)$confirmedIgnored).isEmpty());
    }

    private static final boolean getExtensionFor$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$dialogTitle(ScheduleForAdditionWithIgnoredFilesConfirmationAction $this, FilePath path2) {
        return $this.dialogTitle(path2);
    }

    public static final /* synthetic */ String access$dialogMessage(ScheduleForAdditionWithIgnoredFilesConfirmationAction $this, FilePath path2) {
        return $this.dialogMessage(path2);
    }

    public static final /* synthetic */ ScheduleForAdditionActionExtension access$getExtensionFor(ScheduleForAdditionWithIgnoredFilesConfirmationAction $this, Project project2, AbstractVcs vcs) {
        return $this.getExtensionFor(project2, vcs);
    }
}

