/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class VcsDirtyScopeMap {
    private final Map<VcsRoot, Set<FilePath>> myMap = new HashMap<VcsRoot, Set<FilePath>>();

    @NotNull
    public Map<VcsRoot, Set<FilePath>> asMap() {
        Map<VcsRoot, Set<FilePath>> map2 = this.myMap;
        if (map2 == null) {
            VcsDirtyScopeMap.$$$reportNull$$$0(0);
        }
        return map2;
    }

    public void add(@NotNull VcsRoot vcs, @NotNull FilePath filePath) {
        if (vcs == null) {
            VcsDirtyScopeMap.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            VcsDirtyScopeMap.$$$reportNull$$$0(2);
        }
        Set<FilePath> set = this.getVcsPathsSet(vcs);
        set.add(filePath);
    }

    public void addAll(@NotNull VcsDirtyScopeMap map2) {
        if (map2 == null) {
            VcsDirtyScopeMap.$$$reportNull$$$0(3);
        }
        for (Map.Entry<VcsRoot, Set<FilePath>> entry2 : map2.myMap.entrySet()) {
            Set<FilePath> set = this.getVcsPathsSet(entry2.getKey());
            set.addAll((Collection<FilePath>)entry2.getValue());
        }
    }

    @NotNull
    private Set<FilePath> getVcsPathsSet(@NotNull VcsRoot vcsRoot) {
        if (vcsRoot == null) {
            VcsDirtyScopeMap.$$$reportNull$$$0(4);
        }
        Set set = this.myMap.computeIfAbsent(vcsRoot, key2 -> {
            HashingStrategy<FilePath> strategy = VcsDirtyScopeManagerImpl.getDirtyScopeHashingStrategy(Objects.requireNonNull(key2.getVcs()));
            return strategy == null ? new HashSet() : CollectionFactory.createCustomHashingStrategySet(strategy);
        });
        if (set == null) {
            VcsDirtyScopeMap.$$$reportNull$$$0(5);
        }
        return set;
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    public void clear() {
        this.myMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "asMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsDirtyScopeMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsPathsSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVcsPathsSet";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string2);
        };
    }
}

