/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.InitialVfsRefreshService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsScopeKt;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesViewCommitPanelSplitter;
import com.intellij.openapi.vcs.changes.ChangesViewDiffPreviewProcessor;
import com.intellij.openapi.vcs.changes.ChangesViewEx;
import com.intellij.openapi.vcs.changes.ChangesViewI;
import com.intellij.openapi.vcs.changes.ChangesViewModifier;
import com.intellij.openapi.vcs.changes.ChangesViewNodeAction;
import com.intellij.openapi.vcs.changes.ChangesViewPanel;
import com.intellij.openapi.vcs.changes.ChangesViewWorkflowManager;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.EditorTabDiffPreviewManager;
import com.intellij.openapi.vcs.changes.EditorTabPreview;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.PreviewDiffSplitterComponent;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.VcsManagedFilesHolder;
import com.intellij.openapi.vcs.changes.VcsToolwindowDnDTarget;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffFromLocalChangesActionProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.openapi.vcs.changes.ui.BackgroundRefresher;
import com.intellij.openapi.vcs.changes.ui.ChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserChangeListNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserUnversionedLoadingPendingNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeDnDSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewDnDSupport;
import com.intellij.openapi.vcs.changes.ui.HoverChangesTree;
import com.intellij.openapi.vcs.changes.ui.HoverIcon;
import com.intellij.openapi.vcs.changes.ui.ShelvedChangeListDragBean;
import com.intellij.openapi.vcs.changes.ui.SimpleTreeEditorDiffPreview;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vcs.telemetry.VcsTelemetrySpan;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.problems.ProblemListener;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.content.Content;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.vcs.commit.ChangesViewCommitPanel;
import com.intellij.vcs.commit.ChangesViewCommitWorkflowHandler;
import com.intellij.vcs.commit.CommitModeManager;
import com.intellij.vcs.commit.FixedSizeScrollPanel;
import com.intellij.vcs.commit.PartialCommitChangeNodeDecorator;
import com.intellij.vcsUtil.VcsUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@com.intellij.openapi.components.State(name="ChangesViewManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ChangesViewManager
implements ChangesViewEx,
PersistentStateComponent<State>,
Disposable {
    private static final Tracer TRACER = TelemetryManager.getInstance().getTracer(VcsScopeKt.VcsScope);
    private static final String CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION = "ChangesViewManager.DETAILS_SPLITTER_PROPORTION";
    @NotNull
    private final Project myProject;
    @NotNull
    private State myState;
    @Nullable
    private ChangesViewPanel myChangesPanel;
    @Nullable
    private ChangesViewToolWindowPanel myToolWindowPanel;

    @NotNull
    @RequiresEdt
    ChangesViewPanel initChangesPanel() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myChangesPanel == null) {
            Activity activity2 = StartUpMeasurer.startActivity((String)"ChangesViewPanel initialization");
            LocalChangesListView tree2 = new LocalChangesListView(this.myProject);
            this.myChangesPanel = new ChangesViewPanel(tree2);
            activity2.end();
        }
        ChangesViewPanel changesViewPanel = this.myChangesPanel;
        if (changesViewPanel == null) {
            ChangesViewManager.$$$reportNull$$$0(0);
        }
        return changesViewPanel;
    }

    @RequiresEdt
    @NotNull
    private ChangesViewToolWindowPanel initToolWindowPanel() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.myToolWindowPanel == null) {
            Activity activity2 = StartUpMeasurer.startActivity((String)"ChangesViewToolWindowPanel initialization");
            ChangesViewPanel changesViewPanel = this.initChangesPanel();
            ChangesViewToolWindowPanel panel2 = new ChangesViewToolWindowPanel(this.myProject, this, changesViewPanel);
            Disposer.register((Disposable)this, (Disposable)panel2);
            panel2.updateCommitWorkflow();
            this.myToolWindowPanel = panel2;
            Disposer.register((Disposable)panel2, () -> {
                this.myChangesPanel = null;
                this.myToolWindowPanel = null;
            });
            activity2.end();
        }
        ChangesViewToolWindowPanel changesViewToolWindowPanel = this.myToolWindowPanel;
        if (changesViewToolWindowPanel == null) {
            ChangesViewManager.$$$reportNull$$$0(1);
        }
        return changesViewToolWindowPanel;
    }

    public ChangesViewManager(@NotNull Project project2) {
        if (project2 == null) {
            ChangesViewManager.$$$reportNull$$$0(2);
        }
        this.myState = new State();
        this.myProject = project2;
        ChangesViewModifier.KEY.addChangeListener((AreaInstance)project2, this::resetViewImmediatelyAndRefreshLater, (Disposable)this);
        MessageBusConnection busConnection = project2.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(ChangesViewWorkflowManager.TOPIC, () -> this.updateCommitWorkflow());
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            ChangesViewManager.$$$reportNull$$$0(3);
        }
        return state;
    }

    @NotNull
    public Collection<String> getGrouping() {
        TreeSet<String> treeSet = this.myState.groupingKeys;
        if (treeSet == null) {
            ChangesViewManager.$$$reportNull$$$0(4);
        }
        return treeSet;
    }

    @NotNull
    public static ChangesViewI getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ChangesViewManager.$$$reportNull$$$0(5);
        }
        ChangesViewI changesViewI = (ChangesViewI)project2.getService(ChangesViewI.class);
        if (changesViewI == null) {
            ChangesViewManager.$$$reportNull$$$0(6);
        }
        return changesViewI;
    }

    @NotNull
    public static ChangesViewEx getInstanceEx(@NotNull Project project2) {
        if (project2 == null) {
            ChangesViewManager.$$$reportNull$$$0(7);
        }
        return (ChangesViewEx)ChangesViewManager.getInstance(project2);
    }

    @NotNull
    public static Factory<JComponent> createTextStatusFactory(@NlsContexts.Label String text2, boolean isError) {
        Factory factory = () -> {
            JBLabel label2 = new JBLabel(StringUtil.replace((String)text2.trim(), (String)"\n", (String)"<br/>")).setCopyable(true);
            label2.setVerticalTextPosition(1);
            label2.setBorder(JBUI.Borders.empty((int)3));
            label2.setForeground((Color)(isError ? JBColor.RED : UIUtil.getLabelForeground()));
            return label2;
        };
        if (factory == null) {
            ChangesViewManager.$$$reportNull$$$0(8);
        }
        return factory;
    }

    public void dispose() {
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ChangesViewManager.$$$reportNull$$$0(9);
        }
        this.myState = state;
        this.migrateShowFlattenSetting();
    }

    private void migrateShowFlattenSetting() {
        if (!this.myState.myShowFlatten) {
            this.myState.groupingKeys.clear();
            this.myState.groupingKeys.addAll(ChangesTree.DEFAULT_GROUPING_KEYS);
            this.myState.myShowFlatten = true;
        }
    }

    public void setGrouping(@NotNull Collection<String> grouping) {
        if (grouping == null) {
            ChangesViewManager.$$$reportNull$$$0(10);
        }
        this.myState.groupingKeys.clear();
        this.myState.groupingKeys.addAll(grouping);
    }

    @Override
    @NotNull
    public Promise<?> promiseRefresh(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            ChangesViewManager.$$$reportNull$$$0(11);
        }
        if (this.myToolWindowPanel == null) {
            Promise promise = Promises.cancelledPromise();
            if (promise == null) {
                ChangesViewManager.$$$reportNull$$$0(12);
            }
            return promise;
        }
        Promise<?> promise = this.myToolWindowPanel.scheduleRefreshWithDelay(0, modalityState);
        if (promise == null) {
            ChangesViewManager.$$$reportNull$$$0(13);
        }
        return promise;
    }

    @Override
    public void scheduleRefresh() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.scheduleRefresh();
    }

    @Override
    public void selectFile(VirtualFile vFile) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.selectFile(vFile);
    }

    @Override
    public void selectChanges(@NotNull List<? extends Change> changes2) {
        if (changes2 == null) {
            ChangesViewManager.$$$reportNull$$$0(14);
        }
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.selectChanges(changes2);
    }

    @Override
    public void updateProgressText(@NlsContexts.Label String text2, boolean isError) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.updateProgressText(text2, isError);
    }

    @Override
    public void setBusy(boolean b) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.setBusy(b);
    }

    @Override
    public void setGrouping(@NotNull String groupingKey) {
        if (groupingKey == null) {
            ChangesViewManager.$$$reportNull$$$0(15);
        }
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.setGrouping(groupingKey);
    }

    private void updateCommitWorkflow() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.updateCommitWorkflow();
    }

    @Override
    public void refreshImmediately() {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.scheduleRefreshNow();
    }

    @Override
    public boolean isAllowExcludeFromCommit() {
        if (this.myToolWindowPanel == null) {
            return false;
        }
        return this.myToolWindowPanel.isAllowExcludeFromCommit();
    }

    public void closeEditorPreview(boolean onlyIfEmpty) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        this.myToolWindowPanel.closeEditorPreview(onlyIfEmpty);
    }

    @Override
    public void resetViewImmediatelyAndRefreshLater() {
        if (this.myToolWindowPanel != null) {
            this.myToolWindowPanel.resetViewImmediatelyAndRefreshLater();
        }
    }

    public boolean isDiffPreviewAvailable() {
        if (this.myToolWindowPanel == null) {
            return false;
        }
        return this.myToolWindowPanel.mySplitterDiffPreview != null || this.myToolWindowPanel.myEditorDiffPreview != null && ChangesViewToolWindowPanel.isOpenEditorDiffPreviewWithSingleClick.asBoolean();
    }

    public void diffPreviewChanged(boolean state) {
        if (this.myToolWindowPanel == null) {
            return;
        }
        DiffPreview preview = (DiffPreview)ObjectUtils.chooseNotNull((Object)this.myToolWindowPanel.mySplitterDiffPreview, (Object)this.myToolWindowPanel.myEditorDiffPreview);
        DiffPreview.setPreviewVisible(preview, state);
        this.myToolWindowPanel.setCommitSplitOrientation();
    }

    @NotNull
    @Nls
    public static String getLocalChangesToolWindowName(@NotNull Project project2) {
        if (project2 == null) {
            ChangesViewManager.$$$reportNull$$$0(16);
        }
        String string2 = ChangesViewContentManagerKt.isCommitToolWindowShown(project2) ? VcsBundle.message("tab.title.commit", new Object[0]) : VcsBundle.message("local.changes.tab", new Object[0]);
        if (string2 == null) {
            ChangesViewManager.$$$reportNull$$$0(17);
        }
        return string2;
    }

    @Override
    @Nullable
    public ChangesViewCommitWorkflowHandler getCommitWorkflowHandler() {
        return ChangesViewWorkflowManager.getInstance(this.myProject).getCommitWorkflowHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 5, 7, 9, 10, 11, 14, 15, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouping";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupingKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initChangesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initToolWindowPanel";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGrouping";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextStatusFactory";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseRefresh";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalChangesToolWindowName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceEx";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setGrouping";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "promiseRefresh";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectChanges";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLocalChangesToolWindowName";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 2, 5, 7, 9, 10, 11, 14, 15, 16 -> new IllegalArgumentException(string2);
        };
    }

    private static class LocalChangesListView
    extends ChangesListView {
        private LocalChangesListView(@NotNull Project project2) {
            if (project2 == null) {
                LocalChangesListView.$$$reportNull$$$0(0);
            }
            super(project2, false);
            this.putClientProperty("LogCommitSessionEvents", true);
            this.setTreeExpander((TreeExpander)new MyTreeExpander((JTree)((Object)this)));
            this.setDoubleClickHandler((Processor<? super MouseEvent>)((Processor)e -> {
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((Object)this), (MouseEvent)e)) {
                    return false;
                }
                OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)((Object)this)), (boolean)true);
                return true;
            }));
            this.setEnterKeyHandler((Processor<? super KeyEvent>)((Processor)e -> {
                OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)((Object)this)), (boolean)false);
                return true;
            }));
            new HoverChangesTree(this){

                @Override
                @Nullable
                public HoverIcon getHoverIcon(@NotNull ChangesBrowserNode<?> node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (HoverIcon)ChangesViewNodeAction.EP_NAME.computeSafeIfAny((AreaInstance)myProject, it -> it.createNodeHoverIcon(node));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/vcs/changes/ChangesViewManager$LocalChangesListView$1", "getHoverIcon"));
                }
            }.install();
        }

        @Override
        @NotNull
        protected ChangesGroupingSupport installGroupingSupport() {
            return new ChangesGroupingSupport(this.myProject, (Object)this, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesViewManager$LocalChangesListView", "<init>"));
        }

        private static class MyTreeExpander
        extends DefaultTreeExpander {
            private MyTreeExpander(@NotNull JTree tree2) {
                if (tree2 == null) {
                    MyTreeExpander.$$$reportNull$$$0(0);
                }
                super(tree2);
            }

            protected void collapseAll(@NotNull JTree tree2, int keepSelectionLevel) {
                if (tree2 == null) {
                    MyTreeExpander.$$$reportNull$$$0(1);
                }
                super.collapseAll(tree2, 2);
                TreeUtil.expand((JTree)tree2, (int)1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "tree";
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$LocalChangesListView$MyTreeExpander";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "collapseAll";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static final class ChangesViewToolWindowPanel
    extends SimpleToolWindowPanel
    implements Disposable {
        @NotNull
        private static final RegistryValue isToolbarHorizontalSetting = Registry.get((String)"vcs.local.changes.toolbar.horizontal");
        @NotNull
        private static final RegistryValue isOpenEditorDiffPreviewWithSingleClick = Registry.get((String)"show.diff.preview.as.editor.tab.with.single.click");
        @NotNull
        private final Project myProject;
        @NotNull
        private final ChangesViewManager myChangesViewManager;
        @NotNull
        private final VcsConfiguration myVcsConfiguration;
        @NotNull
        private final BorderLayoutPanel myMainPanel;
        @NotNull
        private final BorderLayoutPanel myContentPanel;
        @NotNull
        private final ChangesViewPanel myChangesPanel;
        @NotNull
        private final ChangesListView myView;
        @NotNull
        private final ChangesViewCommitPanelSplitter myCommitPanelSplitter;
        private ChangesViewDiffPreviewProcessor myEditorChangeProcessor;
        private ChangesViewDiffPreviewProcessor mySplitterChangeProcessor;
        private EditorTabPreview myEditorDiffPreview;
        private PreviewDiffSplitterComponent mySplitterDiffPreview;
        @NotNull
        private final Wrapper myProgressLabel;
        @Nullable
        private ChangesViewCommitPanel myCommitPanel;
        @Nullable
        private ChangesViewCommitWorkflowHandler myCommitWorkflowHandler;
        private final BackgroundRefresher<@Nullable Runnable> myBackgroundRefresher;
        private boolean myModelUpdateInProgress;
        private boolean myDisposed;
        private final Function0<Boolean> isAllowExcludeFromCommit;

        private ChangesViewToolWindowPanel(@NotNull Project project2, @NotNull ChangesViewManager changesViewManager, @NotNull ChangesViewPanel changesViewPanel) {
            if (project2 == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(0);
            }
            if (changesViewManager == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(1);
            }
            if (changesViewPanel == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(2);
            }
            super(false, true);
            this.myProgressLabel = new Wrapper();
            this.myBackgroundRefresher = new BackgroundRefresher(((Object)((Object)this)).getClass().getSimpleName() + " refresh", this);
            this.myDisposed = false;
            this.isAllowExcludeFromCommit = () -> this.isAllowExcludeFromCommit();
            this.myProject = project2;
            this.myChangesViewManager = changesViewManager;
            this.myChangesPanel = changesViewPanel;
            MessageBusConnection busConnection = this.myProject.getMessageBus().connect((Disposable)this);
            this.myVcsConfiguration = VcsConfiguration.getInstance(this.myProject);
            this.myView = this.myChangesPanel.getChangesView();
            this.myView.installPopupHandler((ActionGroup)((DefaultActionGroup)ActionManager.getInstance().getAction("ChangesViewPopupMenu")));
            ChangesTree.installGroupingSupport(this.myView.getGroupingSupport(), () -> this.myChangesViewManager.getGrouping(), newValue -> this.myChangesViewManager.setGrouping((Collection<String>)newValue), () -> this.scheduleRefresh());
            ChangesViewDnDSupport.install(this.myProject, this.myView, this);
            this.myChangesPanel.getToolbarActionGroup().addAll(this.createChangesToolbarActions(this.myView.getTreeExpander()));
            ChangesViewToolWindowPanel.registerShortcuts((JComponent)((Object)this));
            this.configureToolbars();
            isToolbarHorizontalSetting.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value2) {
                    if (value2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.configureToolbars();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$1", "afterValueChanged"));
                }
            }, (Disposable)this);
            this.myCommitPanelSplitter = new ChangesViewCommitPanelSplitter(this.myProject);
            Disposer.register((Disposable)this, (Disposable)this.myCommitPanelSplitter);
            this.myCommitPanelSplitter.setFirstComponent((JComponent)((Object)this.myChangesPanel));
            this.myContentPanel = new BorderLayoutPanel(){

                public Dimension getMinimumSize() {
                    return this.isMinimumSizeSet() || myChangesPanel.isToolbarHorizontal() ? super.getMinimumSize() : myChangesPanel.getToolbar().getComponent().getPreferredSize();
                }
            };
            this.myContentPanel.addToCenter((Component)((Object)this.myCommitPanelSplitter));
            this.myMainPanel = JBUI.Panels.simplePanel((Component)this.myContentPanel).addToBottom((Component)this.myProgressLabel);
            this.setDiffPreview();
            EditorTabDiffPreviewManager.getInstance(project2).subscribeToPreviewVisibilityChange(this, this::setDiffPreview);
            isOpenEditorDiffPreviewWithSingleClick.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value2) {
                    if (value2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (myEditorDiffPreview != null) {
                        this.setDiffPreview();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$3", "afterValueChanged"));
                }
            }, (Disposable)this);
            this.setContent((JComponent)this.myMainPanel);
            busConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

                public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                    if (toolWindowManager == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    this.setCommitSplitOrientation();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindowManager", "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$4", "stateChanged"));
                }
            });
            busConnection.subscribe(RemoteRevisionsCache.REMOTE_VERSION_CHANGED, () -> this.scheduleRefresh());
            busConnection.subscribe(ProblemListener.TOPIC, (Object)new ProblemListener(){

                public void problemsAppeared(@NotNull VirtualFile file) {
                    if (file == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    this.refreshChangesViewNodeAsync(file);
                }

                public void problemsDisappeared(@NotNull VirtualFile file) {
                    if (file == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    this.refreshChangesViewNodeAsync(file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "file";
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "problemsAppeared";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "problemsDisappeared";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            busConnection.subscribe(ChangeListListener.TOPIC, (Object)new MyChangeListListener());
            busConnection.subscribe(LineStatusTrackerSettingListener.TOPIC, () -> {
                if (this.myEditorChangeProcessor != null) {
                    this.myEditorChangeProcessor.fireDiffSettingsChanged();
                }
                if (this.mySplitterChangeProcessor != null) {
                    this.mySplitterChangeProcessor.fireDiffSettingsChanged();
                }
            });
            busConnection.subscribe(ChangesViewModifier.TOPIC, () -> this.scheduleRefresh());
            busConnection.subscribe(VcsManagedFilesHolder.TOPIC, () -> ApplicationManager.getApplication().invokeLater(() -> this.myView.repaint()));
            this.scheduleRefresh();
            this.updatePreview(false);
        }

        public void dispose() {
            this.myDisposed = true;
        }

        private void setDiffPreview() {
            boolean needUpdatePreviews;
            if (this.myDisposed) {
                return;
            }
            boolean isEditorPreview = true;
            boolean hasSplitterPreview = !ChangesViewContentManagerKt.isCommitToolWindowShown(this.myProject);
            boolean bl = isEditorPreview != (this.myEditorChangeProcessor != null) || hasSplitterPreview != (this.mySplitterChangeProcessor != null) ? true : (needUpdatePreviews = false);
            if (!needUpdatePreviews) {
                return;
            }
            if (this.myEditorChangeProcessor != null) {
                Disposer.dispose((Disposable)this.myEditorChangeProcessor);
            }
            if (this.mySplitterChangeProcessor != null) {
                Disposer.dispose((Disposable)this.mySplitterChangeProcessor);
            }
            if (isEditorPreview) {
                this.myEditorChangeProcessor = new ChangesViewDiffPreviewProcessor(this.myView, true);
                Disposer.register((Disposable)this, (Disposable)this.myEditorChangeProcessor);
                this.myEditorDiffPreview = this.installEditorPreview(this.myEditorChangeProcessor, hasSplitterPreview);
            } else {
                this.myEditorChangeProcessor = null;
                this.myEditorDiffPreview = null;
            }
            if (hasSplitterPreview) {
                this.mySplitterChangeProcessor = new ChangesViewDiffPreviewProcessor(this.myView, false);
                Disposer.register((Disposable)this, (Disposable)this.mySplitterChangeProcessor);
                this.mySplitterDiffPreview = this.installSplitterPreview(this.mySplitterChangeProcessor);
            } else {
                this.mySplitterChangeProcessor = null;
                this.mySplitterDiffPreview = null;
            }
            this.configureDiffPreview();
        }

        @NotNull
        private EditorTabPreview installEditorPreview(final @NotNull ChangesViewDiffPreviewProcessor changeProcessor, boolean hasSplitterPreview) {
            if (changeProcessor == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(3);
            }
            return new SimpleTreeEditorDiffPreview(changeProcessor, this.myView, (JComponent)this.myContentPanel, isOpenEditorDiffPreviewWithSingleClick.asBoolean() && !hasSplitterPreview){

                @Override
                public void returnFocusToTree() {
                    ToolWindow toolWindow = ChangesViewContentManager.getToolWindowFor(myProject, "Local Changes");
                    if (toolWindow != null) {
                        toolWindow.activate(null);
                    }
                }

                @Override
                public void updateDiffAction(@NotNull AnActionEvent e) {
                    if (e == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    ShowDiffFromLocalChangesActionProvider.updateAvailability(e);
                }

                @Override
                protected String getCurrentName() {
                    String changeName = changeProcessor.getCurrentChangeName();
                    return changeName != null ? VcsBundle.message("commit.editor.diff.preview.title", changeName) : VcsBundle.message("commit.editor.diff.preview.empty.title", new Object[0]);
                }

                @Override
                protected boolean skipPreviewUpdate() {
                    if (super.skipPreviewUpdate()) {
                        return true;
                    }
                    if (!((Object)((Object)myView)).equals(IdeFocusManager.getInstance((Project)myProject).getFocusOwner())) {
                        return true;
                    }
                    if (!this.isPreviewOpen() && !this.isEditorPreviewAllowed()) {
                        return true;
                    }
                    return myModelUpdateInProgress;
                }

                @Override
                protected boolean isPreviewOnDoubleClickAllowed() {
                    return ChangesViewContentManagerKt.isCommitToolWindowShown(myProject) ? VcsApplicationSettings.getInstance().SHOW_EDITOR_PREVIEW_ON_DOUBLE_CLICK : VcsApplicationSettings.getInstance().SHOW_DIFF_ON_DOUBLE_CLICK;
                }

                @Override
                protected boolean isPreviewOnEnterAllowed() {
                    return ChangesViewContentManagerKt.isCommitToolWindowShown(myProject) ? VcsApplicationSettings.getInstance().SHOW_EDITOR_PREVIEW_ON_DOUBLE_CLICK : VcsApplicationSettings.getInstance().SHOW_DIFF_ON_DOUBLE_CLICK;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$6", "updateDiffAction"));
                }
            };
        }

        @NotNull
        private PreviewDiffSplitterComponent installSplitterPreview(@NotNull ChangesViewDiffPreviewProcessor changeProcessor) {
            if (changeProcessor == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(4);
            }
            PreviewDiffSplitterComponent previewSplitter = new PreviewDiffSplitterComponent(changeProcessor, ChangesViewManager.CHANGES_VIEW_PREVIEW_SPLITTER_PROPORTION);
            previewSplitter.setFirstComponent((JComponent)this.myContentPanel);
            DiffPreview.setPreviewVisible(previewSplitter, this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN);
            this.myView.addSelectionListener(() -> {
                boolean fromModelRefresh = this.myModelUpdateInProgress;
                this.invokeLater(() -> previewSplitter.updatePreview(fromModelRefresh));
            }, (Disposable)changeProcessor);
            this.myMainPanel.addToCenter((Component)((Object)previewSplitter));
            Disposer.register((Disposable)changeProcessor, () -> {
                if (Disposer.isDisposed((Disposable)this)) {
                    return;
                }
                this.myMainPanel.remove((Component)((Object)previewSplitter));
                this.myMainPanel.addToCenter((Component)this.myContentPanel);
                this.myMainPanel.revalidate();
                this.myMainPanel.repaint();
            });
            PreviewDiffSplitterComponent previewDiffSplitterComponent = previewSplitter;
            if (previewDiffSplitterComponent == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(5);
            }
            return previewDiffSplitterComponent;
        }

        private boolean isEditorPreviewAllowed() {
            return !isOpenEditorDiffPreviewWithSingleClick.asBoolean() || this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN;
        }

        private void closeEditorPreview(boolean onlyIfEmpty) {
            if (this.myEditorDiffPreview == null) {
                return;
            }
            EditorTabPreview editorPreview = this.myEditorDiffPreview;
            if (onlyIfEmpty && editorPreview.hasContent()) {
                return;
            }
            editorPreview.closePreview();
        }

        private void updatePreview(boolean fromModelRefresh) {
            if (this.myEditorDiffPreview != null) {
                this.myEditorDiffPreview.updatePreview(fromModelRefresh);
            }
            if (this.mySplitterDiffPreview != null) {
                this.mySplitterDiffPreview.updatePreview(fromModelRefresh);
            }
        }

        public void updateCommitWorkflow() {
            if (this.myDisposed) {
                return;
            }
            ChangesViewCommitWorkflowHandler newWorkflowHandler = ChangesViewWorkflowManager.getInstance(this.myProject).getCommitWorkflowHandler();
            if (this.myCommitWorkflowHandler == newWorkflowHandler) {
                return;
            }
            if (newWorkflowHandler != null) {
                newWorkflowHandler.addActivityListener(() -> this.configureDiffPreview());
                ChangesViewCommitPanel newCommitPanel = (ChangesViewCommitPanel)newWorkflowHandler.getUi();
                newCommitPanel.registerRootComponent((JComponent)((Object)this));
                this.myCommitPanelSplitter.setSecondComponent((JComponent)((Object)newCommitPanel));
                this.myCommitWorkflowHandler = newWorkflowHandler;
                this.myCommitPanel = newCommitPanel;
            } else {
                this.myCommitPanelSplitter.setSecondComponent(null);
                this.myCommitWorkflowHandler = null;
                this.myCommitPanel = null;
            }
            this.configureDiffPreview();
            this.configureToolbars();
        }

        public boolean isAllowExcludeFromCommit() {
            return this.myCommitWorkflowHandler != null && this.myCommitWorkflowHandler.isActive();
        }

        private void configureDiffPreview() {
            if (this.myEditorChangeProcessor != null) {
                this.myEditorChangeProcessor.setAllowExcludeFromCommit(this.isAllowExcludeFromCommit());
            }
            if (this.mySplitterChangeProcessor != null) {
                this.mySplitterChangeProcessor.setAllowExcludeFromCommit(this.isAllowExcludeFromCommit());
            }
        }

        private void configureToolbars() {
            boolean isToolbarHorizontal = CommitModeManager.getInstance(this.myProject).getCurrentCommitMode().useCommitToolWindow() && isToolbarHorizontalSetting.asBoolean();
            this.myChangesPanel.setToolbarHorizontal(isToolbarHorizontal);
            if (this.myCommitPanel != null) {
                this.myCommitPanel.setToolbarHorizontal(isToolbarHorizontal);
            }
        }

        private void setCommitSplitOrientation() {
            boolean hasPreviewPanel = this.myVcsConfiguration.LOCAL_CHANGES_DETAILS_PREVIEW_SHOWN && this.mySplitterDiffPreview != null;
            ToolWindow tw = ChangesViewContentManager.getToolWindowFor(this.myProject, "Local Changes");
            if (tw != null) {
                boolean toolwindowIsHorizontal = tw.getAnchor().isHorizontal();
                this.myCommitPanelSplitter.setOrientation(hasPreviewPanel || !toolwindowIsHorizontal);
            }
        }

        @NotNull
        private Function<ChangeNodeDecorator, ChangeNodeDecorator> getChangeDecoratorProvider() {
            Function<ChangeNodeDecorator, ChangeNodeDecorator> function = baseDecorator -> new PartialCommitChangeNodeDecorator(this.myProject, (ChangeNodeDecorator)baseDecorator, this.isAllowExcludeFromCommit);
            if (function == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(6);
            }
            return function;
        }

        @NotNull
        public List<AnAction> getActions(boolean originalProvider) {
            List<AnAction> list2 = Arrays.asList(this.myChangesPanel.getToolbarActionGroup().getChildren(null));
            if (list2 == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(7);
            }
            return list2;
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            Object data2;
            if (dataId == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(8);
            }
            if ((data2 = super.getData(dataId)) != null) {
                return data2;
            }
            if (EditorTabDiffPreviewManager.EDITOR_TAB_DIFF_PREVIEW.is(dataId)) {
                return this.myEditorDiffPreview;
            }
            return this.myCommitPanel != null ? this.myCommitPanel.getDataFromProviders(dataId) : null;
        }

        private static void registerShortcuts(@NotNull JComponent component2) {
            if (component2 == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(9);
            }
            ActionUtil.wrap((String)"ChangesView.Refresh").registerCustomShortcutSet(CommonShortcuts.getRerun(), component2);
            ActionUtil.wrap((String)"ChangesView.NewChangeList").registerCustomShortcutSet(CommonShortcuts.getNew(), component2);
            ActionUtil.wrap((String)"ChangesView.RemoveChangeList").registerCustomShortcutSet(CommonShortcuts.getDelete(), component2);
            ActionUtil.wrap((String)"ChangesView.Move").registerCustomShortcutSet(CommonShortcuts.getMove(), component2);
        }

        @NotNull
        private List<AnAction> createChangesToolbarActions(@NotNull TreeExpander treeExpander) {
            if (treeExpander == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(10);
            }
            ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
            actions2.add(CustomActionsSchema.getInstance().getCorrectedAction("ChangesViewToolbar"));
            if (!ExperimentalUI.isNewUI()) {
                actions2.add((AnAction)Separator.getInstance());
            }
            DefaultActionGroup viewOptionsGroup = DefaultActionGroup.createPopupGroup(() -> VcsBundle.message("action.ChangesViewToolWindowPanel.text", new Object[0]));
            viewOptionsGroup.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
            viewOptionsGroup.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
            viewOptionsGroup.add((AnAction)new Separator(VcsBundle.message("action.vcs.log.show.separator", new Object[0])));
            viewOptionsGroup.add((AnAction)new ToggleShowIgnoredAction());
            viewOptionsGroup.add(ActionManager.getInstance().getAction("ChangesView.ViewOptions"));
            actions2.add((AnAction)viewOptionsGroup);
            actions2.add(CommonActionsManager.getInstance().createExpandAllHeaderAction(treeExpander, (JComponent)((Object)this.myView)));
            actions2.add(CommonActionsManager.getInstance().createCollapseAllAction(treeExpander, (JComponent)((Object)this.myView)));
            actions2.add((AnAction)Separator.getInstance());
            actions2.add(ActionManager.getInstance().getAction("ChangesView.SingleClickPreview"));
            ArrayList<AnAction> arrayList = actions2;
            if (arrayList == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        private void updateProgressComponent(@NotNull List<Supplier<@Nullable JComponent>> progress) {
            if (progress == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(12);
            }
            this.invokeLaterIfNeeded(() -> {
                if (this.myDisposed) {
                    return;
                }
                @Nullable List components = ContainerUtil.mapNotNull((Collection)progress, it -> (JComponent)it.get());
                if (!components.isEmpty()) {
                    JComponent component2 = DiffUtil.createStackedComponents((List)components, (JBValue)DiffUtil.TITLE_GAP);
                    this.myProgressLabel.setContent((JComponent)((Object)new FixedSizeScrollPanel(component2, (Dimension)new JBDimension(400, 100))));
                } else {
                    this.myProgressLabel.setContent(null);
                }
            });
        }

        public void updateProgressText(@NlsContexts.Label String text2, boolean isError) {
            this.updateProgressComponent(Collections.singletonList(ChangesViewManager.createTextStatusFactory(text2, isError)));
        }

        public void setBusy(boolean b) {
            this.invokeLaterIfNeeded(() -> this.myView.setPaintBusy(b));
        }

        public void scheduleRefresh() {
            this.scheduleRefreshWithDelay(100, ModalityState.nonModal());
        }

        private void scheduleRefreshNow() {
            this.scheduleRefreshWithDelay(0, ModalityState.nonModal());
        }

        @NotNull
        private Promise<?> scheduleRefreshWithDelay(int delayMillis, @NotNull ModalityState modalityState) {
            if (modalityState == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(13);
            }
            this.setBusy(true);
            Promise promise = this.myBackgroundRefresher.requestRefresh(delayMillis, (Computable<Runnable>)((Computable)this::refreshView)).thenAsync(callback2 -> callback2 != null ? AppUIExecutor.onUiThread((ModalityState)modalityState).submit(callback2) : Promises.rejectedPromise((Throwable)Promises.createError((String)"ChangesViewManager is not available", (boolean)false))).onProcessed(__ -> this.setBusy(false));
            if (promise == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(14);
            }
            return promise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresBackgroundThread
        @Nullable
        private Runnable refreshView() {
            ThreadingAssertions.assertBackgroundThread();
            if (this.myDisposed || !this.myProject.isInitialized() || ApplicationManager.getApplication().isUnitTestMode()) {
                return null;
            }
            Span span = TRACER.spanBuilder(VcsTelemetrySpan.ChangesView.ChangesViewRefreshBackground.getName()).startSpan();
            try {
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
                List<LocalChangeList> changeLists = changeListManager.getChangeLists();
                List<FilePath> unversionedFiles = changeListManager.getUnversionedFilesPaths();
                boolean shouldShowUntrackedLoading = unversionedFiles.isEmpty() && !((InitialVfsRefreshService)this.myProject.getService(InitialVfsRefreshService.class)).isInitialVfsRefreshFinished() && changeListManager.isUnversionedInUpdateMode();
                boolean skipSingleDefaultChangeList = Registry.is((String)"vcs.skip.single.default.changelist") || !changeListManager.areChangeListsEnabled();
                TreeModelBuilder treeModelBuilder = new TreeModelBuilder(this.myProject, this.myView.getGrouping()).setChangeLists(changeLists, skipSingleDefaultChangeList, this.getChangeDecoratorProvider()).setLocallyDeletedPaths(changeListManager.getDeletedFiles()).setModifiedWithoutEditing(changeListManager.getModifiedWithoutEditing()).setSwitchedFiles(changeListManager.getSwitchedFilesMap()).setSwitchedRoots(changeListManager.getSwitchedRoots()).setLockedFolders(changeListManager.getLockedFolders()).setLogicallyLockedFiles(changeListManager.getLogicallyLockedFolders()).setUnversioned(unversionedFiles);
                if (this.myChangesViewManager.myState.myShowIgnored) {
                    List<FilePath> ignoredFilePaths = changeListManager.getIgnoredFilePaths();
                    treeModelBuilder.setIgnored(ignoredFilePaths);
                }
                if (shouldShowUntrackedLoading) {
                    treeModelBuilder.insertSubtreeRoot((ChangesBrowserNode)new ChangesBrowserUnversionedLoadingPendingNode());
                }
                for (ChangesViewModifier extension : ChangesViewModifier.KEY.getExtensions((AreaInstance)this.myProject)) {
                    try {
                        extension.modifyTreeModelBuilder(treeModelBuilder);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        Logger.getInstance(ChangesViewToolWindowPanel.class).error(t);
                    }
                }
                DefaultTreeModel treeModel = treeModelBuilder.build(true);
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                indicator.checkCanceled();
                boolean[] wasCalled = new boolean[1];
                Runnable runnable = () -> {
                    if (wasCalled[0]) {
                        return;
                    }
                    wasCalled[0] = true;
                    this.refreshViewOnEdt(treeModel, changeLists, unversionedFiles, indicator.isCanceled());
                };
                return runnable;
            }
            finally {
                span.end();
            }
        }

        @RequiresEdt
        private void resetViewImmediatelyAndRefreshLater() {
            ThreadingAssertions.assertEventDispatchThread();
            this.myView.setModel(new DefaultTreeModel(ChangesBrowserNode.createRoot()));
            this.myView.setPaintBusy(true);
            ApplicationManager.getApplication().invokeLater(() -> this.scheduleRefreshNow(), ModalityState.nonModal());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresEdt
        private void refreshViewOnEdt(@NotNull DefaultTreeModel treeModel, @NotNull List<? extends LocalChangeList> changeLists, @NotNull List<? extends FilePath> unversionedFiles, boolean hasPendingRefresh) {
            if (treeModel == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(15);
            }
            if (changeLists == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(16);
            }
            if (unversionedFiles == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(17);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (this.myDisposed) {
                return;
            }
            Span span = TRACER.spanBuilder(VcsTelemetrySpan.ChangesView.ChangesViewRefreshEdt.getName()).startSpan();
            try {
                this.myModelUpdateInProgress = true;
                try {
                    ChangesViewToolWindowPanel.updateModel(this.myView, treeModel);
                }
                finally {
                    this.myModelUpdateInProgress = false;
                }
                if (this.myCommitWorkflowHandler != null && !hasPendingRefresh) {
                    this.myCommitWorkflowHandler.synchronizeInclusion(changeLists, unversionedFiles);
                }
                this.updatePreview(true);
            }
            finally {
                span.end();
            }
        }

        private static void updateModel(@NotNull ChangesListView view, @NotNull DefaultTreeModel newModel) {
            if (view == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(18);
            }
            if (newModel == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(19);
            }
            TreeState state = TreeState.createOn((JTree)((Object)view), view.getRoot());
            state.setScrollToSelection(false);
            ChangesBrowserNode<?> oldRoot = view.getRoot();
            view.setModel(newModel);
            ChangesBrowserNode<?> newRoot = view.getRoot();
            state.applyTo((JTree)((Object)view), newRoot);
            ChangesViewToolWindowPanel.initTreeStateIfNeeded(view, oldRoot, newRoot);
        }

        private static void initTreeStateIfNeeded(@NotNull ChangesListView view, @NotNull ChangesBrowserNode<?> oldRoot, @NotNull ChangesBrowserNode<?> newRoot) {
            ChangesBrowserNode<?> defaultListNode;
            if (view == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(20);
            }
            if (oldRoot == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(21);
            }
            if (newRoot == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(22);
            }
            if ((defaultListNode = ChangesViewToolWindowPanel.getDefaultChangelistNode(newRoot)) == null) {
                return;
            }
            if (view.getSelectionCount() == 0) {
                TreeUtil.selectNode((JTree)((Object)view), defaultListNode);
            }
            if (oldRoot.getFileCount() == 0 && TreeUtil.collectExpandedPaths((JTree)((Object)view)).isEmpty()) {
                view.expandSafe(defaultListNode);
            }
        }

        @Nullable
        private static ChangesBrowserNode<?> getDefaultChangelistNode(@NotNull ChangesBrowserNode<?> root) {
            if (root == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(23);
            }
            return (ChangesBrowserNode)root.iterateNodeChildren().filter(ChangesBrowserChangeListNode.class).find(node -> {
                ChangeList list2 = (ChangeList)node.getUserObject();
                return list2 instanceof LocalChangeList && ((LocalChangeList)list2).isDefault();
            });
        }

        public void setGrouping(@NotNull String groupingKey) {
            if (groupingKey == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(24);
            }
            this.myView.getGroupingSupport().setGroupingKeysOrSkip(Set.of(groupingKey));
            this.scheduleRefreshNow();
        }

        public void selectFile(@Nullable VirtualFile vFile) {
            if (vFile == null) {
                return;
            }
            ChangesBrowserNode<?> node = this.findNodeForFile(vFile);
            if (node == null) {
                return;
            }
            TreeUtil.selectNode((JTree)((Object)this.myView), node);
        }

        public void selectChanges(@NotNull List<? extends Change> changes2) {
            if (changes2 == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(25);
            }
            ArrayList paths = new ArrayList();
            for (Change change : changes2) {
                ContainerUtil.addIfNotNull(paths, (Object)this.myView.findNodePathInTree(change));
            }
            TreeUtil.selectPaths((JTree)((Object)this.myView), paths);
        }

        public void refreshChangesViewNodeAsync(@NotNull VirtualFile file) {
            if (file == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(26);
            }
            this.invokeLater(() -> this.refreshChangesViewNode(file));
        }

        private void refreshChangesViewNode(@NotNull VirtualFile file) {
            ChangesBrowserNode<?> node;
            if (file == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(27);
            }
            if ((node = this.findNodeForFile(file)) == null) {
                return;
            }
            this.myView.getModel().nodeChanged(node);
        }

        @Nullable
        private ChangesBrowserNode<?> findNodeForFile(@NotNull VirtualFile file) {
            if (file == null) {
                ChangesViewToolWindowPanel.$$$reportNull$$$0(28);
            }
            FilePath filePath = VcsUtil.getFilePath(file);
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.myView.getModel().getRoot();
            return (ChangesBrowserNode)TreeUtil.findNode((DefaultMutableTreeNode)root, node -> {
                FilePath nodeFilePath = VcsTreeModelData.mapUserObjectToFilePath(node.getUserObject());
                return Objects.equals(filePath, nodeFilePath);
            });
        }

        private void invokeLater(Runnable runnable) {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.nonModal(), this.myProject.getDisposed());
        }

        private void invokeLaterIfNeeded(Runnable runnable) {
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.nonModal(), (Condition)this.myProject.getDisposed(), (Runnable)runnable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7, 11, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesViewManager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changesViewPanel";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeProcessor";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeExpander";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modalityState";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeModel";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeLists";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unversionedFiles";
                    break;
                }
                case 18: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newModel";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldRoot";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newRoot";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupingKey";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 26: 
                case 27: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "installSplitterPreview";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChangeDecoratorProvider";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChangesToolbarActions";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "scheduleRefreshWithDelay";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "installEditorPreview";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "installSplitterPreview";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 14: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "registerShortcuts";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createChangesToolbarActions";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "updateProgressComponent";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "scheduleRefreshWithDelay";
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "refreshViewOnEdt";
                    break;
                }
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "updateModel";
                    break;
                }
                case 20: 
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "initTreeStateIfNeeded";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultChangelistNode";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "setGrouping";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "selectChanges";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "refreshChangesViewNodeAsync";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "refreshChangesViewNode";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "findNodeForFile";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 5, 6, 7, 11, 14 -> new IllegalStateException(string2);
            };
        }

        private class MyChangeListListener
        extends ChangeListAdapter {
            private MyChangeListListener() {
            }

            @Override
            public void changeListsChanged() {
                ChangesViewToolWindowPanel.this.scheduleRefresh();
            }

            @Override
            public void unchangedFileStatusChanged() {
                ChangesViewToolWindowPanel.this.scheduleRefresh();
            }

            @Override
            public void changedFileStatusChanged() {
                ChangesViewToolWindowPanel.this.setBusy(false);
                ChangesViewToolWindowPanel.this.scheduleRefresh();
                ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(ChangesViewToolWindowPanel.this.myProject);
                ChangesViewToolWindowPanel.this.updateProgressComponent(changeListManager.getAdditionalUpdateInfo());
            }
        }

        private class ToggleShowIgnoredAction
        extends ToggleAction
        implements DumbAware {
            ToggleShowIgnoredAction() {
                super(VcsBundle.messagePointer("changes.action.show.ignored.text", new Object[0]), VcsBundle.messagePointer("changes.action.show.ignored.description", new Object[0]), AllIcons.Actions.ToggleVisibility);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    ToggleShowIgnoredAction.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    ToggleShowIgnoredAction.$$$reportNull$$$0(1);
                }
                return ChangesViewToolWindowPanel.this.myChangesViewManager.myState.myShowIgnored;
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    ToggleShowIgnoredAction.$$$reportNull$$$0(2);
                }
                ChangesViewToolWindowPanel.this.myChangesViewManager.myState.myShowIgnored = state;
                ChangesViewToolWindowPanel.this.scheduleRefreshNow();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$ToggleShowIgnoredAction";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ChangesViewToolWindowPanel$ToggleShowIgnoredAction";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1, 2 -> new IllegalArgumentException(string2);
                };
            }
        }
    }

    public static class State {
        @Deprecated
        @Attribute(value="flattened_view")
        public boolean myShowFlatten = true;
        @XCollection
        public TreeSet<String> groupingKeys = new TreeSet();
        @Attribute(value="show_ignored")
        public boolean myShowIgnored;
    }

    private static final class MyContentDnDTarget
    extends VcsToolwindowDnDTarget {
        private MyContentDnDTarget(@NotNull Project project2, @NotNull Content content) {
            if (project2 == null) {
                MyContentDnDTarget.$$$reportNull$$$0(0);
            }
            if (content == null) {
                MyContentDnDTarget.$$$reportNull$$$0(1);
            }
            super(project2, content);
        }

        @Override
        public void drop(DnDEvent event) {
            super.drop(event);
            Object attachedObject = event.getAttachedObject();
            if (attachedObject instanceof ShelvedChangeListDragBean) {
                ShelveChangesManager.unshelveSilentlyWithDnd(this.myProject, (ShelvedChangeListDragBean)attachedObject, null, !ChangesTreeDnDSupport.isCopyAction(event));
            }
        }

        @Override
        public boolean isDropPossible(@NotNull DnDEvent event) {
            Object attachedObject;
            if (event == null) {
                MyContentDnDTarget.$$$reportNull$$$0(2);
            }
            if ((attachedObject = event.getAttachedObject()) instanceof ShelvedChangeListDragBean) {
                return !((ShelvedChangeListDragBean)attachedObject).getShelvedChangelists().isEmpty();
            }
            return attachedObject instanceof ChangeListDragBean;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$MyContentDnDTarget";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDropPossible";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ContentProvider
    implements ChangesViewContentProvider {
        @NotNull
        private final Project myProject;

        public ContentProvider(@NotNull Project project2) {
            if (project2 == null) {
                ContentProvider.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @Override
        public void initTabContent(@NotNull Content content) {
            if (content == null) {
                ContentProvider.$$$reportNull$$$0(1);
            }
            ChangesViewManager viewManager = (ChangesViewManager)ChangesViewManager.getInstance(this.myProject);
            ChangesViewToolWindowPanel panel2 = viewManager.initToolWindowPanel();
            content.setHelpId("ideaInterface.changes");
            content.setComponent((JComponent)((Object)panel2));
            content.setPreferredFocusableComponent((JComponent)((Object)panel2.myView));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ContentProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "initTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class ContentPredicate
    implements Predicate<Project> {
        ContentPredicate() {
        }

        @Override
        public boolean test(Project project2) {
            return ProjectLevelVcsManager.getInstance(project2).hasActiveVcss() && !CommitModeManager.getInstance(project2).getCurrentCommitMode().hideLocalChangesTab();
        }
    }

    public static class ContentPreloader
    implements ChangesViewContentProvider.Preloader {
        @NotNull
        private final Project myProject;

        public ContentPreloader(@NotNull Project project2) {
            if (project2 == null) {
                ContentPreloader.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @Override
        public void preloadTabContent(@NotNull Content content) {
            if (content == null) {
                ContentPreloader.$$$reportNull$$$0(1);
            }
            content.putUserData(Content.TAB_DND_TARGET_KEY, (Object)new MyContentDnDTarget(this.myProject, content));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangesViewManager$ContentPreloader";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preloadTabContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DisplayNameSupplier
    implements Supplier<String> {
        @NotNull
        private final Project myProject;

        public DisplayNameSupplier(@NotNull Project project2) {
            if (project2 == null) {
                DisplayNameSupplier.$$$reportNull$$$0(0);
            }
            this.myProject = project2;
        }

        @Override
        public String get() {
            return ChangesViewManager.getLocalChangesToolWindowName(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/ChangesViewManager$DisplayNameSupplier", "<init>"));
        }
    }
}

