/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.codeinsight.JsonStandardComplianceProvider;
import com.intellij.json.jsonLines.JsonLinesFileType;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementGenerator;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonStandardComplianceInspection
extends LocalInspectionTool {
    public boolean myWarnAboutComments = true;
    public boolean myWarnAboutNanInfinity = true;
    public boolean myWarnAboutTrailingCommas = true;
    public boolean myWarnAboutMultipleTopLevelValues = true;

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(1);
        }
        if (!JsonDialectUtil.isStandardJson((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JsonStandardComplianceInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new StandardJsonValidatingElementVisitor(holder);
    }

    @Nullable
    protected static PsiElement findTrailingComma(@NotNull PsiElement lastChild, @NotNull IElementType ending) {
        if (lastChild == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(3);
        }
        if (ending == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(4);
        }
        if (lastChild.getNode().getElementType() != ending) {
            return null;
        }
        PsiElement beforeEnding = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastChild);
        if (beforeEnding != null && beforeEnding.getNode().getElementType() == JsonElementTypes.COMMA) {
            return beforeEnding;
        }
        return null;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myWarnAboutComments", (String)JsonBundle.message("inspection.compliance.option.comments", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myWarnAboutMultipleTopLevelValues", (String)JsonBundle.message("inspection.compliance.option.multiple.top.level.values", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myWarnAboutTrailingCommas", (String)JsonBundle.message("inspection.compliance.option.trailing.comma", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myWarnAboutNanInfinity", (String)JsonBundle.message("inspection.compliance.option.nan.infinity", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(5);
        }
        return optPane;
    }

    @NotNull
    protected static String escapeSingleQuotedStringContent(@NotNull String content) {
        if (content == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(6);
        }
        StringBuilder result2 = new StringBuilder();
        boolean nextCharEscaped = false;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (nextCharEscaped && c != '\'' || !nextCharEscaped && c == '\"') {
                result2.append('\\');
            }
            if (c != '\\' || nextCharEscaped) {
                result2.append(c);
                nextCharEscaped = false;
                continue;
            }
            nextCharEscaped = true;
        }
        if (nextCharEscaped) {
            result2.append('\\');
        }
        String string2 = result2.toString();
        if (string2 == null) {
            JsonStandardComplianceInspection.$$$reportNull$$$0(7);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/json/codeinsight/JsonStandardComplianceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastChild";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ending";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/json/codeinsight/JsonStandardComplianceInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeSingleQuotedStringContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTrailingComma";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "escapeSingleQuotedStringContent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 3, 4, 6 -> new IllegalArgumentException(string2);
        };
    }

    protected class StandardJsonValidatingElementVisitor
    extends JsonElementVisitor {
        private final ProblemsHolder myHolder;
        private static final String MISSING_VALUE = "missingValue";

        public StandardJsonValidatingElementVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        protected boolean allowComments() {
            return false;
        }

        protected boolean allowSingleQuotes() {
            return false;
        }

        protected boolean allowIdentifierPropertyNames() {
            return false;
        }

        protected boolean allowTrailingCommas() {
            return false;
        }

        protected boolean isValidPropertyName(@NotNull PsiElement literal) {
            if (literal == null) {
                StandardJsonValidatingElementVisitor.$$$reportNull$$$0(0);
            }
            return literal instanceof JsonLiteral && JsonPsiUtil.getElementTextWithoutHostEscaping(literal).startsWith("\"");
        }

        public void visitComment(@NotNull PsiComment comment) {
            if (comment == null) {
                StandardJsonValidatingElementVisitor.$$$reportNull$$$0(1);
            }
            if (!this.allowComments() && JsonStandardComplianceInspection.this.myWarnAboutComments && JsonStandardComplianceProvider.shouldWarnAboutComment(comment) && comment.getContainingFile().getLanguage() instanceof JsonLanguage) {
                this.myHolder.registerProblem((PsiElement)comment, JsonBundle.message("inspection.compliance.msg.comments", new Object[0]), new LocalQuickFix[0]);
            }
        }

        @Override
        public void visitStringLiteral(@NotNull JsonStringLiteral stringLiteral) {
            if (stringLiteral == null) {
                StandardJsonValidatingElementVisitor.$$$reportNull$$$0(2);
            }
            if (!this.allowSingleQuotes() && JsonPsiUtil.getElementTextWithoutHostEscaping(stringLiteral).startsWith("'")) {
                this.myHolder.registerProblem((PsiElement)stringLiteral, JsonBundle.message("inspection.compliance.msg.single.quoted.strings", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
            }
            super.visitStringLiteral(stringLiteral);
        }

        @Override
        public void visitLiteral(@NotNull JsonLiteral literal) {
            String text2;
            if (literal == null) {
                StandardJsonValidatingElementVisitor.$$$reportNull$$$0(3);
            }
            if (JsonPsiUtil.isPropertyKey(literal) && !this.isValidPropertyName(literal)) {
                this.myHolder.registerProblem((PsiElement)literal, JsonBundle.message("inspection.compliance.msg.illegal.property.key", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
            }
            if (!this.allowNanInfinity() && literal instanceof JsonNumberLiteral && JsonStandardComplianceInspection.this.myWarnAboutNanInfinity && ("Infinity".equals(text2 = JsonPsiUtil.getElementTextWithoutHostEscaping(literal)) || "-Infinity".equals(text2) || "NaN".equals(text2))) {
                this.myHolder.registerProblem((PsiElement)literal, JsonBundle.message("syntax.error.illegal.floating.point.literal", new Object[0]), new LocalQuickFix[0]);
            }
            super.visitLiteral(literal);
        }

        protected boolean allowNanInfinity() {
            return false;
        }

        @Override
        public void visitReferenceExpression(@NotNull JsonReferenceExpression reference) {
            if (reference == null) {
                StandardJsonValidatingElementVisitor.$$$reportNull$$$0(4);
            }
            if (!(this.allowIdentifierPropertyNames() && JsonPsiUtil.isPropertyKey(reference) && this.isValidPropertyName(reference) || MISSING_VALUE.equals(reference.getText()) && InjectedLanguageManager.getInstance((Project)this.myHolder.getProject()).isInjectedFragment(this.myHolder.getFile()))) {
                this.myHolder.registerProblem((PsiElement)reference, JsonBundle.message("inspection.compliance.msg.bad.token", new Object[0]), new LocalQuickFix[]{new AddDoubleQuotesFix()});
            }
            super.visitReferenceExpression(reference);
        }

        @Override
        public void visitArray(@NotNull JsonArray array) {
            PsiElement trailingComma;
            if (array == null) {
                StandardJsonValidatingElementVisitor.$$$reportNull$$$0(5);
            }
            if (JsonStandardComplianceInspection.this.myWarnAboutTrailingCommas && !this.allowTrailingCommas() && JsonStandardComplianceProvider.shouldWarnAboutTrailingComma(array) && (trailingComma = JsonStandardComplianceInspection.findTrailingComma(array.getLastChild(), JsonElementTypes.R_BRACKET)) != null) {
                this.myHolder.registerProblem(trailingComma, JsonBundle.message("inspection.compliance.msg.trailing.comma", new Object[0]), new LocalQuickFix[0]);
            }
            super.visitArray(array);
        }

        @Override
        public void visitObject(@NotNull JsonObject object) {
            PsiElement trailingComma;
            if (object == null) {
                StandardJsonValidatingElementVisitor.$$$reportNull$$$0(6);
            }
            if (JsonStandardComplianceInspection.this.myWarnAboutTrailingCommas && !this.allowTrailingCommas() && JsonStandardComplianceProvider.shouldWarnAboutTrailingComma(object) && (trailingComma = JsonStandardComplianceInspection.findTrailingComma(object.getLastChild(), JsonElementTypes.R_CURLY)) != null) {
                this.myHolder.registerProblem(trailingComma, JsonBundle.message("inspection.compliance.msg.trailing.comma", new Object[0]), new LocalQuickFix[0]);
            }
            super.visitObject(object);
        }

        @Override
        public void visitValue(@NotNull JsonValue value2) {
            PsiFile psiFile2;
            if (value2 == null) {
                StandardJsonValidatingElementVisitor.$$$reportNull$$$0(7);
            }
            if ((psiFile2 = value2.getContainingFile()) instanceof JsonFile) {
                JsonFile jsonFile = (JsonFile)psiFile2;
                if (JsonStandardComplianceInspection.this.myWarnAboutMultipleTopLevelValues && value2.getParent() == jsonFile && value2 != jsonFile.getTopLevelValue() && jsonFile.getFileType() != JsonLinesFileType.INSTANCE) {
                    this.myHolder.registerProblem((PsiElement)value2, JsonBundle.message("inspection.compliance.msg.multiple.top.level.values", new Object[0]), new LocalQuickFix[0]);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringLiteral";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "array";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/json/codeinsight/JsonStandardComplianceInspection$StandardJsonValidatingElementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isValidPropertyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitComment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitStringLiteral";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteral";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitArray";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitObject";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class AddDoubleQuotesFix
    implements LocalQuickFix {
        private AddDoubleQuotesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string2 = JsonBundle.message("quickfix.add.double.quotes.desc", new Object[0]);
            if (string2 == null) {
                AddDoubleQuotesFix.$$$reportNull$$$0(0);
            }
            return string2;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                AddDoubleQuotesFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddDoubleQuotesFix.$$$reportNull$$$0(2);
            }
            PsiElement element = descriptor.getPsiElement();
            String rawText = element.getText();
            if (element instanceof JsonLiteral || element instanceof JsonReferenceExpression) {
                String content = JsonPsiUtil.stripQuotes(rawText);
                if (element instanceof JsonStringLiteral && rawText.startsWith("'")) {
                    content = JsonStandardComplianceInspection.escapeSingleQuotedStringContent(content);
                }
                Object replacement = new JsonElementGenerator(project2).createValue("\"" + content + "\"");
                CodeStyleManager.getInstance((Project)project2).performActionWithFormatterDisabled(() -> element.replace(replacement));
            } else {
                Logger.getInstance(JsonStandardComplianceInspection.class).error("Quick fix was applied to unexpected element", new String[]{rawText, element.getParent().getText()});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/json/codeinsight/JsonStandardComplianceInspection$AddDoubleQuotesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/json/codeinsight/JsonStandardComplianceInspection$AddDoubleQuotesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }
}

