/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.tree;

import com.intellij.history.core.Content;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.Entry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;

public final class FileEntry
extends Entry {
    private long myTimestamp;
    private boolean isReadOnly;
    private Content myContent;

    public FileEntry(int nameId, Content content, long timestamp, boolean isReadOnly) {
        super(nameId);
        this.myTimestamp = timestamp;
        this.isReadOnly = isReadOnly;
        this.myContent = content;
    }

    public FileEntry(String name, Content content, long timestamp, boolean isReadOnly) {
        this(FileEntry.toNameId(name), content, timestamp, isReadOnly);
    }

    public FileEntry(DataInput in, boolean dummy) throws IOException {
        super(in);
        this.myTimestamp = in.readLong();
        this.isReadOnly = in.readBoolean();
        this.myContent = new StoredContent(in);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeLong(this.myTimestamp);
        out.writeBoolean(this.isReadOnly);
        this.myContent.write(out);
    }

    @Override
    public long getTimestamp() {
        return this.myTimestamp;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Content getContent() {
        return this.myContent;
    }

    @Override
    public boolean hasUnavailableContent(List<? super Entry> entriesWithUnavailableContent) {
        if (this.myContent.isAvailable()) {
            return false;
        }
        entriesWithUnavailableContent.add(this);
        return true;
    }

    @Override
    @NotNull
    public FileEntry copy() {
        return new FileEntry(this.getNameId(), this.myContent, this.myTimestamp, this.isReadOnly);
    }

    @Override
    public void setContent(Content newContent, long newTimestamp) {
        this.myContent = newContent;
        this.myTimestamp = newTimestamp;
    }

    @Override
    public void collectDifferencesWith(@NotNull Entry e, @NotNull BiConsumer<Entry, Entry> consumer) {
        if (e == null) {
            FileEntry.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            FileEntry.$$$reportNull$$$0(1);
        }
        if (this.getPath().equals(e.getPath()) && this.myContent.equals(e.getContent()) && this.isReadOnly == e.isReadOnly()) {
            return;
        }
        consumer.accept(this, e);
    }

    @Override
    protected void collectCreatedDifferences(@NotNull BiConsumer<Entry, Entry> consumer) {
        if (consumer == null) {
            FileEntry.$$$reportNull$$$0(2);
        }
        consumer.accept(null, this);
    }

    @Override
    protected void collectDeletedDifferences(@NotNull BiConsumer<Entry, Entry> consumer) {
        if (consumer == null) {
            FileEntry.$$$reportNull$$$0(3);
        }
        consumer.accept(this, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/history/core/tree/FileEntry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDifferencesWith";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "collectCreatedDifferences";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDeletedDifferences";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

