/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.storage.AbstractRecordsTable;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class LocalHistoryRecordsTable
extends AbstractRecordsTable {
    private static final int VERSION = 4;
    private static final int LAST_ID_OFFSET = 8;
    private static final int FIRST_RECORD_OFFSET = 16;
    private static final int LAST_RECORD_OFFSET = 20;
    private static final int FS_TIMESTAMP_OFFSET = 24;
    private static final int HEADER_SIZE = 32;
    private static final int PREV_RECORD_OFFSET = 16;
    private static final int NEXT_RECORD_OFFSET = 20;
    private static final int TIMESTAMP_OFFSET = 24;
    private static final int RECORD_SIZE = 32;
    private static final byte[] ZEROS = new byte[32];

    public LocalHistoryRecordsTable(@NotNull Path storageFilePath, @NotNull StorageLockContext pool) throws IOException {
        if (storageFilePath == null) {
            LocalHistoryRecordsTable.$$$reportNull$$$0(0);
        }
        if (pool == null) {
            LocalHistoryRecordsTable.$$$reportNull$$$0(1);
        }
        super(storageFilePath, pool);
    }

    protected int getHeaderSize() {
        return 32;
    }

    protected int getRecordSize() {
        return 32;
    }

    protected int getImplVersion() {
        return 4;
    }

    protected byte[] getZeros() {
        return ZEROS;
    }

    public long getLastId() throws IOException {
        return this.myStorage.getLong(8L);
    }

    public void setLastId(long lastId) throws IOException {
        this.markDirty();
        this.myStorage.putLong(8L, lastId);
    }

    public void setFirstRecord(int record) throws IOException {
        this.markDirty();
        this.myStorage.putInt(16L, record);
    }

    public int getFirstRecord() throws IOException {
        return this.myStorage.getInt(16L);
    }

    public void setLastRecord(int record) throws IOException {
        this.markDirty();
        this.myStorage.putInt(20L, record);
    }

    public int getLastRecord() throws IOException {
        return this.myStorage.getInt(20L);
    }

    public void setFSTimestamp(long timestamp) throws IOException {
        this.markDirty();
        this.myStorage.putLong(24L, timestamp);
    }

    public long getFSTimestamp() throws IOException {
        return this.myStorage.getLong(24L);
    }

    public void setPrevRecord(int record, int prevRecord) throws IOException {
        this.markDirty();
        this.myStorage.putInt((long)this.getOffset(record, 16), prevRecord);
    }

    public int getPrevRecord(int record) throws IOException {
        return this.myStorage.getInt((long)this.getOffset(record, 16));
    }

    public void setNextRecord(int record, int nextRecord) throws IOException {
        this.markDirty();
        this.myStorage.putInt((long)this.getOffset(record, 20), nextRecord);
    }

    public int getNextRecord(int record) throws IOException {
        return this.myStorage.getInt((long)this.getOffset(record, 20));
    }

    public void setTimestamp(int record, long timestamp) throws IOException {
        this.markDirty();
        this.myStorage.putLong((long)this.getOffset(record, 24), timestamp);
    }

    public long getTimestamp(int record) throws IOException {
        return this.myStorage.getLong((long)this.getOffset(record, 24));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "storageFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "pool";
                break;
            }
        }
        objectArray[1] = "com/intellij/history/core/LocalHistoryRecordsTable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

