/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/SimpleChangesGroupingPolicy;", "Lcom/intellij/dvcs/repo/Repository;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "colorManager", "Lcom/intellij/vcs/log/ui/VcsLogColorManager;", "getProject", "()Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lcom/intellij/dvcs/repo/VcsRepositoryManager;", "Lorg/jetbrains/annotations/NotNull;", "createGroupRootNode", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "value", "getGroupRootValueFor", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "node", "getRepositoryFor", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "Factory", "intellij.platform.vcs.dvcs.impl"})
public final class RepositoryChangesGroupingPolicy
extends SimpleChangesGroupingPolicy<Repository> {
    @NotNull
    private final Project project;
    @NotNull
    private final VcsRepositoryManager repositoryManager;
    @NotNull
    private final VcsLogColorManager colorManager;

    public RepositoryChangesGroupingPolicy(@NotNull Project project2, @NotNull DefaultTreeModel model2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        super(model2);
        this.project = project2;
        VcsRepositoryManager vcsRepositoryManager = VcsRepositoryManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)vcsRepositoryManager, (String)"getInstance(...)");
        this.repositoryManager = vcsRepositoryManager;
        this.colorManager = RepositoryChangesBrowserNode.Companion.getColorManager(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    protected Repository getGroupRootValueFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> node) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        if (!this.colorManager.hasMultiplePaths()) {
            return null;
        }
        FilePath filePath = nodePath.getFilePath();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath filePath2 = filePath;
        Repository repository = this.getRepositoryFor(filePath2);
        if (repository == null) {
            return null;
        }
        Repository repository2 = repository;
        if (this.repositoryManager.isExternal(repository2)) {
            return null;
        }
        return repository2;
    }

    @Override
    @NotNull
    protected ChangesBrowserNode<?> createGroupRootNode(@NotNull Repository value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        RepositoryChangesBrowserNode repoNode = new RepositoryChangesBrowserNode(value2, this.colorManager);
        repoNode.markAsHelperNode();
        return repoNode;
    }

    private final Repository getRepositoryFor(FilePath filePath) {
        Repository parentRepo;
        Repository repository = this.repositoryManager.getRepositoryForFile(filePath, true);
        if (repository != null && !repository.getVcs().areDirectoriesVersionedItems() && Intrinsics.areEqual((Object)this.repositoryManager.getRepositoryForRootQuick(filePath), (Object)repository) && (parentRepo = this.repositoryManager.getRepositoryForFile(repository.getRoot().getParent(), true)) != null) {
            return parentRepo;
        }
        return repository;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/dvcs/ui/RepositoryChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "()V", "createGroupingPolicy", "Lcom/intellij/dvcs/ui/RepositoryChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.dvcs.impl"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        @Override
        @NotNull
        public RepositoryChangesGroupingPolicy createGroupingPolicy(@NotNull Project project2, @NotNull DefaultTreeModel model2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            return new RepositoryChangesGroupingPolicy(project2, model2);
        }
    }
}

