/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SimpleCoverageAnnotator
extends BaseCoverageAnnotator {
    private final Map<String, BaseCoverageAnnotator.FileCoverageInfo> myFileCoverageInfos = new HashMap<String, BaseCoverageAnnotator.FileCoverageInfo>();
    private final Map<String, BaseCoverageAnnotator.DirCoverageInfo> myTestDirCoverageInfos = new HashMap<String, BaseCoverageAnnotator.DirCoverageInfo>();
    private final Map<String, BaseCoverageAnnotator.DirCoverageInfo> myDirCoverageInfos = new HashMap<String, BaseCoverageAnnotator.DirCoverageInfo>();
    private final Set<String> myTestDirectories = new HashSet<String>();

    public SimpleCoverageAnnotator(Project project2) {
        super(project2);
    }

    @Override
    public void onSuiteChosen(CoverageSuitesBundle newSuite) {
        super.onSuiteChosen(newSuite);
        this.myFileCoverageInfos.clear();
        this.myTestDirCoverageInfos.clear();
        this.myDirCoverageInfos.clear();
        this.myTestDirectories.clear();
    }

    @Nullable
    protected BaseCoverageAnnotator.DirCoverageInfo getDirCoverageInfo(@NotNull VirtualFile dir, @NotNull CoverageSuitesBundle currentSuite) {
        if (dir == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(0);
        }
        if (currentSuite == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(1);
        }
        String path2 = SimpleCoverageAnnotator.normalizeFilePath(dir.getPath());
        boolean isInTestContent = this.myTestDirectories.contains(path2);
        if (!currentSuite.isTrackTestFolders() && isInTestContent) {
            return null;
        }
        return isInTestContent ? this.myTestDirCoverageInfos.get(path2) : this.myDirCoverageInfos.get(path2);
    }

    @Override
    @Nullable
    @Nls
    public String getDirCoverageInformationString(@NotNull Project project2, @NotNull VirtualFile dir, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        BaseCoverageAnnotator.DirCoverageInfo coverageInfo;
        if (project2 == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(2);
        }
        if (dir == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(3);
        }
        if (currentSuite == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(5);
        }
        if ((coverageInfo = this.getDirCoverageInfo(dir, currentSuite)) == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.coveredLineCount > 0 ? CoverageBundle.message("coverage.view.text.covered", new Object[0]) : null;
        }
        String filesCoverageInfo = this.getFilesCoverageInformationString(coverageInfo);
        if (filesCoverageInfo != null) {
            @Nls StringBuilder builder2 = new StringBuilder();
            builder2.append(filesCoverageInfo);
            String linesCoverageInfo = this.getLinesCoverageInformationString(coverageInfo);
            if (linesCoverageInfo != null) {
                builder2.append(", ").append(linesCoverageInfo);
            }
            return builder2.toString();
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static String getFilePath(String filePath) {
        return SimpleCoverageAnnotator.normalizeFilePath(filePath);
    }

    @NotNull
    protected static String normalizeFilePath(@NotNull String filePath) {
        if (filePath == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(6);
        }
        if (SystemInfo.isWindows) {
            filePath = StringUtil.toLowerCase((String)filePath);
        }
        String string2 = FileUtil.toSystemIndependentName((String)filePath);
        if (string2 == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @Nullable
    @Nls
    public String getFileCoverageInformationString(@NotNull Project project2, @NotNull VirtualFile file, @NotNull CoverageSuitesBundle currentSuite, @NotNull CoverageDataManager manager) {
        String path2;
        BaseCoverageAnnotator.FileCoverageInfo coverageInfo;
        if (project2 == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(8);
        }
        if (file == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(9);
        }
        if (currentSuite == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(10);
        }
        if (manager == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(11);
        }
        if ((coverageInfo = this.myFileCoverageInfos.get(path2 = SimpleCoverageAnnotator.normalizeFilePath(file.getPath()))) == null) {
            return null;
        }
        if (manager.isSubCoverageActive()) {
            return coverageInfo.coveredLineCount > 0 ? CoverageBundle.message("coverage.view.text.covered", new Object[0]) : null;
        }
        return this.getLinesCoverageInformationString(coverageInfo);
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo collectBaseFileCoverage(@NotNull VirtualFile file, @NotNull CoverageAnnotatorRunner annotator, @NotNull ProjectData projectData, @NotNull Map<String, String> normalizedFiles2Files) {
        if (file == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(12);
        }
        if (annotator == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(13);
        }
        if (projectData == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(14);
        }
        if (normalizedFiles2Files == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(15);
        }
        VirtualFile virtualFile = file = file.getCanonicalFile() != null ? file.getCanonicalFile() : file;
        assert (file != null);
        String filePath = SimpleCoverageAnnotator.normalizeFilePath(file.getPath());
        ClassData classData = SimpleCoverageAnnotator.getClassData(filePath, projectData, normalizedFiles2Files);
        BaseCoverageAnnotator.FileCoverageInfo info = classData != null ? this.fileInfoForCoveredFile(classData) : this.fillInfoForUncoveredFile(VfsUtilCore.virtualToIoFile((VirtualFile)file));
        if (info != null) {
            annotator.annotateFile(filePath, info);
        }
        return info;
    }

    @Nullable
    protected static ClassData getClassData(@NotNull String filePath, @NotNull ProjectData data2, @NotNull Map<String, String> normalizedFiles2Files) {
        String originalFileName;
        if (filePath == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(16);
        }
        if (data2 == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(17);
        }
        if (normalizedFiles2Files == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(18);
        }
        if ((originalFileName = normalizedFiles2Files.get(filePath)) == null) {
            return null;
        }
        return data2.getClassData(originalFileName);
    }

    @Nullable
    protected BaseCoverageAnnotator.DirCoverageInfo collectFolderCoverage(@NotNull VirtualFile dir, @NotNull CoverageDataManager dataManager, CoverageAnnotatorRunner annotator, ProjectData projectInfo, boolean trackTestFolders, @NotNull ProjectFileIndex index, @NotNull CoverageEngine coverageEngine, Set<? super VirtualFile> visitedDirs, @NotNull Map<String, String> normalizedFiles2Files) {
        if (dir == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(19);
        }
        if (dataManager == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(20);
        }
        if (index == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(21);
        }
        if (coverageEngine == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(22);
        }
        if (normalizedFiles2Files == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(23);
        }
        if (((Boolean)ReadAction.compute(() -> !index.isInContent(dir) && !index.isInLibrary(dir))).booleanValue()) {
            return null;
        }
        if (visitedDirs.contains(dir)) {
            return null;
        }
        if (!this.shouldCollectCoverageInsideLibraryDirs() && ((Boolean)ReadAction.compute(() -> index.isInLibrary(dir))).booleanValue()) {
            return null;
        }
        visitedDirs.add((VirtualFile)dir);
        String dirPath = SimpleCoverageAnnotator.normalizeFilePath(dir.getPath());
        boolean isInTestSrcContent = (Boolean)ReadAction.compute(() -> TestSourcesFilter.isTestSources((VirtualFile)dir, (Project)this.getProject()));
        if (isInTestSrcContent) {
            this.myTestDirectories.add(dirPath);
        }
        if (!trackTestFolders && isInTestSrcContent) {
            return null;
        }
        VirtualFile[] children = (VirtualFile[])dataManager.doInReadActionIfProjectOpen(() -> ((VirtualFile)dir).getChildren());
        if (children == null) {
            return null;
        }
        BaseCoverageAnnotator.DirCoverageInfo dirCoverageInfo = new BaseCoverageAnnotator.DirCoverageInfo();
        for (VirtualFile fileOrDir : children) {
            BaseCoverageAnnotator.FileCoverageInfo fileInfo;
            if (fileOrDir.isDirectory()) {
                BaseCoverageAnnotator.DirCoverageInfo childCoverageInfo = this.collectFolderCoverage(fileOrDir, dataManager, annotator, projectInfo, trackTestFolders, index, coverageEngine, visitedDirs, normalizedFiles2Files);
                if (childCoverageInfo == null) continue;
                dirCoverageInfo.totalFilesCount += childCoverageInfo.totalFilesCount;
                dirCoverageInfo.coveredFilesCount += childCoverageInfo.coveredFilesCount;
                dirCoverageInfo.totalLineCount += childCoverageInfo.totalLineCount;
                dirCoverageInfo.coveredLineCount += childCoverageInfo.coveredLineCount;
                continue;
            }
            if (!coverageEngine.coverageProjectViewStatisticsApplicableTo(fileOrDir) || (fileInfo = this.collectBaseFileCoverage(fileOrDir, annotator, projectInfo, normalizedFiles2Files)) == null) continue;
            dirCoverageInfo.totalLineCount += fileInfo.totalLineCount;
            ++dirCoverageInfo.totalFilesCount;
            if (fileInfo.coveredLineCount <= 0) continue;
            ++dirCoverageInfo.coveredFilesCount;
            dirCoverageInfo.coveredLineCount += fileInfo.coveredLineCount;
        }
        if (dirCoverageInfo.totalFilesCount == 0) {
            return null;
        }
        if (isInTestSrcContent) {
            annotator.annotateTestDirectory(dirPath, dirCoverageInfo);
        } else {
            annotator.annotateSourceDirectory(dirPath, dirCoverageInfo);
        }
        return dirCoverageInfo;
    }

    protected boolean shouldCollectCoverageInsideLibraryDirs() {
        return true;
    }

    protected void annotate(@NotNull VirtualFile contentRoot, @NotNull CoverageSuitesBundle suite2, @NotNull CoverageDataManager dataManager, @NotNull ProjectData data2, Project project2, CoverageAnnotatorRunner annotator) {
        if (contentRoot == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(24);
        }
        if (suite2 == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(25);
        }
        if (dataManager == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(26);
        }
        if (data2 == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(27);
        }
        if (!contentRoot.isValid()) {
            return;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        Map<String, String> normalizedFiles2Files = this.getNormalizedFiles2FilesMapping(data2);
        this.collectFolderCoverage(contentRoot, dataManager, annotator, data2, suite2.isTrackTestFolders(), index, suite2.getCoverageEngine(), new HashSet(), Collections.unmodifiableMap(normalizedFiles2Files));
    }

    protected Map<String, String> getNormalizedFiles2FilesMapping(ProjectData data2) {
        HashMap<String, String> normalizedFiles2Files = new HashMap<String, String>();
        Set files2 = data2.getClasses().keySet();
        for (String file : files2) {
            normalizedFiles2Files.put(SimpleCoverageAnnotator.normalizeFilePath(file), file);
        }
        return normalizedFiles2Files;
    }

    @Override
    @Nullable
    protected Runnable createRenewRequest(@NotNull CoverageSuitesBundle suite2, @NotNull CoverageDataManager dataManager) {
        ProjectData data2;
        if (suite2 == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(28);
        }
        if (dataManager == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(29);
        }
        if ((data2 = suite2.getCoverageData()) == null) {
            return null;
        }
        return () -> {
            Project project2 = this.getProject();
            VirtualFile[] modulesContentRoots = this.getRoots(project2, dataManager, suite2);
            if (modulesContentRoots == null) {
                return;
            }
            for (VirtualFile root : modulesContentRoots) {
                this.annotate(root, suite2, dataManager, data2, project2, new CoverageAnnotatorRunner(){

                    @Override
                    public void annotateSourceDirectory(String dirPath, BaseCoverageAnnotator.DirCoverageInfo info) {
                        SimpleCoverageAnnotator.this.myDirCoverageInfos.put(dirPath, info);
                        try {
                            SimpleCoverageAnnotator.this.myDirCoverageInfos.put(new File(dirPath).getCanonicalPath(), info);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void annotateTestDirectory(String dirPath, BaseCoverageAnnotator.DirCoverageInfo info) {
                        SimpleCoverageAnnotator.this.myTestDirCoverageInfos.put(dirPath, info);
                        try {
                            SimpleCoverageAnnotator.this.myTestDirCoverageInfos.put(new File(dirPath).getCanonicalPath(), info);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void annotateFile(@NotNull String filePath, @NotNull BaseCoverageAnnotator.FileCoverageInfo info) {
                        if (filePath == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (info == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        SimpleCoverageAnnotator.this.myFileCoverageInfos.put(filePath, info);
                        try {
                            SimpleCoverageAnnotator.this.myFileCoverageInfos.put(new File(filePath).getCanonicalPath(), info);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "filePath";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "info";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/coverage/SimpleCoverageAnnotator$1";
                        objectArray[2] = "annotateFile";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            dataManager.triggerPresentationUpdate();
        };
    }

    protected VirtualFile[] getRoots(Project project2, @NotNull CoverageDataManager dataManager, CoverageSuitesBundle suite2) {
        if (dataManager == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(30);
        }
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project2);
        return (VirtualFile[])dataManager.doInReadActionIfProjectOpen(() -> rootManager.getContentRoots());
    }

    @Nullable
    @Nls
    protected String getLinesCoverageInformationString(@NotNull BaseCoverageAnnotator.FileCoverageInfo info) {
        if (info == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(31);
        }
        return CoverageBundle.message("coverage.view.text.lines.covered", SimpleCoverageAnnotator.calcCoveragePercentage(info));
    }

    protected static int calcCoveragePercentage(BaseCoverageAnnotator.FileCoverageInfo info) {
        return SimpleCoverageAnnotator.calcPercent(info.coveredLineCount, info.totalLineCount);
    }

    protected static int calcPercent(int covered, int total) {
        return total != 0 ? (int)((double)covered / (double)total * 100.0) : 100;
    }

    @Nullable
    @Nls
    protected String getFilesCoverageInformationString(@NotNull BaseCoverageAnnotator.DirCoverageInfo info) {
        if (info == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(32);
        }
        return CoverageBundle.message("coverage.view.text.files.covered", SimpleCoverageAnnotator.calcPercent(info.coveredFilesCount, info.totalFilesCount));
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo fileInfoForCoveredFile(@NotNull ClassData classData) {
        Object[] lines;
        int count;
        if (classData == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(33);
        }
        if ((count = (lines = classData.getLines()).length - 1) == 0) {
            return null;
        }
        BaseCoverageAnnotator.FileCoverageInfo info = new BaseCoverageAnnotator.FileCoverageInfo();
        info.coveredLineCount = 0;
        info.totalLineCount = 0;
        for (int i = 1; i <= count; ++i) {
            LineData lineData = classData.getLineData(i);
            this.processLineData(info, lineData);
        }
        return info;
    }

    protected void processLineData(@NotNull BaseCoverageAnnotator.FileCoverageInfo info, @Nullable LineData lineData) {
        if (info == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(34);
        }
        if (lineData == null) {
            return;
        }
        int status = lineData.getStatus();
        if (status != 0) {
            ++info.coveredLineCount;
        }
        ++info.totalLineCount;
    }

    @Nullable
    protected BaseCoverageAnnotator.FileCoverageInfo fillInfoForUncoveredFile(@NotNull File file) {
        if (file == null) {
            SimpleCoverageAnnotator.$$$reportNull$$$0(35);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSuite";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/SimpleCoverageAnnotator";
                break;
            }
            case 9: 
            case 12: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 15: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedFiles2Files";
                break;
            }
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 20: 
            case 26: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataManager";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coverageEngine";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/SimpleCoverageAnnotator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDirCoverageInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDirCoverageInformationString";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "normalizeFilePath";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFileCoverageInformationString";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectBaseFileCoverage";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getClassData";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectFolderCoverage";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createRenewRequest";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLinesCoverageInformationString";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFilesCoverageInformationString";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fileInfoForCoveredFile";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processLineData";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "fillInfoForUncoveredFile";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7 -> new IllegalStateException(string2);
        };
    }

    protected static interface CoverageAnnotatorRunner {
        public void annotateSourceDirectory(String var1, BaseCoverageAnnotator.DirCoverageInfo var2);

        public void annotateTestDirectory(String var1, BaseCoverageAnnotator.DirCoverageInfo var2);

        public void annotateFile(@NotNull String var1, @NotNull BaseCoverageAnnotator.FileCoverageInfo var2);
    }
}

