/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.editorActions.XmlTokenSelectioner;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlSelectioner
extends AbstractWordSelectioner {
    private static final SelectWordUtil.CharCondition JAVA_IDENTIFIER_AND_HYPHEN_CONDITION = ch -> Character.isJavaIdentifierPart(ch) || ch == '-';

    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            HtmlSelectioner.$$$reportNull$$$0(0);
        }
        return HtmlSelectioner.canSelectElement(e);
    }

    static boolean canSelectElement(PsiElement e) {
        if (e instanceof XmlToken) {
            return HtmlUtil.hasHtml(e.getContainingFile()) || HtmlUtil.supportsXmlTypedHandlers(e.getContainingFile());
        }
        return false;
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (e == null) {
            HtmlSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            HtmlSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            HtmlSelectioner.$$$reportNull$$$0(3);
        }
        ArrayList<TextRange> result2 = !(e instanceof XmlToken) || XmlTokenSelectioner.shouldSelectToken((XmlToken)e) || ((XmlToken)e).getTokenType() == XmlTokenType.XML_DATA_CHARACTERS ? super.select(e, editorText, cursorOffset, editor) : new ArrayList<TextRange>();
        PsiElement parent = e.getParent();
        if (parent instanceof XmlComment) {
            result2.addAll(HtmlSelectioner.expandToWholeLine((CharSequence)editorText, (TextRange)parent.getTextRange(), (boolean)true));
        }
        PsiFile psiFile2 = e.getContainingFile();
        this.addAttributeSelection(result2, editor, cursorOffset, editorText, e);
        FileViewProvider fileViewProvider = psiFile2.getViewProvider();
        for (Language lang : fileViewProvider.getLanguages()) {
            PsiFile langFile = fileViewProvider.getPsi(lang);
            if (langFile == psiFile2) continue;
            this.addAttributeSelection(result2, editor, cursorOffset, editorText, fileViewProvider.findElementAt(cursorOffset, lang));
        }
        EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)e.getProject(), (VirtualFile)psiFile2.getVirtualFile());
        highlighter.setText(editorText);
        HtmlSelectioner.addTagSelection2(e, result2);
        return result2;
    }

    private static void addTagSelection2(PsiElement e, List<? super TextRange> result2) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)e, XmlTag.class, (boolean)true);
        while (tag != null) {
            result2.add((TextRange)tag.getTextRange());
            ASTNode tagStartEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
            ASTNode tagEndStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tag.getNode());
            if (tagStartEnd != null && tagEndStart != null) {
                result2.add((TextRange)new UnfairTextRange(tagStartEnd.getTextRange().getEndOffset(), tagEndStart.getTextRange().getStartOffset()));
            }
            if (tagStartEnd != null) {
                result2.add((TextRange)new TextRange(tag.getTextRange().getStartOffset(), tagStartEnd.getTextRange().getEndOffset()));
            }
            if (tagEndStart != null) {
                result2.add((TextRange)new TextRange(tagEndStart.getTextRange().getStartOffset(), tag.getTextRange().getEndOffset()));
            }
            tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class, (boolean)true);
        }
    }

    private void addAttributeSelection(@NotNull List<? super TextRange> result2, @NotNull Editor editor, int cursorOffset, @NotNull CharSequence editorText, @Nullable PsiElement e) {
        XmlAttribute attribute;
        if (result2 == null) {
            HtmlSelectioner.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            HtmlSelectioner.$$$reportNull$$$0(5);
        }
        if (editorText == null) {
            HtmlSelectioner.$$$reportNull$$$0(6);
        }
        if ((attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttribute.class)) != null) {
            result2.add((TextRange)attribute.getTextRange());
            XmlAttributeValue value2 = attribute.getValueElement();
            if (value2 != null) {
                if (this.getClassAttributeName().equalsIgnoreCase(attribute.getName())) {
                    HtmlSelectioner.addClassAttributeRanges(result2, editor, cursorOffset, editorText, value2);
                }
                TextRange range = value2.getTextRange();
                result2.add((TextRange)range);
                if (value2.getFirstChild() != null && value2.getFirstChild().getNode().getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                    result2.add((TextRange)new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 1));
                }
            }
        }
    }

    public int getMinimalTextRangeLength(@NotNull PsiElement element, @NotNull CharSequence text2, int cursorOffset) {
        if (element == null) {
            HtmlSelectioner.$$$reportNull$$$0(7);
        }
        if (text2 == null) {
            HtmlSelectioner.$$$reportNull$$$0(8);
        }
        if (WebEditorOptions.getInstance().isSelectWholeCssIdentifierOnDoubleClick()) {
            TextRange valueTextRange;
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
            XmlAttributeValue attributeValue2 = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class);
            if (attribute != null && attributeValue2 != null && this.getClassAttributeName().equalsIgnoreCase(attribute.getName()) && !(valueTextRange = attributeValue2.getValueTextRange()).isEmpty()) {
                int start2;
                int end = cursorOffset;
                for (start2 = cursorOffset; start2 > valueTextRange.getStartOffset() && JAVA_IDENTIFIER_AND_HYPHEN_CONDITION.value(text2.charAt(start2 - 1)); --start2) {
                }
                while (end < valueTextRange.getEndOffset() && JAVA_IDENTIFIER_AND_HYPHEN_CONDITION.value(text2.charAt(end + 1))) {
                    ++end;
                }
                return end - start2;
            }
        }
        return super.getMinimalTextRangeLength(element, text2, cursorOffset);
    }

    @NotNull
    protected String getClassAttributeName() {
        return "class";
    }

    public static void addClassAttributeRanges(@NotNull List<? super TextRange> result2, @NotNull Editor editor, int cursorOffset, @NotNull CharSequence editorText, @NotNull XmlAttributeValue attributeValue2) {
        if (result2 == null) {
            HtmlSelectioner.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            HtmlSelectioner.$$$reportNull$$$0(10);
        }
        if (editorText == null) {
            HtmlSelectioner.$$$reportNull$$$0(11);
        }
        if (attributeValue2 == null) {
            HtmlSelectioner.$$$reportNull$$$0(12);
        }
        TextRange attributeValueTextRange = attributeValue2.getTextRange();
        LinkedList wordRanges = new LinkedList();
        SelectWordUtil.addWordSelection((boolean)editor.getSettings().isCamelWords(), (CharSequence)editorText, (int)cursorOffset, wordRanges, (SelectWordUtil.CharCondition)JAVA_IDENTIFIER_AND_HYPHEN_CONDITION);
        for (TextRange range : wordRanges) {
            if (!attributeValueTextRange.contains(range)) continue;
            result2.add((TextRange)range);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/HtmlSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addAttributeSelection";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinimalTextRangeLength";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addClassAttributeRanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

