/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector.ngram.impl;

import ai.grazie.detector.ngram.filter.StandardNgramFilter;
import ai.grazie.detector.ngram.impl.NgramExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\u0010\u001a\u00020\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0012"}, d2={"Lai/grazie/detector/ngram/impl/NgramExtractor;", "", "gramLengths", "", "", "textPadding", "", "(Ljava/util/List;Ljava/lang/Character;)V", "getGramLengths", "()Ljava/util/List;", "Ljava/lang/Character;", "applyPadding", "", "text", "extract", "", "input", "Companion", "nlp-detect"})
@SourceDebugExtension(value={"SMAP\nNgramExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NgramExtractor.kt\nai/grazie/detector/ngram/impl/NgramExtractor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public final class NgramExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Integer> gramLengths;
    @Nullable
    private final Character textPadding;
    @NotNull
    private static final Lazy<NgramExtractor> standard$delegate = LazyKt.lazy((Function0)Companion.standard.2.INSTANCE);

    public NgramExtractor(@NotNull List<Integer> gramLengths, @Nullable Character textPadding) {
        Intrinsics.checkNotNullParameter(gramLengths, (String)"gramLengths");
        this.gramLengths = gramLengths;
        this.textPadding = textPadding;
        if (!(!((Collection)this.gramLengths).isEmpty())) {
            boolean bl = false;
            String string2 = "GramLengths cannot be empty";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ NgramExtractor(List list2, Character c, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            c = Character.valueOf(' ');
        }
        this(list2, c);
    }

    @NotNull
    public final List<Integer> getGramLengths() {
        return this.gramLengths;
    }

    @NotNull
    public final List<String> extract(@NotNull CharSequence input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        CharSequence text2 = this.applyPadding(input);
        int len = text2.length();
        ArrayList<String> grams = new ArrayList<String>();
        Iterator<Integer> iterator = this.gramLengths.iterator();
        while (iterator.hasNext()) {
            int gramLength = ((Number)iterator.next()).intValue();
            int numGrams = len - (gramLength - 1);
            if (numGrams < 1) continue;
            for (int pos = 0; pos < numGrams; ++pos) {
                String gram = ((Object)text2.subSequence(pos, pos + gramLength)).toString();
                if (!StandardNgramFilter.INSTANCE.use(gram)) continue;
                grams.add(gram);
            }
        }
        return grams;
    }

    private final CharSequence applyPadding(CharSequence text2) {
        StringBuilder stringBuilder;
        if (this.textPadding == null || text2.length() == 0 || StringsKt.startsWith$default((CharSequence)text2, (char)this.textPadding.charValue(), (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)text2, (char)this.textPadding.charValue(), (boolean)false, (int)2, null)) {
            return text2;
        }
        StringBuilder $this$applyPadding_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!StringsKt.startsWith$default((CharSequence)text2, (char)this.textPadding.charValue(), (boolean)false, (int)2, null)) {
            $this$applyPadding_u24lambda_u241.append(this.textPadding.charValue());
        }
        $this$applyPadding_u24lambda_u241.append(text2);
        if (!StringsKt.endsWith$default((CharSequence)text2, (char)this.textPadding.charValue(), (boolean)false, (int)2, null)) {
            $this$applyPadding_u24lambda_u241.append(this.textPadding.charValue());
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\u00042\n\u0010\n\u001a\u00020\u000b\"\u00020\fR\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lai/grazie/detector/ngram/impl/NgramExtractor$Companion;", "", "()V", "standard", "Lai/grazie/detector/ngram/impl/NgramExtractor;", "getStandard", "()Lai/grazie/detector/ngram/impl/NgramExtractor;", "standard$delegate", "Lkotlin/Lazy;", "gramLengths", "gramLength", "", "", "nlp-detect"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NgramExtractor gramLengths(int ... gramLength) {
            Intrinsics.checkNotNullParameter((Object)gramLength, (String)"gramLength");
            return new NgramExtractor(ArraysKt.toList((int[])gramLength), null, 2, null);
        }

        @NotNull
        public final NgramExtractor getStandard() {
            Lazy lazy = standard$delegate;
            return (NgramExtractor)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

