/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.detector.ngram;

import ai.grazie.detector.DetectedLanguage;
import ai.grazie.detector.LanguageDetector;
import ai.grazie.detector.ngram.NgramDetector;
import ai.grazie.detector.ngram.impl.NgramExtractor;
import ai.grazie.detector.ngram.impl.NgramFrequencies;
import ai.grazie.detector.utils.StatisticsKt;
import ai.grazie.detector.utils.collections.array.OptimizedFloatArray;
import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.word.StandardWordTokenizer;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0013\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001*B=\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J*\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u0019J&\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u0019H\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J*\u0010\u001f\u001a\u00020\u001b2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00060\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u001bH\u0002J \u0010$\u001a\u00020%2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u000f*\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lai/grazie/detector/ngram/NgramDetector;", "Lai/grazie/detector/LanguageDetector;", "", "ngramFrequencies", "Lai/grazie/detector/ngram/impl/NgramFrequencies;", "alpha", "", "prefixFactor", "suffixFactor", "probabilityThreshold", "minimalConfidence", "ngramExtractor", "Lai/grazie/detector/ngram/impl/NgramExtractor;", "(Lai/grazie/detector/ngram/impl/NgramFrequencies;DDDDDLai/grazie/detector/ngram/impl/NgramExtractor;)V", "languages", "", "Lai/grazie/nlp/langs/Language;", "getLanguages", "()Ljava/util/List;", "detect", "Lai/grazie/detector/LanguageDetector$DetectionResult;", "input", "isReliable", "", "weights", "", "detectBlock", "", "text", "initProbability", "priorMap", "makeInternalPrioMap", "langWeightingMap", "langlist", "normalizeProb", "prob", "updateLangProb", "", "ngram", "", "sortProbability", "Lai/grazie/detector/DetectedLanguage;", "Companion", "nlp-detect"})
@SourceDebugExtension(value={"SMAP\nNgramDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NgramDetector.kt\nai/grazie/detector/ngram/NgramDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,249:1\n1#2:250\n1271#3,2:251\n1285#3,4:253\n1963#3,14:257\n1747#3,3:273\n819#3:276\n847#3,2:277\n37#4,2:271\n*S KotlinDebug\n*F\n+ 1 NgramDetector.kt\nai/grazie/detector/ngram/NgramDetector\n*L\n93#1:251,2\n93#1:253,4\n102#1:257,14\n231#1:273,3\n80#1:276\n80#1:277,2\n107#1:271,2\n*E\n"})
public final class NgramDetector
extends LanguageDetector<CharSequence> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final NgramFrequencies ngramFrequencies;
    private final double alpha;
    private final double prefixFactor;
    private final double suffixFactor;
    private final double probabilityThreshold;
    private final double minimalConfidence;
    @NotNull
    private final NgramExtractor ngramExtractor;
    @NotNull
    private final List<Language> languages;
    private static final double ALPHA_WIDTH = 0.05;
    private static final int ITERATION_LIMIT = 1000;
    private static final double CONV_THRESHOLD = 0.99999;
    private static final int BASE_FREQ = 10000;
    private static final int N_TRIAL = 7;
    private static final long DEFAULT_SEED = 41L;
    @NotNull
    private static final Comparator<DetectedLanguage> PROBABILITY_SORTING_COMPARATOR;
    @NotNull
    private static final List<Language> supported;

    public NgramDetector(@NotNull NgramFrequencies ngramFrequencies, double alpha, double prefixFactor, double suffixFactor, double probabilityThreshold, double minimalConfidence, @NotNull NgramExtractor ngramExtractor) {
        Intrinsics.checkNotNullParameter((Object)ngramFrequencies, (String)"ngramFrequencies");
        Intrinsics.checkNotNullParameter((Object)ngramExtractor, (String)"ngramExtractor");
        this.ngramFrequencies = ngramFrequencies;
        this.alpha = alpha;
        this.prefixFactor = prefixFactor;
        this.suffixFactor = suffixFactor;
        this.probabilityThreshold = probabilityThreshold;
        this.minimalConfidence = minimalConfidence;
        this.ngramExtractor = ngramExtractor;
        this.languages = this.ngramFrequencies.getLanguages();
        double d = this.alpha;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            boolean $i$a$-require-NgramDetector$62 = false;
            String $i$a$-require-NgramDetector$62 = "alpha must be between 0 and 1, but was: " + this.alpha;
            throw new IllegalArgumentException($i$a$-require-NgramDetector$62.toString());
        }
        d = this.prefixFactor;
        if (!(0.0 <= d ? d <= 10.0 : false)) {
            boolean $i$a$-require-NgramDetector$72 = false;
            String $i$a$-require-NgramDetector$72 = "prefixFactor must be between 0 and 10, but was: " + this.prefixFactor;
            throw new IllegalArgumentException($i$a$-require-NgramDetector$72.toString());
        }
        d = this.suffixFactor;
        if (!(0.0 <= d ? d <= 10.0 : false)) {
            boolean $i$a$-require-NgramDetector$82 = false;
            String $i$a$-require-NgramDetector$82 = "suffixFactor must be between 0 and 10, but was: " + this.suffixFactor;
            throw new IllegalArgumentException($i$a$-require-NgramDetector$82.toString());
        }
        d = this.probabilityThreshold;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            boolean $i$a$-require-NgramDetector$92 = false;
            String $i$a$-require-NgramDetector$92 = "probabilityThreshold must be between 0 and 1, but was: " + this.probabilityThreshold;
            throw new IllegalArgumentException($i$a$-require-NgramDetector$92.toString());
        }
        d = this.minimalConfidence;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            boolean bl = false;
            String string2 = "minimalConfidence must be between 0 and 1, but was: " + this.minimalConfidence;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final List<Language> getLanguages() {
        return this.languages;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LanguageDetector.DetectionResult detect(@NotNull CharSequence input, boolean isReliable) {
        Map map2;
        void $this$associateWith$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Iterable iterable = this.languages;
        boolean bl = isReliable;
        CharSequence charSequence = input;
        NgramDetector ngramDetector = this;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Language language = (Language)((Object)element$iv$iv);
            Object t = element$iv$iv;
            map2 = result$iv;
            boolean bl2 = false;
            Double d = 1.0;
            map2.put(t, d);
        }
        map2 = result$iv;
        return ngramDetector.detect(charSequence, bl, StatisticsKt.normalize(map2));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final LanguageDetector.DetectionResult detect(@NotNull CharSequence input, boolean isReliable, @NotNull Map<Language, Double> weights) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(weights, (String)"weights");
        words = StandardWordTokenizer.INSTANCE.words(input.toString());
        if (isReliable && (words.size() < 3 || words.size() < 3 && input.length() < 10)) {
            return LanguageDetector.DetectionResult.Companion.unknown(LanguageDetector.Type.Ngram);
        }
        v0 = this.detectBlock(input, weights);
        v1 = v0 != null ? this.sortProbability(v0) : null;
        if (v1 == null) {
            v1 = CollectionsKt.emptyList();
        }
        probabilities = v1;
        $this$maxByOrNull$iv = probabilities;
        $i$f$maxByOrNull = false;
        iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                it = (DetectedLanguage)maxElem$iv;
                $i$a$-maxByOrNull-NgramDetector$detect$prob$1 = false;
                maxValue$iv = it.getProbability();
                do {
                    e$iv = iterator$iv.next();
                    it = (DetectedLanguage)e$iv;
                    $i$a$-maxByOrNull-NgramDetector$detect$prob$1 = false;
                    v$iv = it.getProbability();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        if ((v3 = (DetectedLanguage)v2) == null) ** GOTO lbl-1000
        it = $i$f$maxByOrNull = v3;
        $i$a$-takeIf-NgramDetector$detect$prob$2 = false;
        v3 = it.getProbability() >= this.minimalConfidence != false ? $i$f$maxByOrNull : null;
        if (v3 != null) {
            v4 = v3.getLang();
        } else lbl-1000:
        // 2 sources

        {
            v4 = null;
        }
        if ((v5 = (prob = v4)) == null) {
            v5 = Language.UNKNOWN;
        }
        $this$toTypedArray$iv = CollectionsKt.sortedWith((Iterable)probabilities, (Comparator)(Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, detect$lambda$8(kotlin.jvm.functions.Function2 java.lang.Object java.lang.Object ), (Ljava/lang/Object;Ljava/lang/Object;)I)((Function2)detect.2.INSTANCE));
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        return new LanguageDetector.DetectionResult(LanguageDetector.Type.Ngram, v5, thisCollection$iv.toArray(new DetectedLanguage[0]));
    }

    private final double[] detectBlock(CharSequence text2, Map<Language, Double> weights) {
        List<String> ngrams = this.ngramExtractor.extract(text2);
        if (ngrams.isEmpty()) {
            return null;
        }
        double[] prior = this.makeInternalPrioMap(weights, this.ngramFrequencies.getLanguages());
        double[] langprob = new double[this.ngramFrequencies.getLanguages().size()];
        Random rand = RandomKt.Random((long)41L);
        for (int trial = 0; trial < 7; ++trial) {
            double[] prob = this.initProbability(prior);
            double alpha = this.alpha + rand.nextDouble() * 0.05;
            for (int i = 0; i < 1000; ++i) {
                String randomNgram = ngrams.get(rand.nextInt(ngrams.size()));
                this.updateLangProb(prob, randomNgram, alpha);
                if (i != 0 && i % 5 == 0 && this.normalizeProb(prob) > 0.99999) break;
            }
            int n = langprob.length;
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                langprob[n2] = langprob[n2] + prob[j] / (double)7;
            }
        }
        return langprob;
    }

    private final double[] initProbability(double[] priorMap) {
        int n = 0;
        int n2 = this.ngramFrequencies.getLanguages().size();
        double[] dArray = new double[n2];
        while (n < n2) {
            int n3 = n++;
            dArray[n3] = 0.0;
        }
        double[] prob = dArray;
        n2 = prob.length;
        for (int i = 0; i < n2; ++i) {
            prob[i] = priorMap[i];
        }
        return prob;
    }

    private final void updateLangProb(double[] prob, String ngram, double alpha) {
        OptimizedFloatArray langProbMap = this.ngramFrequencies.getProbabilities(ngram);
        double weight = alpha / (double)10000;
        if (ngram.length() > 1) {
            if (!(this.prefixFactor == 1.0) && ngram.charAt(0) == ' ') {
                weight *= this.prefixFactor;
            } else if (!(this.suffixFactor == 1.0) && ngram.charAt(ngram.length() - 1) == ' ') {
                weight *= this.suffixFactor;
            }
        }
        int n = prob.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            prob[n2] = prob[n2] * (weight + (double)langProbMap.get(i));
        }
    }

    private final List<DetectedLanguage> sortProbability(double[] $this$sortProbability) {
        ArrayList<DetectedLanguage> list2 = new ArrayList<DetectedLanguage>();
        int n = $this$sortProbability.length;
        for (int i = 0; i < n; ++i) {
            double prob = $this$sortProbability[i];
            if (!(prob >= this.probabilityThreshold)) continue;
            list2.add(new DetectedLanguage(this.ngramFrequencies.getLanguage(i), prob));
        }
        if (list2.size() >= 2) {
            CollectionsKt.sortWith((List)list2, PROBABILITY_SORTING_COMPARATOR);
        }
        return list2;
    }

    private final double normalizeProb(double[] prob) {
        double maxp = 0.0;
        double sump = ArraysKt.sum((double[])prob);
        int n = prob.length;
        for (int i = 0; i < n; ++i) {
            double p = prob[i] / sump;
            if (maxp < p) {
                maxp = p;
            }
            prob[i] = p;
        }
        return maxp;
    }

    private final double[] makeInternalPrioMap(Map<Language, Double> langWeightingMap, List<? extends Language> langlist) {
        int i;
        int n;
        int n2 = 0;
        int n3 = langlist.size();
        double[] dArray = new double[n3];
        while (n2 < n3) {
            n = n2++;
            dArray[n] = 0.0;
        }
        double[] priorMap = dArray;
        if (langWeightingMap.isEmpty()) {
            return priorMap;
        }
        double sump = 0.0;
        n = priorMap.length;
        for (i = 0; i < n; ++i) {
            Object element$iv2;
            boolean bl;
            block12: {
                Language lang = langlist.get(i);
                if (langWeightingMap.containsKey((Object)lang)) {
                    double prob = ((Number)MapsKt.getValue(langWeightingMap, (Object)((Object)lang))).doubleValue();
                    if (!(prob >= 0.0)) {
                        boolean $i$a$-require-NgramDetector$makeInternalPrioMap$22 = false;
                        String $i$a$-require-NgramDetector$makeInternalPrioMap$22 = "Prior probability must be non-negative!";
                        throw new IllegalArgumentException($i$a$-require-NgramDetector$makeInternalPrioMap$22.toString());
                    }
                    priorMap[i] = prob;
                    sump += prob;
                }
                if (lang != Language.UNKNOWN) continue;
                Iterable $this$any$iv = langlist;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        Language it = (Language)((Object)element$iv2);
                        boolean bl2 = false;
                        if (!(!langWeightingMap.containsKey((Object)it))) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            element$iv2 = CollectionsKt.averageOfDouble((Iterable)langWeightingMap.values());
            double it = ((Number)element$iv2).doubleValue();
            boolean bl3 = false;
            Object object = !(it == 0.0) ? element$iv2 : null;
            double prob = object != null ? (Double)object : 1.0;
            if (!(prob >= 0.0)) {
                boolean bl4 = false;
                String string2 = "Prior probability must be non-negative!";
                throw new IllegalArgumentException(string2.toString());
            }
            priorMap[i] = prob;
            sump += prob;
        }
        if (sump == 0.0) {
            i = 0;
            n = langlist.size();
            double[] dArray2 = new double[n];
            while (i < n) {
                int n4 = i++;
                dArray2[n4] = 0.0;
            }
            return dArray2;
        }
        i = 0;
        n = priorMap.length;
        while (i < n) {
            int n5 = i++;
            priorMap[n5] = priorMap[n5] / sump;
        }
        return priorMap;
    }

    private static final int detect$lambda$8(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    private static final int PROBABILITY_SORTING_COMPARATOR$lambda$13(DetectedLanguage a, DetectedLanguage b) {
        return !(b.getProbability() == a.getProbability()) ? Double.compare(b.getProbability(), a.getProbability()) : b.getLang().getIso().compareTo((Enum)a.getLang().getIso());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$filterNotTo$iv$iv;
        Companion = new Companion(null);
        PROBABILITY_SORTING_COMPARATOR = NgramDetector::PROBABILITY_SORTING_COMPARATOR$lambda$13;
        Iterable $this$filterNot$iv = Language.Companion.getAll();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Language it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            Language[] languageArray = new Language[]{Language.CHINESE, Language.JAPANESE, Language.KOREAN, Language.GREEK, Language.TAMIL, Language.KHMER};
            if (SetsKt.setOf((Object[])languageArray).contains((Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        supported = (List)var3_3;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lai/grazie/detector/ngram/NgramDetector$Companion;", "", "()V", "ALPHA_WIDTH", "", "BASE_FREQ", "", "CONV_THRESHOLD", "DEFAULT_SEED", "", "ITERATION_LIMIT", "N_TRIAL", "PROBABILITY_SORTING_COMPARATOR", "Ljava/util/Comparator;", "Lai/grazie/detector/DetectedLanguage;", "supported", "", "Lai/grazie/nlp/langs/Language;", "getSupported", "()Ljava/util/List;", "nlp-detect"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<Language> getSupported() {
            return supported;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

