/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.qt.clion.workspace;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.qt.clion.workspace.QtWorkspaceListenerActivity;
import com.intellij.qt.common.settings.QtSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorSpec;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLHost;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0007J6\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J \u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/qt/clion/workspace/QtWorkspaceListenerActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findQtPaths", "Lkotlin/Pair;", "", "cmakePrefix", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "hasQt5", "", "hasQt6", "getMatchingModelConfig", "Lcom/jetbrains/cidr/cpp/cmake/model/CMakeModelConfigurationData;", "profileInfo", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProfileInfo;", "modelConfigs", "", "listenChanges", "updateQtSettings", "intellij.qt.clion"})
public final class QtWorkspaceListenerActivity
implements ProjectActivity {
    private final Pair<String, String> findQtPaths(String cmakePrefix, CPPEnvironment environment, boolean hasQt5, boolean hasQt6) {
        HostMachine hostMachine = environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
        HostMachine host = hostMachine;
        Path path = host.createTempDirectory("cmake_check_environment", null);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        Path projectDir = path;
        Path path2 = Files.createTempDirectory(projectDir, "_build", new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"createTempDirectory(...)");
        Path outputDir = path2;
        CMakeExecutableTool cMakeExecutableTool = environment.getCMake();
        ToolVersion cmakeVersion = cMakeExecutableTool != null ? cMakeExecutableTool.readToolVersion() : null;
        List cmakeListsContent = new ArrayList();
        ToolVersion toolVersion = cmakeVersion;
        if (toolVersion != null) {
            ToolVersion it = toolVersion;
            boolean bl = false;
            cmakeListsContent.add("cmake_minimum_required(VERSION " + it.versionNumber.major + "." + it.versionNumber.minor + ")");
        }
        String qtVersionsList = (hasQt6 ? "Qt6" : "") + (hasQt5 ? " Qt5" : "");
        cmakeListsContent.add(StringsKt.trimIndent((String)("\n      project(qml_test_run)\n      set(CMAKE_CXX_STANDARD 17)\n      set(CMAKE_C_COMPILER_WORKS 1)\n      set(CMAKE_CXX_COMPILER_WORKS 1)\n      set(CMAKE_AUTOMOC ON)\n      set(CMAKE_AUTORCC ON)\n      set(CMAKE_AUTOUIC ON)\n      find_package(QT NAMES " + qtVersionsList + " COMPONENTS Core Quick REQUIRED)\n      find_package(Qt${QT_VERSION_MAJOR} COMPONENTS Core Quick REQUIRED)\n      message(\"QML ${QT6_INSTALL_PREFIX}/${QT6_INSTALL_QML}\")\n      message(\"BIN ${QT6_INSTALL_PREFIX}/${QT6_INSTALL_BINS}\")\n      message(\"MOC ${QT_MOC_EXECUTABLE}\")\n      add_executable(qtdiag main.cpp)\n      target_link_libraries(qtdiag Qt${QT_VERSION_MAJOR}::Core)\n      ")));
        List mainCppContent = new ArrayList();
        mainCppContent.add("#include <QtCore>\n#include <QDebug>\nint main() {\n#if QT_VERSION_MAJOR > 5\n    qDebug()  << \"QmlImportsPath:\" << QLibraryInfo::path(QLibraryInfo::QmlImportsPath);\n#else\n    qDebug()  << \"QmlImportsPath:\" << QLibraryInfo::location(QLibraryInfo::Qml2ImportsPath);\n#endif\n    return 0;\n}");
        Files.write(projectDir.resolve("main.cpp"), (Iterable<? extends CharSequence>)mainCppContent, new OpenOption[0]);
        Files.write(projectDir.resolve("CMakeLists.txt"), (Iterable<? extends CharSequence>)cmakeListsContent, new OpenOption[0]);
        List options = new ArrayList();
        options.add("-DCMAKE_PREFIX_PATH=" + cmakePrefix);
        CMakeGeneratorSpec spec = (CMakeGeneratorSpec)CMakeGeneratorParameters.Companion.calculateGeneratorSpec(options, cmakeVersion, null, environment, false).getSecond();
        List effectiveOptions = CMakeGeneratorParameters.Companion.calculateEffectiveGenerationOptions$default((CMakeGeneratorParameters.Companion)CMakeGeneratorParameters.Companion, (List)options, (CMakeGeneratorSpec)spec, (CPPEnvironment)environment, null, (int)8, null);
        CMakeRunner.CMakeOutput cMakeOutput = CMakeGenerator.runCMakeGenerator((CPPEnvironment)environment, (Path)projectDir, (Path)outputDir, (List)effectiveOptions, (String)spec.getGenerator().getName());
        Intrinsics.checkNotNullExpressionValue((Object)cMakeOutput, (String)"runCMakeGenerator(...)");
        CMakeRunner.CMakeOutput processOutput = cMakeOutput;
        if (processOutput.getExitCode() != 0) {
            return null;
        }
        String outputStr = ((Object)processOutput.getOutput()).toString();
        int qmlLineStart = StringsKt.indexOf$default((CharSequence)outputStr, (String)"\nQML ", (int)0, (boolean)false, (int)6, null);
        if (qmlLineStart == -1) {
            return null;
        }
        int binLineStart = StringsKt.indexOf$default((CharSequence)outputStr, (String)"\nBIN ", (int)(qmlLineStart + 5), (boolean)false, (int)4, null);
        if (binLineStart == -1) {
            return null;
        }
        int mocLineStart = StringsKt.indexOf$default((CharSequence)outputStr, (String)"\nMOC ", (int)(binLineStart + 5), (boolean)false, (int)4, null);
        if (mocLineStart == -1) {
            return null;
        }
        int mocLineEnd = StringsKt.indexOf$default((CharSequence)outputStr, (String)"\n", (int)(mocLineStart + 5), (boolean)false, (int)4, null);
        String string = outputStr.substring(qmlLineStart + 5, binLineStart);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String qmlPath = string;
        String string2 = outputStr.substring(binLineStart + 5, mocLineStart);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String binPath = string2;
        String string3 = outputStr.substring(mocLineStart + 5, mocLineEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String mocPath = string3;
        if (binPath.length() < 2) {
            if (((CharSequence)mocPath).length() == 0) {
                return null;
            }
            String string4 = PathUtil.getParentPath((String)mocPath);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getParentPath(...)");
            binPath = string4;
        }
        if (qmlPath.length() < 2) {
            if (binPath.length() < 2) {
                return null;
            }
            String qtDiagBinaryName = "qtdiag" + (SystemInfo.isWindows && !host.isWsl() && !host.isRemote() ? ".exe" : "");
            String[] stringArray = new String[]{binPath, qtDiagBinaryName};
            String string5 = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"join(...)");
            String qtDiagPath = string5;
            String qtDiagOutput = null;
            if (FileUtil.exists((String)qtDiagPath)) {
                GeneralCommandLine commandLine = new GeneralCommandLine();
                commandLine.setExePath(qtDiagPath);
                commandLine.addParameter("--no-gl");
                commandLine.addParameter("--no-vulkan");
                commandLine.addParameter("--no-rhi");
                environment.prepare(commandLine, CidrToolEnvironment.PrepareFor.RUN);
                ProcessOutput processOutput2 = host.runProcess(commandLine, 5000);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcess(...)");
                ProcessOutput output = processOutput2;
                qtDiagOutput = output.getStdout();
            } else {
                CMakeExecutableTool cmake = environment.getCMake();
                GeneralCommandLine cmakeBuildCommandLine = new GeneralCommandLine();
                CMakeExecutableTool cMakeExecutableTool2 = cmake;
                Intrinsics.checkNotNull((Object)cMakeExecutableTool2);
                cmakeBuildCommandLine.setExePath(cMakeExecutableTool2.getExecutablePath());
                cmakeBuildCommandLine.addParameter("--build");
                cmakeBuildCommandLine.addParameter(environment.toEnvPath(((Object)outputDir).toString()));
                cmakeBuildCommandLine.addParameter("--target");
                cmakeBuildCommandLine.addParameter("all");
                environment.prepare(cmakeBuildCommandLine, CidrToolEnvironment.PrepareFor.BUILD);
                host.runProcess(cmakeBuildCommandLine, 5000);
                GeneralCommandLine commandLine = new GeneralCommandLine();
                commandLine.setExePath(environment.toEnvPath(((Object)outputDir.resolve(qtDiagBinaryName)).toString()));
                environment.prepare(commandLine, CidrToolEnvironment.PrepareFor.RUN);
                ProcessOutput processOutput3 = host.runProcess(commandLine, 5000);
                Intrinsics.checkNotNullExpressionValue((Object)processOutput3, (String)"runProcess(...)");
                ProcessOutput output = processOutput3;
                qtDiagOutput = output.getStderr();
            }
            int qmlImportsPathStart = StringsKt.indexOf$default((CharSequence)qtDiagOutput, (String)"Qml2ImportsPath: ", (int)0, (boolean)false, (int)6, null);
            if (qmlImportsPathStart != -1) {
                qmlImportsPathStart += 17;
            } else {
                qmlImportsPathStart = StringsKt.indexOf$default((CharSequence)qtDiagOutput, (String)"QmlImportsPath: ", (int)0, (boolean)false, (int)6, null);
                if (qmlImportsPathStart != -1) {
                    qmlImportsPathStart += 16;
                }
            }
            if (qmlImportsPathStart == -1) {
                return null;
            }
            int endOfLine = StringsKt.indexOf$default((CharSequence)qtDiagOutput, (String)"\n", (int)qmlImportsPathStart, (boolean)false, (int)4, null);
            String string6 = qtDiagOutput.substring(qmlImportsPathStart, endOfLine);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            char[] cArray = new char[]{'\"'};
            String string7 = StringsKt.trimStart((String)string6, (char[])cArray);
            cArray = new char[]{'\"'};
            qmlPath = StringsKt.trimEnd((String)string7, (char[])cArray);
        }
        if (host.isWsl()) {
            CidrWSLHost wslHost = (CidrWSLHost)host;
            String string8 = wslHost.convertToLocal(qmlPath);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"convertToLocal(...)");
            qmlPath = string8;
            String string9 = wslHost.convertToLocal(binPath);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"convertToLocal(...)");
            binPath = string9;
        }
        if (qmlPath.length() < 2 || !FileUtil.exists((String)qmlPath)) {
            qmlPath = "";
        }
        if (binPath.length() < 2 || !FileUtil.exists((String)binPath)) {
            binPath = "";
        }
        if (((CharSequence)qmlPath).length() == 0 && ((CharSequence)binPath).length() == 0) {
            return null;
        }
        return new Pair((Object)PathUtil.toSystemIndependentName((String)qmlPath), (Object)PathUtil.toSystemIndependentName((String)binPath));
    }

    private final CMakeModelConfigurationData getMatchingModelConfig(CMakeProfileInfo profileInfo, List<CMakeModelConfigurationData> modelConfigs) {
        for (CMakeModelConfigurationData modelConfig : modelConfigs) {
            if (!Intrinsics.areEqual((Object)modelConfig.getConfigName(), (Object)profileInfo.getProfile().getName())) continue;
            return modelConfig;
        }
        return null;
    }

    private final void updateQtSettings(Project project) {
        if (project.isDisposed()) {
            return;
        }
        CMakeWorkspace cMakeWorkspace = CMakeWorkspace.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)cMakeWorkspace, (String)"getInstance(...)");
        CMakeWorkspace cmakeWorkspace = cMakeWorkspace;
        if (!cmakeWorkspace.isInitialized()) {
            return;
        }
        List list = cmakeWorkspace.getModelConfigurationData();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getModelConfigurationData(...)");
        List modelConfigs = list;
        Collection collection = cmakeWorkspace.getProfileInfos();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getProfileInfos(...)");
        List profileInfos = CollectionsKt.toList((Iterable)collection);
        Map nextProfileNameToPaths = new LinkedHashMap();
        Map pathsCache = new LinkedHashMap();
        for (CMakeProfileInfo profileInfo : profileInfos) {
            String cmakePrefix;
            if (profileInfo.getEnvironment() == null) continue;
            Intrinsics.checkNotNull((Object)profileInfo);
            CMakeModelConfigurationData cMakeModelConfigurationData = this.getMatchingModelConfig(profileInfo, modelConfigs);
            if (cMakeModelConfigurationData == null) continue;
            CMakeConfigurator cache = null;
            try {
                cache = cMakeModelConfigurationData.getCacheConfigurator();
            }
            catch (CMakeException cmakeEx) {
                continue;
            }
            CMakeVariable qt5 = cache.findVariable("Qt5_DIR");
            CMakeVariable qt6 = cache.findVariable("Qt6_DIR");
            if (qt5 == null && qt6 == null) continue;
            CMakeVariable cMakeVariable = qt5;
            if (cMakeVariable != null) {
                v4 = cMakeVariable.getValue();
            } else {
                CMakeVariable cMakeVariable2 = qt6;
                Intrinsics.checkNotNull((Object)cMakeVariable2);
                v4 = cmakePrefix = cMakeVariable2.getValue();
            }
            if (cmakePrefix == null) continue;
            cmakePrefix = PathUtil.getParentPath((String)cmakePrefix);
            Pair<String, String> paths = null;
            if (pathsCache.containsKey(cmakePrefix)) {
                paths = (Pair<String, String>)pathsCache.get(cmakePrefix);
            } else {
                paths = this.findQtPaths(cmakePrefix, profileInfo.getEnvironmentSafe(false), qt5 != null, qt6 != null);
                pathsCache.put(cmakePrefix, paths);
            }
            if (paths == null) continue;
            nextProfileNameToPaths.put(profileInfo.getProfile().getName(), paths);
        }
        QtSettings settings = QtSettings.getInstance(project);
        for (String string : settings.getProfilesList()) {
            Intrinsics.checkNotNull((Object)string);
            if (((CharSequence)string).length() == 0 || nextProfileNameToPaths.containsKey(string)) continue;
            settings.removeProfileSettings(string);
        }
        if (nextProfileNameToPaths.isEmpty()) {
            return;
        }
        for (Map.Entry entry : nextProfileNameToPaths.entrySet()) {
            settings.setProfileWithPaths((String)entry.getKey(), (String)((Pair)entry.getValue()).getFirst(), (String)((Pair)entry.getValue()).getSecond());
        }
        ApplicationManager.getApplication().runReadAction(() -> QtWorkspaceListenerActivity.updateQtSettings$lambda$1(project, settings));
    }

    private final void listenChanges(Project project) {
        MessageBusConnection connection = project.getMessageBus().connect();
        Topic topic = CMakeWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new CMakeWorkspaceListener(this, project){
            final /* synthetic */ QtWorkspaceListenerActivity this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
            }

            public void reloadingFinished(boolean canceled) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> listenChanges.1.reloadingFinished$lambda$0(this.this$0, this.$project));
            }

            private static final void reloadingFinished$lambda$0(QtWorkspaceListenerActivity this$0, Project $project) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                QtWorkspaceListenerActivity.access$updateQtSettings(this$0, $project);
            }
        });
        Topic topic2 = OCWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new OCWorkspaceListener(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void selectedResolveConfigurationChanged() {
                ApplicationManager.getApplication().executeOnPooledThread(() -> listenChanges.2.selectedResolveConfigurationChanged$lambda$1(this.$project));
            }

            private static final void selectedResolveConfigurationChanged$lambda$1$lambda$0(CMakeBuildProfileExecutionTarget $currentBuildProfile, QtSettings $settings) {
                if ($currentBuildProfile != null && $settings.getProfilesList().contains($currentBuildProfile.getProfileName())) {
                    $settings.setCurrentProfile($currentBuildProfile.getProfileName());
                } else {
                    $settings.setCurrentProfile("");
                }
            }

            private static final void selectedResolveConfigurationChanged$lambda$1(Project $project) {
                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                QtSettings settings = QtSettings.getInstance($project);
                CMakeBuildProfileExecutionTarget currentBuildProfile = CMakeAppRunConfiguration.getSelectedBuildProfile((Project)$project);
                ApplicationManager.getApplication().runReadAction(() -> listenChanges.2.selectedResolveConfigurationChanged$lambda$1$lambda$0(currentBuildProfile, settings));
            }
        });
    }

    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> QtWorkspaceListenerActivity.execute$lambda$2(this, project));
        this.listenChanges(project);
        return Unit.INSTANCE;
    }

    private static final void updateQtSettings$lambda$1(Project $project, QtSettings $settings) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        CMakeBuildProfileExecutionTarget currentBuildProfile = CMakeAppRunConfiguration.getSelectedBuildProfile((Project)$project);
        if (currentBuildProfile != null) {
            $settings.setCurrentProfile(currentBuildProfile.getProfileName());
        } else {
            $settings.setCurrentProfile("");
        }
    }

    private static final void execute$lambda$2(QtWorkspaceListenerActivity this$0, Project $project) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        this$0.updateQtSettings($project);
    }

    public static final /* synthetic */ void access$updateQtSettings(QtWorkspaceListenerActivity $this, Project project) {
        $this.updateQtSettings(project);
    }
}

