/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JCEFHtmlPanel;
import com.intellij.util.ApplicationKt;
import com.intellij.util.SlowOperations;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.handler.CefResourceRequestHandlerAdapter;
import org.cef.misc.BoolRef;
import org.cef.network.CefRequest;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownConfigurableExtension;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.ui.actions.ChangeFontSizeActionKt;
import org.intellij.plugins.markdown.ui.preview.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelEx;
import org.intellij.plugins.markdown.ui.preview.PreviewStaticServer;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.jcef.impl.FileSchemeResourcesProcessor;
import org.intellij.plugins.markdown.ui.preview.jcef.impl.IncrementalDOMBuilder;
import org.intellij.plugins.markdown.ui.preview.jcef.impl.JcefBrowserPipeImpl;
import org.intellij.plugins.markdown.ui.preview.jcef.impl.JcefUtilKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u0000 P2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003PQRB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020$H\u0016J\b\u0010-\u001a\u00020\rH\u0002J\b\u0010.\u001a\u00020+H\u0016J\b\u0010/\u001a\u000200H\u0017J\n\u00101\u001a\u0004\u0018\u00010\u0006H\u0017JD\u00102\u001a\t\u0018\u0001H3\u00a2\u0006\u0002\b4\"\u0010\b\u0000\u00103*\n 6*\u0004\u0018\u000105052\u001b\b\u0001\u00107\u001a\u0015\u0012\f\u0012\n 6*\u0004\u0018\u0001H3H308\u00a2\u0006\u0002\b9H\u0097\u0001\u00a2\u0006\u0002\u0010:J\n\u0010;\u001a\u0004\u0018\u00010\bH\u0017J\b\u0010<\u001a\u00020+H\u0002JN\u0010=\u001a\u00020+\"\u0010\b\u0000\u00103*\n 6*\u0004\u0018\u000105052\u001b\b\u0001\u00107\u001a\u0015\u0012\f\u0012\n 6*\u0004\u0018\u0001H3H308\u00a2\u0006\u0002\b92\u000f\b\u0001\u0010>\u001a\t\u0018\u0001H3\u00a2\u0006\u0002\b4H\u0096\u0001\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020+H\u0002J\u0010\u0010A\u001a\u00020+2\u0006\u0010B\u001a\u00020CH\u0016J\u0012\u0010D\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010$H\u0016J\u0018\u0010E\u001a\u00020+2\u0006\u0010F\u001a\u00020C2\u0006\u0010G\u001a\u00020CH\u0016J\u0018\u0010H\u001a\u00020+2\u0006\u0010B\u001a\u00020C2\u0006\u0010I\u001a\u00020\u0017H\u0016J\"\u0010J\u001a\u00020+2\u0006\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020C2\b\u0010M\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010N\u001a\u00020+2\u0006\u0010O\u001a\u00020\r2\u0006\u0010L\u001a\u00020CH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001b\u001a\u00060\u001cR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001e\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010!R\u0014\u0010(\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000f\u00a8\u0006S"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;", "Lcom/intellij/ui/jcef/JCEFHtmlPanel;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanelEx;", "Lcom/intellij/openapi/util/UserDataHolder;", "()V", "_project", "Lcom/intellij/openapi/project/Project;", "_virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "browserPipe", "Lorg/intellij/plugins/markdown/ui/preview/jcef/impl/JcefBrowserPipeImpl;", "contentSecurityPolicy", "", "getContentSecurityPolicy", "()Ljava/lang/String;", "currentExtensions", "", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "delayedContent", "fileSchemeResourcesProcessor", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "firstUpdate", "", "pageBaseName", "previousRenderClosure", "projectRoot", "resourceProvider", "Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$MyAggregatingResourceProvider;", "scriptingLines", "getScriptingLines", "scripts", "getScripts", "()Ljava/util/List;", "scrollListeners", "Ljava/util/ArrayList;", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel$ScrollListener;", "Lkotlin/collections/ArrayList;", "styles", "getStyles", "stylesLines", "getStylesLines", "addScrollListener", "", "listener", "buildIndexContent", "dispose", "getBrowserPipe", "Lorg/intellij/plugins/markdown/ui/preview/BrowserPipe;", "getProject", "getUserData", "T", "Lorg/jetbrains/annotations/Nullable;", "", "kotlin.jvm.PlatformType", "p0", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/annotations/NotNull;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "getVirtualFile", "loadIndexContent", "putUserData", "p1", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "reloadExtensions", "reloadWithOffset", "offset", "", "removeScrollListener", "scrollBy", "horizontalUnits", "verticalUnits", "scrollToMarkdownSrcOffset", "smooth", "setHtml", "html", "initialScrollOffset", "document", "updateDom", "renderClosure", "Companion", "MyAggregatingResourceProvider", "MyFilteringRequestHandler", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownJCEFHtmlPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownJCEFHtmlPanel.kt\norg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,322:1\n1855#2,2:323\n1603#2,9:325\n1855#2:334\n1856#2:336\n1612#2:337\n766#2:338\n857#2,2:339\n1360#2:341\n1446#2,5:342\n1360#2:347\n1446#2,5:348\n1549#2:353\n1620#2,3:354\n1549#2:357\n1620#2,3:358\n1855#2,2:361\n1#3:335\n11#4:363\n*S KotlinDebug\n*F\n+ 1 MarkdownJCEFHtmlPanel.kt\norg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel\n*L\n56#1:323,2\n58#1:325,9\n58#1:334\n58#1:336\n58#1:337\n59#1:338\n59#1:339,2\n64#1:341\n64#1:342,5\n67#1:347\n67#1:348,5\n80#1:353\n80#1:354,3\n81#1:357\n81#1:358,3\n119#1:361,2\n58#1:335\n300#1:363\n*E\n"})
public final class MarkdownJCEFHtmlPanel
extends JCEFHtmlPanel
implements MarkdownHtmlPanelEx,
UserDataHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project _project;
    @Nullable
    private final VirtualFile _virtualFile;
    private final /* synthetic */ UserDataHolderBase $$delegate_0;
    @NotNull
    private final String pageBaseName;
    @Nullable
    private VirtualFile projectRoot;
    @NotNull
    private final ResourceProvider fileSchemeResourcesProcessor;
    @NotNull
    private final MyAggregatingResourceProvider resourceProvider;
    @NotNull
    private final JcefBrowserPipeImpl browserPipe;
    @NotNull
    private final ArrayList<MarkdownHtmlPanel.ScrollListener> scrollListeners;
    @NotNull
    private List<? extends MarkdownBrowserPreviewExtension> currentExtensions;
    @Nullable
    private volatile String delayedContent;
    private boolean firstUpdate;
    @NotNull
    private String previousRenderClosure;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String SET_SCROLL_EVENT = "setScroll";
    @NotNull
    private static final List<String> baseScripts;
    @NotNull
    private static final List<String> baseStyles;

    public MarkdownJCEFHtmlPanel(@Nullable Project _project, @Nullable VirtualFile _virtualFile) {
        super(MarkdownJCEFHtmlPanel.Companion.isOffScreenRendering(), null, null);
        this._project = _project;
        this._virtualFile = _virtualFile;
        this.$$delegate_0 = new UserDataHolderBase();
        this.pageBaseName = "markdown-preview-index-" + this.hashCode() + ".html";
        this.resourceProvider = new MyAggregatingResourceProvider();
        this.browserPipe = new JcefBrowserPipeImpl((JBCefBrowserBase)this, CollectionsKt.listOf((Object)PreviewStaticServer.Companion.getStaticUrl(this.resourceProvider, this.pageBaseName)));
        this.scrollListeners = new ArrayList();
        this.currentExtensions = CollectionsKt.emptyList();
        this.firstUpdate = true;
        this.previousRenderClosure = "";
        if (this._virtualFile != null && this._project != null) {
            SlowOperations.allowSlowOperations(() -> MarkdownJCEFHtmlPanel._init_$lambda$6(this));
        }
        this.fileSchemeResourcesProcessor = new FileSchemeResourcesProcessor(this._virtualFile, this.projectRoot);
        Disposer.register((Disposable)this.browserPipe, () -> MarkdownJCEFHtmlPanel._init_$lambda$8(this));
        Disposer.register((Disposable)this, (Disposable)this.browserPipe);
        Disposer.register((Disposable)this, (Disposable)PreviewStaticServer.Companion.getInstance().registerResourceProvider(this.resourceProvider));
        Disposer.register((Disposable)this, (Disposable)PreviewStaticServer.Companion.getInstance().registerResourceProvider(this.fileSchemeResourcesProcessor));
        JBCefClient jBCefClient = this.getJBCefClient();
        Intrinsics.checkNotNullExpressionValue((Object)jBCefClient, (String)"getJBCefClient(...)");
        CefRequestHandler cefRequestHandler = (CefRequestHandler)new MyFilteringRequestHandler();
        CefBrowser cefBrowser = this.getCefBrowser();
        Intrinsics.checkNotNullExpressionValue((Object)cefBrowser, (String)"getCefBrowser(...)");
        JcefUtilKt.addRequestHandler(jBCefClient, cefRequestHandler, cefBrowser, this);
        this.browserPipe.subscribe("documentReady", new BrowserPipe.Handler(){

            @Override
            public boolean processMessageReceived(@NotNull String data) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    String string = delayedContent;
                    if (string == null) break block0;
                    String string2 = string;
                    MarkdownJCEFHtmlPanel markdownJCEFHtmlPanel = this;
                    String it = string2;
                    boolean bl = false;
                    markdownJCEFHtmlPanel.getCefBrowser().executeJavaScript(it, null, 0);
                    markdownJCEFHtmlPanel.delayedContent = null;
                }
                return false;
            }
        });
        this.browserPipe.subscribe(SET_SCROLL_EVENT, new BrowserPipe.Handler(){

            @Override
            public boolean processMessageReceived(@NotNull String data) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    Integer n = StringsKt.toIntOrNull((String)data);
                    if (n == null) break block1;
                    Integer n2 = n;
                    MarkdownJCEFHtmlPanel markdownJCEFHtmlPanel = this;
                    int offset = ((Number)n2).intValue();
                    boolean bl = false;
                    Iterable $this$forEach$iv = markdownJCEFHtmlPanel.scrollListeners;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        MarkdownHtmlPanel.ScrollListener it = (MarkdownHtmlPanel.ScrollListener)element$iv;
                        boolean bl2 = false;
                        it.onScroll(offset);
                    }
                }
                return false;
            }
        });
        MessageBusConnection connection = ApplicationKt.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(MarkdownPreviewSettings.ChangeListener.TOPIC, arg_0 -> MarkdownJCEFHtmlPanel._init_$lambda$9(this, arg_0));
        this.loadIndexContent();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> p0) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        return (T)this.$$delegate_0.getUserData(p0);
    }

    public <T> void putUserData(@NotNull Key<T> p0, @Nullable T p1) {
        Intrinsics.checkNotNullParameter(p0, (String)"p0");
        this.$$delegate_0.putUserData(p0, p1);
    }

    public MarkdownJCEFHtmlPanel() {
        this(null, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void reloadExtensions() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable $this$forEach$iv = this.currentExtensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable p0 = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)p0);
        }
        $this$forEach$iv = MarkdownBrowserPreviewExtension.Provider.Companion.getAll();
        MarkdownJCEFHtmlPanel markdownJCEFHtmlPanel = this;
        boolean $i$f$mapNotNull = false;
        Iterator iterator = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            MarkdownBrowserPreviewExtension it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            MarkdownBrowserPreviewExtension.Provider it = (MarkdownBrowserPreviewExtension.Provider)element$iv$iv;
            boolean bl2 = false;
            if (it.createBrowserExtension(this) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MarkdownBrowserPreviewExtension it = (MarkdownBrowserPreviewExtension)element$iv$iv;
            boolean bl = false;
            MarkdownConfigurableExtension markdownConfigurableExtension = it instanceof MarkdownConfigurableExtension ? (MarkdownConfigurableExtension)((Object)it) : null;
            if (!(markdownConfigurableExtension != null ? markdownConfigurableExtension.isEnabled() : true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        markdownJCEFHtmlPanel.currentExtensions = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getScripts() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = this.currentExtensions;
        Collection collection = baseScripts;
        boolean $i$f$flatMap = false;
        void var3_4 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MarkdownBrowserPreviewExtension it = (MarkdownBrowserPreviewExtension)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getScripts();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getStyles() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.currentExtensions;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MarkdownBrowserPreviewExtension it = (MarkdownBrowserPreviewExtension)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getStyles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String getScriptingLines() {
        return CollectionsKt.joinToString$default((Iterable)this.getScripts(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
            final /* synthetic */ MarkdownJCEFHtmlPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "<script src=\"" + PreviewStaticServer.Companion.getStaticUrl(MarkdownJCEFHtmlPanel.access$getResourceProvider$p(this.this$0), it) + "\"></script>";
            }
        }), (int)30, null);
    }

    private final String getStylesLines() {
        return CollectionsKt.joinToString$default((Iterable)this.getStyles(), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
            final /* synthetic */ MarkdownJCEFHtmlPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "<link rel=\"stylesheet\" href=\"" + PreviewStaticServer.Companion.getStaticUrl(MarkdownJCEFHtmlPanel.access$getResourceProvider$p(this.this$0), it) + "\"/>";
            }
        }), (int)30, null);
    }

    private final String getContentSecurityPolicy() {
        Collection<String> collection;
        String it;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = this.getScripts();
        PreviewStaticServer.Companion companion = PreviewStaticServer.Companion;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(PreviewStaticServer.Companion.getStaticUrl(this.resourceProvider, it));
        }
        $this$map$iv = this.getStyles();
        collection2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PreviewStaticServer.Companion.getStaticUrl(this.resourceProvider, it));
        }
        collection = (List)destination$iv$iv;
        return companion.createCSP((List<String>)collection2, (List<String>)collection);
    }

    private final String buildIndexContent() {
        return "\n      <!DOCTYPE html>\n      <html>\n        <head>\n          <title>IntelliJ Markdown Preview</title>\n          <meta http-equiv=\"Content-Security-Policy\" content=\"" + this.getContentSecurityPolicy() + "\"/>\n          <meta name=\"markdown-position-attribute-name\" content=\"" + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "\"/>\n          " + this.getScriptingLines() + "\n          " + this.getStylesLines() + "\n        </head>\n      </html>\n    ";
    }

    private final void loadIndexContent() {
        this.reloadExtensions();
        this.loadURL(PreviewStaticServer.Companion.getStaticUrl(this.resourceProvider, this.pageBaseName));
    }

    private final void updateDom(String renderClosure, int initialScrollOffset) {
        this.previousRenderClosure = renderClosure;
        Object scrollCode = this.firstUpdate ? "window.scrollController?.scrollTo(" + initialScrollOffset + ", true);" : "";
        String code = "\n      (function() {\n        const action = () => {\n          console.time(\"incremental-dom-patch\");\n          const render = " + this.previousRenderClosure + ";\n          // noinspection JSCheckFunctionSignatures\n          IncrementalDOM.patch(document.body, () => render());\n          " + (String)scrollCode + "\n          if (IncrementalDOM.notifications.afterPatchListeners) {\n            IncrementalDOM.notifications.afterPatchListeners.forEach(listener => listener());\n          }\n          console.timeEnd(\"incremental-dom-patch\");\n        };\n        if (document.readyState === \"loading\" || document.readyState === \"uninitialized\") {\n          document.addEventListener(\"DOMContentLoaded\", () => action(), { once: true });\n        } else {\n          action();\n        }\n      })();\n    ";
        this.delayedContent = code;
        JcefUtilKt.executeJavaScript((JBCefBrowser)this, code);
    }

    @Override
    public void setHtml(@NotNull String html2, int initialScrollOffset, @Nullable VirtualFile document) {
        Intrinsics.checkNotNullParameter((Object)html2, (String)"html");
        VirtualFile virtualFile = document;
        VirtualFile baseFile = virtualFile != null ? virtualFile.getParent() : null;
        IncrementalDOMBuilder builder = new IncrementalDOMBuilder(html2, baseFile, this.projectRoot, this.fileSchemeResourcesProcessor);
        this.updateDom(builder.generateRenderClosure(), initialScrollOffset);
        this.firstUpdate = false;
    }

    @Override
    public void reloadWithOffset(int offset) {
        this.delayedContent = null;
        this.firstUpdate = true;
        this.loadIndexContent();
        this.updateDom(this.previousRenderClosure, offset);
    }

    public void dispose() {
        for (MarkdownBrowserPreviewExtension markdownBrowserPreviewExtension : this.currentExtensions) {
            Disposer.dispose((Disposable)markdownBrowserPreviewExtension);
        }
        this.currentExtensions = CollectionsKt.emptyList();
        this.scrollListeners.clear();
        super.dispose();
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public BrowserPipe getBrowserPipe() {
        return this.browserPipe;
    }

    @Override
    @ApiStatus.Experimental
    @Nullable
    public Project getProject() {
        return this._project;
    }

    @Override
    @ApiStatus.Experimental
    @Nullable
    public VirtualFile getVirtualFile() {
        return this._virtualFile;
    }

    @Override
    public void addScrollListener(@NotNull MarkdownHtmlPanel.ScrollListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.scrollListeners.add(listener);
    }

    @Override
    public void removeScrollListener(@Nullable MarkdownHtmlPanel.ScrollListener listener) {
        TypeIntrinsics.asMutableCollection((Object)this.scrollListeners).remove(listener);
    }

    @Override
    public void scrollToMarkdownSrcOffset(int offset, boolean smooth) {
        JcefUtilKt.executeJavaScript((JBCefBrowser)this, "window.scrollController?.scrollTo(" + offset + ", " + smooth + ")");
    }

    @Override
    public void scrollBy(int horizontalUnits, int verticalUnits) {
        int horizontal = JBCefApp.normalizeScaledSize((int)horizontalUnits);
        int vertical = JBCefApp.normalizeScaledSize((int)verticalUnits);
        JcefUtilKt.executeJavaScript((JBCefBrowser)this, "window.scrollController?.scrollBy(" + horizontal + ", " + vertical + ")");
    }

    private static final void _init_$lambda$6(MarkdownJCEFHtmlPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.projectRoot = ProjectFileIndex.getInstance((Project)this$0._project).getContentRootForFile(this$0._virtualFile);
    }

    private static final void _init_$lambda$8(MarkdownJCEFHtmlPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = this$0.currentExtensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable p0 = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)p0);
        }
    }

    private static final void _init_$lambda$9(MarkdownJCEFHtmlPanel this$0, MarkdownPreviewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        ChangeFontSizeActionKt.changeFontSize(this$0, ((MarkdownPreviewSettings.State)settings.getState()).getFontSize());
    }

    public static final /* synthetic */ List access$getBaseScripts$cp() {
        return baseScripts;
    }

    public static final /* synthetic */ List access$getBaseStyles$cp() {
        return baseStyles;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MarkdownJCEFHtmlPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MarkdownJCEFHtmlPanel.logger = logger;
        Object[] objectArray = new String[]{"incremental-dom.min.js", "incremental-dom-additions.js", "BrowserPipe.js", "ScrollSync.js"};
        baseScripts = CollectionsKt.listOf((Object[])objectArray);
        baseStyles = CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$Companion;", "", "()V", "SET_SCROLL_EVENT", "", "baseScripts", "", "baseStyles", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isOffScreenRendering", "", "ProhibitingResourceRequestHandler", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isOffScreenRendering() {
            return Registry.is((String)"ide.browser.jcef.markdownView.osr.enabled");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$Companion$ProhibitingResourceRequestHandler;", "Lorg/cef/handler/CefResourceRequestHandlerAdapter;", "()V", "onBeforeResourceLoad", "", "browser", "Lorg/cef/browser/CefBrowser;", "frame", "Lorg/cef/browser/CefFrame;", "request", "Lorg/cef/network/CefRequest;", "intellij.markdown"})
        private static final class ProhibitingResourceRequestHandler
        extends CefResourceRequestHandlerAdapter {
            @NotNull
            public static final ProhibitingResourceRequestHandler INSTANCE = new ProhibitingResourceRequestHandler();

            private ProhibitingResourceRequestHandler() {
            }

            public boolean onBeforeResourceLoad(@Nullable CefBrowser browser, @Nullable CefFrame frame, @NotNull CefRequest request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                return true;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\b\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$MyAggregatingResourceProvider;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "(Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;)V", "internalResources", "", "", "canProvide", "", "resourceName", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nMarkdownJCEFHtmlPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownJCEFHtmlPanel.kt\norg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$MyAggregatingResourceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ResourceProvider.kt\norg/intellij/plugins/markdown/ui/preview/ResourceProvider$Companion\n*L\n1#1,322:1\n1747#2,3:323\n1549#2:328\n1620#2,3:329\n288#2,2:332\n106#3,2:326\n*S KotlinDebug\n*F\n+ 1 MarkdownJCEFHtmlPanel.kt\norg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$MyAggregatingResourceProvider\n*L\n236#1:323,3\n243#1:328\n243#1:329,3\n243#1:332,2\n242#1:326,2\n*E\n"})
    private final class MyAggregatingResourceProvider
    implements ResourceProvider {
        @NotNull
        private final List<String> internalResources = CollectionsKt.plus((Collection)MarkdownJCEFHtmlPanel.access$getBaseScripts$cp(), (Iterable)MarkdownJCEFHtmlPanel.access$getBaseStyles$cp());

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean canProvide(@NotNull String resourceName) {
            MarkdownBrowserPreviewExtension it;
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            if (this.internalResources.contains(resourceName)) return true;
            if (Intrinsics.areEqual((Object)resourceName, (Object)MarkdownJCEFHtmlPanel.this.pageBaseName)) return true;
            Iterable $this$any$iv = MarkdownJCEFHtmlPanel.this.currentExtensions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (MarkdownBrowserPreviewExtension)element$iv;
                boolean bl = false;
            } while (!it.getResourceProvider().canProvide(resourceName));
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
            ResourceProvider.Resource resource;
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            String string = resourceName;
            if (Intrinsics.areEqual((Object)string, (Object)MarkdownJCEFHtmlPanel.this.pageBaseName)) {
                String string2 = MarkdownJCEFHtmlPanel.this.buildIndexContent();
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                resource = new ResourceProvider.Resource(byArray, "text/html");
            } else if (this.internalResources.contains(string)) {
                ResourceProvider.Companion $this$iv = ResourceProvider.Companion;
                String contentType$iv = null;
                boolean $i$f$loadInternalResource = false;
                resource = $this$iv.loadInternalResource(MarkdownJCEFHtmlPanel.class, resourceName, contentType$iv);
            } else {
                Object v2;
                block6: {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = MarkdownJCEFHtmlPanel.this.currentExtensions;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        MarkdownBrowserPreviewExtension markdownBrowserPreviewExtension = (MarkdownBrowserPreviewExtension)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getResourceProvider());
                    }
                    Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ResourceProvider it = (ResourceProvider)element$iv;
                        boolean bl = false;
                        if (!it.canProvide(resourceName)) continue;
                        v2 = element$iv;
                        break block6;
                    }
                    v2 = null;
                }
                ResourceProvider resourceProvider = v2;
                resource = resourceProvider != null ? resourceProvider.loadResource(resourceName) : null;
            }
            return resource;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J0\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fH\u0016J(\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\fH\u0016\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$MyFilteringRequestHandler;", "Lorg/cef/handler/CefRequestHandlerAdapter;", "(Lorg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel;)V", "getResourceRequestHandler", "Lorg/cef/handler/CefResourceRequestHandler;", "browser", "Lorg/cef/browser/CefBrowser;", "frame", "Lorg/cef/browser/CefFrame;", "request", "Lorg/cef/network/CefRequest;", "isNavigation", "", "isDownload", "requestInitiator", "", "disableDefaultHandling", "Lorg/cef/misc/BoolRef;", "onBeforeBrowse", "user_gesture", "is_redirect", "onOpenURLFromTab", "target_url", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nMarkdownJCEFHtmlPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownJCEFHtmlPanel.kt\norg/intellij/plugins/markdown/ui/preview/jcef/MarkdownJCEFHtmlPanel$MyFilteringRequestHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
    private final class MyFilteringRequestHandler
    extends CefRequestHandlerAdapter {
        @Nullable
        public CefResourceRequestHandler getResourceRequestHandler(@Nullable CefBrowser browser, @Nullable CefFrame frame, @NotNull CefRequest request, boolean isNavigation, boolean isDownload, @Nullable String requestInitiator, @Nullable BoolRef disableDefaultHandling) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (Registry.is((String)"markdown.experimental.allow.external.requests", (boolean)true)) {
                return null;
            }
            Object object2 = this;
            try {
                MyFilteringRequestHandler $this$getResourceRequestHandler_u24lambda_u240 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)new URL(request.getURL()));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            URL uRL = (URL)(Result.isFailure-impl((Object)object2) ? null : object2);
            if (uRL == null) {
                return null;
            }
            URL url = uRL;
            if (!NetUtils.isLocalhost((String)url.getHost())) {
                return (CefResourceRequestHandler)Companion.ProhibitingResourceRequestHandler.INSTANCE;
            }
            return null;
        }

        public boolean onBeforeBrowse(@NotNull CefBrowser browser, @NotNull CefFrame frame, @NotNull CefRequest request, boolean user_gesture, boolean is_redirect) {
            Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (request.getResourceType() == CefRequest.ResourceType.RT_CSP_REPORT) {
                logger.warn(StringsKt.trimIndent((String)("\n          Detected a CSP violation on the preview page: " + MarkdownJCEFHtmlPanel.this.pageBaseName + "!\n          Current page url: " + browser.getURL() + "\n          Initiated by user gesture: " + user_gesture + "\n          Was redirect: " + is_redirect + "\n          Full request:\n          " + request + "\n        ")));
                return true;
            }
            String targetPageUrl = PreviewStaticServer.Companion.getStaticUrl(MarkdownJCEFHtmlPanel.this.resourceProvider, MarkdownJCEFHtmlPanel.this.pageBaseName);
            String requestedUrl = request.getURL();
            if (!Intrinsics.areEqual((Object)requestedUrl, (Object)targetPageUrl)) {
                logger.warn(StringsKt.trimIndent((String)("\n          Canceling request for an external page with url: " + requestedUrl + ".\n          Current page url: " + browser.getURL() + "\n          Target safe url: " + targetPageUrl + "\n        ")));
                return true;
            }
            return false;
        }

        public boolean onOpenURLFromTab(@NotNull CefBrowser browser, @NotNull CefFrame frame, @NotNull String target_url, boolean user_gesture) {
            Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Intrinsics.checkNotNullParameter((Object)target_url, (String)"target_url");
            logger.warn("Canceling navigation for url: " + target_url + " (user_gesture=" + user_gesture + ")");
            return true;
        }
    }
}

