/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.channels;

import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.schmizz.sshj.xfer.FileSystemFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/ssh/impl/sshj/channels/PatchedFileSystemFile;", "Lnet/schmizz/sshj/xfer/FileSystemFile;", "path", "", "(Ljava/lang/String;)V", "getTargetDirectory", "dirname", "getTargetFile", "filename", "intellij.platform.ssh"})
public final class PatchedFileSystemFile
extends FileSystemFile {
    public PatchedFileSystemFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(path);
    }

    @NotNull
    public FileSystemFile getTargetDirectory(@NotNull String dirname) {
        Intrinsics.checkNotNullParameter((Object)dirname, (String)"dirname");
        Path path = this.getFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        PathKt.createDirectories((Path)path);
        return this;
    }

    @NotNull
    public FileSystemFile getTargetFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        FileSystemFile f = this;
        if (!f.getFile().exists()) {
            File parentFile = f.getFile().getParentFile();
            if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
                throw new IOException("Failed to create directory: " + this);
            }
            if (!f.getFile().createNewFile()) {
                throw new IOException("Could not create: " + this.getFile());
            }
            return f;
        }
        if (f.isDirectory()) {
            FileSystemFile fileSystemFile = f.getChild(filename);
            Intrinsics.checkNotNullExpressionValue((Object)fileSystemFile, (String)"getChild(...)");
            f = fileSystemFile;
            if (f.isDirectory()) {
                throw new IOException("A directory by the same name already exists: " + f);
            }
            if (!f.getFile().createNewFile()) {
                throw new IOException("Could not create: " + this.getFile());
            }
        }
        return f;
    }
}

