/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.grazie.text.ProblemFilter;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.grazie.utils.Text;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/grazie/text/LiteralProblemFilter;", "Lcom/intellij/grazie/text/ProblemFilter;", "()V", "ignoredRules", "Lcom/intellij/grazie/text/RuleGroup;", "shouldIgnore", "", "problem", "Lcom/intellij/grazie/text/TextProblem;", "intellij.grazie.core"})
public final class LiteralProblemFilter
extends ProblemFilter {
    @NotNull
    private final RuleGroup ignoredRules = RuleGroup.LITERALS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldIgnore(@NotNull TextProblem problem) {
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        if (problem.getText().getDomain() != TextContent.TextDomain.LITERALS) return false;
        TextContent textContent = problem.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textContent, (String)"getText(...)");
        if (!Text.isSingleSentence(textContent)) return false;
        if (!problem.fitsGroup(this.ignoredRules)) return false;
        return true;
    }
}

