/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.collect;

import com.jgoodies.common.collect.ObservableList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class LinkedListModel<E>
extends LinkedList<E>
implements ObservableList<E> {
    private static final long serialVersionUID = 5753378113505707237L;
    private EventListenerList listenerList;

    public LinkedListModel() {
    }

    public LinkedListModel(Collection<? extends E> c2) {
        super(c2);
    }

    @Override
    public final void add(int index, E element) {
        super.add(index, element);
        this.fireIntervalAdded(index, index);
    }

    @Override
    public final boolean add(E e2) {
        int newIndex = this.size();
        super.add(e2);
        this.fireIntervalAdded(newIndex, newIndex);
        return true;
    }

    @Override
    public final boolean addAll(int index, Collection<? extends E> c2) {
        boolean changed = super.addAll(index, c2);
        if (changed) {
            int lastIndex = index + c2.size() - 1;
            this.fireIntervalAdded(index, lastIndex);
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        boolean modified = false;
        Iterator e2 = this.iterator();
        while (e2.hasNext()) {
            if (!c2.contains(e2.next())) continue;
            e2.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        boolean modified = false;
        Iterator e2 = this.iterator();
        while (e2.hasNext()) {
            if (c2.contains(e2.next())) continue;
            e2.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public final void addFirst(E e2) {
        super.addFirst(e2);
        this.fireIntervalAdded(0, 0);
    }

    @Override
    public final void addLast(E e2) {
        int newIndex = this.size();
        super.addLast(e2);
        this.fireIntervalAdded(newIndex, newIndex);
    }

    @Override
    public final void clear() {
        if (this.isEmpty()) {
            return;
        }
        int oldLastIndex = this.size() - 1;
        super.clear();
        this.fireIntervalRemoved(0, oldLastIndex);
    }

    @Override
    public final E remove(int index) {
        Object removedElement = super.remove(index);
        this.fireIntervalRemoved(index, index);
        return removedElement;
    }

    @Override
    public final boolean remove(Object o2) {
        int index = this.indexOf(o2);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public final E removeFirst() {
        Object first2 = super.removeFirst();
        this.fireIntervalRemoved(0, 0);
        return first2;
    }

    @Override
    public final E removeLast() {
        int lastIndex = this.size() - 1;
        Object last2 = super.removeLast();
        this.fireIntervalRemoved(lastIndex, lastIndex);
        return last2;
    }

    @Override
    protected final void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.fireIntervalRemoved(fromIndex, toIndex - 1);
    }

    @Override
    public final E set(int index, E element) {
        E previousElement = super.set(index, element);
        this.fireContentsChanged(index, index);
        return previousElement;
    }

    @Override
    public final ListIterator<E> listIterator(int index) {
        return new ReportingListIterator(super.listIterator(index));
    }

    @Override
    public final void addListDataListener(ListDataListener l2) {
        this.getEventListenerList().add(ListDataListener.class, l2);
    }

    @Override
    public final void removeListDataListener(ListDataListener l2) {
        this.getEventListenerList().remove(ListDataListener.class, l2);
    }

    @Override
    public final E getElementAt(int index) {
        return this.get(index);
    }

    @Override
    public final int getSize() {
        return this.size();
    }

    public final void fireContentsChanged(int index) {
        this.fireContentsChanged(index, index);
    }

    public final ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.getEventListenerList().getListeners(ListDataListener.class);
    }

    private void fireContentsChanged(int index0, int index1) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        ListDataEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ListDataListener.class) continue;
            if (e2 == null) {
                e2 = new ListDataEvent(this, 0, index0, index1);
            }
            ((ListDataListener)listeners[i2 + 1]).contentsChanged(e2);
        }
    }

    private void fireIntervalAdded(int index0, int index1) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        ListDataEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ListDataListener.class) continue;
            if (e2 == null) {
                e2 = new ListDataEvent(this, 1, index0, index1);
            }
            ((ListDataListener)listeners[i2 + 1]).intervalAdded(e2);
        }
    }

    private void fireIntervalRemoved(int index0, int index1) {
        Object[] listeners = this.getEventListenerList().getListenerList();
        ListDataEvent e2 = null;
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != ListDataListener.class) continue;
            if (e2 == null) {
                e2 = new ListDataEvent(this, 2, index0, index1);
            }
            ((ListDataListener)listeners[i2 + 1]).intervalRemoved(e2);
        }
    }

    private EventListenerList getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    private final class ReportingListIterator
    implements ListIterator<E> {
        private final ListIterator<E> delegate;
        private int lastReturnedIndex;

        ReportingListIterator(ListIterator<E> delegate) {
            this.delegate = delegate;
            this.lastReturnedIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            this.lastReturnedIndex = this.nextIndex();
            return this.delegate.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public E previous() {
            this.lastReturnedIndex = this.previousIndex();
            return this.delegate.previous();
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            int oldSize = LinkedListModel.this.size();
            this.delegate.remove();
            int newSize = LinkedListModel.this.size();
            if (newSize < oldSize) {
                LinkedListModel.this.fireIntervalRemoved(this.lastReturnedIndex, this.lastReturnedIndex);
            }
        }

        @Override
        public void set(E e2) {
            this.delegate.set(e2);
            LinkedListModel.this.fireContentsChanged(this.lastReturnedIndex);
        }

        @Override
        public void add(E e2) {
            this.delegate.add(e2);
            int newIndex = this.previousIndex();
            LinkedListModel.this.fireIntervalAdded(newIndex, newIndex);
            this.lastReturnedIndex = -1;
        }
    }
}

