/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.keyStorage;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOCancellationCallbackHolder;
import com.intellij.util.io.InputStreamOverPagedStorage;
import com.intellij.util.io.LimitedInputStream;
import com.intellij.util.io.PagedFileStorageWithRWLockedPageContent;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.NoDataException;
import com.intellij.util.io.pagecache.Page;
import com.intellij.util.io.pagecache.PagedStorage;
import com.intellij.util.io.pagecache.PagedStorageWithPageUnalignedAccess;
import com.intellij.util.io.pagecache.impl.PageContentLockingStrategy;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class AppendableStorageBackedByPagedStorageLockFree<Data>
implements AppendableObjectStorage<Data> {
    @VisibleForTesting
    @ApiStatus.Internal
    public static final int APPEND_BUFFER_SIZE = 4096;
    private static final ThreadLocal<DataStreamOverPagedStorage> TLOCAL_READ_STREAMS = ThreadLocal.withInitial(() -> new DataStreamOverPagedStorage());
    private final PagedStorage storage;
    private final ReentrantReadWriteLock storageLock;
    private int fileLength;
    @Nullable
    private AppendMemoryBuffer appendBuffer;
    @NotNull
    private final DataExternalizer<Data> dataDescriptor;
    private static final InputStream TOMBSTONE = new InputStream(){

        @Override
        public int read() {
            throw new IllegalStateException("should not happen");
        }
    };

    public AppendableStorageBackedByPagedStorageLockFree(@NotNull Path file2, @Nullable StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, @NotNull DataExternalizer<Data> dataDescriptor, @NotNull ReentrantReadWriteLock storageLock) throws IOException {
        if (file2 == null) {
            AppendableStorageBackedByPagedStorageLockFree.$$$reportNull$$$0(0);
        }
        if (dataDescriptor == null) {
            AppendableStorageBackedByPagedStorageLockFree.$$$reportNull$$$0(1);
        }
        if (storageLock == null) {
            AppendableStorageBackedByPagedStorageLockFree.$$$reportNull$$$0(2);
        }
        this.storageLock = storageLock;
        PagedFileStorageWithRWLockedPageContent storage2 = PagedFileStorageWithRWLockedPageContent.createWithDefaults(file2, lockContext, pageSize, false, new PageContentLockingStrategy.SharedLockLockingStrategy(this.storageLock));
        this.storage = valuesAreBufferAligned ? storage2 : new PagedStorageWithPageUnalignedAccess(storage2);
        this.dataDescriptor = dataDescriptor;
        this.fileLength = Math.toIntExact(this.storage.length());
    }

    @Override
    public void clear() throws IOException {
        this.storage.clear();
        this.fileLength = 0;
    }

    @Override
    public void lockRead() {
        this.storageLock.readLock().lock();
    }

    @Override
    public void unlockRead() {
        this.storageLock.readLock().unlock();
    }

    @Override
    public void lockWrite() {
        this.storageLock.writeLock().lock();
    }

    @Override
    public void unlockWrite() {
        this.storageLock.writeLock().unlock();
    }

    @Override
    public boolean isDirty() {
        return AppendMemoryBuffer.hasChanges(this.appendBuffer) || this.storage.isDirty();
    }

    private void flushAppendBuffer() throws IOException {
        if (AppendMemoryBuffer.hasChanges(this.appendBuffer)) {
            int bufferPosition = this.appendBuffer.getBufferPosition();
            this.storage.put(this.fileLength, this.appendBuffer.getAppendBuffer(), 0, bufferPosition);
            this.fileLength += bufferPosition;
            this.appendBuffer = this.appendBuffer.rewind(this.fileLength);
        }
    }

    @Override
    public void force() throws IOException {
        this.flushAppendBuffer();
        this.storage.force();
    }

    @Override
    public void close() throws IOException {
        try {
            ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
            throwableRunnableArray[0] = this::flushAppendBuffer;
            throwableRunnableArray[1] = this.storage::close;
            ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Failed to .close() appendable storage [" + this.storage.getFile() + "]"), throwableRunnableArray);
        }
        finally {
            TLOCAL_READ_STREAMS.remove();
        }
    }

    @Override
    public Data read(int valueId, boolean checkAccess) throws IOException {
        AppendMemoryBuffer buffer = this.appendBuffer;
        int offset = valueId;
        if (buffer != null && (long)offset >= (long)buffer.startingOffsetInFile) {
            AppendMemoryBuffer copyForRead = buffer.copy();
            int bufferOffset = offset - copyForRead.startingOffsetInFile;
            if (bufferOffset > copyForRead.bufferPosition) {
                throw new NoDataException("Requested address(=" + offset + ") points to un-existed data: " + this.appendBuffer);
            }
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(copyForRead.getAppendBuffer(), bufferOffset, copyForRead.getBufferPosition());
            return this.dataDescriptor.read(new DataInputStream(is));
        }
        if (offset >= this.fileLength) {
            throw new NoDataException("Requested address(=" + offset + ") points to un-existed data (file length: " + this.fileLength + ")");
        }
        DataStreamOverPagedStorage rs = TLOCAL_READ_STREAMS.get();
        rs.setup(this.storage, offset, this.fileLength);
        return this.dataDescriptor.read(rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAll(@NotNull AppendableObjectStorage.StorageObjectProcessor<? super Data> processor) throws IOException {
        int fileLengthLocal;
        if (processor == null) {
            AppendableStorageBackedByPagedStorageLockFree.$$$reportNull$$$0(3);
        }
        assert (this.storageLock.getReadLockCount() == 0) : "Read-lock must not be held";
        this.lockWrite();
        try {
            this.flushAppendBuffer();
            fileLengthLocal = this.fileLength;
            if (fileLengthLocal == 0) {
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            this.unlockWrite();
        }
        IOCancellationCallbackHolder.checkCancelled();
        return this.storage.readInputStream(is -> {
            LimitedInputStream lis = new LimitedInputStream(new BufferedInputStream((InputStream)is), fileLengthLocal){

                public int available() {
                    return this.remainingLimit();
                }
            };
            DataInputStream valuesStream = new DataInputStream((InputStream)lis);
            try {
                Data value;
                int offset;
                while (processor.process(offset = lis.getBytesRead(), (Data)(value = this.dataDescriptor.read(valuesStream)))) {
                }
                return false;
            }
            catch (EOFException eOFException) {
                return true;
            }
        });
    }

    @Override
    public int getCurrentLength() {
        return AppendMemoryBuffer.getBufferPosition(this.appendBuffer) + this.fileLength;
    }

    @Override
    public int append(Data value) throws IOException {
        BufferExposingByteArrayOutputStream bos = new BufferExposingByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        this.dataDescriptor.save(out, value);
        int size = bos.size();
        byte[] buffer = bos.getInternalBuffer();
        int currentLength = this.getCurrentLength();
        if (size > 4096) {
            this.flushAppendBuffer();
            this.storage.put(currentLength, buffer, 0, size);
            this.fileLength += size;
            if (this.appendBuffer != null) {
                this.appendBuffer = this.appendBuffer.rewind(this.fileLength);
            }
        } else {
            if (size > 4096 - AppendMemoryBuffer.getBufferPosition(this.appendBuffer)) {
                this.flushAppendBuffer();
            }
            if (this.appendBuffer == null) {
                this.appendBuffer = new AppendMemoryBuffer(this.fileLength);
            }
            this.appendBuffer.append(buffer, size);
        }
        return currentLength;
    }

    @Override
    public boolean checkBytesAreTheSame(int valueId, Data value) throws IOException {
        int offset = valueId;
        try (CheckerOutputStream comparer = this.buildOldComparerStream(offset);){
            DataOutputStream out = new DataOutputStream(comparer);
            this.dataDescriptor.save(out, value);
            boolean bl2 = comparer.same;
            return bl2;
        }
    }

    @NotNull
    private CheckerOutputStream buildOldComparerStream(final int startingOffsetInFile) throws IOException {
        if (this.fileLength <= startingOffsetInFile) {
            return new CheckerOutputStream(){
                private int address;
                {
                    this.address = startingOffsetInFile - AppendableStorageBackedByPagedStorageLockFree.this.fileLength;
                }

                @Override
                public void write(int b2) {
                    if (this.same) {
                        AppendMemoryBuffer buffer = AppendableStorageBackedByPagedStorageLockFree.this.appendBuffer;
                        this.same = this.address < AppendMemoryBuffer.getBufferPosition(buffer) && buffer.getAppendBuffer()[this.address++] == (byte)b2;
                    }
                }
            };
        }
        return new CheckerOutputStream(){
            private int offsetInFile;
            private int offsetInPage;
            private Page currentPage;
            private final int pageSize;
            {
                this.offsetInFile = startingOffsetInFile;
                this.offsetInPage = AppendableStorageBackedByPagedStorageLockFree.this.storage.toOffsetInPage(startingOffsetInFile);
                this.currentPage = AppendableStorageBackedByPagedStorageLockFree.this.storage.pageByOffset(startingOffsetInFile, false);
                this.pageSize = AppendableStorageBackedByPagedStorageLockFree.this.storage.getPageSize();
            }

            @Override
            public void write(int b2) throws IOException {
                if (this.same) {
                    if (this.pageSize == this.offsetInPage && this.offsetInFile < AppendableStorageBackedByPagedStorageLockFree.this.fileLength) {
                        this.offsetInFile += this.offsetInPage;
                        this.currentPage.close();
                        this.currentPage = AppendableStorageBackedByPagedStorageLockFree.this.storage.pageByOffset(this.offsetInFile, false);
                        this.offsetInPage = 0;
                    }
                    this.same = this.offsetInPage < AppendableStorageBackedByPagedStorageLockFree.this.fileLength && this.currentPage.get(this.offsetInPage) == (byte)b2;
                    ++this.offsetInPage;
                }
            }

            @Override
            public void close() {
                this.currentPage.close();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageLock";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/keyStorage/AppendableStorageBackedByPagedStorageLockFree";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class AppendMemoryBuffer {
        private final byte[] buffer;
        private int bufferPosition;
        private final int startingOffsetInFile;

        private AppendMemoryBuffer(int startingOffsetInFile) {
            this(new byte[4096], 0, startingOffsetInFile);
        }

        private AppendMemoryBuffer(byte[] buffer, int bufferPosition, int startingOffsetInFile) {
            this.buffer = buffer;
            this.startingOffsetInFile = startingOffsetInFile;
            this.bufferPosition = bufferPosition;
        }

        private byte[] getAppendBuffer() {
            return this.buffer;
        }

        private int getBufferPosition() {
            return this.bufferPosition;
        }

        public void append(byte[] buffer, int size) {
            System.arraycopy(buffer, 0, this.buffer, this.bufferPosition, size);
            this.bufferPosition += size;
        }

        @NotNull
        public AppendMemoryBuffer copy() {
            return new AppendMemoryBuffer((byte[])this.buffer.clone(), this.bufferPosition, this.startingOffsetInFile);
        }

        @NotNull
        public AppendMemoryBuffer rewind(int offsetInFile) {
            return new AppendMemoryBuffer(this.buffer, 0, offsetInFile);
        }

        public String toString() {
            return "AppendMemoryBuffer[" + this.startingOffsetInFile + ".." + (this.startingOffsetInFile + this.bufferPosition) + "]";
        }

        private static int getBufferPosition(@Nullable AppendMemoryBuffer buffer) {
            return buffer != null ? buffer.bufferPosition : 0;
        }

        private static boolean hasChanges(@Nullable AppendMemoryBuffer buffer) {
            return buffer != null && buffer.getBufferPosition() > 0;
        }
    }

    private static final class DataStreamOverPagedStorage
    extends DataInputStream {
        private DataStreamOverPagedStorage() {
            super(new BufferedInputStreamOverPagedStorage());
        }

        void setup(PagedStorage storage2, long pos, long limit2) {
            ((BufferedInputStreamOverPagedStorage)this.in).setup(storage2, pos, limit2);
        }
    }

    private static abstract class CheckerOutputStream
    extends OutputStream {
        boolean same = true;

        private CheckerOutputStream() {
        }
    }

    private static final class BufferedInputStreamOverPagedStorage
    extends BufferedInputStream {
        BufferedInputStreamOverPagedStorage() {
            super(TOMBSTONE, 512);
        }

        /*
         * WARNING - void declaration
         */
        void setup(@NotNull PagedStorage storage2, long position, long l2) {
            void limit2;
            if (storage2 == null) {
                BufferedInputStreamOverPagedStorage.$$$reportNull$$$0(0);
            }
            this.pos = 0;
            this.count = 0;
            this.in = new InputStreamOverPagedStorage(storage2, position, (long)limit2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/util/io/keyStorage/AppendableStorageBackedByPagedStorageLockFree$BufferedInputStreamOverPagedStorage", "setup"));
        }
    }
}

