/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.RefValueHashMapUtil;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ConcurrentRefHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
HashingStrategy<K> {
    final ReferenceQueue<K> myReferenceQueue = new ReferenceQueue();
    private final ConcurrentMap<KeyReference<K>, V> myMap;
    @NotNull
    private final HashingStrategy<? super K> myHashingStrategy;
    static final float LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CAPACITY = 16;
    static final int DEFAULT_CONCURRENCY_LEVEL = Math.min(Runtime.getRuntime().availableProcessors(), 4);
    private final BiConsumer<? super ConcurrentMap<K, V>, ? super V> myEvictionListener;
    private static final HashingStrategy<?> THIS = new HashingStrategy<Object>(){

        @Override
        public int hashCode(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o1, Object o2) {
            throw new UnsupportedOperationException();
        }
    };
    private static final ThreadLocal<HardKey<?>> HARD_KEY = ThreadLocal.withInitial(() -> new HardKey());
    private Set<Map.Entry<K, V>> entrySet;

    ConcurrentRefHashMap(@Nullable BiConsumer<? super ConcurrentMap<K, V>, ? super V> evictionListener) {
        this.myHashingStrategy = this;
        this.myMap = new ConcurrentHashMap<KeyReference<K>, V>(16, 0.75f, DEFAULT_CONCURRENCY_LEVEL);
        this.myEvictionListener = evictionListener;
    }

    ConcurrentRefHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @Nullable HashingStrategy<? super K> hashingStrategy) {
        this.myHashingStrategy = hashingStrategy == THIS ? this : (hashingStrategy == null ? HashingStrategy.canonical() : hashingStrategy);
        this.myMap = new ConcurrentHashMap<KeyReference<K>, V>(initialCapacity, loadFactor, concurrencyLevel);
        this.myEvictionListener = null;
    }

    @NotNull
    abstract KeyReference<K> createKeyReference(@NotNull K var1, @NotNull HashingStrategy<? super K> var2);

    @NotNull
    private KeyReference<K> createKeyReference(@NotNull K key) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(0);
        }
        KeyReference<? super K> keyReference = this.createKeyReference(key, this.myHashingStrategy);
        if (keyReference == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(1);
        }
        return keyReference;
    }

    private boolean processQueue() {
        KeyReference wk;
        boolean processed = false;
        while ((wk = (KeyReference)((Object)this.myReferenceQueue.poll())) != null) {
            Object v2 = this.myMap.remove(wk);
            if (this.myEvictionListener != null) {
                this.myEvictionListener.accept(this, v2);
            }
            processed = true;
        }
        return processed;
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty() || this.entrySet().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(@NotNull Object key) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(2);
        }
        if (this.myMap.isEmpty()) {
            return false;
        }
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            boolean bl2 = this.myMap.containsKey(hardKey);
            return bl2;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    @NotNull
    private HardKey<K> createHardKey(@NotNull Object o2) {
        if (o2 == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(3);
        }
        Object key = o2;
        HardKey<?> hardKey = HARD_KEY.get();
        hardKey.setKey(key, this.myHashingStrategy.hashCode(key));
        HardKey<?> hardKey2 = hardKey;
        if (hardKey2 == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(4);
        }
        return hardKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(5);
        }
        if (this.myMap.isEmpty()) {
            return null;
        }
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            Object v2 = this.myMap.get(hardKey);
            return v2;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public V put(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(6);
        }
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(7);
        }
        KeyReference<K> weakKey = this.createKeyReference(key);
        V prev = this.myMap.put(weakKey, value);
        this.processQueue();
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(8);
        }
        HardKey<K> hardKey = this.createHardKey(key);
        try {
            Object v2 = this.myMap.remove(hardKey);
            return v2;
        }
        finally {
            this.processQueue();
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        if (es == null) {
            this.entrySet = es = new EntrySet();
        }
        EntrySet entrySet = es;
        if (entrySet == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(9);
        }
        return entrySet;
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(10);
        }
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(11);
        }
        V prev = this.myMap.putIfAbsent(this.createKeyReference(key), value);
        this.processQueue();
        return prev;
    }

    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(12);
        }
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(13);
        }
        boolean removed = this.myMap.remove(this.createKeyReference(key), value);
        this.processQueue();
        return removed;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(14);
        }
        if (oldValue == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(15);
        }
        if (newValue == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(16);
        }
        boolean replaced = this.myMap.replace(this.createKeyReference(key), oldValue, newValue);
        this.processQueue();
        return replaced;
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(17);
        }
        if (value == null) {
            ConcurrentRefHashMap.$$$reportNull$$$0(18);
        }
        V replaced = this.myMap.replace(this.createKeyReference(key), value);
        this.processQueue();
        return replaced;
    }

    @Override
    public int hashCode(@Nullable K object) {
        int h2 = object == null ? 0 : object.hashCode();
        h2 += ~(h2 << 9);
        h2 ^= h2 >>> 14;
        h2 += h2 << 4;
        h2 ^= h2 >>> 10;
        return h2;
    }

    @Override
    public boolean equals(K o1, K o2) {
        return Objects.equals(o1, o2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentRefHashMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: 
            case 11: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentRefHashMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createHardKey";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createKeyReference";
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createHardKey";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HardKey<K>
    implements KeyReference<K> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        void setKey(K key, int hash) {
            this.myKey = key;
            this.myHash = hash;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        @Override
        public boolean equals(Object o2) {
            return o2.equals(this);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        private void clear() {
            this.setKey(null, 0);
        }
    }

    @FunctionalInterface
    static interface KeyReference<K> {
        public K get();

        public boolean equals(Object var1);

        public int hashCode();
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<KeyReference<K>, V>> hashEntrySet;

        private EntrySet() {
            this.hashEntrySet = ConcurrentRefHashMap.this.myMap.entrySet();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<Map.Entry<KeyReference<K>, V>> hashIterator;
                private RefEntry<K, V> next;
                {
                    this.hashIterator = EntrySet.this.hashEntrySet.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        KeyReference wk = ent.getKey();
                        Object k2 = null;
                        if (wk != null) {
                            Object k3 = wk.get();
                            k2 = k3;
                            if (k3 == null) continue;
                        }
                        this.next = new RefEntry(ent, k2);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    RefEntry e2 = this.next;
                    this.next = null;
                    return e2;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            for (Map.Entry ent : this.hashEntrySet) {
                KeyReference wk = ent.getKey();
                if (wk != null && wk.get() == null) continue;
                return false;
            }
            return true;
        }

        @Override
        public int size() {
            int j2 = 0;
            Iterator i2 = this.iterator();
            while (i2.hasNext()) {
                ++j2;
                i2.next();
            }
            return j2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o2) {
            boolean toRemove;
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            Object ev = e2.getValue();
            HardKey key = ConcurrentRefHashMap.this.createHardKey(e2.getKey());
            try {
                Object hv = ConcurrentRefHashMap.this.myMap.get(key);
                boolean bl2 = hv == null ? ev == null && ConcurrentRefHashMap.this.myMap.containsKey(key) : (toRemove = hv.equals(ev));
                if (toRemove) {
                    ConcurrentRefHashMap.this.myMap.remove(key);
                }
            }
            finally {
                key.clear();
            }
            ConcurrentRefHashMap.this.processQueue();
            return toRemove;
        }

        @Override
        public int hashCode() {
            int h2 = 0;
            for (Map.Entry entry : this.hashEntrySet) {
                Object v2;
                KeyReference wk = entry.getKey();
                if (wk == null) continue;
                h2 += wk.hashCode() ^ ((v2 = entry.getValue()) == null ? 0 : v2.hashCode());
            }
            return h2;
        }
    }

    private static final class RefEntry<K, V>
    implements Map.Entry<K, V> {
        private final Map.Entry<?, V> ent;
        private final K key;

        RefEntry(@NotNull Map.Entry<?, V> ent, @Nullable K key) {
            if (ent == null) {
                RefEntry.$$$reportNull$$$0(0);
            }
            this.ent = ent;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.ent.getValue();
        }

        @Override
        public V setValue(@NotNull V value) {
            if (value == null) {
                RefEntry.$$$reportNull$$$0(1);
            }
            return this.ent.setValue(value);
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return Objects.equals(this.key, e2.getKey()) && Objects.equals(this.getValue(), e2.getValue());
        }

        @Override
        public int hashCode() {
            V v2 = this.getValue();
            return (this.key == null ? 0 : this.key.hashCode()) ^ (v2 == null ? 0 : v2.hashCode());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/containers/ConcurrentRefHashMap$RefEntry";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

