/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Random;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class CommandLineWrapperUtil {
    public static final String CLASSPATH_JAR_FILE_NAME_PREFIX = "classpath";

    @NotNull
    public static File createClasspathJarFile(@NotNull Manifest manifest, @NotNull List<String> pathList) throws IOException {
        if (manifest == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(0);
        }
        if (pathList == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(1);
        }
        File file2 = FileUtil.createTempFile(CLASSPATH_JAR_FILE_NAME_PREFIX + Math.abs(new Random().nextInt(Integer.MAX_VALUE)), ".jar", true);
        CommandLineWrapperUtil.fillClasspathJarFile(manifest, pathList, false, file2);
        File file3 = file2;
        if (file3 == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(2);
        }
        return file3;
    }

    public static void fillClasspathJarFile(Manifest manifest, List<String> pathList, boolean notEscape, @NotNull File outputJar) throws IOException {
        if (outputJar == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(3);
        }
        StringBuilder classPath = new StringBuilder();
        for (String path : pathList) {
            if (classPath.length() > 0) {
                classPath.append(' ');
            }
            File classpathElement = new File(path);
            String url = (notEscape ? classpathElement.toURL() : classpathElement.toURI().toURL()).toString();
            classPath.append(url);
        }
        CommandLineWrapperUtil.fillClasspathJarFile(manifest, classPath.toString(), outputJar);
    }

    public static void fillClasspathJarFile(Manifest manifest, String classPath, @NotNull File outputJar) throws IOException {
        if (outputJar == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(4);
        }
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPath);
        new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(outputJar)), manifest).close();
    }

    @NotNull
    public static File createArgumentFile(@NotNull List<String> args2, @NotNull Charset cs) throws IOException {
        if (args2 == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(5);
        }
        if (cs == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(6);
        }
        File argFile = FileUtil.createTempFile("idea_arg_file" + new Random().nextInt(Integer.MAX_VALUE), null, true);
        CommandLineWrapperUtil.writeArgumentsFile(argFile, args2, cs);
        File file2 = argFile;
        if (file2 == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(7);
        }
        return file2;
    }

    public static void writeArgumentsFile(@NotNull File argFile, @NotNull List<String> args2, @NotNull Charset cs) throws IOException {
        if (argFile == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(8);
        }
        if (args2 == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(9);
        }
        if (cs == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(10);
        }
        CommandLineWrapperUtil.writeArgumentsFile(argFile, args2, System.lineSeparator(), cs);
    }

    public static void writeArgumentsFile(@NotNull File argFile, @NotNull List<String> args2, String lineSeparator, @NotNull Charset cs) throws IOException {
        if (argFile == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(11);
        }
        if (args2 == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(12);
        }
        if (cs == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(13);
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(argFile), cs));){
            for (String arg2 : args2) {
                writer.write(CommandLineWrapperUtil.quoteArg(arg2));
                writer.write(lineSeparator);
            }
        }
    }

    private static String quoteArg(String arg2) {
        String specials = " #'\"\n\r\t\f";
        if (!StringUtil.containsAnyChar(arg2, specials)) {
            return arg2;
        }
        @NonNls StringBuilder sb = new StringBuilder(arg2.length() * 2);
        for (int i2 = 0; i2 < arg2.length(); ++i2) {
            char c2 = arg2.charAt(i2);
            if (c2 == ' ' || c2 == '#' || c2 == '\'') {
                sb.append('\"').append(c2).append('\"');
                continue;
            }
            if (c2 == '\"') {
                sb.append("\"\\\"\"");
                continue;
            }
            if (c2 == '\n') {
                sb.append("\"\\n\"");
                continue;
            }
            if (c2 == '\r') {
                sb.append("\"\\r\"");
                continue;
            }
            if (c2 == '\t') {
                sb.append("\"\\t\"");
                continue;
            }
            if (c2 == '\f') {
                sb.append("\"\\f\"");
                continue;
            }
            sb.append(c2);
        }
        return sb.toString();
    }

    @NotNull
    public static File createWrapperFile(@NotNull List<String> classpath, @NotNull Charset cs) throws IOException {
        if (classpath == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(14);
        }
        if (cs == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(15);
        }
        File file2 = FileUtil.createTempFile(CLASSPATH_JAR_FILE_NAME_PREFIX + new Random().nextInt(Integer.MAX_VALUE), null, true);
        CommandLineWrapperUtil.writeWrapperFile(file2, classpath, System.lineSeparator(), cs);
        File file3 = file2;
        if (file3 == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(16);
        }
        return file3;
    }

    public static void writeWrapperFile(@NotNull File wrapperFile, @NotNull List<String> classpath, @NotNull String lineSeparator, @NotNull Charset cs) throws IOException {
        if (wrapperFile == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(17);
        }
        if (classpath == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(18);
        }
        if (lineSeparator == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(19);
        }
        if (cs == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(20);
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(wrapperFile), cs));){
            for (String path : classpath) {
                writer.write(path);
                writer.write(lineSeparator);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifest";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathList";
                break;
            }
            case 2: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/CommandLineWrapperUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputJar";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argFile";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = CLASSPATH_JAR_FILE_NAME_PREFIX;
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapperFile";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineSeparator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/CommandLineWrapperUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createClasspathJarFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createArgumentFile";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createWrapperFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createClasspathJarFile";
                break;
            }
            case 2: 
            case 7: 
            case 16: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fillClasspathJarFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createArgumentFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeArgumentsFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createWrapperFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "writeWrapperFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 7: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

