/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.toolbar;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.ide.ui.customization.ToolbarQuickActionInsertStrategiesKt;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.wm.impl.ExpandableComboAction;
import com.intellij.openapi.wm.impl.ToolbarComboButton;
import com.intellij.ui.util.UiSizeUtilKt;
import git4idea.GitVcs;
import git4idea.branch.GitBranchSyncStatus;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitCurrentBranchPresenter;
import git4idea.ui.branch.popup.GitBranchesTreePopup;
import git4idea.ui.toolbar.GitToolbarActions;
import git4idea.ui.toolbar.GitToolbarWidgetActionKt;
import icons.DvcsImplIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0002\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction;", "Lcom/intellij/openapi/wm/impl/ExpandableComboAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionsWithIncomingOutgoingEnabled", "", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "updateCustomComponent", "component", "Companion", "GitWidgetState", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitToolbarWidgetAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitToolbarWidgetAction.kt\ngit4idea/ui/toolbar/GitToolbarWidgetAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
public final class GitToolbarWidgetAction
extends ExpandableComboAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean actionsWithIncomingOutgoingEnabled = GitToolbarActions.INSTANCE.isEnabledAndVisible$intellij_vcs_git();
    public static final int BRANCH_NAME_MAX_LENGTH = 80;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Nullable
    public JBPopup createPopup(@NotNull AnActionEvent event) {
        JBPopup jBPopup;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        GitRepository repository = (GitRepository)event.getPresentation().getClientProperty(GitToolbarWidgetActionKt.access$getREPOSITORY_KEY$p());
        if (repository != null) {
            jBPopup = GitBranchesTreePopup.Companion.create(project2, repository);
        } else {
            ActionGroup actionGroup;
            GitToolbarWidgetAction.Companion.updatePlaceholder(project2, null);
            if (TrustedProjects.isTrusted((Project)project2)) {
                AnAction anAction = ActionManager.getInstance().getAction("Vcs.ToolbarWidget.CreateRepository");
                Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
                actionGroup = (ActionGroup)anAction;
            } else {
                Separator separator = new Separator(GitBundle.message("action.main.toolbar.git.project.not.trusted.separator.text", new Object[0]));
                AnAction trustProjectAction = ActionManager.getInstance().getAction("ShowTrustProjectDialog");
                AnAction[] anActionArray = new AnAction[]{separator, trustProjectAction};
                actionGroup = (ActionGroup)new DefaultActionGroup(anActionArray);
            }
            ActionGroup group = actionGroup;
            String string = ActionPlaces.getPopupPlace((String)"Vcs.Toolbar.Widget");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPopupPlace(...)");
            String place = string;
            ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, group, event.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true, place);
            Intrinsics.checkNotNull((Object)listPopup);
            jBPopup = (JBPopup)listPopup;
        }
        JBPopup popup2 = jBPopup;
        return popup2;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        JComponent jComponent;
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        JComponent $this$createCustomComponent_u24lambda_u240 = jComponent = super.createCustomComponent(presentation2, place);
        boolean bl = false;
        UiSizeUtilKt.setMaximumWidth((JComponent)$this$createCustomComponent_u24lambda_u240, (int)Integer.MAX_VALUE);
        return jComponent;
    }

    public void updateCustomComponent(@NotNull JComponent component2, @NotNull Presentation presentation2) {
        boolean showOutgoing;
        boolean showIncoming;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        ToolbarComboButton toolbarComboButton = component2 instanceof ToolbarComboButton ? (ToolbarComboButton)component2 : null;
        if (toolbarComboButton == null) {
            return;
        }
        ToolbarComboButton widget = toolbarComboButton;
        widget.setText(presentation2.getText());
        widget.setToolTipText(presentation2.getDescription());
        widget.setLeftIcons(CollectionsKt.listOfNotNull((Object)presentation2.getIcon()));
        CustomActionsSchema schema = CustomActionsSchema.Companion.getInstance();
        List rightIcons = new ArrayList();
        GitBranchSyncStatus syncStatus = (GitBranchSyncStatus)presentation2.getClientProperty(GitToolbarWidgetActionKt.access$getSYNC_STATUS_KEY$p());
        boolean bl = showIncoming = !this.actionsWithIncomingOutgoingEnabled || !ToolbarQuickActionInsertStrategiesKt.groupContainsAction((String)"MainToolbarNewUI", (String)"main.toolbar.git.update.project", (CustomActionsSchema)schema);
        if (showIncoming) {
            GitBranchSyncStatus gitBranchSyncStatus = syncStatus;
            boolean bl2 = gitBranchSyncStatus != null ? gitBranchSyncStatus.getIncoming() : false;
            if (bl2) {
                Icon icon = DvcsImplIcons.Incoming;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Incoming");
                rightIcons.add(icon);
            }
        }
        boolean bl3 = showOutgoing = !this.actionsWithIncomingOutgoingEnabled || !ToolbarQuickActionInsertStrategiesKt.groupContainsAction((String)"MainToolbarNewUI", (String)"main.toolbar.git.push", (CustomActionsSchema)schema);
        if (showOutgoing) {
            GitBranchSyncStatus gitBranchSyncStatus = syncStatus;
            boolean bl4 = gitBranchSyncStatus != null ? gitBranchSyncStatus.getOutgoing() : false;
            if (bl4) {
                Icon icon = DvcsImplIcons.Outgoing;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Outgoing");
                rightIcons.add(icon);
            }
        }
        widget.setRightIcons(rightIcons);
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GitRepository gitRepository = GitBranchUtil.guessWidgetRepository(project, e.getDataContext());
        GitWidgetState state2 = Companion.getWidgetState(project, gitRepository);
        if (gitRepository != null && !Intrinsics.areEqual((Object)gitRepository, (Object)e.getPresentation().getClientProperty(GitToolbarWidgetActionKt.access$getREPOSITORY_KEY$p()))) {
            GitVcsSettings.getInstance(project).setRecentRoot(gitRepository.getRoot().getPath());
        }
        e.getPresentation().putClientProperty(GitToolbarWidgetActionKt.access$getREPOSITORY_KEY$p(), (Object)gitRepository);
        GitWidgetState gitWidgetState = state2;
        if (Intrinsics.areEqual((Object)gitWidgetState, (Object)GitWidgetState.OtherVcs.INSTANCE)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        if (Intrinsics.areEqual((Object)gitWidgetState, (Object)GitWidgetState.NoVcs.INSTANCE)) {
            String placeholder = GitToolbarWidgetAction.Companion.getPlaceholder(project);
            Presentation $this$update_u24lambda_u241 = e.getPresentation();
            boolean bl = false;
            $this$update_u24lambda_u241.setEnabledAndVisible(true);
            String string = placeholder;
            if (string == null) {
                string = GitBundle.message("git.toolbar.widget.no.repo", new Object[0]);
            }
            $this$update_u24lambda_u241.setText(string);
            $this$update_u24lambda_u241.setIcon(placeholder != null ? GitToolbarWidgetActionKt.access$getWIDGET_ICON$p() : null);
            $this$update_u24lambda_u241.setDescription(GitBundle.message("git.toolbar.widget.no.repo.tooltip", new Object[0]));
        } else if (gitWidgetState instanceof GitWidgetState.Repo) {
            void it;
            String string;
            Presentation $this$update_u24lambda_u243 = e.getPresentation();
            boolean bl = false;
            $this$update_u24lambda_u243.setEnabledAndVisible(true);
            GitCurrentBranchPresenter.Presentation presentation2 = GitCurrentBranchPresenter.Companion.getPresentation(((GitWidgetState.Repo)state2).getRepository());
            Icon icon = presentation2.getIcon();
            if (icon == null) {
                icon = GitToolbarWidgetActionKt.access$getWIDGET_ICON$p();
            }
            $this$update_u24lambda_u243.setIcon(icon);
            String string2 = string = presentation2.getText();
            Presentation presentation3 = $this$update_u24lambda_u243;
            boolean bl2 = false;
            GitToolbarWidgetAction.Companion.updatePlaceholder(project, (String)it);
            presentation3.setText(string);
            $this$update_u24lambda_u243.setDescription(presentation2.getDescription());
            $this$update_u24lambda_u243.putClientProperty(GitToolbarWidgetActionKt.access$getSYNC_STATUS_KEY$p(), (Object)presentation2.getSyncStatus());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001f\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\r\u0010\u0010\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction$Companion;", "", "()V", "BRANCH_NAME_MAX_LENGTH", "", "getPlaceholder", "", "Lcom/intellij/openapi/util/NlsSafe;", "project", "Lcom/intellij/openapi/project/Project;", "getWidgetState", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState;", "gitRepository", "Lgit4idea/repo/GitRepository;", "updatePlaceholder", "", "newPlaceholder", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitToolbarWidgetAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitToolbarWidgetAction.kt\ngit4idea/ui/toolbar/GitToolbarWidgetAction$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,180:1\n12474#2,2:181\n*S KotlinDebug\n*F\n+ 1 GitToolbarWidgetAction.kt\ngit4idea/ui/toolbar/GitToolbarWidgetAction$Companion\n*L\n166#1:181,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void updatePlaceholder(Project project, String newPlaceholder) {
            PropertiesComponent.getInstance((Project)project).setValue("git-widget-placeholder", newPlaceholder);
        }

        private final String getPlaceholder(Project project) {
            return PropertiesComponent.getInstance((Project)project).getValue("git-widget-placeholder");
        }

        @NotNull
        public final GitWidgetState getWidgetState(@NotNull Project project, @Nullable GitRepository gitRepository) {
            GitWidgetState gitWidgetState;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (gitRepository != null) {
                return new GitWidgetState.Repo(gitRepository);
            }
            AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss();
            Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
            AbstractVcs[] allVcss = abstractVcsArray;
            if (allVcss.length == 0) {
                gitWidgetState = GitWidgetState.NoVcs.INSTANCE;
            } else {
                boolean bl;
                block4: {
                    AbstractVcs[] $this$any$iv = allVcss;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        AbstractVcs element$iv;
                        AbstractVcs it = element$iv = $this$any$iv[i];
                        boolean bl2 = false;
                        if (!(!Intrinsics.areEqual((Object)it.getKeyInstanceMethod(), (Object)GitVcs.getKey()))) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
                gitWidgetState = bl ? (GitWidgetState)GitWidgetState.OtherVcs.INSTANCE : (GitWidgetState)GitWidgetState.NoVcs.INSTANCE;
            }
            return gitWidgetState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState;", "", "()V", "NoVcs", "OtherVcs", "Repo", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$NoVcs;", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$OtherVcs;", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$Repo;", "intellij.vcs.git"})
    public static abstract class GitWidgetState {
        private GitWidgetState() {
        }

        public /* synthetic */ GitWidgetState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$NoVcs;", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState;", "()V", "intellij.vcs.git"})
        public static final class NoVcs
        extends GitWidgetState {
            @NotNull
            public static final NoVcs INSTANCE = new NoVcs();

            private NoVcs() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$OtherVcs;", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState;", "()V", "intellij.vcs.git"})
        public static final class OtherVcs
        extends GitWidgetState {
            @NotNull
            public static final OtherVcs INSTANCE = new OtherVcs();

            private OtherVcs() {
                super(null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState$Repo;", "Lgit4idea/ui/toolbar/GitToolbarWidgetAction$GitWidgetState;", "repository", "Lgit4idea/repo/GitRepository;", "(Lgit4idea/repo/GitRepository;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
        public static final class Repo
        extends GitWidgetState {
            @NotNull
            private final GitRepository repository;

            public Repo(@NotNull GitRepository repository) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                super(null);
                this.repository = repository;
            }

            @NotNull
            public final GitRepository getRepository() {
                return this.repository;
            }
        }
    }
}

