/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import git4idea.ui.branch.GitBranchPopupActions;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0002\u0014\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0016J\u0016\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/ui/branch/GitBranchesClippedNamesCache;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "Lgit4idea/ui/branch/GitBranchesClippedNamesCache$ClippedBranch;", "cacheDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "clear", "", "dispose", "getOrCache", "branchName", "maxBranchNameLength", "", "truncateBranchName", "ClippedBranch", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitBranchesClippedNamesCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchesClippedNamesCache.kt\ngit4idea/ui/branch/GitBranchesClippedNamesCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class GitBranchesClippedNamesCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Cache<String, ClippedBranch> cache;
    @NotNull
    private final CheckedDisposable cacheDisposable;
    private static final long CACHE_MAX_SIZE = 1000L;
    private static final long CACHE_ACCESS_EXPIRATION_MIN = 5L;

    /*
     * WARNING - void declaration
     */
    public GitBranchesClippedNamesCache(@NotNull Project project) {
        void it;
        CheckedDisposable checkedDisposable;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Cache cache = Caffeine.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(1000L).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
        CheckedDisposable checkedDisposable2 = checkedDisposable = Disposer.newCheckedDisposable();
        GitBranchesClippedNamesCache gitBranchesClippedNamesCache = this;
        boolean bl = false;
        Disposer.register((Disposable)this, (Disposable)((Disposable)it));
        CheckedDisposable checkedDisposable3 = checkedDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable3, (String)"also(...)");
        gitBranchesClippedNamesCache.cacheDisposable = checkedDisposable3;
    }

    @NotNull
    public final String getOrCache(@NotNull String branchName, int maxBranchNameLength) {
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        if (this.cacheDisposable.isDisposed()) {
            return branchName;
        }
        ClippedBranch oldClippedBranch2 = (ClippedBranch)this.cache.get((Object)branchName, arg_0 -> GitBranchesClippedNamesCache.getOrCache$lambda$1((Function1)new Function1<String, ClippedBranch>(this, branchName, maxBranchNameLength){
            final /* synthetic */ GitBranchesClippedNamesCache this$0;
            final /* synthetic */ String $branchName;
            final /* synthetic */ int $maxBranchNameLength;
            {
                this.this$0 = $receiver;
                this.$branchName = $branchName;
                this.$maxBranchNameLength = $maxBranchNameLength;
                super(1);
            }

            public final ClippedBranch invoke(String it) {
                return GitBranchesClippedNamesCache.access$truncateBranchName(this.this$0, this.$branchName, this.$maxBranchNameLength);
            }
        }, arg_0));
        if (oldClippedBranch2.getLength() == maxBranchNameLength) {
            return oldClippedBranch2.getClippedName();
        }
        ClippedBranch clippedBranch = this.truncateBranchName(branchName, maxBranchNameLength);
        this.cache.put((Object)branchName, (Object)clippedBranch);
        return clippedBranch.getClippedName();
    }

    private final ClippedBranch truncateBranchName(String branchName, int maxBranchNameLength) {
        String string = GitBranchPopupActions.truncateBranchName(this.project, branchName, maxBranchNameLength, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"truncateBranchName(...)");
        return new ClippedBranch(string, maxBranchNameLength);
    }

    public final void clear() {
        this.cache.invalidateAll();
    }

    public void dispose() {
        this.cache.invalidateAll();
    }

    private static final ClippedBranch getOrCache$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ClippedBranch)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ClippedBranch access$truncateBranchName(GitBranchesClippedNamesCache $this, String branchName, int maxBranchNameLength) {
        return $this.truncateBranchName(branchName, maxBranchNameLength);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lgit4idea/ui/branch/GitBranchesClippedNamesCache$ClippedBranch;", "", "clippedName", "", "length", "", "(Ljava/lang/String;I)V", "getClippedName", "()Ljava/lang/String;", "getLength", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.vcs.git"})
    private static final class ClippedBranch {
        @NotNull
        private final String clippedName;
        private final int length;

        public ClippedBranch(@NotNull String clippedName, int length) {
            Intrinsics.checkNotNullParameter((Object)clippedName, (String)"clippedName");
            this.clippedName = clippedName;
            this.length = length;
        }

        @NotNull
        public final String getClippedName() {
            return this.clippedName;
        }

        public final int getLength() {
            return this.length;
        }

        @NotNull
        public final String component1() {
            return this.clippedName;
        }

        public final int component2() {
            return this.length;
        }

        @NotNull
        public final ClippedBranch copy(@NotNull String clippedName, int length) {
            Intrinsics.checkNotNullParameter((Object)clippedName, (String)"clippedName");
            return new ClippedBranch(clippedName, length);
        }

        public static /* synthetic */ ClippedBranch copy$default(ClippedBranch clippedBranch, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = clippedBranch.clippedName;
            }
            if ((n2 & 2) != 0) {
                n = clippedBranch.length;
            }
            return clippedBranch.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "ClippedBranch(clippedName=" + this.clippedName + ", length=" + this.length + ")";
        }

        public int hashCode() {
            int result2 = this.clippedName.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.length);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClippedBranch)) {
                return false;
            }
            ClippedBranch clippedBranch = (ClippedBranch)other;
            if (!Intrinsics.areEqual((Object)this.clippedName, (Object)clippedBranch.clippedName)) {
                return false;
            }
            return this.length == clippedBranch.length;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/ui/branch/GitBranchesClippedNamesCache$Companion;", "", "()V", "CACHE_ACCESS_EXPIRATION_MIN", "", "CACHE_MAX_SIZE", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

