/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesUi;
import com.intellij.openapi.vcs.changes.savedPatches.ShelfProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.i18n.GitBundle;
import git4idea.stash.GitStashTracker;
import git4idea.stash.ui.GitStashContentProviderKt;
import git4idea.stash.ui.GitStashDisplayNameSupplier;
import git4idea.stash.ui.GitStashProvider;
import git4idea.stash.ui.GitStashSettingsListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lgit4idea/stash/ui/GitStashContentProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "initTabContent", "", "content", "Lcom/intellij/ui/content/Content;", "isEditorDiffPreview", "", "isShowDiffWithLocal", "isVertical", "returnFocusToToolWindow", "componentToFocus", "Ljava/awt/Component;", "Companion", "GitSavedPatchesUi", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStashContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashContentProvider.kt\ngit4idea/stash/ui/GitStashContentProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,207:1\n31#2,2:208\n*S KotlinDebug\n*F\n+ 1 GitStashContentProvider.kt\ngit4idea/stash/ui/GitStashContentProvider\n*L\n45#1:208,2\n*E\n"})
public final class GitStashContentProvider
implements ChangesViewContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NonNls
    @NotNull
    public static final String TAB_NAME = "Stash";

    public GitStashContentProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void initTabContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitStashTracker> serviceClass$iv = GitStashTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((GitStashTracker)object).scheduleRefresh();
        Disposable disposable = Disposer.newDisposable((String)"Git Stash Content Provider");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        GitSavedPatchesUi savedPatchesUi = new GitSavedPatchesUi(new GitStashProvider(this.project, disposable2), new ShelfProvider(this.project, disposable2), disposable2);
        this.project.getMessageBus().connect(disposable2).subscribe(ChangesViewContentManagerListener.TOPIC, (Object)new ChangesViewContentManagerListener(savedPatchesUi){
            final /* synthetic */ GitSavedPatchesUi $savedPatchesUi;
            {
                this.$savedPatchesUi = $savedPatchesUi;
            }

            public void toolWindowMappingChanged() {
                this.$savedPatchesUi.updateLayout();
            }
        });
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(disposable2);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(savedPatchesUi){
            final /* synthetic */ GitSavedPatchesUi $savedPatchesUi;
            {
                this.$savedPatchesUi = $savedPatchesUi;
            }

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                this.$savedPatchesUi.updateLayout();
            }
        });
        content.setComponent((JComponent)((Object)savedPatchesUi));
        content.setDisposer(disposable2);
    }

    private final boolean isVertical() {
        ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.project, TAB_NAME);
        return toolWindow != null && (toolWindow = toolWindow.getAnchor()) != null ? !toolWindow.isHorizontal() : false;
    }

    private final boolean isEditorDiffPreview() {
        return ChangesViewContentManager.Companion.isCommitToolWindowShown(this.project);
    }

    private final void returnFocusToToolWindow(Component componentToFocus) {
        ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.project, TAB_NAME);
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (componentToFocus == null) {
            toolWindow2.activate(null);
            return;
        }
        toolWindow2.activate(() -> GitStashContentProvider.returnFocusToToolWindow$lambda$0(this, componentToFocus), false);
    }

    private final boolean isShowDiffWithLocal() {
        return GitVcsApplicationSettings.getInstance().isCompareWithLocalInStashesEnabled();
    }

    private static final void returnFocusToToolWindow$lambda$0(GitStashContentProvider this$0, Component $componentToFocus) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        IdeFocusManager.getInstance((Project)this$0.project).requestFocus($componentToFocus, true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/stash/ui/GitStashContentProvider$Companion;", "", "()V", "TAB_NAME", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/stash/ui/GitStashContentProvider$GitSavedPatchesUi;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesUi;", "stashProvider", "Lgit4idea/stash/ui/GitStashProvider;", "shelfProvider", "Lcom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lgit4idea/stash/ui/GitStashContentProvider;Lgit4idea/stash/ui/GitStashProvider;Lcom/intellij/openapi/vcs/changes/savedPatches/ShelfProvider;Lcom/intellij/openapi/Disposable;)V", "updateTabName", "", "updateVisibleProviders", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitStashContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashContentProvider.kt\ngit4idea/stash/ui/GitStashContentProvider$GitSavedPatchesUi\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,207:1\n59#2:208\n*S KotlinDebug\n*F\n+ 1 GitStashContentProvider.kt\ngit4idea/stash/ui/GitStashContentProvider$GitSavedPatchesUi\n*L\n87#1:208\n*E\n"})
    private final class GitSavedPatchesUi
    extends SavedPatchesUi {
        @NotNull
        private final GitStashProvider stashProvider;
        @NotNull
        private final ShelfProvider shelfProvider;

        public GitSavedPatchesUi(@NotNull GitStashProvider stashProvider, @NotNull ShelfProvider shelfProvider, Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)stashProvider, (String)"stashProvider");
            Intrinsics.checkNotNullParameter((Object)shelfProvider, (String)"shelfProvider");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Object[] objectArray = new Object[]{stashProvider, shelfProvider};
            super(GitStashContentProvider.this.project, CollectionsKt.listOf((Object[])objectArray), (Function0)new Function0<Boolean>((Object)GitStashContentProvider.this){

                @NotNull
                public final Boolean invoke() {
                    return ((GitStashContentProvider)this.receiver).isVertical();
                }
            }, (Function0)new Function0<Boolean>((Object)GitStashContentProvider.this){

                @NotNull
                public final Boolean invoke() {
                    return ((GitStashContentProvider)this.receiver).isEditorDiffPreview();
                }
            }, (Function0)new Function0<Boolean>((Object)GitStashContentProvider.this){

                @NotNull
                public final Boolean invoke() {
                    return ((GitStashContentProvider)this.receiver).isShowDiffWithLocal();
                }
            }, (Function1)new Function1<Component, Unit>((Object)GitStashContentProvider.this){

                public final void invoke(@Nullable Component p0) {
                    ((GitStashContentProvider)this.receiver).returnFocusToToolWindow(p0);
                }
            }, parentDisposable);
            this.stashProvider = stashProvider;
            this.shelfProvider = shelfProvider;
            this.getTree().getEmptyText().appendLine("").appendLine(AllIcons.General.ContextHelp, GitBundle.message("stash.empty.text.help.link", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, GitSavedPatchesUi::_init_$lambda$0);
            GitStashContentProvider.this.project.getMessageBus().connect((Disposable)this).subscribe(GitStashSettingsListener.Companion.getTOPIC(), (Object)new GitStashSettingsListener(){

                @Override
                public void stashesAndShelvesTabSettingChanged() {
                    this.updateVisibleProviders();
                    this.updateTabName();
                }
            });
            this.updateVisibleProviders();
        }

        private final void updateVisibleProviders() {
            List list2;
            boolean isStashesAndShelvesTabEnabled = GitStashContentProviderKt.isStashesAndShelvesTabEnabled(GitStashContentProvider.this.project);
            if (isStashesAndShelvesTabEnabled) {
                Object[] objectArray = new Object[]{this.stashProvider, this.shelfProvider};
                list2 = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list2 = CollectionsKt.listOf((Object)this.stashProvider);
            }
            this.setVisibleProviders(list2);
        }

        private final void updateTabName() {
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)GitStashContentProvider.this.project;
            boolean $i$f$serviceIfCreated = false;
            ChangesViewContentI changesViewContentI = (ChangesViewContentI)$this$serviceIfCreated$iv.getServiceIfCreated(ChangesViewContentI.class);
            if (changesViewContentI == null) {
                return;
            }
            ChangesViewContentI contentManager = changesViewContentI;
            Content content = contentManager.findContent(GitStashContentProvider.TAB_NAME);
            if (content == null) {
                return;
            }
            Content content2 = content;
            content2.setDisplayName(new GitStashDisplayNameSupplier(GitStashContentProvider.this.project).get());
        }

        private static final void _init_$lambda$0(ActionEvent it) {
            HelpManager.getInstance().invokeHelp("reference.VersionControl.Git.StashAndShelf");
        }
    }
}

