/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.error;

import com.intellij.collaboration.api.HttpStatusErrorException;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import java.net.ConnectException;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.data.GitLabHttpStatusError;
import org.jetbrains.plugins.gitlab.api.data.GitLabHttpStatusErrorKt;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccountViewModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0015\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0015\u0010\r\u001a\u00070\u000b\u00a2\u0006\u0002\b\f2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/error/GitLabMergeRequestErrorStatusPresenter;", "Lcom/intellij/collaboration/ui/codereview/list/error/ErrorStatusPresenter$Text;", "", "accountVm", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountViewModel;", "reloadAction", "Ljavax/swing/Action;", "(Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountViewModel;Ljavax/swing/Action;)V", "getErrorAction", "error", "getErrorDescription", "", "Lorg/jetbrains/annotations/Nls;", "getErrorTitle", "intellij.vcs.gitlab"})
public final class GitLabMergeRequestErrorStatusPresenter
implements ErrorStatusPresenter.Text<Throwable> {
    @NotNull
    private final GitLabAccountViewModel accountVm;
    @Nullable
    private final Action reloadAction;

    public GitLabMergeRequestErrorStatusPresenter(@NotNull GitLabAccountViewModel accountVm, @Nullable Action reloadAction) {
        Intrinsics.checkNotNullParameter((Object)accountVm, (String)"accountVm");
        this.accountVm = accountVm;
        this.reloadAction = reloadAction;
    }

    @NotNull
    public String getErrorTitle(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        return GitLabBundle.message("merge.request.list.error", new Object[0]);
    }

    @NotNull
    public String getErrorDescription(@NotNull Throwable error) {
        String string;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Throwable throwable = error;
        if (throwable instanceof ConnectException) {
            String string2 = CollaborationToolsBundle.message((String)"review.list.connection.error", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else if (throwable instanceof HttpStatusErrorException) {
            GitLabHttpStatusError gitLabHttpStatusError = GitLabHttpStatusErrorKt.asGitLabStatusError((HttpStatusErrorException)error);
            if (gitLabHttpStatusError == null) {
                return ((HttpStatusErrorException)error).getLocalizedMessage();
            }
            GitLabHttpStatusError actualError = gitLabHttpStatusError;
            String string3 = switch (WhenMappings.$EnumSwitchMapping$0[actualError.getStatusErrorType().ordinal()]) {
                case 1 -> CollaborationToolsBundle.message((String)"http.status.error.refresh.token", (Object[])new Object[0]);
                case 2 -> CollaborationToolsBundle.message((String)"http.request.error", (Object[])new Object[0]) + "\n" + actualError.getError();
                default -> throw new NoWhenBranchMatchedException();
            };
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        } else {
            String string4 = error.getLocalizedMessage();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getLocalizedMessage(...)");
        }
        return string;
    }

    @Nullable
    public Action getErrorAction(@NotNull Throwable error) {
        Action action2;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                if (!(error instanceof HttpStatusErrorException)) break block5;
                GitLabHttpStatusError gitLabHttpStatusError = GitLabHttpStatusErrorKt.asGitLabStatusError((HttpStatusErrorException)error);
                if (gitLabHttpStatusError == null) {
                    return null;
                }
                GitLabHttpStatusError actualError = gitLabHttpStatusError;
                switch (WhenMappings.$EnumSwitchMapping$0[actualError.getStatusErrorType().ordinal()]) {
                    case 1: {
                        action2 = this.accountVm.loginAction();
                        break block6;
                    }
                    case 2: {
                        action2 = null;
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            action2 = this.reloadAction;
        }
        return action2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GitLabHttpStatusError.HttpStatusErrorType.values().length];
            try {
                nArray[GitLabHttpStatusError.HttpStatusErrorType.INVALID_TOKEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabHttpStatusError.HttpStatusErrorType.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

