/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.util;

import com.intellij.ui.JBColor;
import com.jetbrains.rd.ui.util.CIELabUtils;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a \u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"getContrastedForeground", "Ljava/awt/Color;", "background", "foreground", "getContrastedForegroundIfNotThemed", "addContrastToForegroundIfNeeded", "", "intellij.rd.ui"})
public final class ColorUtilsKt {
    @NotNull
    public static final Color getContrastedForegroundIfNotThemed(@NotNull Color background, @NotNull Color foreground, boolean addContrastToForegroundIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        if (foreground instanceof JBColor || !addContrastToForegroundIfNeeded) {
            return foreground;
        }
        return ColorUtilsKt.getContrastedForeground(background, foreground);
    }

    public static /* synthetic */ Color getContrastedForegroundIfNotThemed$default(Color color, Color color2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return ColorUtilsKt.getContrastedForegroundIfNotThemed(color, color2, bl);
    }

    @NotNull
    public static final Color getContrastedForeground(@NotNull Color background, @NotNull Color foreground) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        float contrast = 0.45f;
        float margin = 0.02f;
        float whiteBalance = 0.66f;
        float[] fArray = foreground.getColorComponents(null);
        Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"getColorComponents(...)");
        float[] fArray2 = CIELabUtils.INSTANCE.fromRGB(fArray);
        float fL = fArray2[0];
        float fA = fArray2[1];
        float fB = fArray2[2];
        float[] fArray3 = background.getColorComponents(null);
        Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"getColorComponents(...)");
        float[] fArray4 = CIELabUtils.INSTANCE.fromRGB(fArray3);
        float bL = fArray4[0];
        float bA = fArray4[1];
        float bB = fArray4[2];
        if (Math.abs(bL - fL) / 100.0f < contrast) {
            float lightness;
            fL = bL / 100.0f > whiteBalance ? (bL / 100.0f - (lightness = Math.min(fL / 100.0f, margin)) < contrast ? lightness * 100.0f : (bL / 100.0f - contrast) * 100.0f) : ((lightness = Math.max(fL / 100.0f, 1.0f - margin)) - bL / 100.0f < contrast ? lightness * 100.0f : (bL / 100.0f + contrast) * 100.0f);
            float[] fArray5 = new float[]{fL, fA, fB};
            float[] fArray6 = CIELabUtils.INSTANCE.toRGB(fArray5);
            float r = fArray6[0];
            float g = fArray6[1];
            float b = fArray6[2];
            Color rgb = new Color(r, g, b);
            int min = Math.min(Math.min(foreground.getRed(), foreground.getGreen()), foreground.getBlue());
            int max = Math.max(Math.max(foreground.getRed(), foreground.getGreen()), foreground.getBlue());
            if (max != min) {
                double redPortion = (double)(foreground.getRed() - min) / (double)(max - min);
                double greenPortion = (double)(foreground.getGreen() - min) / (double)(max - min);
                double bluePortion = (double)(foreground.getBlue() - min) / (double)(max - min);
                Integer[] integerArray = new Integer[]{rgb.getRed(), rgb.getGreen(), rgb.getBlue()};
                Integer[] sorted = integerArray;
                ArraysKt.sort((Object[])sorted);
                min = (sorted[0] + sorted[1]) / 2;
                max = sorted[2];
                return new Color((int)(redPortion * (double)(max - min) + (double)min), (int)(greenPortion * (double)(max - min) + (double)min), (int)(bluePortion * (double)(max - min) + (double)min), foreground.getAlpha());
            }
            return new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), foreground.getAlpha());
        }
        return foreground;
    }
}

