/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.sarif;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.Fix;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.sarif.CodeInspectionReader;
import org.jetbrains.qodana.sarif.PathSerializer;
import org.jetbrains.qodana.sarif.ProblemReaderException;
import org.jetbrains.qodana.sarif.ProblemWriter;
import org.jetbrains.qodana.sarif.ProblemsWriteResult;
import org.jetbrains.qodana.sarif.QodanaDirectory;
import org.jetbrains.qodana.sarif.QodanaFile;
import org.jetbrains.qodana.sarif.QodanaReportConverter;
import org.jetbrains.qodana.sarif.QodanaReportConverterKt;
import org.jetbrains.qodana.sarif.json.idea.Description;
import org.jetbrains.qodana.sarif.model.CoverageInformation;
import org.jetbrains.qodana.sarif.model.MetaInformation;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004/012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J.\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\u0014\b\u0002\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001dJ\u0018\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ,\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u00152\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001dH\u0002J\b\u0010%\u001a\u00020\bH\u0002J\u0018\u0010&\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(H\u0002J\u001a\u0010)\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0018\u0010,\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u00063"}, d2={"Lorg/jetbrains/qodana/sarif/QodanaReportConverter;", "", "options", "Lorg/jetbrains/qodana/sarif/QodanaReportConverter$Options;", "(Lorg/jetbrains/qodana/sarif/QodanaReportConverter$Options;)V", "gson", "Lcom/google/gson/Gson;", "optionsAreValid", "", "getOptionsAreValid", "()Z", "optionsAreValid$delegate", "Lkotlin/Lazy;", "convert", "", "convertSarifFirstRun", "Lorg/jetbrains/qodana/sarif/QodanaReportConverter$ConvertSarifResult;", "config", "Lorg/jetbrains/qodana/sarif/QodanaReportConverter$ConvertSarifOptions;", "copy", "file", "Ljava/io/File;", "destination", "copyDirectoryToOutput", "qodanaDirectory", "Lorg/jetbrains/qodana/sarif/QodanaDirectory;", "outputPath", "", "filePathReplacements", "", "copyFileToOutput", "qodanaFile", "Lorg/jetbrains/qodana/sarif/QodanaFile;", "copyFiles", "src", "dst", "pathReplacements", "validateOptionsOrThrow", "writeCoverage", "coverageInformation", "Lorg/jetbrains/qodana/sarif/model/CoverageInformation;", "writeDescription", "description", "Lorg/jetbrains/qodana/sarif/json/idea/Description;", "writeMetaInformation", "metaInformation", "Lorg/jetbrains/qodana/sarif/model/MetaInformation;", "ConversionErrorCount", "ConvertSarifOptions", "ConvertSarifResult", "Options", "sarif-converter"})
@SourceDebugExtension(value={"SMAP\nQodanaReportConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaReportConverter.kt\norg/jetbrains/qodana/sarif/QodanaReportConverter\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 json.kt\norg/jetbrains/qodana/sarif/json/JsonKt\n*L\n1#1,250:1\n1224#2,2:251\n1#3:253\n9#4:254\n9#4:255\n9#4:256\n*S KotlinDebug\n*F\n+ 1 QodanaReportConverter.kt\norg/jetbrains/qodana/sarif/QodanaReportConverter\n*L\n213#1:251,2\n230#1:254\n238#1:255\n244#1:256\n*E\n"})
public final class QodanaReportConverter {
    @NotNull
    private final Options options;
    @NotNull
    private final Gson gson;
    @NotNull
    private final Lazy optionsAreValid$delegate;

    public QodanaReportConverter(@NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        Gson gson = new GsonBuilder().registerTypeHierarchyAdapter(Path.class, (Object)new PathSerializer()).registerTypeAdapter((Type)((Object)Fix.class), (Object)SarifUtil.createGson().getAdapter(Fix.class)).setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder()\n          \u2026g()\n            .create()");
        this.gson = gson;
        this.optionsAreValid$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ QodanaReportConverter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return QodanaReportConverter.access$validateOptionsOrThrow(this.this$0);
            }
        }));
    }

    private final boolean getOptionsAreValid() {
        Lazy lazy = this.optionsAreValid$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean copyFileToOutput(@NotNull QodanaFile qodanaFile, @NotNull String outputPath) {
        Intrinsics.checkNotNullParameter((Object)qodanaFile, (String)"qodanaFile");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        if (!this.getOptionsAreValid()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.options.getOutput().mkdirs();
        File file = FilesKt.resolve((File)this.options.getInput(), (String)qodanaFile.getRelativeInputPath());
        if (!file.exists()) {
            QodanaReportConverterKt.access$getLog$p().warn("File '" + file + "' does not exist");
            return false;
        }
        return this.copy(file, FilesKt.resolve((File)this.options.getOutput(), (String)outputPath));
    }

    public static /* synthetic */ boolean copyFileToOutput$default(QodanaReportConverter qodanaReportConverter, QodanaFile qodanaFile, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = qodanaFile.getDefaultOutputPath();
        }
        return qodanaReportConverter.copyFileToOutput(qodanaFile, string);
    }

    public final boolean copyDirectoryToOutput(@NotNull QodanaDirectory qodanaDirectory, @NotNull String outputPath, @NotNull Map<String, String> filePathReplacements) {
        Intrinsics.checkNotNullParameter((Object)qodanaDirectory, (String)"qodanaDirectory");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter(filePathReplacements, (String)"filePathReplacements");
        if (!this.getOptionsAreValid()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.options.getOutput().mkdirs();
        File directory = FilesKt.resolve((File)this.options.getInput(), (String)qodanaDirectory.getRelativeInputPath());
        if (!directory.exists()) {
            QodanaReportConverterKt.access$getLog$p().warn("Directory '" + directory + "' does not exist");
            return false;
        }
        return this.copyFiles(directory, FilesKt.resolve((File)this.options.getOutput(), (String)outputPath), filePathReplacements);
    }

    public static /* synthetic */ boolean copyDirectoryToOutput$default(QodanaReportConverter qodanaReportConverter, QodanaDirectory qodanaDirectory, String string, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            string = qodanaDirectory.getDefaultOutputPath();
        }
        if ((n & 4) != 0) {
            map2 = qodanaDirectory.getDefaultFilePathReplacements();
        }
        return qodanaReportConverter.copyDirectoryToOutput(qodanaDirectory, string, map2);
    }

    @NotNull
    public final ConvertSarifResult convertSarifFirstRun(@NotNull ConvertSarifOptions config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!this.getOptionsAreValid()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.options.getOutput().mkdirs();
        File out = this.options.getOutput();
        File descriptionOut = FilesKt.resolve((File)out, (String)config.getDescriptionOut());
        File metaInformationOut = FilesKt.resolve((File)out, (String)config.getMetaInformationOut());
        File coverageOut = FilesKt.resolve((File)out, (String)config.getCoverageOut());
        File allProblemsOut = FilesKt.resolve((File)out, (String)config.getAllProblemsOut());
        File sanityOut = FilesKt.resolve((File)out, (String)config.getSanityProblemsOut());
        File promoOut = FilesKt.resolve((File)out, (String)config.getPromoProblemsOut());
        CodeInspectionReader codeInspectionReader = new CodeInspectionReader(FilesKt.resolve((File)this.options.getInput(), (String)QodanaFile.QodanaSarif.INSTANCE.getRelativeInputPath()));
        ProblemWriter problemWriter = new ProblemWriter(codeInspectionReader, this.gson);
        ProblemsWriteResult allProblemsWriteResult = problemWriter.writeResultAllProblems(allProblemsOut, this.options.getLimit());
        boolean descriptionWasWritten = this.writeDescription(descriptionOut, codeInspectionReader.getDescription());
        this.writeMetaInformation(metaInformationOut, codeInspectionReader.getMetaInformation(allProblemsWriteResult.getNumProblemsWritten()));
        this.writeCoverage(coverageOut, codeInspectionReader.getCoverageInformation());
        ProblemsWriteResult sanityWriteResult = problemWriter.writeSanityProblems(sanityOut);
        ProblemsWriteResult promoWriteResult = problemWriter.writePromoProblems(promoOut);
        Object[] objectArray = new File[]{metaInformationOut, coverageOut, allProblemsOut, sanityOut, promoOut};
        return new ConvertSarifResult(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)(descriptionWasWritten ? CollectionsKt.listOf((Object)descriptionOut) : CollectionsKt.emptyList())), codeInspectionReader.getNumberOfRuns() > 1, new ConversionErrorCount(sanityWriteResult.getNumProblemsFailed(), promoWriteResult.getNumProblemsFailed(), allProblemsWriteResult.getNumProblemsFailed()));
    }

    public static /* synthetic */ ConvertSarifResult convertSarifFirstRun$default(QodanaReportConverter qodanaReportConverter, ConvertSarifOptions convertSarifOptions, int n, Object object) {
        if ((n & 1) != 0) {
            convertSarifOptions = new ConvertSarifOptions(null, null, null, null, null, null, 63, null);
        }
        return qodanaReportConverter.convertSarifFirstRun(convertSarifOptions);
    }

    public final void convert() {
        if (!this.getOptionsAreValid()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.options.getOutput().mkdirs();
        QodanaReportConverter.convertSarifFirstRun$default(this, null, 1, null);
        QodanaReportConverter.copyFileToOutput$default(this, QodanaFile.QodanaConfiguration.INSTANCE, null, 2, null);
        QodanaReportConverter.copyFileToOutput$default(this, QodanaFile.QodanaSarif.INSTANCE, null, 2, null);
        QodanaReportConverter.copyDirectoryToOutput$default(this, QodanaDirectory.CoverageArtifacts.INSTANCE, null, null, 6, null);
        QodanaReportConverter.copyDirectoryToOutput$default(this, QodanaDirectory.ProjectStructure.INSTANCE, null, null, 6, null);
    }

    private final boolean validateOptionsOrThrow() {
        boolean outputDirIsNotEmpty;
        if (this.options.getLimit() < 0) {
            throw new ProblemReaderException("Limit must not be less than zero", null, 2, null);
        }
        if (!this.options.getInput().isDirectory()) {
            throw new ProblemReaderException("Input must exist and be a directory", null, 2, null);
        }
        File[] fileArray = this.options.getOutput().listFiles();
        boolean bl = fileArray != null ? !(fileArray.length == 0) : (outputDirIsNotEmpty = false);
        if (outputDirIsNotEmpty) {
            throw new ProblemReaderException("Output directory is not empty", null, 2, null);
        }
        return true;
    }

    private final boolean copy(File file, File destination) {
        boolean bl;
        destination.getParentFile().mkdirs();
        try {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(file.toPath(), destination.toPath(), copyOptionArray);
            bl = true;
        }
        catch (Exception e) {
            QodanaReportConverterKt.access$getLog$p().error("Problems occurred while moving " + file.getName() + " to " + destination + ": " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    private final boolean copyFiles(File src, File dst, Map<String, String> pathReplacements) {
        try {
            boolean bl;
            block4: {
                Files.deleteIfExists(dst.toPath());
                Files.createDirectories(dst.toPath(), new FileAttribute[0]);
                Sequence $this$all$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)src, null, (int)1, null)), (Function1)copyFiles.1.INSTANCE);
                boolean $i$f$all = false;
                for (Object element$iv : $this$all$iv) {
                    File file = (File)element$iv;
                    boolean bl2 = false;
                    String relativePath = FilesKt.relativeTo((File)file, (File)src).getPath();
                    String string = pathReplacements.get(relativePath);
                    if (string == null) {
                        string = relativePath;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathReplacements[relativePath] ?: relativePath");
                    File dest = FilesKt.resolve((File)dst, (String)string);
                    if (this.copy(file, dest)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
            return bl;
        }
        catch (Exception e) {
            QodanaReportConverterKt.access$getLog$p().error("Problems occurred while moving " + src + " to " + dst + ": " + e.getMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean writeDescription(File destination, Description description2) {
        File file;
        if (description2 == null) {
            QodanaReportConverterKt.access$getLog$p().warn("Missing description in sarif report");
            return false;
        }
        File $this$writeDescription_u24lambda_u241 = file = destination;
        boolean bl = false;
        $this$writeDescription_u24lambda_u241.getParentFile().mkdirs();
        File file$iv = file;
        boolean $i$f$useJsonWriter = false;
        Closeable closeable = (Closeable)new JsonWriter((Writer)new BufferedWriter(new FileWriter(file$iv, StandardCharsets.UTF_8)));
        Throwable throwable = null;
        try {
            JsonWriter writer = (JsonWriter)closeable;
            boolean bl2 = false;
            JsonWriter jsonWriter = writer.jsonValue(this.gson.toJson((Object)description2));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeMetaInformation(File destination, MetaInformation metaInformation) {
        File file;
        File $this$writeMetaInformation_u24lambda_u243 = file = destination;
        boolean bl = false;
        $this$writeMetaInformation_u24lambda_u243.getParentFile().mkdirs();
        File file$iv = file;
        boolean $i$f$useJsonWriter = false;
        Closeable closeable = (Closeable)new JsonWriter((Writer)new BufferedWriter(new FileWriter(file$iv, StandardCharsets.UTF_8)));
        Throwable throwable = null;
        try {
            JsonWriter it = (JsonWriter)closeable;
            boolean bl2 = false;
            JsonWriter jsonWriter = it.jsonValue(this.gson.toJson((Object)MetaInformation.copy$default(metaInformation, null, 0, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Code Inspection", (Object)metaInformation.getTotalProblem())), null, null, null, 59, null)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeCoverage(File destination, CoverageInformation coverageInformation) {
        File file;
        File $this$writeCoverage_u24lambda_u245 = file = destination;
        boolean bl = false;
        $this$writeCoverage_u24lambda_u245.getParentFile().mkdirs();
        File file$iv = file;
        boolean $i$f$useJsonWriter = false;
        Closeable closeable = (Closeable)new JsonWriter((Writer)new BufferedWriter(new FileWriter(file$iv, StandardCharsets.UTF_8)));
        Throwable throwable = null;
        try {
            JsonWriter writer = (JsonWriter)closeable;
            boolean bl2 = false;
            JsonElement obj = this.gson.toJsonTree((Object)coverageInformation);
            this.gson.toJson(obj, writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final /* synthetic */ boolean access$validateOptionsOrThrow(QodanaReportConverter $this) {
        return $this.validateOptionsOrThrow();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/sarif/QodanaReportConverter$Options;", "", "limit", "", "input", "Ljava/io/File;", "output", "(ILjava/io/File;Ljava/io/File;)V", "getInput", "()Ljava/io/File;", "getLimit", "()I", "getOutput", "sarif-converter"})
    public static final class Options {
        private final int limit;
        @NotNull
        private final File input;
        @NotNull
        private final File output;

        public Options(int limit, @NotNull File input, @NotNull File output2) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
            this.limit = limit;
            this.input = input;
            this.output = output2;
        }

        public final int getLimit() {
            return this.limit;
        }

        @NotNull
        public final File getInput() {
            return this.input;
        }

        @NotNull
        public final File getOutput() {
            return this.output;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/qodana/sarif/QodanaReportConverter$ConvertSarifOptions;", "", "descriptionOut", "", "metaInformationOut", "coverageOut", "allProblemsOut", "sanityProblemsOut", "promoProblemsOut", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAllProblemsOut", "()Ljava/lang/String;", "getCoverageOut", "getDescriptionOut", "getMetaInformationOut", "getPromoProblemsOut", "getSanityProblemsOut", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "sarif-converter"})
    public static final class ConvertSarifOptions {
        @NotNull
        private final String descriptionOut;
        @NotNull
        private final String metaInformationOut;
        @NotNull
        private final String coverageOut;
        @NotNull
        private final String allProblemsOut;
        @NotNull
        private final String sanityProblemsOut;
        @NotNull
        private final String promoProblemsOut;

        public ConvertSarifOptions(@NotNull String descriptionOut, @NotNull String metaInformationOut, @NotNull String coverageOut, @NotNull String allProblemsOut, @NotNull String sanityProblemsOut, @NotNull String promoProblemsOut) {
            Intrinsics.checkNotNullParameter((Object)descriptionOut, (String)"descriptionOut");
            Intrinsics.checkNotNullParameter((Object)metaInformationOut, (String)"metaInformationOut");
            Intrinsics.checkNotNullParameter((Object)coverageOut, (String)"coverageOut");
            Intrinsics.checkNotNullParameter((Object)allProblemsOut, (String)"allProblemsOut");
            Intrinsics.checkNotNullParameter((Object)sanityProblemsOut, (String)"sanityProblemsOut");
            Intrinsics.checkNotNullParameter((Object)promoProblemsOut, (String)"promoProblemsOut");
            this.descriptionOut = descriptionOut;
            this.metaInformationOut = metaInformationOut;
            this.coverageOut = coverageOut;
            this.allProblemsOut = allProblemsOut;
            this.sanityProblemsOut = sanityProblemsOut;
            this.promoProblemsOut = promoProblemsOut;
        }

        public /* synthetic */ ConvertSarifOptions(String string, String string2, String string3, String string4, String string5, String string6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "descriptions/Code_Inspection.json";
            }
            if ((n & 2) != 0) {
                string2 = "metaInformation.json";
            }
            if ((n & 4) != 0) {
                string3 = "coverageInformation.json";
            }
            if ((n & 8) != 0) {
                string4 = "result-allProblems.json";
            }
            if ((n & 0x10) != 0) {
                string5 = "sanity.json";
            }
            if ((n & 0x20) != 0) {
                string6 = "promo.json";
            }
            this(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public final String getDescriptionOut() {
            return this.descriptionOut;
        }

        @NotNull
        public final String getMetaInformationOut() {
            return this.metaInformationOut;
        }

        @NotNull
        public final String getCoverageOut() {
            return this.coverageOut;
        }

        @NotNull
        public final String getAllProblemsOut() {
            return this.allProblemsOut;
        }

        @NotNull
        public final String getSanityProblemsOut() {
            return this.sanityProblemsOut;
        }

        @NotNull
        public final String getPromoProblemsOut() {
            return this.promoProblemsOut;
        }

        @NotNull
        public final String component1() {
            return this.descriptionOut;
        }

        @NotNull
        public final String component2() {
            return this.metaInformationOut;
        }

        @NotNull
        public final String component3() {
            return this.coverageOut;
        }

        @NotNull
        public final String component4() {
            return this.allProblemsOut;
        }

        @NotNull
        public final String component5() {
            return this.sanityProblemsOut;
        }

        @NotNull
        public final String component6() {
            return this.promoProblemsOut;
        }

        @NotNull
        public final ConvertSarifOptions copy(@NotNull String descriptionOut, @NotNull String metaInformationOut, @NotNull String coverageOut, @NotNull String allProblemsOut, @NotNull String sanityProblemsOut, @NotNull String promoProblemsOut) {
            Intrinsics.checkNotNullParameter((Object)descriptionOut, (String)"descriptionOut");
            Intrinsics.checkNotNullParameter((Object)metaInformationOut, (String)"metaInformationOut");
            Intrinsics.checkNotNullParameter((Object)coverageOut, (String)"coverageOut");
            Intrinsics.checkNotNullParameter((Object)allProblemsOut, (String)"allProblemsOut");
            Intrinsics.checkNotNullParameter((Object)sanityProblemsOut, (String)"sanityProblemsOut");
            Intrinsics.checkNotNullParameter((Object)promoProblemsOut, (String)"promoProblemsOut");
            return new ConvertSarifOptions(descriptionOut, metaInformationOut, coverageOut, allProblemsOut, sanityProblemsOut, promoProblemsOut);
        }

        public static /* synthetic */ ConvertSarifOptions copy$default(ConvertSarifOptions convertSarifOptions, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                string = convertSarifOptions.descriptionOut;
            }
            if ((n & 2) != 0) {
                string2 = convertSarifOptions.metaInformationOut;
            }
            if ((n & 4) != 0) {
                string3 = convertSarifOptions.coverageOut;
            }
            if ((n & 8) != 0) {
                string4 = convertSarifOptions.allProblemsOut;
            }
            if ((n & 0x10) != 0) {
                string5 = convertSarifOptions.sanityProblemsOut;
            }
            if ((n & 0x20) != 0) {
                string6 = convertSarifOptions.promoProblemsOut;
            }
            return convertSarifOptions.copy(string, string2, string3, string4, string5, string6);
        }

        @NotNull
        public String toString() {
            return "ConvertSarifOptions(descriptionOut=" + this.descriptionOut + ", metaInformationOut=" + this.metaInformationOut + ", coverageOut=" + this.coverageOut + ", allProblemsOut=" + this.allProblemsOut + ", sanityProblemsOut=" + this.sanityProblemsOut + ", promoProblemsOut=" + this.promoProblemsOut + ')';
        }

        public int hashCode() {
            int result2 = this.descriptionOut.hashCode();
            result2 = result2 * 31 + this.metaInformationOut.hashCode();
            result2 = result2 * 31 + this.coverageOut.hashCode();
            result2 = result2 * 31 + this.allProblemsOut.hashCode();
            result2 = result2 * 31 + this.sanityProblemsOut.hashCode();
            result2 = result2 * 31 + this.promoProblemsOut.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConvertSarifOptions)) {
                return false;
            }
            ConvertSarifOptions convertSarifOptions = (ConvertSarifOptions)other;
            if (!Intrinsics.areEqual((Object)this.descriptionOut, (Object)convertSarifOptions.descriptionOut)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.metaInformationOut, (Object)convertSarifOptions.metaInformationOut)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.coverageOut, (Object)convertSarifOptions.coverageOut)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.allProblemsOut, (Object)convertSarifOptions.allProblemsOut)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sanityProblemsOut, (Object)convertSarifOptions.sanityProblemsOut)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.promoProblemsOut, (Object)convertSarifOptions.promoProblemsOut);
        }

        public ConvertSarifOptions() {
            this(null, null, null, null, null, null, 63, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/qodana/sarif/QodanaReportConverter$ConvertSarifResult;", "", "writtenFiles", "", "Ljava/io/File;", "hasMultipleRuns", "", "conversionErrors", "Lorg/jetbrains/qodana/sarif/QodanaReportConverter$ConversionErrorCount;", "(Ljava/util/List;ZLorg/jetbrains/qodana/sarif/QodanaReportConverter$ConversionErrorCount;)V", "getConversionErrors", "()Lorg/jetbrains/qodana/sarif/QodanaReportConverter$ConversionErrorCount;", "getHasMultipleRuns", "()Z", "getWrittenFiles", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "sarif-converter"})
    public static final class ConvertSarifResult {
        @NotNull
        private final List<File> writtenFiles;
        private final boolean hasMultipleRuns;
        @NotNull
        private final ConversionErrorCount conversionErrors;

        public ConvertSarifResult(@NotNull List<? extends File> writtenFiles, boolean hasMultipleRuns, @NotNull ConversionErrorCount conversionErrors) {
            Intrinsics.checkNotNullParameter(writtenFiles, (String)"writtenFiles");
            Intrinsics.checkNotNullParameter((Object)conversionErrors, (String)"conversionErrors");
            this.writtenFiles = writtenFiles;
            this.hasMultipleRuns = hasMultipleRuns;
            this.conversionErrors = conversionErrors;
        }

        @NotNull
        public final List<File> getWrittenFiles() {
            return this.writtenFiles;
        }

        public final boolean getHasMultipleRuns() {
            return this.hasMultipleRuns;
        }

        @NotNull
        public final ConversionErrorCount getConversionErrors() {
            return this.conversionErrors;
        }

        @NotNull
        public final List<File> component1() {
            return this.writtenFiles;
        }

        public final boolean component2() {
            return this.hasMultipleRuns;
        }

        @NotNull
        public final ConversionErrorCount component3() {
            return this.conversionErrors;
        }

        @NotNull
        public final ConvertSarifResult copy(@NotNull List<? extends File> writtenFiles, boolean hasMultipleRuns, @NotNull ConversionErrorCount conversionErrors) {
            Intrinsics.checkNotNullParameter(writtenFiles, (String)"writtenFiles");
            Intrinsics.checkNotNullParameter((Object)conversionErrors, (String)"conversionErrors");
            return new ConvertSarifResult(writtenFiles, hasMultipleRuns, conversionErrors);
        }

        public static /* synthetic */ ConvertSarifResult copy$default(ConvertSarifResult convertSarifResult, List list2, boolean bl, ConversionErrorCount conversionErrorCount, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = convertSarifResult.writtenFiles;
            }
            if ((n & 2) != 0) {
                bl = convertSarifResult.hasMultipleRuns;
            }
            if ((n & 4) != 0) {
                conversionErrorCount = convertSarifResult.conversionErrors;
            }
            return convertSarifResult.copy(list2, bl, conversionErrorCount);
        }

        @NotNull
        public String toString() {
            return "ConvertSarifResult(writtenFiles=" + this.writtenFiles + ", hasMultipleRuns=" + this.hasMultipleRuns + ", conversionErrors=" + this.conversionErrors + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.writtenFiles).hashCode();
            int n = this.hasMultipleRuns ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + this.conversionErrors.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConvertSarifResult)) {
                return false;
            }
            ConvertSarifResult convertSarifResult = (ConvertSarifResult)other;
            if (!Intrinsics.areEqual(this.writtenFiles, convertSarifResult.writtenFiles)) {
                return false;
            }
            if (this.hasMultipleRuns != convertSarifResult.hasMultipleRuns) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.conversionErrors, (Object)convertSarifResult.conversionErrors);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/sarif/QodanaReportConverter$ConversionErrorCount;", "", "numSanityErrors", "", "numPromoErrors", "numAllProblemsErrors", "(III)V", "getNumAllProblemsErrors", "()I", "getNumPromoErrors", "getNumSanityErrors", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "sarif-converter"})
    public static final class ConversionErrorCount {
        private final int numSanityErrors;
        private final int numPromoErrors;
        private final int numAllProblemsErrors;

        public ConversionErrorCount(int numSanityErrors, int numPromoErrors, int numAllProblemsErrors) {
            this.numSanityErrors = numSanityErrors;
            this.numPromoErrors = numPromoErrors;
            this.numAllProblemsErrors = numAllProblemsErrors;
        }

        public final int getNumSanityErrors() {
            return this.numSanityErrors;
        }

        public final int getNumPromoErrors() {
            return this.numPromoErrors;
        }

        public final int getNumAllProblemsErrors() {
            return this.numAllProblemsErrors;
        }

        public final int component1() {
            return this.numSanityErrors;
        }

        public final int component2() {
            return this.numPromoErrors;
        }

        public final int component3() {
            return this.numAllProblemsErrors;
        }

        @NotNull
        public final ConversionErrorCount copy(int numSanityErrors, int numPromoErrors, int numAllProblemsErrors) {
            return new ConversionErrorCount(numSanityErrors, numPromoErrors, numAllProblemsErrors);
        }

        public static /* synthetic */ ConversionErrorCount copy$default(ConversionErrorCount conversionErrorCount, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = conversionErrorCount.numSanityErrors;
            }
            if ((n4 & 2) != 0) {
                n2 = conversionErrorCount.numPromoErrors;
            }
            if ((n4 & 4) != 0) {
                n3 = conversionErrorCount.numAllProblemsErrors;
            }
            return conversionErrorCount.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "ConversionErrorCount(numSanityErrors=" + this.numSanityErrors + ", numPromoErrors=" + this.numPromoErrors + ", numAllProblemsErrors=" + this.numAllProblemsErrors + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.numSanityErrors);
            result2 = result2 * 31 + Integer.hashCode(this.numPromoErrors);
            result2 = result2 * 31 + Integer.hashCode(this.numAllProblemsErrors);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConversionErrorCount)) {
                return false;
            }
            ConversionErrorCount conversionErrorCount = (ConversionErrorCount)other;
            if (this.numSanityErrors != conversionErrorCount.numSanityErrors) {
                return false;
            }
            if (this.numPromoErrors != conversionErrorCount.numPromoErrors) {
                return false;
            }
            return this.numAllProblemsErrors == conversionErrorCount.numAllProblemsErrors;
        }
    }
}

