/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.RichSequence;
import org.jetbrains.annotations.NotNull;

public class Range {
    public static final Range NULL = new Range(Integer.MAX_VALUE, Integer.MIN_VALUE);
    public static final Range EMPTY = new Range(0, 0);
    private final int start;
    private final int end;

    @NotNull
    public static Range of(int start, int end) {
        return start == Range.NULL.start && end == Range.NULL.end ? NULL : new Range(start, end);
    }

    @NotNull
    public static Range emptyOf(int position) {
        return new Range(position, position);
    }

    @NotNull
    public static Range ofLength(int start, int length) {
        return new Range(start, start + length);
    }

    protected Range(int start, int end) {
        this.start = start;
        this.end = end;
    }

    protected @NotNull Range(@NotNull Range other) {
        this.start = other.start;
        this.end = other.end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int component1() {
        return this.start;
    }

    public int component2() {
        return this.end;
    }

    public int getStartOffset() {
        return this.start;
    }

    public int getEndOffset() {
        return this.end;
    }

    public Range withStart(int start) {
        return start == this.start ? this : Range.of(start, this.end);
    }

    public Range withEnd(int end) {
        return end == this.end ? this : Range.of(this.start, end);
    }

    public Range endMinus(int delta) {
        return delta == 0 ? this : Range.of(this.start, this.end - delta);
    }

    public Range endPlus(int delta) {
        return delta == 0 ? this : Range.of(this.start, this.end + delta);
    }

    public Range startMinus(int delta) {
        return delta == 0 ? this : Range.of(this.start - delta, this.end);
    }

    public Range startPlus(int delta) {
        return delta == 0 ? this : Range.of(this.start + delta, this.end);
    }

    public Range withRange(int start, int end) {
        return start == this.start && end == this.end ? this : Range.of(start, end);
    }

    public Range shiftLeft(int delta) {
        return delta == 0 ? this : Range.of(this.start - delta, this.end - delta);
    }

    public Range shiftRight(int delta) {
        return delta == 0 ? this : Range.of(this.start + delta, this.end + delta);
    }

    public int getSpan() {
        return this.isNull() ? 0 : this.end - this.start;
    }

    public boolean isNull() {
        return this.start == Range.NULL.start && this.end == Range.NULL.end;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public boolean isEmpty() {
        return this.start >= this.end;
    }

    public boolean isNotEmpty() {
        return this.start < this.end;
    }

    public boolean contains(@NotNull Range other) {
        return this.end >= other.end && this.start <= other.start;
    }

    public boolean doesContain(@NotNull Range other) {
        return this.end >= other.end && this.start <= other.start;
    }

    public boolean contains(int index) {
        return this.start <= index && index < this.end;
    }

    public boolean doesContain(int index) {
        return this.start <= index && index < this.end;
    }

    public boolean contains(int start, int end) {
        return this.start <= start && end <= this.end;
    }

    public boolean doesContain(int start, int end) {
        return this.start <= start && end <= this.end;
    }

    public boolean overlaps(@NotNull Range other) {
        return other.end > this.start && other.start < this.end;
    }

    public boolean doesOverlap(@NotNull Range other) {
        return other.end > this.start && other.start < this.end;
    }

    public boolean doesNotOverlap(@NotNull Range other) {
        return other.end <= this.start || other.start >= this.end;
    }

    public boolean overlapsOrAdjacent(@NotNull Range other) {
        return other.end >= this.start && other.start <= this.end;
    }

    public boolean doesOverlapOrAdjacent(@NotNull Range other) {
        return other.end >= this.start && other.start <= this.end;
    }

    public boolean doesNotOverlapOrAdjacent(@NotNull Range other) {
        return other.end < this.start || other.start > this.end;
    }

    public boolean doesNotOverlapNorAdjacent(@NotNull Range other) {
        return other.end < this.start || other.start > this.end;
    }

    public boolean properlyContains(@NotNull Range other) {
        return this.end > other.end && this.start < other.start;
    }

    public boolean doesProperlyContain(@NotNull Range other) {
        return this.end > other.end && this.start < other.start;
    }

    public boolean isAdjacent(int index) {
        return index == this.start - 1 || index == this.end;
    }

    public boolean isAdjacentAfter(int index) {
        return this.start - 1 == index;
    }

    public boolean isAdjacentBefore(int index) {
        return this.end == index;
    }

    public boolean isAdjacent(@NotNull Range other) {
        return this.start == other.end || this.end == other.start;
    }

    public boolean isAdjacentBefore(@NotNull Range other) {
        return this.end == other.start;
    }

    public boolean isAdjacentAfter(@NotNull Range other) {
        return this.start == other.end;
    }

    public boolean isContainedBy(@NotNull Range other) {
        return other.end >= this.end && other.start <= this.start;
    }

    public boolean isContainedBy(int start, int end) {
        return end >= this.end && start <= this.start;
    }

    public boolean isProperlyContainedBy(@NotNull Range other) {
        return other.end > this.end && other.start < this.start;
    }

    public boolean isProperlyContainedBy(int start, int end) {
        return end > this.end && start < this.start;
    }

    public boolean isEqual(@NotNull Range other) {
        return this.end == other.end && this.start == other.start;
    }

    public boolean isValidIndex(int index) {
        return index >= this.start && index <= this.end;
    }

    public boolean isStart(int index) {
        return index == this.start;
    }

    public boolean isEnd(int index) {
        return index == this.end;
    }

    public boolean isLast(int index) {
        return index >= this.start && index == this.end - 1;
    }

    public boolean leadBy(int index) {
        return index <= this.start;
    }

    public boolean leads(int index) {
        return this.end <= index;
    }

    public boolean trailedBy(int index) {
        return this.end <= index;
    }

    public boolean trails(int index) {
        return index <= this.start;
    }

    @NotNull
    public Range intersect(@NotNull Range other) {
        int thisEnd;
        int thisStart = Math.max(this.start, other.start);
        if (thisStart >= (thisEnd = Math.min(this.end, other.end))) {
            thisStart = thisEnd;
        }
        return this.withRange(thisStart, thisEnd);
    }

    @NotNull
    public Range exclude(@NotNull Range other) {
        int thisEnd;
        int thisStart = this.start;
        if (thisStart >= other.start && thisStart < other.end) {
            thisStart = other.end;
        }
        if ((thisEnd = this.end) <= other.end && thisEnd > other.start) {
            thisEnd = other.start;
        }
        if (thisStart >= thisEnd) {
            thisEnd = 0;
            thisStart = 0;
        }
        return this.withRange(thisStart, thisEnd);
    }

    public int compare(@NotNull Range other) {
        if (this.start < other.start) {
            return -1;
        }
        if (this.start > other.start) {
            return 1;
        }
        if (this.end > other.end) {
            return -1;
        }
        if (this.end < other.end) {
            return 1;
        }
        return 0;
    }

    @NotNull
    public Range include(@NotNull Range other) {
        return other.isNull() ? (this.isNull() ? NULL : this) : this.expandToInclude(other);
    }

    @NotNull
    public Range include(int pos) {
        return this.include(pos, pos);
    }

    @NotNull
    public Range include(int start, int end) {
        return this.isNull() ? Range.of(start, end) : this.expandToInclude(start, end);
    }

    @NotNull
    public Range expandToInclude(@NotNull Range other) {
        return this.expandToInclude(other.start, other.end);
    }

    @NotNull
    public Range expandToInclude(int start, int end) {
        return this.withRange(Math.min(this.start, start), Math.max(this.end, end));
    }

    @Deprecated
    @NotNull
    public BasedSequence subSequence(@NotNull CharSequence charSequence) {
        return this.basedSubSequence(charSequence);
    }

    @NotNull
    public BasedSequence basedSubSequence(@NotNull CharSequence charSequence) {
        return BasedSequence.of(charSequence).subSequence(this.start, this.end);
    }

    @NotNull
    public BasedSequence basedSafeSubSequence(@NotNull CharSequence charSequence) {
        int end = Math.min(charSequence.length(), this.end);
        return this.isNull() ? BasedSequence.NULL : BasedSequence.of(charSequence).subSequence(Math.min(end, Math.max(0, this.start)), end);
    }

    @NotNull
    public RichSequence richSubSequence(@NotNull CharSequence charSequence) {
        return RichSequence.of(charSequence.subSequence(this.start, this.end));
    }

    @NotNull
    public RichSequence richSafeSubSequence(@NotNull CharSequence charSequence) {
        int end = Math.min(charSequence.length(), this.end);
        return this.isNull() ? RichSequence.NULL : RichSequence.of(charSequence, Math.min(end, Math.max(0, this.start)), end);
    }

    @NotNull
    public CharSequence charSubSequence(@NotNull CharSequence charSequence) {
        return charSequence.subSequence(this.start, this.end);
    }

    @NotNull
    public CharSequence safeSubSequence(@NotNull CharSequence charSequence) {
        int end = Math.min(charSequence.length(), this.end);
        return this.isNull() ? charSequence.subSequence(0, 0) : charSequence.subSequence(Math.min(end, Math.max(0, this.start)), end);
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return this.start == range.start && this.end == range.end;
    }

    public int hashCode() {
        int result2 = this.start;
        result2 = 31 * result2 + this.end;
        return result2;
    }
}

