/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection;

import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyOnWriteRef<T> {
    @Nullable
    private T value;
    private int referenceCount;
    @NotNull
    private final Function<T, T> copyFunction;

    public CopyOnWriteRef(@Nullable T value2, @NotNull Function<T, T> copyFunction) {
        this.value = value2;
        this.referenceCount = 0;
        this.copyFunction = copyFunction;
    }

    @Nullable
    public T getPeek() {
        return this.value;
    }

    @Nullable
    public T getImmutable() {
        if (this.value != null) {
            ++this.referenceCount;
        }
        return this.value;
    }

    @Nullable
    public T getMutable() {
        if (this.referenceCount > 0) {
            this.value = this.copyFunction.apply(this.value);
            this.referenceCount = 0;
        }
        return this.value;
    }

    public void setValue(@Nullable T value2) {
        this.referenceCount = 0;
        this.value = this.copyFunction.apply(value2);
    }

    public boolean isMutable() {
        return this.referenceCount == 0;
    }
}

