/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.layout.BoxRangeData;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.util.XRRuntimeException;
import java.util.LinkedList;
import java.util.List;

public class BoxRangeHelper {
    private LinkedList<BoxRangeData> _clipRegionStack = new LinkedList();
    private OutputDevice _outputDevice;
    private List<BoxRangeData> _rangeList;
    private int _rangeIndex = 0;
    private BoxRangeData _current = null;

    public BoxRangeHelper(OutputDevice outputDevice, List<BoxRangeData> rangeList) {
        this._outputDevice = outputDevice;
        this._rangeList = rangeList;
        if (rangeList.size() > 0) {
            this._current = rangeList.get(0);
        }
    }

    public void checkFinished() {
        if (this._clipRegionStack.size() != 0) {
            throw new XRRuntimeException("internal error");
        }
    }

    public void pushClipRegion(RenderingContext c, int contentIndex) {
        while (this._current != null && this._current.getRange().getStart() == contentIndex) {
            this._current.setClip(this._outputDevice.getClip());
            this._clipRegionStack.add(this._current);
            this._outputDevice.clip(this._current.getBox().getChildrenClipEdge(c));
            if (this._rangeIndex == this._rangeList.size() - 1) {
                this._current = null;
                continue;
            }
            this._current = this._rangeList.get(++this._rangeIndex);
        }
    }

    public void popClipRegions(RenderingContext c, int contentIndex) {
        BoxRangeData data2;
        while (this._clipRegionStack.size() > 0 && (data2 = this._clipRegionStack.getLast()).getRange().getEnd() == contentIndex) {
            this._outputDevice.setClip(data2.getClip());
            this._clipRegionStack.removeLast();
        }
    }
}

