/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.history;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.completion.TerminalShellSupport;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0007H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/exp/history/CommandHistoryManager;", "", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "(Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;)V", "history", "", "", "getHistory", "()Ljava/util/List;", "mutableHistory", "", "initCommandHistory", "", "intellij.terminal"})
public final class CommandHistoryManager {
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final Set<String> mutableHistory;

    public CommandHistoryManager(@NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        Set set = Collections.synchronizedSet(new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(...)");
        this.mutableHistory = set;
        BlockTerminalSession.addCommandListener$default(this.session, new ShellCommandListener(){

            @Override
            public void commandHistoryReceived(@NotNull String history) {
                Intrinsics.checkNotNullParameter((Object)history, (String)"history");
                this.initCommandHistory(history);
            }

            @Override
            public void commandStarted(@NotNull String command) {
                Intrinsics.checkNotNullParameter((Object)command, (String)"command");
                String trimmedCommand = ((Object)StringsKt.trim((CharSequence)command)).toString();
                if (((CharSequence)trimmedCommand).length() > 0) {
                    mutableHistory.remove(trimmedCommand);
                    mutableHistory.add(trimmedCommand);
                }
            }
        }, null, 2, null);
    }

    @NotNull
    public final List<String> getHistory() {
        return CollectionsKt.toList((Iterable)this.mutableHistory);
    }

    private final void initCommandHistory(String history) {
        if (!((Collection)this.mutableHistory).isEmpty()) {
            return;
        }
        TerminalShellSupport terminalShellSupport = TerminalShellSupport.Companion.findByShellType(this.session.getShellIntegration().getShellType());
        if (terminalShellSupport == null) {
            return;
        }
        TerminalShellSupport shellSupport = terminalShellSupport;
        List<String> unsortedHistory = shellSupport.parseCommandHistory(history);
        LinkedHashSet<String> historySet = new LinkedHashSet<String>();
        for (int ind = unsortedHistory.size() - 1; -1 < ind; --ind) {
            historySet.add(unsortedHistory.get(ind));
        }
        List reversedHistory = CollectionsKt.reversed((Iterable)historySet);
        this.mutableHistory.addAll(reversedHistory);
    }
}

