/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.completion;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.terminal.completion.CommandSpecCompletionUtil;
import com.intellij.terminal.completion.ShellArgumentSuggestion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalIcons;
import org.jetbrains.terminal.completion.BaseSuggestion;
import org.jetbrains.terminal.completion.ShellArgument;
import org.jetbrains.terminal.completion.ShellCommand;
import org.jetbrains.terminal.completion.ShellOption;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0016\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0013\u001a\u00020\t*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/TerminalCompletionUtil;", "", "()V", "findIconForSuggestion", "Ljavax/swing/Icon;", "suggestion", "Lorg/jetbrains/terminal/completion/BaseSuggestion;", "getFileIcon", "fileName", "", "getFileOrFolderIcon", "getNextArgumentsString", "args", "", "Lorg/jetbrains/terminal/completion/ShellArgument;", "getNextOptionsAndArgumentsString", "command", "Lorg/jetbrains/terminal/completion/ShellCommand;", "getNextSuggestionsString", "asSuggestionString", "index", "", "findIcon", "Lcom/intellij/terminal/completion/ShellArgumentSuggestion;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalCompletionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCompletionUtil.kt\norg/jetbrains/plugins/terminal/exp/completion/TerminalCompletionUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n766#2:84\n857#2,2:85\n1559#2:87\n1590#2,4:88\n*S KotlinDebug\n*F\n+ 1 TerminalCompletionUtil.kt\norg/jetbrains/plugins/terminal/exp/completion/TerminalCompletionUtil\n*L\n30#1:84\n30#1:85,2\n46#1:87\n46#1:88,4\n*E\n"})
public final class TerminalCompletionUtil {
    @NotNull
    public static final TerminalCompletionUtil INSTANCE = new TerminalCompletionUtil();

    private TerminalCompletionUtil() {
    }

    @NotNull
    public final String getNextSuggestionsString(@NotNull BaseSuggestion suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        BaseSuggestion baseSuggestion = suggestion;
        String result2 = baseSuggestion instanceof ShellCommand ? this.getNextOptionsAndArgumentsString((ShellCommand)suggestion) : (baseSuggestion instanceof ShellOption ? this.getNextArgumentsString(((ShellOption)suggestion).getArgs()) : "");
        return ((CharSequence)result2).length() > 0 ? " " + result2 : "";
    }

    /*
     * WARNING - void declaration
     */
    private final String getNextOptionsAndArgumentsString(ShellCommand command) {
        StringBuilder stringBuilder;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = command.getOptions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ShellOption it = (ShellOption)element$iv$iv;
            boolean bl = false;
            if (!it.isRequired()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nextOptions = (List)destination$iv$iv;
        StringBuilder $this$getNextOptionsAndArgumentsString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (ShellOption option : nextOptions) {
            $this$getNextOptionsAndArgumentsString_u24lambda_u241.append((String)CollectionsKt.first(option.getNames()));
            String arguments = INSTANCE.getNextArgumentsString(option.getArgs());
            if (((CharSequence)arguments).length() > 0) {
                $this$getNextOptionsAndArgumentsString_u24lambda_u241.append(' ');
                $this$getNextOptionsAndArgumentsString_u24lambda_u241.append(arguments);
            }
            $this$getNextOptionsAndArgumentsString_u24lambda_u241.append(' ');
        }
        $this$getNextOptionsAndArgumentsString_u24lambda_u241.append(INSTANCE.getNextArgumentsString(command.getArgs()));
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String getNextArgumentsString(List<ShellArgument> args) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = args;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void arg;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ShellArgument shellArgument = (ShellArgument)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.asSuggestionString((ShellArgument)arg, (int)index));
        }
        List argStrings = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)argStrings, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String asSuggestionString(ShellArgument $this$asSuggestionString, int index) {
        Object object = $this$asSuggestionString.getDisplayName();
        if (object == null) {
            object = "arg" + (index + 1);
        }
        String name = object;
        return $this$asSuggestionString.isOptional() ? "[" + name + "]" : "<" + name + ">";
    }

    @Nullable
    public final Icon findIconForSuggestion(@NotNull BaseSuggestion suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        BaseSuggestion baseSuggestion = suggestion;
        return baseSuggestion instanceof ShellCommand ? TerminalIcons.Command : (baseSuggestion instanceof ShellOption ? TerminalIcons.Option : (baseSuggestion instanceof ShellArgumentSuggestion ? this.findIcon((ShellArgumentSuggestion)suggestion) : null));
    }

    private final Icon findIcon(ShellArgumentSuggestion $this$findIcon) {
        Icon icon;
        if (CommandSpecCompletionUtil.INSTANCE.isFilePath($this$findIcon.getArgument()) || CommandSpecCompletionUtil.INSTANCE.isFolder($this$findIcon.getArgument())) {
            icon = this.getFileOrFolderIcon((String)CollectionsKt.first($this$findIcon.getNames()));
        } else {
            Icon icon2 = TerminalIcons.Other;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Other");
        }
        return icon;
    }

    private final Icon getFileOrFolderIcon(String fileName) {
        Icon icon;
        if (StringsKt.endsWith$default((CharSequence)fileName, (char)File.separatorChar, (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)fileName, (Object)"~") || Intrinsics.areEqual((Object)fileName, (Object)"-")) {
            Icon icon2 = AllIcons.Nodes.Folder;
            Intrinsics.checkNotNull((Object)icon2);
            icon = icon2;
        } else {
            icon = this.getFileIcon(fileName);
        }
        return icon;
    }

    @NotNull
    public final Icon getFileIcon(@NotNull String fileName) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
        FileType fileType2 = fileType;
        Icon icon2 = fileType2.getIcon();
        if (icon2 == null) {
            Icon icon3 = TerminalIcons.OtherFile;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"OtherFile");
        }
        Icon fileIcon = icon2;
        if (fileType2 instanceof UnknownFileType) {
            Icon icon4 = TerminalIcons.OtherFile;
            icon = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"OtherFile");
        } else {
            icon = fileIcon;
        }
        return icon;
    }
}

