/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.EmptyTextAttributesProvider;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.PromptRenderingInfo;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.TerminalPromptState;
import org.jetbrains.plugins.terminal.exp.TerminalPromptStateListener;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtils;
import org.jetbrains.plugins.terminal.exp.TextAttributesProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0015\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u0015\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPromptModel;", "", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "(Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;)V", "listeners", "", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptStateListener;", "<set-?>", "Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;", "renderingInfo", "getRenderingInfo", "()Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;", "addListener", "", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "calculateDirectoryText", "", "Lcom/intellij/openapi/util/NlsSafe;", "directory", "calculateRenderingInfo", "state", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptState;", "getPromptComponents", "", "Lorg/jetbrains/plugins/terminal/exp/TerminalPromptModel$PromptComponentInfo;", "plainAttributes", "Lorg/jetbrains/plugins/terminal/exp/TextAttributesProvider;", "colorIndex", "", "PromptComponentInfo", "intellij.terminal"})
public final class TerminalPromptModel {
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final List<TerminalPromptStateListener> listeners;
    @NotNull
    private PromptRenderingInfo renderingInfo;

    public TerminalPromptModel(@NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.listeners = new CopyOnWriteArrayList();
        this.renderingInfo = new PromptRenderingInfo("", CollectionsKt.emptyList());
        BlockTerminalSession.addCommandListener$default(this.session, new ShellCommandListener(){

            @Override
            public void promptStateUpdated(@NotNull TerminalPromptState newState) {
                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                PromptRenderingInfo updatedInfo = this.calculateRenderingInfo(newState);
                ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, updatedInfo){
                    final /* synthetic */ TerminalPromptModel this$0;
                    final /* synthetic */ PromptRenderingInfo $updatedInfo;
                    {
                        this.this$0 = $receiver;
                        this.$updatedInfo = $updatedInfo;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$forEach$iv;
                        TerminalPromptModel.access$setRenderingInfo$p(this.this$0, this.$updatedInfo);
                        Iterable iterable = TerminalPromptModel.access$getListeners$p(this.this$0);
                        PromptRenderingInfo promptRenderingInfo = this.$updatedInfo;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            TerminalPromptStateListener it = (TerminalPromptStateListener)element$iv;
                            boolean bl = false;
                            it.promptStateUpdated(promptRenderingInfo);
                        }
                    }
                }), (int)1, null);
            }
        }, null, 2, null);
    }

    @RequiresEdt
    @NotNull
    public final PromptRenderingInfo getRenderingInfo() {
        return this.renderingInfo;
    }

    private final PromptRenderingInfo calculateRenderingInfo(TerminalPromptState state) {
        List<PromptComponentInfo> components = this.getPromptComponents(state);
        StringBuilder builder = new StringBuilder();
        List highlightings = new ArrayList();
        for (PromptComponentInfo component2 : components) {
            int startOffset = builder.length();
            builder.append(component2.getText());
            highlightings.add(new HighlightingInfo(startOffset, builder.length(), component2.getAttributesProvider()));
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new PromptRenderingInfo(string, highlightings);
    }

    private final List<PromptComponentInfo> getPromptComponents(TerminalPromptState state) {
        List result2 = new ArrayList();
        TextAttributesProvider greenAttributes = this.plainAttributes(2);
        TextAttributesProvider yellowAttributes = this.plainAttributes(3);
        EmptyTextAttributesProvider defaultAttributes = EmptyTextAttributesProvider.INSTANCE;
        CharSequence charSequence = state.getVirtualEnv();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String string = PathUtil.getFileName((String)state.getVirtualEnv());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            String venvName = string;
            TerminalPromptModel.getPromptComponents$addComponent(result2, "(" + venvName + ")", greenAttributes);
        }
        if (!((charSequence = (CharSequence)state.getCondaEnv()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            TerminalPromptModel.getPromptComponents$addComponent(result2, "(" + state.getCondaEnv() + ")", greenAttributes);
        }
        if (!((Collection)result2).isEmpty()) {
            TerminalPromptModel.getPromptComponents$addComponent(result2, " ", defaultAttributes);
        }
        TerminalPromptModel.getPromptComponents$addComponent(result2, this.calculateDirectoryText(state.getCurrentDirectory()), defaultAttributes);
        charSequence = state.getGitBranch();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            TerminalPromptModel.getPromptComponents$addComponent(result2, " ", defaultAttributes);
            TerminalPromptModel.getPromptComponents$addComponent(result2, "git:", yellowAttributes);
            TerminalPromptModel.getPromptComponents$addComponent(result2, "[" + state.getGitBranch() + "]", greenAttributes);
        }
        return result2;
    }

    private final String calculateDirectoryText(String directory) {
        String string;
        if (!Intrinsics.areEqual((Object)directory, (Object)SystemProperties.getUserHome())) {
            String string2 = FileUtil.getLocationRelativeToUserHome((String)directory, (boolean)false);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = "~";
        }
        return string;
    }

    private final TextAttributesProvider plainAttributes(int colorIndex) {
        return TerminalUiUtils.INSTANCE.plainAttributesProvider(colorIndex, this.session.getColorPalette());
    }

    public final void addListener(@NotNull TerminalPromptStateListener listener, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        TerminalUtil.addItem(this.listeners, listener, disposable);
    }

    private static final void getPromptComponents$addComponent(List<PromptComponentInfo> result2, String text, TextAttributesProvider attributesProvider) {
        result2.add(new PromptComponentInfo(text, attributesProvider));
    }

    public static final /* synthetic */ void access$setRenderingInfo$p(TerminalPromptModel $this, PromptRenderingInfo promptRenderingInfo) {
        $this.renderingInfo = promptRenderingInfo;
    }

    public static final /* synthetic */ List access$getListeners$p(TerminalPromptModel $this) {
        return $this.listeners;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalPromptModel$PromptComponentInfo;", "", "text", "", "attributesProvider", "Lorg/jetbrains/plugins/terminal/exp/TextAttributesProvider;", "(Ljava/lang/String;Lorg/jetbrains/plugins/terminal/exp/TextAttributesProvider;)V", "getAttributesProvider", "()Lorg/jetbrains/plugins/terminal/exp/TextAttributesProvider;", "getText", "()Ljava/lang/String;", "intellij.terminal"})
    private static final class PromptComponentInfo {
        @NotNull
        private final String text;
        @NotNull
        private final TextAttributesProvider attributesProvider;

        public PromptComponentInfo(@NotNull String text, @NotNull TextAttributesProvider attributesProvider) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)attributesProvider, (String)"attributesProvider");
            this.text = text;
            this.attributesProvider = attributesProvider;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final TextAttributesProvider getAttributesProvider() {
            return this.attributesProvider;
        }
    }
}

