/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.ScrollingModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.terminal.BlockTerminalColors;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jediterm.terminal.TextStyle;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.BlockTerminalEventsHandler;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.CommandBlockInfo;
import org.jetbrains.plugins.terminal.exp.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.PromptRenderingInfo;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.ShellCommandOutputListener;
import org.jetbrains.plugins.terminal.exp.ShellCommandOutputScraper;
import org.jetbrains.plugins.terminal.exp.StyleRange;
import org.jetbrains.plugins.terminal.exp.StyledCommandOutput;
import org.jetbrains.plugins.terminal.exp.TerminalBlocksDecorator;
import org.jetbrains.plugins.terminal.exp.TerminalCaretModel;
import org.jetbrains.plugins.terminal.exp.TerminalCaretPainter;
import org.jetbrains.plugins.terminal.exp.TerminalDataContextUtils;
import org.jetbrains.plugins.terminal.exp.TerminalEventDispatcherKt;
import org.jetbrains.plugins.terminal.exp.TerminalFocusModel;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalOutputController;
import org.jetbrains.plugins.terminal.exp.TerminalOutputModel;
import org.jetbrains.plugins.terminal.exp.TerminalSelectionModel;
import org.jetbrains.plugins.terminal.exp.TerminalTextHighlighter;
import org.jetbrains.plugins.terminal.exp.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.exp.TextAttributesKeyAdapter;
import org.jetbrains.plugins.terminal.exp.TextAttributesProvider;
import org.jetbrains.plugins.terminal.exp.TextStyleAdapter;
import org.jetbrains.plugins.terminal.exp.hyperlinks.TerminalHyperlinkHighlighter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 Z2\u00020\u0001:\u0004YZ[\\B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+J$\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u00100\u001a\u000201H\u0002J\u0015\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u000204H\u0001\u00a2\u0006\u0002\b5J.\u00106\u001a\u00020\u00162\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010;\u001a\u000204H\u0002J\u0010\u0010<\u001a\u00020.2\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010=\u001a\u0002082\u0006\u0010>\u001a\u00020\u001cH\u0002J\b\u0010?\u001a\u00020\u0016H\u0003J\u0016\u0010@\u001a\u00020\u00162\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0007J!\u0010B\u001a\u0002HC\"\u0004\b\u0000\u0010C2\f\u0010D\u001a\b\u0012\u0004\u0012\u0002HC0\u0015H\u0003\u00a2\u0006\u0002\u0010EJ\u000e\u0010F\u001a\u00020\u00162\u0006\u0010G\u001a\u000201J\b\u0010H\u001a\u00020\u0016H\u0007J\u0012\u0010I\u001a\u00020\u00162\b\u0010J\u001a\u0004\u0018\u00010:H\u0003J\b\u0010K\u001a\u00020\u0016H\u0007J\u0010\u0010L\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+H\u0002J\u001c\u0010M\u001a\u00020\u00162\b\u0010J\u001a\u0004\u0018\u00010:2\b\u0010N\u001a\u0004\u0018\u00010OH\u0007J\u0018\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\u0006\u00100\u001a\u000201H\u0002J\u0018\u0010T\u001a\u00020\u00162\u0006\u00107\u001a\u0002082\u0006\u0010R\u001a\u00020QH\u0002J\u0010\u0010U\u001a\u0002082\u0006\u0010R\u001a\u00020SH\u0003J\f\u0010V\u001a\u00020W*\u00020XH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0018\u00010\u001eR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController;", "Lorg/jetbrains/plugins/terminal/exp/TerminalModel$TerminalListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "focusModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lorg/jetbrains/plugins/terminal/exp/TerminalFocusModel;)V", "blockCreationAlarm", "Lcom/intellij/util/Alarm;", "blocksDecorator", "Lorg/jetbrains/plugins/terminal/exp/TerminalBlocksDecorator;", "hyperlinkHighlighter", "Lorg/jetbrains/plugins/terminal/exp/hyperlinks/TerminalHyperlinkHighlighter;", "nextBlockCanBeStartedQueue", "Ljava/util/Queue;", "Lkotlin/Function0;", "", "outputModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "getOutputModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "runningCommandContext", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$RunningCommandContext;", "runningCommandInteractivity", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$RunningCommandInteractivity;", "scraper", "Lorg/jetbrains/plugins/terminal/exp/ShellCommandOutputScraper;", "selectionModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;", "getSelectionModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalSelectionModel;", "textHighlighter", "Lorg/jetbrains/plugins/terminal/exp/TerminalTextHighlighter;", "addDocumentListener", "listener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "disposable", "Lcom/intellij/openapi/Disposable;", "adjustHighlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "highlightings", "baseOffset", "", "alternateBufferStateChanged", "enabled", "", "alternateBufferStateChanged$intellij_terminal", "appendLineToBlock", "block", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "text", "", "addTrailingNewLine", "createCommandHighlighting", "createNewBlock", "context", "disposeRunningCommandInteractivity", "doWhenNextBlockCanBeStarted", "callback", "doWithScrollingAware", "T", "action", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "finishCommandBlock", "exitCode", "insertEmptyLine", "installRunningCommandInteractivity", "command", "scrollToBottom", "setupContentListener", "startCommandBlock", "prompt", "Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;", "toHighlightedCommandOutput", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$CommandOutput;", "output", "Lorg/jetbrains/plugins/terminal/exp/StyledCommandOutput;", "updateBlock", "updateCommandOutput", "toTextAttributesProvider", "Lorg/jetbrains/plugins/terminal/exp/TextAttributesProvider;", "Lcom/jediterm/terminal/TextStyle;", "CommandOutput", "Companion", "RunningCommandContext", "RunningCommandInteractivity", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputController.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputController\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,316:1\n9#2:317\n1#3:318\n1549#4:319\n1620#4,3:320\n1549#4:323\n1620#4,3:324\n*S KotlinDebug\n*F\n+ 1 TerminalOutputController.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputController\n*L\n147#1:317\n204#1:319\n204#1:320,3\n273#1:323\n273#1:324,3\n*E\n"})
public final class TerminalOutputController
implements TerminalModel.TerminalListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalSelectionModel selectionModel;
    @NotNull
    private final ShellCommandOutputScraper scraper;
    @NotNull
    private final TerminalBlocksDecorator blocksDecorator;
    @NotNull
    private final TerminalTextHighlighter textHighlighter;
    @NotNull
    private final Alarm blockCreationAlarm;
    @Nullable
    private RunningCommandContext runningCommandContext;
    @Nullable
    private RunningCommandInteractivity runningCommandInteractivity;
    @NotNull
    private final TerminalHyperlinkHighlighter hyperlinkHighlighter;
    @NotNull
    private final Queue<Function0<Unit>> nextBlockCanBeStartedQueue;
    @NotNull
    private static final DataKey<TerminalOutputController> KEY;

    public TerminalOutputController(@NotNull Project project, @NotNull EditorEx editor, @NotNull BlockTerminalSession session2, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalFocusModel focusModel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)focusModel, (String)"focusModel");
        this.editor = editor;
        this.session = session2;
        this.settings = settings;
        this.outputModel = new TerminalOutputModel(this.editor);
        this.selectionModel = new TerminalSelectionModel(this.outputModel);
        this.scraper = new ShellCommandOutputScraper(this.session);
        this.blocksDecorator = new TerminalBlocksDecorator(this.session.getColorPalette(), this.outputModel, focusModel, this.selectionModel, this.editor);
        this.textHighlighter = new TerminalTextHighlighter(this.outputModel);
        this.blockCreationAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.session);
        this.hyperlinkHighlighter = new TerminalHyperlinkHighlighter(project, this.outputModel, this.session);
        this.nextBlockCanBeStartedQueue = new LinkedList();
        this.editor.putUserData(TerminalDataContextUtils.INSTANCE.getIS_OUTPUT_EDITOR_KEY(), (Object)true);
        this.editor.setHighlighter((EditorHighlighter)this.textHighlighter);
        TerminalModel.addTerminalListener$default(this.session.getModel(), this, null, 2, null);
        BlockTerminalSession.addCommandListener$default(this.session, new ShellCommandListener(){

            @Override
            public void clearInvoked() {
                Disposable disposable = Disposer.newDisposable();
                Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
                Disposable disposable2 = disposable;
                session.addCommandListener(new ShellCommandListener(this, disposable2){
                    final /* synthetic */ TerminalOutputController this$0;
                    final /* synthetic */ Disposable $disposable;
                    {
                        this.this$0 = $receiver;
                        this.$disposable = $disposable;
                    }

                    public void commandFinished(@NotNull CommandFinishedEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Function0<Boolean> function0 = TerminalUiUtilsKt.getDisposed((Editor)TerminalOutputController.access$getEditor$p(this.this$0));
                        ModalityState modalityState = ModalityState.any();
                        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                        TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> clearInvoked.1.commandFinished$lambda$0(this.this$0));
                        Disposer.dispose((Disposable)this.$disposable);
                    }

                    private static final void commandFinished$lambda$0(TerminalOutputController this$0) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        this$0.getOutputModel().clearBlocks();
                    }
                }, disposable2);
            }
        }, null, 2, null);
    }

    @NotNull
    public final TerminalOutputModel getOutputModel() {
        return this.outputModel;
    }

    @NotNull
    public final TerminalSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @RequiresEdt
    public final void startCommandBlock(@Nullable String command, @Nullable PromptRenderingInfo prompt) {
        this.scrollToBottom();
        this.installRunningCommandInteractivity(command);
        this.runningCommandContext = new RunningCommandContext(command, prompt);
        Function0 createBlockRequest2 = (Function0)new Function0<Unit>(this){
            final /* synthetic */ TerminalOutputController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                TerminalOutputController.access$doWithScrollingAware(this.this$0, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ TerminalOutputController this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        RunningCommandContext runningCommandContext = TerminalOutputController.access$getRunningCommandContext$p(this.this$0);
                        if (runningCommandContext == null) {
                            throw new IllegalStateException("No running command context".toString());
                        }
                        RunningCommandContext context = runningCommandContext;
                        TerminalOutputController.access$createNewBlock(this.this$0, context);
                    }
                });
            }
        };
        this.blockCreationAlarm.addRequest(() -> TerminalOutputController.startCommandBlock$lambda$0(createBlockRequest2), 200);
    }

    @RequiresEdt(generateAssertion=false)
    private final void installRunningCommandInteractivity(String command) {
        if (!(this.runningCommandInteractivity == null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.runningCommandInteractivity = new RunningCommandInteractivity(command);
    }

    @RequiresEdt(generateAssertion=false)
    private final void disposeRunningCommandInteractivity() {
        if (!(this.runningCommandInteractivity != null)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        RunningCommandInteractivity runningCommandInteractivity = this.runningCommandInteractivity;
        Intrinsics.checkNotNull((Object)runningCommandInteractivity);
        Disposer.dispose((Disposable)runningCommandInteractivity.getDisposable());
        this.runningCommandInteractivity = null;
    }

    public final void finishCommandBlock(int exitCode) {
        StyledCommandOutput output = this.scraper.scrapeOutput();
        Function0<Boolean> function0 = TerminalUiUtilsKt.getDisposed((Editor)this.editor);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> TerminalOutputController.finishCommandBlock$lambda$1(this, exitCode, output));
    }

    @RequiresEdt
    public final void insertEmptyLine() {
        this.editor.getDocument().insertString(this.editor.getDocument().getTextLength(), (CharSequence)"\n");
        this.scrollToBottom();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void scrollToBottom() {
        ScrollingModelEx scrollingModelEx = this.editor.getScrollingModel();
        Intrinsics.checkNotNullExpressionValue((Object)scrollingModelEx, (String)"getScrollingModel(...)");
        ScrollingModelEx scrollingModel = scrollingModelEx;
        scrollingModel.disableAnimation();
        try {
            Rectangle rectangle = this.editor.getScrollingModel().getVisibleArea();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
            Rectangle visibleArea = rectangle;
            scrollingModel.scrollVertically(this.editor.getContentComponent().getHeight() - visibleArea.height);
        }
        finally {
            scrollingModel.enableAnimation();
        }
    }

    @RequiresEdt(generateAssertion=false)
    public final void alternateBufferStateChanged$intellij_terminal(boolean enabled) {
        block2: {
            RunningCommandContext runningCommandContext;
            block1: {
                if (this.runningCommandContext == null) {
                    TerminalOutputController $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(TerminalOutputController.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Alternate screen buffer changed (" + enabled + "), but no running command");
                }
                if (!enabled) break block1;
                if (this.runningCommandInteractivity == null) break block2;
                this.disposeRunningCommandInteractivity();
                break block2;
            }
            RunningCommandContext it = runningCommandContext = this.runningCommandContext;
            boolean bl = false;
            RunningCommandContext runningCommandContext2 = this.runningCommandInteractivity == null ? runningCommandContext : null;
            if (runningCommandContext2 == null) break block2;
            it = runningCommandContext2;
            boolean bl2 = false;
            this.installRunningCommandInteractivity(it.getCommand());
        }
    }

    private final void setupContentListener(Disposable disposable) {
        this.scraper.addListener(new ShellCommandOutputListener(this){
            final /* synthetic */ TerminalOutputController this$0;
            {
                this.this$0 = $receiver;
            }

            public void commandOutputChanged(@NotNull StyledCommandOutput output) {
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                Function0<Boolean> function0 = TerminalUiUtilsKt.getDisposed((Editor)TerminalOutputController.access$getEditor$p(this.this$0));
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                TerminalUiUtilsKt.invokeLater(function0, modalityState, () -> setupContentListener.1.commandOutputChanged$lambda$0(this.this$0, output));
            }

            private static final void commandOutputChanged$lambda$0(TerminalOutputController this$0, StyledCommandOutput $output) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$output, (String)"$output");
                if (TerminalOutputController.access$getRunningCommandContext$p(this$0) != null) {
                    TerminalOutputController.access$doWithScrollingAware(this$0, (Function0)new Function0<CommandBlock>(this$0, $output){
                        final /* synthetic */ TerminalOutputController this$0;
                        final /* synthetic */ StyledCommandOutput $output;
                        {
                            this.this$0 = $receiver;
                            this.$output = $output;
                            super(0);
                        }

                        @NotNull
                        public final CommandBlock invoke() {
                            return TerminalOutputController.access$updateCommandOutput(this.this$0, this.$output);
                        }
                    });
                }
            }
        }, disposable, true);
    }

    @RequiresEdt(generateAssertion=false)
    private final CommandBlock updateCommandOutput(StyledCommandOutput output) {
        CommandBlock commandBlock = this.outputModel.getActiveBlock();
        if (commandBlock == null) {
            TerminalOutputController $this$updateCommandOutput_u24lambda_u244 = this;
            boolean bl = false;
            $this$updateCommandOutput_u24lambda_u244.blockCreationAlarm.cancelAllRequests();
            RunningCommandContext runningCommandContext = $this$updateCommandOutput_u24lambda_u244.runningCommandContext;
            if (runningCommandContext == null) {
                throw new IllegalStateException("No running command context".toString());
            }
            RunningCommandContext context = runningCommandContext;
            commandBlock = $this$updateCommandOutput_u24lambda_u244.createNewBlock(context);
        }
        CommandBlock activeBlock = commandBlock;
        this.updateBlock(activeBlock, this.toHighlightedCommandOutput(output, activeBlock.getOutputStartOffset()));
        return activeBlock;
    }

    private final CommandBlock createNewBlock(RunningCommandContext context) {
        CommandBlock block2 = this.outputModel.createBlock(context.getCommand(), context.getPrompt());
        if (block2.getWithPrompt()) {
            PromptRenderingInfo promptRenderingInfo = block2.getPrompt();
            Intrinsics.checkNotNull((Object)promptRenderingInfo);
            List<HighlightingInfo> highlightings = this.adjustHighlightings(promptRenderingInfo.getHighlightings(), block2.getStartOffset());
            this.appendLineToBlock(block2, block2.getPrompt().getText(), highlightings, block2.getWithCommand());
        }
        if (block2.getWithCommand()) {
            String string = context.getCommand();
            Intrinsics.checkNotNull((Object)string);
            this.appendLineToBlock(block2, string, CollectionsKt.listOf((Object)this.createCommandHighlighting(block2)), false);
        }
        if (block2.getWithPrompt() || block2.getWithCommand()) {
            this.blocksDecorator.installDecoration(block2);
        }
        return block2;
    }

    /*
     * WARNING - void declaration
     */
    private final CommandOutput toHighlightedCommandOutput(StyledCommandOutput output, int baseOffset) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = output.getStyleRanges();
        String string = output.getText();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StyleRange styleRange = (StyleRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HighlightingInfo(baseOffset + it.getStartOffset(), baseOffset + it.getEndOffset(), this.toTextAttributesProvider(it.getStyle())));
        }
        List list = (List)destination$iv$iv;
        String string2 = string;
        return new CommandOutput(string2, list);
    }

    private final void updateBlock(CommandBlock block2, CommandOutput output) {
        block6: {
            Object object;
            String string;
            List list;
            if (block2.getWithPrompt() || block2.getWithCommand()) {
                List list2;
                List highlightings = list2 = CollectionsKt.toMutableList((Collection)output.getHighlightings());
                boolean bl = false;
                if (block2.getWithCommand()) {
                    highlightings.add(0, this.createCommandHighlighting(block2));
                }
                if (block2.getWithPrompt()) {
                    PromptRenderingInfo promptRenderingInfo = block2.getPrompt();
                    Intrinsics.checkNotNull((Object)promptRenderingInfo);
                    highlightings.addAll(0, (Collection)this.adjustHighlightings(promptRenderingInfo.getHighlightings(), block2.getStartOffset()));
                }
                list = list2;
            } else {
                list = output.getHighlightings();
            }
            List highlightings = list;
            this.outputModel.putHighlightings(block2, highlightings);
            String it = string = "\n";
            boolean bl = false;
            String string2 = block2.getWithPrompt() || block2.getWithCommand() ? string : null;
            if (string2 == null) {
                string2 = "";
            }
            String prefix = string2;
            this.editor.getDocument().replaceString(block2.getOutputStartOffset() - prefix.length(), block2.getEndOffset(), (CharSequence)(prefix + output.getText()));
            this.outputModel.trimOutput();
            this.hyperlinkHighlighter.highlightHyperlinks(block2);
            if (!StringsKt.isBlank((CharSequence)output.getText()) && !Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)output.getText())).toString(), (Object)"%")) {
                this.blocksDecorator.installDecoration(block2);
            }
            if ((object = this.runningCommandInteractivity) == null || (object = ((RunningCommandInteractivity)object).getCaretPainter()) == null) break block6;
            ((TerminalCaretPainter)object).repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt(generateAssertion=false)
    private final <T> T doWithScrollingAware(Function0<? extends T> action) {
        Rectangle it = this.editor.getScrollingModel().getVisibleArea();
        boolean bl = false;
        boolean wasAtBottom = it.y + it.height == this.editor.getContentComponent().getHeight();
        try {
            Object object = action.invoke();
            return (T)object;
        }
        finally {
            if (wasAtBottom) {
                this.scrollToBottom();
            }
        }
    }

    private final TextAttributesProvider toTextAttributesProvider(TextStyle $this$toTextAttributesProvider) {
        return new TextStyleAdapter($this$toTextAttributesProvider, this.session.getColorPalette());
    }

    private final void appendLineToBlock(CommandBlock block2, String text, List<HighlightingInfo> highlightings, boolean addTrailingNewLine) {
        List list = this.outputModel.getHighlightings(block2);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List existingHighlightings = list;
        this.outputModel.putHighlightings(block2, CollectionsKt.plus((Collection)existingHighlightings, (Iterable)highlightings));
        this.editor.getDocument().insertString(block2.getEndOffset(), (CharSequence)(addTrailingNewLine ? text + "\n" : text));
    }

    private final HighlightingInfo createCommandHighlighting(CommandBlock block2) {
        int n = block2.getCommandStartOffset();
        int n2 = block2.getCommandStartOffset();
        String string = block2.getCommand();
        Intrinsics.checkNotNull((Object)string);
        return new HighlightingInfo(n, n2 + string.length(), new TextAttributesKeyAdapter((Editor)this.editor, BlockTerminalColors.COMMAND));
    }

    /*
     * WARNING - void declaration
     */
    private final List<HighlightingInfo> adjustHighlightings(List<HighlightingInfo> highlightings, int baseOffset) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = highlightings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HighlightingInfo highlightingInfo = (HighlightingInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new HighlightingInfo(baseOffset + it.getStartOffset(), baseOffset + it.getEndOffset(), it.getTextAttributesProvider()));
        }
        return (List)destination$iv$iv;
    }

    public final void addDocumentListener(@NotNull DocumentListener listener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (disposable != null) {
            this.editor.getDocument().addDocumentListener(listener, disposable);
        } else {
            this.editor.getDocument().addDocumentListener(listener);
        }
    }

    public static /* synthetic */ void addDocumentListener$default(TerminalOutputController terminalOutputController, DocumentListener documentListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalOutputController.addDocumentListener(documentListener, disposable);
    }

    @RequiresEdt
    public final void doWhenNextBlockCanBeStarted(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (this.runningCommandContext == null && this.outputModel.getActiveBlock() == null) {
            callback.invoke();
        } else {
            this.nextBlockCanBeStartedQueue.offer(callback);
        }
    }

    private static final void startCommandBlock$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    private static final void finishCommandBlock$lambda$1(TerminalOutputController this$0, int $exitCode, StyledCommandOutput $output) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$output, (String)"$output");
            CommandBlock block2 = (CommandBlock)this$0.doWithScrollingAware((Function0)new Function0<CommandBlock>(this$0, $output){
                final /* synthetic */ TerminalOutputController this$0;
                final /* synthetic */ StyledCommandOutput $output;
                {
                    this.this$0 = $receiver;
                    this.$output = $output;
                    super(0);
                }

                @NotNull
                public final CommandBlock invoke() {
                    return TerminalOutputController.access$updateCommandOutput(this.this$0, this.$output);
                }
            });
            this$0.disposeRunningCommandInteractivity();
            DocumentEx documentEx = this$0.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            DocumentEx document = documentEx;
            int lastLineInd = document.getLineNumber(block2.getEndOffset());
            int lastLineStart = document.getLineStartOffset(lastLineInd);
            String string = document.getText(new TextRange(lastLineStart, block2.getEndOffset()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String lastLineText = string;
            if (StringsKt.isBlank((CharSequence)lastLineText)) {
                int startRemoveOffset = lastLineStart - (lastLineStart > 0 ? 1 : 0);
                this$0.outputModel.deleteDocumentRange(block2, new TextRange(startRemoveOffset, block2.getEndOffset()));
            }
            String string2 = document.getText(block2.getTextRange());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string2)) {
                this$0.outputModel.removeBlock(block2);
            } else {
                this$0.outputModel.setBlockInfo(block2, new CommandBlockInfo($exitCode));
                this$0.outputModel.finalizeBlock$intellij_terminal(block2);
            }
            this$0.runningCommandContext = null;
            Function0<Unit> function0 = this$0.nextBlockCanBeStartedQueue.poll();
            if (function0 == null) break block3;
            function0.invoke();
        }
    }

    public static final /* synthetic */ Object access$doWithScrollingAware(TerminalOutputController $this, Function0 action) {
        return $this.doWithScrollingAware(action);
    }

    public static final /* synthetic */ RunningCommandContext access$getRunningCommandContext$p(TerminalOutputController $this) {
        return $this.runningCommandContext;
    }

    public static final /* synthetic */ CommandBlock access$createNewBlock(TerminalOutputController $this, RunningCommandContext context) {
        return $this.createNewBlock(context);
    }

    public static final /* synthetic */ CommandBlock access$updateCommandOutput(TerminalOutputController $this, StyledCommandOutput output) {
        return $this.updateCommandOutput(output);
    }

    static {
        DataKey dataKey = DataKey.create((String)"TerminalOutputController");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create(...)");
        KEY = dataKey;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$CommandOutput;", "", "text", "", "highlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "(Ljava/lang/String;Ljava/util/List;)V", "getHighlightings", "()Ljava/util/List;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class CommandOutput {
        @NotNull
        private final String text;
        @NotNull
        private final List<HighlightingInfo> highlightings;

        public CommandOutput(@NotNull String text, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            this.text = text;
            this.highlightings = highlightings;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final List<HighlightingInfo> getHighlightings() {
            return this.highlightings;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final List<HighlightingInfo> component2() {
            return this.highlightings;
        }

        @NotNull
        public final CommandOutput copy(@NotNull String text, @NotNull List<HighlightingInfo> highlightings) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
            return new CommandOutput(text, highlightings);
        }

        public static /* synthetic */ CommandOutput copy$default(CommandOutput commandOutput, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = commandOutput.text;
            }
            if ((n & 2) != 0) {
                list = commandOutput.highlightings;
            }
            return commandOutput.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "CommandOutput(text=" + this.text + ", highlightings=" + this.highlightings + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + ((Object)this.highlightings).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandOutput)) {
                return false;
            }
            CommandOutput commandOutput = (CommandOutput)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)commandOutput.text)) {
                return false;
            }
            return Intrinsics.areEqual(this.highlightings, commandOutput.highlightings);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalOutputController> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J!\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$RunningCommandContext;", "", "command", "", "prompt", "Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;", "(Ljava/lang/String;Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;)V", "getCommand", "()Ljava/lang/String;", "getPrompt", "()Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class RunningCommandContext {
        @Nullable
        private final String command;
        @Nullable
        private final PromptRenderingInfo prompt;

        public RunningCommandContext(@Nullable String command, @Nullable PromptRenderingInfo prompt) {
            this.command = command;
            this.prompt = prompt;
        }

        @Nullable
        public final String getCommand() {
            return this.command;
        }

        @Nullable
        public final PromptRenderingInfo getPrompt() {
            return this.prompt;
        }

        @Nullable
        public final String component1() {
            return this.command;
        }

        @Nullable
        public final PromptRenderingInfo component2() {
            return this.prompt;
        }

        @NotNull
        public final RunningCommandContext copy(@Nullable String command, @Nullable PromptRenderingInfo prompt) {
            return new RunningCommandContext(command, prompt);
        }

        public static /* synthetic */ RunningCommandContext copy$default(RunningCommandContext runningCommandContext, String string, PromptRenderingInfo promptRenderingInfo, int n, Object object) {
            if ((n & 1) != 0) {
                string = runningCommandContext.command;
            }
            if ((n & 2) != 0) {
                promptRenderingInfo = runningCommandContext.prompt;
            }
            return runningCommandContext.copy(string, promptRenderingInfo);
        }

        @NotNull
        public String toString() {
            return "RunningCommandContext(command=" + this.command + ", prompt=" + this.prompt + ")";
        }

        public int hashCode() {
            int result2 = this.command == null ? 0 : this.command.hashCode();
            result2 = result2 * 31 + (this.prompt == null ? 0 : this.prompt.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RunningCommandContext)) {
                return false;
            }
            RunningCommandContext runningCommandContext = (RunningCommandContext)other;
            if (!Intrinsics.areEqual((Object)this.command, (Object)runningCommandContext.command)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.prompt, (Object)runningCommandContext.prompt);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController$RunningCommandInteractivity;", "", "command", "", "(Lorg/jetbrains/plugins/terminal/exp/TerminalOutputController;Ljava/lang/String;)V", "caretModel", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel;", "getCaretModel", "()Lorg/jetbrains/plugins/terminal/exp/TerminalCaretModel;", "caretPainter", "Lorg/jetbrains/plugins/terminal/exp/TerminalCaretPainter;", "getCaretPainter", "()Lorg/jetbrains/plugins/terminal/exp/TerminalCaretPainter;", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "intellij.terminal"})
    private final class RunningCommandInteractivity {
        @NotNull
        private final Disposable disposable;
        @NotNull
        private final TerminalCaretModel caretModel;
        @NotNull
        private final TerminalCaretPainter caretPainter;

        public RunningCommandInteractivity(String command) {
            Disposable disposable = Disposer.newDisposable((Disposable)TerminalOutputController.this.session, (String)("command " + command));
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            this.disposable = disposable;
            this.caretModel = new TerminalCaretModel(TerminalOutputController.this.session, TerminalOutputController.this.getOutputModel(), TerminalOutputController.this.editor, this.disposable);
            this.caretPainter = new TerminalCaretPainter(this.caretModel, TerminalOutputController.this.getOutputModel(), TerminalOutputController.this.getSelectionModel(), TerminalOutputController.this.editor);
            Disposer.register((Disposable)this.disposable, (Disposable)this.caretPainter);
            BlockTerminalEventsHandler eventsHandler = new BlockTerminalEventsHandler(TerminalOutputController.this.session, TerminalOutputController.this.settings, TerminalOutputController.this);
            TerminalEventDispatcherKt.setupKeyEventDispatcher(TerminalOutputController.this.editor, TerminalOutputController.this.settings, eventsHandler, TerminalOutputController.this.getOutputModel(), TerminalOutputController.this.getSelectionModel(), this.disposable);
            TerminalEventDispatcherKt.setupMouseListener(TerminalOutputController.this.editor, TerminalOutputController.this.settings, TerminalOutputController.this.session.getModel(), eventsHandler, this.disposable);
            TerminalOutputController.this.setupContentListener(this.disposable);
        }

        @NotNull
        public final Disposable getDisposable() {
            return this.disposable;
        }

        @NotNull
        public final TerminalCaretModel getCaretModel() {
            return this.caretModel;
        }

        @NotNull
        public final TerminalCaretPainter getCaretPainter() {
            return this.caretPainter;
        }
    }
}

