/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.imports.PyImportOptimizer;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import com.jetbrains.python.refactoring.classes.extractSuperclass.PyExtractSuperclassHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyClassRefactoringUtil {
    private static final Logger LOG = Logger.getInstance((String)PyClassRefactoringUtil.class.getName());
    private static final Key<PsiNamedElement> ENCODED_IMPORT = Key.create((String)"PyEncodedImport");
    private static final Key<Boolean> ENCODED_USE_FROM_IMPORT = Key.create((String)"PyEncodedUseFromImport");
    private static final Key<String> ENCODED_IMPORT_AS = Key.create((String)"PyEncodedImportAs");
    private static final Key<List<PyReferenceExpression>> INJECTION_REFERENCES = Key.create((String)"PyInjectionReferences");
    private static final Key<Set<FutureFeature>> ENCODED_FROM_FUTURE_IMPORTS = Key.create((String)"PyFromFutureImports");

    private PyClassRefactoringUtil() {
    }

    @NotNull
    public static List<PyAssignmentStatement> copyFieldDeclarationToStatement(@NotNull Collection<? extends PyAssignmentStatement> assignmentStatements, @NotNull PyStatementList superClassStatement, @Nullable PyClass dequalifyIfDeclaredInClass) {
        if (assignmentStatements == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (superClassStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(1);
        }
        ArrayList<PyAssignmentStatement> declarations = new ArrayList<PyAssignmentStatement>(assignmentStatements.size());
        for (PyAssignmentStatement pyAssignmentStatement : assignmentStatements) {
            PyExpression value = pyAssignmentStatement.getAssignedValue();
            PyAssignmentStatement newDeclaration = (PyAssignmentStatement)pyAssignmentStatement.copy();
            if (value instanceof PyReferenceExpression && dequalifyIfDeclaredInClass != null) {
                String newValue = PyClassRefactoringUtil.getNewValueToAssign((PyReferenceExpression)value, dequalifyIfDeclaredInClass);
                PyClassRefactoringUtil.setNewAssigneeValue(newDeclaration, newValue);
            }
            declarations.add(PyPsiRefactoringUtil.addElementToStatementList(newDeclaration, superClassStatement));
            PyPsiUtils.removeRedundantPass(superClassStatement);
        }
        ArrayList<PyAssignmentStatement> arrayList = declarations;
        if (arrayList == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void setNewAssigneeValue(@NotNull PyAssignmentStatement assignmentStatement, @NotNull String newValue) {
        if (assignmentStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(3);
        }
        if (newValue == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(4);
        }
        PyExpression oldValue = assignmentStatement.getAssignedValue();
        PyExpression newExpression = PyElementGenerator.getInstance(assignmentStatement.getProject()).createExpressionFromText(LanguageLevel.forElement(assignmentStatement), newValue);
        if (oldValue != null) {
            oldValue.replace((PsiElement)newExpression);
        } else {
            assignmentStatement.add((PsiElement)newExpression);
        }
    }

    @NotNull
    private static String getNewValueToAssign(@NotNull PyReferenceExpression currentValue, @NotNull PyClass dequalifyIfDeclaredInClass) {
        PyExpression qualifier;
        if (currentValue == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(5);
        }
        if (dequalifyIfDeclaredInClass == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(6);
        }
        if ((qualifier = currentValue.getQualifier()) instanceof PyReferenceExpression && ((PyReferenceExpression)qualifier).getReference().isReferenceTo((PsiElement)dequalifyIfDeclaredInClass)) {
            String name2 = currentValue.getName();
            String string = name2 != null ? name2 : currentValue.getText();
            if (string == null) {
                PyClassRefactoringUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = currentValue.getText();
        if (string == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static List<PyFunction> addMethods(@NotNull PyClass destination, boolean skipIfExist, PyFunction ... methods) {
        if (destination == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(9);
        }
        if (methods == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(10);
        }
        PyStatementList destStatementList = destination.getStatementList();
        ArrayList<PyFunction> result2 = new ArrayList<PyFunction>(methods.length);
        for (PyFunction method : methods) {
            PyFunction existingMethod = destination.findMethodByName(method.getName(), false, null);
            if (existingMethod != null && skipIfExist) {
                result2.add(existingMethod);
                continue;
            }
            result2.add(PyClassRefactoringUtil.insertMethodInProperPlace(destStatementList, method));
        }
        PyPsiUtils.removeRedundantPass(destStatementList);
        ArrayList<PyFunction> arrayList = result2;
        if (arrayList == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static PyFunction insertMethodInProperPlace(@NotNull PyStatementList destStatementList, @NotNull PyFunction method) {
        boolean methodIsInit;
        if (destStatementList == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(12);
        }
        if (method == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(13);
        }
        if (!(methodIsInit = "__init__".equals(method.getName()))) {
            PyFunction pyFunction = (PyFunction)destStatementList.add(method);
            if (pyFunction == null) {
                PyClassRefactoringUtil.$$$reportNull$$$0(14);
            }
            return pyFunction;
        }
        for (PsiElement element : destStatementList.getChildren()) {
            boolean elementComment = element instanceof PyExpressionStatement;
            boolean elementClassField = element instanceof PyAssignmentStatement;
            if (elementComment || elementClassField) continue;
            PyFunction pyFunction = (PyFunction)destStatementList.addBefore(method, element);
            if (pyFunction == null) {
                PyClassRefactoringUtil.$$$reportNull$$$0(15);
            }
            return pyFunction;
        }
        PyFunction pyFunction = (PyFunction)destStatementList.add(method);
        if (pyFunction == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(16);
        }
        return pyFunction;
    }

    public static void restoreNamedReferences(@NotNull PsiElement element) {
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(17);
        }
        PyClassRefactoringUtil.restoreNamedReferences(element, null);
    }

    public static void restoreNamedReferences(@NotNull PsiElement newElement, @Nullable PsiElement oldElement) {
        if (newElement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(18);
        }
        PyClassRefactoringUtil.restoreNamedReferences(newElement, oldElement, PsiElement.EMPTY_ARRAY);
    }

    public static void restoreNamedReferences(final @NotNull PsiElement newElement, final @Nullable PsiElement oldElement, final PsiElement @NotNull [] otherMovedElements) {
        if (newElement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(19);
        }
        if (otherMovedElements == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(20);
        }
        Set fromFutureImports = (Set)newElement.getCopyableUserData(ENCODED_FROM_FUTURE_IMPORTS);
        newElement.putCopyableUserData(ENCODED_FROM_FUTURE_IMPORTS, null);
        PsiFile destFile = newElement.getContainingFile();
        if (fromFutureImports != null & destFile != null) {
            for (FutureFeature futureFeature : fromFutureImports) {
                AddImportHelper.addOrUpdateFromImportStatement(destFile, "__future__", futureFeature.toString(), null, AddImportHelper.ImportPriority.FUTURE, null);
            }
        }
        newElement.acceptChildren((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitPyReferenceExpression(node);
                PyClassRefactoringUtil.restoreReference((PsiElement)node, (PsiElement)node, otherMovedElements);
            }

            @Override
            public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitPyStringLiteralExpression(node);
                if (oldElement != null) {
                    for (PsiReference ref : node.getReferences()) {
                        if (!ref.isReferenceTo(oldElement)) continue;
                        ref.bindToElement(newElement);
                    }
                }
                PyClassRefactoringUtil.restoreReference(node, node, otherMovedElements);
            }

            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitComment(comment);
                if (comment instanceof PsiLanguageInjectionHost) {
                    PyClassRefactoringUtil.restoreReference((PsiElement)comment, (PsiElement)comment, otherMovedElements);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comment";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyStringLiteralExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitComment";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void restoreReference(@NotNull PsiElement sourceNode, @NotNull PsiElement targetNode, PsiElement @NotNull [] otherMovedElements) {
        if (sourceNode == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(21);
        }
        if (targetNode == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(22);
        }
        if (otherMovedElements == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(23);
        }
        try {
            List injectionReferences;
            if (sourceNode instanceof PyReferenceExpression) {
                PyClassRefactoringUtil.doRestoreReference((PyReferenceExpression)sourceNode, targetNode, otherMovedElements);
            } else if (sourceNode instanceof PsiLanguageInjectionHost && (injectionReferences = (List)sourceNode.getCopyableUserData(INJECTION_REFERENCES)) != null) {
                injectionReferences.forEach(expression -> PyClassRefactoringUtil.doRestoreReference(expression, targetNode, otherMovedElements));
            }
        }
        finally {
            sourceNode.putCopyableUserData(INJECTION_REFERENCES, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRestoreReference(@NotNull PyReferenceExpression sourceNode, @NotNull PsiElement targetNode, PsiElement @NotNull [] otherMovedElements) {
        if (sourceNode == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(24);
        }
        if (targetNode == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(25);
        }
        if (otherMovedElements == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(26);
        }
        try {
            PyFunction f;
            PyClass c;
            Object target = (PsiNamedElement)sourceNode.getCopyableUserData(ENCODED_IMPORT);
            String asName = (String)sourceNode.getCopyableUserData(ENCODED_IMPORT_AS);
            Boolean useFromImport = (Boolean)sourceNode.getCopyableUserData(ENCODED_USE_FROM_IMPORT);
            if (target == null) {
                return;
            }
            if (target instanceof PsiDirectory) {
                target = (PsiNamedElement)PyUtil.getPackageElement((PsiDirectory)target, (PsiElement)sourceNode);
            }
            if (target instanceof PyFunction && (c = (f = (PyFunction)target).getContainingClass()) != null && c.multiFindInitOrNew(false, null).contains(f)) {
                target = c;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)targetNode.getContainingFile(), (PsiElement)target, (boolean)false)) {
                return;
            }
            if (ArrayUtil.contains((Object)target, (Object[])otherMovedElements)) {
                return;
            }
            if (target instanceof PyFile || target instanceof PsiDirectory) {
                PyPsiRefactoringUtil.insertImport(targetNode, target, asName, useFromImport != null ? useFromImport : true);
            } else {
                PyPsiRefactoringUtil.insertImport(targetNode, target, asName, true);
            }
        }
        finally {
            sourceNode.putCopyableUserData(ENCODED_IMPORT, null);
            sourceNode.putCopyableUserData(ENCODED_IMPORT_AS, null);
            sourceNode.putCopyableUserData(ENCODED_USE_FROM_IMPORT, null);
        }
    }

    public static void rememberNamedReferences(final @NotNull PsiElement element, final String ... namesToSkip) {
        PsiFile containingFile;
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(27);
        }
        if (namesToSkip == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(28);
        }
        if ((containingFile = element.getContainingFile()) instanceof PyFile) {
            Set<FutureFeature> fromFutureImports = PyClassRefactoringUtil.collectFromFutureImports((PyFile)containingFile);
            element.putCopyableUserData(ENCODED_FROM_FUTURE_IMPORTS, fromFutureImports);
        }
        element.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitPyReferenceExpression(node);
                if (PsiTreeUtil.getParentOfType((PsiElement)node, PyImportStatementBase.class) != null) {
                    return;
                }
                PyImportedNameDefiner importElement = PyClassRefactoringUtil.getImportElement(node);
                if (importElement != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)importElement, (boolean)false)) {
                    return;
                }
                if (!ArrayUtil.contains((String)node.getText(), (String[])namesToSkip)) {
                    PyClassRefactoringUtil.rememberReference(node, element);
                }
            }

            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    2.$$$reportNull$$$0(1);
                }
                super.visitComment(comment);
                if (comment instanceof PsiLanguageInjectionHost) {
                    PyClassRefactoringUtil.rememberInjectionReferences((PsiLanguageInjectionHost)comment, element, namesToSkip);
                }
            }

            @Override
            public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(2);
                }
                super.visitPyStringLiteralExpression(expression);
                PyClassRefactoringUtil.rememberInjectionReferences(expression, element, namesToSkip);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comment";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitComment";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyStringLiteralExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void rememberInjectionReferences(final @NotNull PsiLanguageInjectionHost host, final @NotNull PsiElement element, final String ... namesToSkip) {
        List files;
        if (host == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(29);
        }
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(30);
        }
        if (namesToSkip == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(31);
        }
        if ((files = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host)) == null) {
            return;
        }
        for (Pair pair : files) {
            ((PsiElement)pair.getFirst()).accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

                @Override
                public void visitPyReferenceExpression(@NotNull PyReferenceExpression expression) {
                    if (expression == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    super.visitPyReferenceExpression(expression);
                    if (!ArrayUtil.contains((String)expression.getText(), (String[])namesToSkip)) {
                        PyClassRefactoringUtil.rememberReference(expression, element);
                        PyClassRefactoringUtil.rememberReferenceInInjectionHost(expression, host);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil$3", "visitPyReferenceExpression"));
                }
            });
        }
    }

    private static void rememberReferenceInInjectionHost(@NotNull PyReferenceExpression expression, @NotNull PsiLanguageInjectionHost host) {
        List encodedImports;
        if (expression == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(32);
        }
        if (host == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(33);
        }
        List rememberedReferences = (encodedImports = (List)host.getCopyableUserData(INJECTION_REFERENCES)) == null ? new ArrayList() : encodedImports;
        rememberedReferences.add(expression);
        host.putCopyableUserData(INJECTION_REFERENCES, (Object)rememberedReferences);
    }

    @NotNull
    private static Set<FutureFeature> collectFromFutureImports(@NotNull PyFile file) {
        if (file == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(34);
        }
        EnumSet<FutureFeature> result2 = EnumSet.noneOf(FutureFeature.class);
        for (FutureFeature feature : FutureFeature.values()) {
            if (!file.hasImportFromFuture(feature)) continue;
            result2.add(feature);
        }
        EnumSet<FutureFeature> enumSet = result2;
        if (enumSet == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(35);
        }
        return enumSet;
    }

    private static void rememberReference(@NotNull PyReferenceExpression node, @NotNull PsiElement element) {
        PyExpression qualifier;
        if (node == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(36);
        }
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(37);
        }
        if ((qualifier = node.getQualifier()) != null && !(PyClassRefactoringUtil.resolveExpression(qualifier) instanceof PyImportedModule)) {
            return;
        }
        List<PsiElement> allResolveResults = PyClassRefactoringUtil.multiResolveExpression(node);
        Object target = (PsiElement)ContainerUtil.getFirstItem(allResolveResults);
        if (target instanceof PsiNamedElement && !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)target, (boolean)false)) {
            PyImportedNameDefiner importElement = PyClassRefactoringUtil.getImportElement(node);
            if (!PyUtil.inSameFile(element, target) && importElement == null && !(target instanceof PsiFileSystemItem)) {
                return;
            }
            if (target instanceof PyTargetExpression && "__all__".equals(((PyTargetExpression)target).getName())) {
                for (PsiElement result2 : allResolveResults) {
                    QualifiedName importedQName;
                    if (!(result2 instanceof PyImportElement) || (importedQName = ((PyImportElement)result2).getImportedQName()) == null) continue;
                    target = new DynamicNamedElement(target.getContainingFile(), importedQName.toString());
                    break;
                }
            }
            node.putCopyableUserData(ENCODED_IMPORT, (PsiNamedElement)target);
            if (importElement instanceof PyImportElement) {
                node.putCopyableUserData(ENCODED_IMPORT_AS, ((PyImportElement)importElement).getAsName());
            }
            node.putCopyableUserData(ENCODED_USE_FROM_IMPORT, qualifier == null);
        }
    }

    @Nullable
    private static PyImportedNameDefiner getImportElement(PyReferenceExpression expr) {
        for (ResolveResult result2 : expr.getReference().multiResolve(false)) {
            PsiElement e = result2.getElement();
            if (e instanceof PyImportElement) {
                return (PyImportElement)e;
            }
            if (!(e instanceof PyStarImportElement)) continue;
            return (PyStarImportElement)e;
        }
        return null;
    }

    @Nullable
    private static PsiElement resolveExpression(@NotNull PyExpression expr) {
        if (expr == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(38);
        }
        if (expr instanceof PyReferenceExpression) {
            return ((PyReferenceExpression)expr).getReference().resolve();
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> multiResolveExpression(@NotNull PyReferenceExpression expr) {
        if (expr == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(39);
        }
        List list = ContainerUtil.mapNotNull((Object[])expr.getReference().multiResolve(false), result2 -> result2.getElement());
        if (list == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(40);
        }
        return list;
    }

    public static void forceAsName(@NotNull PyReferenceExpression node, @NotNull String asName) {
        if (node == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(41);
        }
        if (asName == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(42);
        }
        if (node.getCopyableUserData(ENCODED_IMPORT) == null) {
            LOG.warn("As name is forced on the referenceExpression, that has no encoded import. Forcing it will likely be ignored.");
        }
        node.putCopyableUserData(ENCODED_IMPORT_AS, asName);
    }

    public static void transferEncodedImports(@NotNull PyReferenceExpression source, @NotNull PyReferenceExpression target) {
        if (source == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(43);
        }
        if (target == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(44);
        }
        target.putCopyableUserData(ENCODED_IMPORT, (PsiNamedElement)source.getCopyableUserData(ENCODED_IMPORT));
        target.putCopyableUserData(ENCODED_IMPORT_AS, (String)source.getCopyableUserData(ENCODED_IMPORT_AS));
        target.putCopyableUserData(ENCODED_USE_FROM_IMPORT, (Boolean)source.getCopyableUserData(ENCODED_USE_FROM_IMPORT));
        source.putCopyableUserData(ENCODED_IMPORT, null);
        source.putCopyableUserData(ENCODED_IMPORT_AS, null);
        source.putCopyableUserData(ENCODED_USE_FROM_IMPORT, null);
    }

    public static boolean hasEncodedTarget(@NotNull PyReferenceExpression node) {
        if (node == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(45);
        }
        return node.getCopyableUserData(ENCODED_IMPORT) != null;
    }

    public static boolean updateUnqualifiedImportOfElement(@NotNull PyImportStatementBase importStatement, @NotNull PsiNamedElement element) {
        String name2;
        if (importStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(46);
        }
        if (element == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(47);
        }
        if ((name2 = PyPsiRefactoringUtil.getOriginalName(element)) != null) {
            PyImportElement importElement = null;
            for (PyImportElement e : importStatement.getImportElements()) {
                if (!name2.equals(PyPsiRefactoringUtil.getOriginalName(e))) continue;
                importElement = e;
            }
            if (importElement != null) {
                PsiFile file = importStatement.getContainingFile();
                PsiFile newFile = element.getContainingFile();
                if (newFile == file || PyPsiRefactoringUtil.insertImport((PsiElement)importStatement, element, importElement.getAsName(), true)) {
                    if (importStatement.getImportElements().length == 1) {
                        boolean isInjected = InjectedLanguageManager.getInstance((Project)importElement.getProject()).isInjectedFragment(importElement.getContainingFile());
                        if (!isInjected) {
                            importStatement.delete();
                        } else {
                            PyClassRefactoringUtil.deleteImportStatementFromInjected(importStatement);
                        }
                    } else {
                        importElement.delete();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static void deleteImportStatementFromInjected(@NotNull PyImportStatementBase importStatement) {
        if (importStatement == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(48);
        }
        PsiElement sibling = importStatement.getPrevSibling();
        importStatement.delete();
        if (sibling instanceof PsiWhiteSpace) {
            sibling.delete();
        }
    }

    public static void optimizeImports(@NotNull PsiFile file) {
        if (file == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(49);
        }
        PyImportOptimizer.onlyRemoveUnused().processFile(file).run();
    }

    @NotNull
    public static PyFile getOrCreateFile(String path2, Project project2) {
        PsiFile psi;
        VirtualFile vfile = LocalFileSystem.getInstance().findFileByIoFile(new File(path2));
        if (vfile == null) {
            File file = new File(path2);
            try {
                VirtualFile baseDir = project2.getBaseDir();
                FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project2);
                FileTemplate template = fileTemplateManager.getInternalTemplate("Python Script");
                Properties properties = fileTemplateManager.getDefaultProperties();
                properties.setProperty("NAME", FileUtilRt.getNameWithoutExtension((String)file.getName()));
                String content2 = template.getText(properties);
                psi = PyExtractSuperclassHelper.placeFile(project2, StringUtil.notNullize((String)file.getParent(), (String)(baseDir != null ? baseDir.getPath() : ".")), file.getName(), content2);
            }
            catch (IOException e) {
                throw new IncorrectOperationException(String.format("Cannot create file '%s'", path2), (Throwable)e);
            }
        } else {
            psi = PsiManager.getInstance((Project)project2).findFile(vfile);
        }
        if (!(psi instanceof PyFile)) {
            throw new IncorrectOperationException(PyPsiBundle.message("refactoring.move.module.members.error.cannot.place.elements.into.nonpython.file", new Object[0]));
        }
        PyFile pyFile = (PyFile)psi;
        if (pyFile == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(50);
        }
        return pyFile;
    }

    public static void transplantImportsFromSignature(@NotNull PyFunction sourceFunction, @NotNull PyFunction targetFunction) {
        if (sourceFunction == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(51);
        }
        if (targetFunction == null) {
            PyClassRefactoringUtil.$$$reportNull$$$0(52);
        }
        final HashMap unresolvedNames = new HashMap();
        targetFunction.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(@NotNull PyReferenceExpression referenceExpression) {
                if (referenceExpression == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.visitPyReferenceExpression(referenceExpression);
                if (!referenceExpression.isQualified() && referenceExpression.getReference().multiResolve(false).length == 0) {
                    unresolvedNames.put(referenceExpression.getName(), referenceExpression);
                }
            }

            @Override
            public void visitPyStatementList(@NotNull PyStatementList pruned) {
                if (pruned == null) {
                    4.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pruned";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyStatementList";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        sourceFunction.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(@NotNull PyReferenceExpression referenceExpression) {
                PyReferenceExpression unresolvedReference;
                if (referenceExpression == null) {
                    5.$$$reportNull$$$0(0);
                }
                super.visitPyReferenceExpression(referenceExpression);
                if (!referenceExpression.isQualified() && (unresolvedReference = (PyReferenceExpression)unresolvedNames.get(referenceExpression.getName())) != null) {
                    PyClassRefactoringUtil.rememberNamedReferences((PsiElement)referenceExpression, new String[0]);
                    PyClassRefactoringUtil.restoreReference((PsiElement)referenceExpression, (PsiElement)unresolvedReference, PsiElement.EMPTY_ARRAY);
                }
            }

            @Override
            public void visitPyStatementList(@NotNull PyStatementList pruned) {
                if (pruned == null) {
                    5.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pruned";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyStatementList";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 8, 11, 14, 15, 16, 35, 40, 50 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClassStatement";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 35: 
            case 40: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dequalifyIfDeclaredInClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destStatementList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 17: 
            case 27: 
            case 30: 
            case 37: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherMovedElements";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToSkip";
                break;
            }
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 34: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 36: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFunction";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFieldDeclarationToStatement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewValueToAssign";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addMethods";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "insertMethodInProperPlace";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFromFutureImports";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveExpression";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyFieldDeclarationToStatement";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 35: 
            case 40: 
            case 50: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setNewAssigneeValue";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNewValueToAssign";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addMethods";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "insertMethodInProperPlace";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "restoreNamedReferences";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "restoreReference";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doRestoreReference";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "rememberNamedReferences";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "rememberInjectionReferences";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "rememberReferenceInInjectionHost";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "collectFromFutureImports";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "rememberReference";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolveExpression";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveExpression";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "forceAsName";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "transferEncodedImports";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "hasEncodedTarget";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "updateUnqualifiedImportOfElement";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "deleteImportStatementFromInjected";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "optimizeImports";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "transplantImportsFromSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 8, 11, 14, 15, 16, 35, 40, 50 -> new IllegalStateException(string);
        };
    }

    private static final class DynamicNamedElement
    extends LightElement
    implements PsiNamedElement {
        private final PsiFile myFile;
        private final String myName;

        private DynamicNamedElement(@NotNull PsiFile file, @NotNull String name2) {
            if (file == null) {
                DynamicNamedElement.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                DynamicNamedElement.$$$reportNull$$$0(1);
            }
            super(file.getManager(), file.getLanguage());
            this.myName = name2;
            this.myFile = file;
        }

        public String toString() {
            return "DynamicNamedElement(file='" + this.getContainingFile().getName() + "', name='" + this.getName() + "')";
        }

        public PsiFile getContainingFile() {
            return this.myFile;
        }

        public PsiElement setName(@NonNls @NotNull String name2) throws IncorrectOperationException {
            if (name2 == null) {
                DynamicNamedElement.$$$reportNull$$$0(2);
            }
            return null;
        }

        public String getName() {
            return this.myName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyClassRefactoringUtil$DynamicNamedElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

