/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.jetbrains.python.packaging.PyCondaPackageManagerImpl;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.packaging.PyCustomPackageManagers;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerProvider;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyTargetEnvironmentPackageManager;
import com.jetbrains.python.packaging.common.PackageManagerHolder;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyPackageManagersImpl
extends PyPackageManagers {
    private static final Logger LOG = Logger.getInstance(PyPackageManagersImpl.class);
    private final Map<String, PyPackageManager> myStandardManagers = new HashMap<String, PyPackageManager>();
    private final Map<String, PyPackageManager> myProvidedManagers = new HashMap<String, PyPackageManager>();

    public PyPackageManagersImpl() {
        PyPackageManagerProvider.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<PyPackageManagerProvider>(){

            public void extensionRemoved(@NotNull PyPackageManagerProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                PyPackageManagersImpl.this.clearProvidedManagersCache();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/packaging/PyPackageManagersImpl$1";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    @Override
    @NotNull
    public synchronized PyPackageManager forSdk(@NotNull Sdk sdk2) {
        String key;
        PyPackageManager manager;
        if (sdk2 == null) {
            PyPackageManagersImpl.$$$reportNull$$$0(0);
        }
        if (sdk2 instanceof Disposable) {
            LOG.assertTrue(!Disposer.isDisposed((Disposable)((Disposable)sdk2)), (Object)("Requesting a package manager for an already disposed SDK " + sdk2 + " (" + sdk2.getClass() + ")"));
        }
        if ((manager = this.myStandardManagers.get(key = PythonSdkType.getSdkKey(sdk2))) == null) {
            manager = this.myProvidedManagers.get(key);
        }
        if (manager == null) {
            Map<String, PyPackageManager> cache;
            PyPackageManager customPackageManager = PyCustomPackageManagers.tryCreateCustomPackageManager(sdk2);
            if (customPackageManager != null) {
                cache = this.myProvidedManagers;
                manager = customPackageManager;
            } else {
                cache = this.myStandardManagers;
                manager = PythonSdkUtil.isConda(sdk2) && sdk2.getHomePath() != null && PyCondaPackageService.getCondaExecutable(sdk2.getHomePath()) != null ? new PyCondaPackageManagerImpl(sdk2) : new PyTargetEnvironmentPackageManager(sdk2);
            }
            cache.put(key, manager);
            if (sdk2 instanceof Disposable) {
                Disposer.register((Disposable)((Disposable)sdk2), () -> this.clearCache(sdk2));
            }
            PyPackageManagersImpl parentDisposable = sdk2 instanceof Disposable ? (Disposable)sdk2 : this;
            Disposer.register((Disposable)parentDisposable, (Disposable)manager);
            if (manager.shouldSubscribeToLocalChanges()) {
                PyPackageUtil.runOnChangeUnderInterpreterPaths(sdk2, manager, () -> PythonSdkType.getInstance().setupSdkPaths(sdk2));
            }
        }
        PyPackageManager pyPackageManager = manager;
        if (pyPackageManager == null) {
            PyPackageManagersImpl.$$$reportNull$$$0(1);
        }
        return pyPackageManager;
    }

    public PyPackageManagementService getManagementService(Project project2, Sdk sdk2) {
        if (sdk2 instanceof Disposable) {
            LOG.assertTrue(!Disposer.isDisposed((Disposable)((Disposable)sdk2)), (Object)("Requesting a package service for an already disposed SDK " + sdk2 + " (" + sdk2.getClass() + ")"));
        }
        return ((PackageManagerHolder)project2.getService(PackageManagerHolder.class)).bridgeForSdk(project2, sdk2);
    }

    @Override
    public synchronized void clearCache(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PyPackageManagersImpl.$$$reportNull$$$0(2);
        }
        String sdkKey = PythonSdkType.getSdkKey(sdk2);
        PyPackageManagersImpl.removeCachedManager(this.myStandardManagers, sdkKey);
        PyPackageManagersImpl.removeCachedManager(this.myProvidedManagers, sdkKey);
    }

    private synchronized void clearProvidedManagersCache() {
        for (String key : ArrayUtil.toStringArray(this.myProvidedManagers.keySet())) {
            PyPackageManagersImpl.removeCachedManager(this.myProvidedManagers, key);
        }
    }

    private static void removeCachedManager(@NotNull Map<String, PyPackageManager> cache, @NotNull String key) {
        PyPackageManager removed;
        if (cache == null) {
            PyPackageManagersImpl.$$$reportNull$$$0(3);
        }
        if (key == null) {
            PyPackageManagersImpl.$$$reportNull$$$0(4);
        }
        if ((removed = cache.remove(key)) != null) {
            Disposer.dispose((Disposable)removed);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagersImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagersImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forSdk";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeCachedManager";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

