/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.ast.PyAstFromImportStatement;
import com.jetbrains.python.ast.PyAstImportElement;
import com.jetbrains.python.ast.PyAstRecursiveElementVisitor;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAstElementGenerator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class PyFromImportPostFormatProcessor
implements PostFormatProcessor {
    PyFromImportPostFormatProcessor() {
    }

    @NotNull
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = new Visitor(settings).processElement(source);
        if (psiElement == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (rangeToReformat == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(5);
        }
        TextRange textRange = new Visitor(settings).processTextRange(source, rangeToReformat);
        if (textRange == null) {
            PyFromImportPostFormatProcessor.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/formatter/PyFromImportPostFormatProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/formatter/PyFromImportPostFormatProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }

    private static class Visitor
    extends PyAstRecursiveElementVisitor {
        private final PostFormatProcessorHelper myHelper;
        private final List<PyAstFromImportStatement> myImportStatements;
        private PsiElement myRootElement;

        Visitor(@NotNull CodeStyleSettings settings) {
            if (settings == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            this.myImportStatements = new ArrayList<PyAstFromImportStatement>();
            this.myHelper = new PostFormatProcessorHelper(settings.getCommonSettings((Language)PythonLanguage.getInstance()));
        }

        @Override
        public void visitPyFromImportStatement(@NotNull PyAstFromImportStatement node) {
            List importedNames;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (this.myHelper.isElementFullyInRange((PsiElement)node) && (importedNames = ContainerUtil.filter((Object[])node.getImportElements(), elem -> elem.getTextLength() != 0)).size() > 1) {
                boolean missingComma;
                PyCodeStyleSettings pySettings = (PyCodeStyleSettings)this.myHelper.getSettings().getRootSettings().getCustomSettings(PyCodeStyleSettings.class);
                boolean forcedParens = pySettings.FROM_IMPORT_PARENTHESES_FORCE_IF_MULTILINE && PostFormatProcessorHelper.isMultiline((PsiElement)node);
                boolean forcedComma = pySettings.FROM_IMPORT_TRAILING_COMMA_IF_MULTILINE && PostFormatProcessorHelper.isMultiline((PsiElement)node);
                PyAstImportElement lastImportedName = (PyAstImportElement)importedNames.get(importedNames.size() - 1);
                PsiElement afterLastName = PyPsiUtilsCore.getNextNonCommentSibling((PsiElement)lastImportedName, true);
                PsiElement openingParen = node.getLeftParen();
                boolean bl = missingComma = afterLastName == null || afterLastName.getNode().getElementType() != PyTokenTypes.COMMA;
                if (forcedParens && openingParen == null || forcedComma && missingComma && openingParen != null) {
                    this.myImportStatements.add(node);
                }
            }
        }

        @NotNull
        public PsiElement processElement(@NotNull PsiElement element) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            this.myRootElement = element;
            this.findAndReplaceFromImports(element);
            PsiElement psiElement = this.myRootElement;
            if (psiElement == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        @NotNull
        public TextRange processTextRange(@NotNull PsiFile file, @NotNull TextRange range) {
            if (file == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (range == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            this.myHelper.setResultTextRange(range);
            this.findAndReplaceFromImports((PsiElement)file);
            TextRange textRange = this.myHelper.getResultTextRange();
            if (textRange == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            return textRange;
        }

        private void findAndReplaceFromImports(@NotNull PsiElement element) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if (element.getLanguage().isKindOf((Language)PythonLanguage.INSTANCE)) {
                element.accept((PsiElementVisitor)this);
                Collections.reverse(this.myImportStatements);
                for (PyAstFromImportStatement statement : this.myImportStatements) {
                    PyAstFromImportStatement newStatement = this.replaceFromImport(statement);
                    if (this.myRootElement != statement) continue;
                    this.myRootElement = newStatement;
                }
            }
        }

        @NotNull
        private PyAstFromImportStatement replaceFromImport(@NotNull PyAstFromImportStatement fromImport) {
            if (fromImport == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            PyAstImportElement[] allNames2 = fromImport.getImportElements();
            PyAstImportElement firstName = allNames2[0];
            PyAstElementGenerator generator = PyAstElementGenerator.getInstance(fromImport.getProject());
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)fromImport.getProject());
            if (fromImport.getLeftParen() == null) {
                String beforeFirstName = fromImport.getText().substring(0, firstName.getStartOffsetInParent());
                StringBuilder newStatementText = new StringBuilder(beforeFirstName);
                newStatementText.append("(");
                boolean lastElementWasComment = false;
                int lastVisibleNameCommaOffset = -1;
                for (PyAstImportElement cur = firstName; cur != null; cur = cur.getNextSibling()) {
                    if (cur instanceof PsiWhiteSpace) {
                        newStatementText.append(cur.getText().replace("\\", ""));
                    } else {
                        newStatementText.append(cur.getText());
                    }
                    if (cur instanceof PyAstImportElement && cur.getTextLength() != 0) {
                        lastVisibleNameCommaOffset = newStatementText.length();
                    } else if (lastVisibleNameCommaOffset != -1 && cur.getNode().getElementType() == PyTokenTypes.COMMA) {
                        lastVisibleNameCommaOffset = -1;
                    }
                    lastElementWasComment = cur instanceof PsiComment;
                }
                PyCodeStyleSettings pySettings = (PyCodeStyleSettings)this.myHelper.getSettings().getRootSettings().getCustomSettings(PyCodeStyleSettings.class);
                if (lastVisibleNameCommaOffset != -1 && pySettings.FROM_IMPORT_TRAILING_COMMA_IF_MULTILINE) {
                    newStatementText.insert(lastVisibleNameCommaOffset, ",");
                }
                if (lastElementWasComment) {
                    newStatementText.append("\n");
                }
                newStatementText.append(")");
                LanguageLevel level = LanguageLevel.forElement((PsiElement)fromImport);
                PyAstFromImportStatement newFromImport = generator.createFromText(level, PyAstFromImportStatement.class, newStatementText.toString());
                newFromImport = (PyAstFromImportStatement)fromImport.replace((PsiElement)newFromImport);
                newFromImport = (PyAstFromImportStatement)codeStyleManager.reformat((PsiElement)newFromImport, true);
                this.myHelper.updateResultRange(fromImport.getTextLength(), newFromImport.getTextLength());
                PyAstFromImportStatement pyAstFromImportStatement = newFromImport;
                if (pyAstFromImportStatement == null) {
                    Visitor.$$$reportNull$$$0(9);
                }
                return pyAstFromImportStatement;
            }
            int oldLength = fromImport.getTextLength();
            fromImport.addAfter(generator.createComma().getPsi(), (PsiElement)allNames2[allNames2.length - 1]);
            codeStyleManager.reformat((PsiElement)fromImport, true);
            this.myHelper.updateResultRange(oldLength, fromImport.getTextLength());
            PyAstFromImportStatement pyAstFromImportStatement = fromImport;
            if (pyAstFromImportStatement == null) {
                Visitor.$$$reportNull$$$0(10);
            }
            return pyAstFromImportStatement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 6, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/formatter/PyFromImportPostFormatProcessor$Visitor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromImport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/formatter/PyFromImportPostFormatProcessor$Visitor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "processTextRange";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replaceFromImport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyFromImportStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "processElement";
                    break;
                }
                case 3: 
                case 6: 
                case 9: 
                case 10: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processTextRange";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "findAndReplaceFromImports";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceFromImport";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 6, 9, 10 -> new IllegalStateException(string);
            };
        }
    }
}

