/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.smartstepinto;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoContext;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariant;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariantVisitor;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class PySmartStepIntoHandler
extends XSmartStepIntoHandler<PySmartStepIntoVariant> {
    @NotNull
    private final XDebugSession mySession;
    @NotNull
    private final PyDebugProcess myProcess;

    public PySmartStepIntoHandler(@NotNull PyDebugProcess process2) {
        if (process2 == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        this.mySession = process2.getSession();
        this.myProcess = process2;
    }

    public void startStepInto(@NotNull PySmartStepIntoVariant smartStepIntoVariant) {
        if (smartStepIntoVariant == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        this.myProcess.startSmartStepInto(smartStepIntoVariant);
    }

    public String getPopupTitle(@NotNull XSourcePosition position) {
        if (position == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(2);
        }
        return PyBundle.message("debug.popup.title.step.into.function", new Object[0]);
    }

    @NotNull
    public Promise<List<PySmartStepIntoVariant>> computeSmartStepVariantsAsync(@NotNull XSourcePosition position) {
        if (position == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(3);
        }
        AsyncPromise promise = new AsyncPromise();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<PySmartStepIntoVariant> computedVariants = this.findVariants(position);
            promise.setResult(computedVariants);
        });
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(4);
        }
        return asyncPromise;
    }

    @NotNull
    private List<PySmartStepIntoVariant> findVariants(@NotNull XSourcePosition position) {
        if (position == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(5);
        }
        ThreadingAssertions.assertBackgroundThread();
        PyStackFrame currentFrame = (PyStackFrame)this.mySession.getCurrentStackFrame();
        if (currentFrame == null || currentFrame.isComprehension()) {
            List<PySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(6);
            }
            return list;
        }
        PySmartStepIntoContext context = (PySmartStepIntoContext)ReadAction.compute(() -> this.createSmartStepIntoContext(currentFrame));
        if (context == null) {
            List<PySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(7);
            }
            return list;
        }
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(position.getFile()));
        if (document == null) {
            List<PySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<Pair<String, Boolean>> variantsFromPython = this.myProcess.getSmartStepIntoVariants(context.getStartLine(), context.getEndLine());
        if (variantsFromPython.isEmpty()) {
            List<PySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(9);
            }
            return list;
        }
        List list = (List)ReadAction.compute(() -> this.removePossiblyUnreachableVariants(document, position.getLine(), variantsFromPython, context));
        if (list == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<PySmartStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        if (position == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(11);
        }
        throw new IllegalStateException("Should not be called");
    }

    @NotNull
    private List<PySmartStepIntoVariant> removePossiblyUnreachableVariants(@NotNull Document document, int line2, @NotNull List<Pair<String, Boolean>> variantsFromPython, @NotNull PySmartStepIntoContext context) {
        PsiElement expression;
        if (document == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(12);
        }
        if (variantsFromPython == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(14);
        }
        if ((expression = this.findSmartStepIntoBaseExpression(document, line2)) == null) {
            List<PySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(15);
            }
            return list;
        }
        ArrayList<PySmartStepIntoVariant> result2 = new ArrayList<PySmartStepIntoVariant>();
        expression.accept((PsiElementVisitor)new PySmartStepIntoVariantVisitor(result2, variantsFromPython, context));
        ArrayList<PySmartStepIntoVariant> arrayList = result2;
        if (arrayList == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Nullable
    private PsiElement findSmartStepIntoBaseExpression(@NotNull Document document, int line2) {
        PsiFile file;
        if (document == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(17);
        }
        if ((file = PsiDocumentManager.getInstance((Project)this.mySession.getProject()).getPsiFile(document)) == null) {
            return null;
        }
        PsiElement element = file.findElementAt(DocumentUtil.getFirstNonSpaceCharOffset((Document)document, (int)line2));
        if (element == null) {
            return null;
        }
        PsiElement argumentList = PsiTreeUtil.getParentOfType((PsiElement)element, PyArgumentList.class);
        if (argumentList != null) {
            return argumentList.getParent();
        }
        PsiElement parenthesizedExpression = PsiTreeUtil.getParentOfType((PsiElement)element, PyParenthesizedExpression.class);
        if (parenthesizedExpression != null) {
            return parenthesizedExpression;
        }
        PsiElement parent = element.getParent();
        int lineStartOffset = document.getLineStartOffset(line2);
        int lineEndOffset = document.getLineEndOffset(line2);
        while (parent != null && lineStartOffset <= parent.getTextOffset() && parent.getTextOffset() < lineEndOffset) {
            element = parent;
            parent = element.getParent();
        }
        if (element instanceof PyExpression) {
            return element;
        }
        final Ref psiElementRef = new Ref();
        element.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.storeElement((PsiElement)node);
            }

            @Override
            public void visitPyCallExpression(@NotNull PyCallExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.storeElement((PsiElement)node);
            }

            @Override
            public void visitPyComprehensionElement(@NotNull PyComprehensionElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.storeElement(node);
            }

            @Override
            public void visitPyElement(@NotNull PyElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (node instanceof PyDecorator) {
                    this.storeElement((PsiElement)node);
                }
                super.visitPyElement(node);
            }

            @Override
            public void visitPyDecoratorList(@NotNull PyDecoratorList node) {
                if (node == null) {
                    1.$$$reportNull$$$0(4);
                }
                this.storeElement((PsiElement)node);
                super.visitPyDecoratorList(node);
            }

            private void storeElement(PsiElement node) {
                if (psiElementRef.isNull()) {
                    psiElementRef.set((Object)node);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/jetbrains/python/debugger/smartstepinto/PySmartStepIntoHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyBinaryExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyCallExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyComprehensionElement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyElement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyDecoratorList";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (PsiElement)psiElementRef.get();
    }

    @NotNull
    public Promise<List<PySmartStepIntoVariant>> computeStepIntoVariants(@NotNull XSourcePosition position) {
        if (position == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(18);
        }
        if (PyDebuggerSettings.getInstance().isAlwaysDoSmartStepInto()) {
            Promise<List<PySmartStepIntoVariant>> promise = this.computeSmartStepVariantsAsync(position);
            if (promise == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(19);
            }
            return promise;
        }
        Promise promise = Promises.rejectedPromise();
        if (promise == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(20);
        }
        return promise;
    }

    @Nullable
    public PySmartStepIntoContext createSmartStepIntoContext(@NotNull PyStackFrame frame) {
        XSourcePosition position;
        if (frame == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(21);
        }
        if ((position = frame.getSourcePosition()) == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
        if (document == null) {
            return null;
        }
        PySmartStepIntoHandler handler2 = (PySmartStepIntoHandler)this.myProcess.getSmartStepIntoHandler();
        PsiElement expression = handler2.findSmartStepIntoBaseExpression(document, position.getLine());
        if (expression != null) {
            TextRange range = expression.getTextRange();
            int startLine = document.getLineNumber(range.getStartOffset());
            int endLine = document.getLineNumber(range.getEndOffset());
            return new PySmartStepIntoContext(startLine + 1, endLine + 1, frame);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 9, 10, 15, 16, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartStepIntoVariant";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/smartstepinto/PySmartStepIntoHandler";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantsFromPython";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/smartstepinto/PySmartStepIntoHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSmartStepVariantsAsync";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findVariants";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "removePossiblyUnreachableVariants";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "computeStepIntoVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startStepInto";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPopupTitle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeSmartStepVariantsAsync";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findVariants";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "computeSmartStepVariants";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removePossiblyUnreachableVariants";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findSmartStepIntoBaseExpression";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeStepIntoVariants";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createSmartStepIntoContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8, 9, 10, 15, 16, 19, 20 -> new IllegalStateException(string);
        };
    }
}

